" VERSION 3
" Stand: 12.12.2024
" Dieses Wrterbuch enthlt alle Texte aus Shellscripten
" Eigennamen FO, FOP und EFOP nicht bersetzen.
" Variablennamen beginnen immer mit $ und drfen nie bersetzt werden.
" Das gilt auch fr Konstrukte wie $? und $1 bzw. ${var} und $(name)
" Verwendungen der Zeichens " und ` mssen exakt bernommen werden, d.h.
" normalerweise mit einem \ davor.
"
"
" This dictionary contains all texts from the shell scripts
" Do not translate names FO, FOP, EFOP.
" Variable names always begin with $ and must not be translated.
" This also applies to constructions such as $? and $1 or ${var} and $(name)
" The " character must be transferred exactly, i.e. usually with a \
" before it.
"
"  Onlinehelp: https://extranet.abas.de/sub_de/help/hd/html/45B.html
"              https://extranet.abas.de/sub_de/help/he/html/45B.html
"
"******** aber.sh ********
      1 D       |Textbereich = Arbeitsbereich
      1 E       |Textbereich = Arbeitsbereich = Workspace
      1 TX=de   |Textbereiche und Texte bearbeiten
      1 hu      |Szvegllomnyok s szvegszerkeszts
"******** aber.sh ********
      2 TX=de   |Neuen Textbereich anlegen
      2 hu      |j szvegllomny ltrehozsa
      3 TX=de   |Textbereich lschen
      3 hu      |Szvegllomny trlse
      4 TX=de   |Textbereich umbenennen
      4 hu      |Szvegllomny tnevezse
      5 TX=de   |Texte kopieren
      5 hu      |Szveg(ek) msolsa
      6 TX=de   |Name des neuen Textbereichs (max. 16 Kleinbuchstaben):
      6 hu      |Az j szvegllomny neve (max. 16 kisbet):
      7 TX=de   |$arber gibt es schon. Bitte einen anderen Namen whlen
      7 hu      |$arber mr van. Krem, vlasszon egy msik nevet!
      8 TX=de   |einbuchstabige Namen sind nicht erlaubt
      8 hu      |Az egybets nv illeglis.
      9 TX=de   |Verzeichnisname enthlt unzulssiges Zeichen
      9 hu      |Meg nem engedett jeleket tartalmaz a knyvtrnv (directory).
     10 TX=de   |Textbereich $arber angelegt
     10 hu      |A $arber szvegllomnyt megnyitottam.
     11 TX=de   |Textbereich $arber kann nicht angelegt werden
     11 hu      |A $arber szvegllomnyt nem tudom megnyitni.
     12 TX=de   |Textbereich $spr/$arber angelegt
     12 hu      |A $spr/$arber szvegllomnyt megnyitottam.
     13 TX=de   |Textbereich $spr/$arber kann nicht angelegt werden
     13 hu      |A $spr/$arber szvegllomnyt nem lehet megnyitni.
     14 TX=de   |Textbereich $arber enthlt noch Texte. Trotzdem lschen?
     14 hu      |A $arber szvegllomnyban mg van szveg. Ennek ellenre trljem?
     15 TX=de   |Textbereich $arber gelscht
     15 hu      |A $arber szvegllomny trlve.
     16 TX=de   |Textbereich $arber nicht gelscht
     16 hu      |A $arber szvegllomnyt nem trltem.
     17 TX=de   |Neuer Name fr Textbereich $arber:
     17 hu      |j nv a $arber szveg tartomnynak:
     18 TX=de   |Verzeichnis oder Datei $narber existiert bereits
     18 hu      |$narber knyvtr vagy llomny mr ltezik
     19 TX=de   |Verzeichnis $arber in $narber umbenannt
     19 hu      |A $arber knyvtr tnevezve, j neve $narber .
"******** allein.sh ********
     20 TX=de   |* Option -P: Pruefen (Standard)
     20 hu      |* Opci -P: Ellenrzs (standard)
     21 TX=de   |* Option -E: Ende
     21 hu      |* -E opci: Vge
     22 TX=de   |* Option -S: Start
     22 hu      |* Opci -S: Start
     23 TX=de   |UB: Unterbrechung setzen
     23 hu      |UB: Megszakts elhelyezse
     24 TX=de   |SICHERN: Sicherungssperre setzen
     24 hu      |SICHERN: Ments zrlat elhelyezse
     25 TX=de   |KEIN_SCHREIBER: nur lesende Zugriffe erlauben
     25 hu      |KEIN_SCHREIBER: Csak olvashat hozzfrsek engedlyezse
     26 TX=de   |ALLEIN: Allein-Sperre setzen
     26 hu      |ALLEIN: Egyedl-zrlat elhelyezse
     27 TX=de   |KEINER: Keiner-Sperre setzen == Default
     27 hu      |KEINER: Senki-zrlat elhelyezse == default
     28 TX=de   |* Option -d: <wait> Sekunden auf Setzen der Sperre warten (nur bei -S)
     28 hu      |* Opci -d: <wait> msodperc vrakozs a zrlat elhelyezsre (csak -S -nl)
     29 TX=de   |* pid: Prozessnummer oder beliebige Zahl
     29 hu      |* pid: Folyamat szm vagy tetszleges szm
     30 TX=de   |Mandant: $MANDANT ist bereits gesperrt
     30 hu      |Mandant: $MANDANT mr zrolva van
     31 TX=de   |Mandant: $MANDANT konnte nicht gesperrt werden
     31 hu      |Mandant: $MANDANT -t nem lehet zrolni
     32 TX=de   |Mandant: $MANDANT konnte nicht freigegeben werden
     32 hu      |Mandant: $MANDANT nem lehet engedlyezni
"******** anwender.sh ********
     33 TX=de   |* Option -a: Anzeige aktiver Bildschirme aller Mandanten
     33 hu      |* Opci -a: Az sszes mandant aktv munkallomsainak szma
     34 TX=de   |* Option -b: Anzeige aktiver Bildschirme fr 1 Mandanten
     34 hu      |* Opci -b: Az aktv munkallomsok megjelentse 1 mandantra
     35 TX=de   |* Option -c: Zhlen angemeldete Benutzer/Schirme
     35 hu      |* Opci -c: bejelentett felhaszn/kperny szml
     36 TX=de   |und Ergebnis in exit status (\$?)
     36 hu      |s eredm kilp sttusban [\$?]
     37 TX=de   |* Option -d: debug
     37 hu      |* -d opci: debug
     38 TX=de   |Keine Bildschirme aktiv
     38 hu      |Nincsenek aktv munkallomsok
     39 TX=de   |PID
     39 hu      |PID
     40 TX=de   |Vaterprozess
     40 hu      |Szlfolyamat
     41 TX=de   |Nr
     41 hu      |Nr
     42 TX=de   |Startzeit
     42 hu      |Kezd id
     43 TX=de   |Abas Anwender in Mandant
     43 hu      |Abas felhasznl a \"mandant\"-ban.
     44 TX=de   |Zustand: OK
     44 hu      |llapot: OK
     45 TX=de   |Zustand: ALLEIN
     45 hu      |llapot: NLL
     46 TX=de   |Zustand: UNTERBROCHEN
     46 hu      |llapot: MEGSZAKTVA
     47 TX=de   |Zustand: SICHERN
     47 hu      |llapot: SICHERN
     48 TX=de   |Zustand: ONLINE_SICHERUNG
     48 hu      |llapot: ONLINE_MENTS
     49 TX=de   |Zustand:
     49 hu      |llapot:
"******** aufraeum.sh ********
     50 TX=de   |Wartungsprogramm hlt Sperre:
     50 hu      |Karbantart program tartja zrolva:
     51 TX=de   |Sperre von unbekanntem Prozess gehalten!
     51 hu      |Ismeretlen processz tartja zrolva!
     52 TX=de   |Benutzer haelt Sperre:
     52 hu      |Felhasznl tartja zrolva:
     53 TX=de   |Wartungsprogram luft nicht mehr
     53 hu      |Karbantart program nem fut mr.
     54 TX=de   |Nicht angemeldetes Wartungsprogram hlt Sperre
     54 hu      |Nem bejelentkezett karbantart program tartja zrolva.
     55 TX=de   |Fehler beim Bestimmen der Prozesse
     55 hu      |Hiba a processzek megjellsnl
     56 TX=de   |Zustand: BUSY
     56 hu      |llapot: FOGLALT
     57 TX=de   |Zustand: KEINER
     57 hu      |llapot: EGY_SEM
     58 TX=de   |Zustand: $status
     58 hu      |llapot: $status
     59 TX=de   |Fehlende $kommando-Abmeldungen der Prozesse
     59 hu      |Hinyz processzek $kommando -kijelentkezse
     60 TX=de   |Fehlende $kommando-Abmeldungen nachgeholt.
     60 hu      |Hinyz  $kommando -kijelentkezs helyrelltsa
     61 TX=de   |Aufrumen fehlgeschlagen.
     61 hu      |Sikertelen takarts.
     62 TX=de   |Kein Schreibzugriff auf $i mglich
     62 hu      |Nincs rsi jog a $i -hez
     63 TX=de   |Kein Lesezugriff auf $i mglich
     63 hu      |Nincs olvassi jog a $i-hez
     64 TX=de   |Fehlende Abmeldungen aufrumen im Mandant
     64 hu      |Hinyz kijelentkezsek trlse a \"mandant\"-bl.
     65 TX=de   |Anwender
     65 hu      |Felhasznl
"******** bj_rebuild.sh ********
     66 TX=de   |rmdir aufbewahrt: $rmdir
     66 hu      |rmdir megrizve: $rmdir
     67 TX=de   |Kann Verzeichnis rmdir=$rmdir nicht lschen.
     67 hu      |rmdir=$rmdir knyvtrat nem tudja trlni.
     68 TX=de   |Kann Verzeichnis rmdir=$rmdir nicht anlegen.
     68 hu      |rmdir=$rmdir knyvtr nem elhelyezhet.
     69 TX=de   |Kann Log-Verzeichnis $logdir nicht anlegen.
     69 hu      |$logdir log knyvtr nem felvihet.
     70 TX=de   |Buchungsjournal im Mandanten $MAND wird neu aufgebaut.
     70 hu      |A knyvelsi napl a $MAND mandantban jonnan felptsre kerl.
     71 TX=de   |Ausgaben werden nach $logdir geschrieben.
     71 hu      |A kiadsok a $logdir-be kerlnek rsra.
     72 TX=de   |Unterbrechungssperre setzen.
     72 hu      |Megszaktsi zrlat elhelyezse.
     73 TX=de   |Kann Unterbrechungssperre nicht setzen.
     73 hu      |Megszaktsi zrlat nem helyezhet el.
     74 TX=de   |Datenbank 131 zurcksetzen.
     74 hu      |131-es adatbzis visszahelyezse.
     75 TX=de   |Kann Unterbrechungssperre nicht aufheben.
     75 hu      |A megszaktsi zrlat nem megszntethet.
     76 TX=de   |Kann Datenbank 131 nicht zurcksetzen.
     76 hu      |A 131-es adatbzis nem visszahelyezhet.
     77 TX=de   |Datenbank 131 neu aufbauen.
     77 hu      |131-es adatbzis jonnani felptse.
"******** bu_bj_schema.sh ********
     78 TX=de   |Gruppe 131-00 nicht vollstaendig
     78 hu      |131-00 csoport nem teljes
     79 TX=de   |Gruppe 131-01 nicht vollstaendig
     79 hu      |131-01 csoport nem teljes
"******** callparameter_admin.sh ********
     80 TX=de   |Passwort:
     80 hu      |Jelsz:
     81 TX=de   |Speichert oder entfernt gelieferte Aufrufparameter
     81 hu      |Elment vagy eltvolt szlltott lehvsi paramtereket
     82 TX=de   |-d: Testmodus anschalten
     82 hu      |-d: Tesztmdozat bekapcsolsa
     83 TX=de   |-a: STORE zum Aktualisieren, REMOVE zum Abschaffen
     83 hu      |-a: STORE az aktualizlshoz, REMOVE a trlshez
     84 TX=de   |-g: Datenbankgruppennummer 9 (Voreinstellung) oder 21
     84 hu      |-g: Adatbzis csoport szm 9 (elzetes bellts) vagy 21
     85 TX=de   |-t: Aktion in einer Transaktion verarbeiten
     85 hu      |-t: Mvelet feldolgozsa egy tranzakciban
     86 TX=de   |-v: Validierung einschalten
     86 hu      |-v: rvnyests bekapcsolsa
     87 TX=de   |$callparameter wurde nicht gefunden
     87 hu      |$callparameter nem tallhat
     88 TX=de   |$callparameter ist nicht lesbar
     88 hu      |$callparameter nem olvashat
     89 TX=de   |Es wurde eine illegale Datenbanknummer angegeben
     89 hu      |rvnytelen adatbzis szm kerlt megadsra
     90 TX=de   |Es wurde eine illegale Datenbankgruppennummer angegeben
     90 hu      |rvnytelen adatbzis csoport szm kerlt megadsra
     91 TX=de   |Nummer $c ist keine aus dem reservierten Bereich!
     91 hu      |$c szm nem a fenntartott tartomnybl van!
     92 TX=de   |Nummer $c ist aus dem reservierten Bereich!
     92 hu      |$c szm a fenntartott tartomnybl!
     93 TX=de   |Es fehlt die Angabe der Identnummern!
     93 hu      |Hinyzik a hivatkozsi szmok megadsa!
     94 TX=de   |Skript im Mandanten aufrufen!
     94 hu      |Script lehvsa a mandantban!
     95 TX=de   |Beim Bekanntmachen der Umgebung ist ein Fehler aufgetreten
     95 hu      |A krnyezet ismertt ttelnl hiba lpett fel
     96 TX=de   |Es wurde kein Passwort angegeben.
     96 hu      |Nem kerlt megadsra jelsz.
"******** callparamgen_admin.sh ********
     97 TX=de   |Suche nach erforderlichen Masken ist gescheitert.
     97 hu      |A szksges maszkok keresse nem sikerlt.
     98 TX=de   |Suche nach erforderlichen Infosystemen ist gescheitert.
     98 hu      |A szksges infosystemek keresse nem sikerlt.
     99 TX=de   |Suche nach vorhandenen Menlisten ist gescheitert.
     99 hu      |A meglv menlistk keresse nem sikerlt.
    100 TX=de   |Lschen der Menlisten mit Fehlern abgebrochen.
    100 hu      |A menlistk trlse hibval megszakadt.
    101 TX=de   |Anlegen der Menlisten mit Fehlern abgebrochen.
    101 hu      |A menlistk felvitele hibval megszakadt.
    102 TX=de   |Bestimmung der Menge zum Anlegen gescheitert.
    102 hu      |A mennyisg meghatrozsa a felvitelhez nem sikerlt.
    103 TX=de   |Bestimmung der Menge zum Lschen gescheitert.
    103 hu      |A mennyisg meghatrozsa a trlshez nem sikerlt.
    104 TX=de   |Die Erweiterung der IDs um Kontextdaten ist gescheitert.
    104 hu      |Az ID-k bvtse kontextus adatokkal nem sikerlt.
    105 TX=de   |* Option -g: Generiert Menlisten
    105 hu      |* Opci -g: Menlistkat generl
    106 TX=de   |* Option -l: Lscht Menlisten
    106 hu      |* Opci -l: Menlistkat trl
    107 TX=de   |* Option -t: Testlauf
    107 hu      |* Opci -t: Teszt futtats
    108 TX=de   |* Option -a: Bearbeite Menlisten am Aktionsbutton
    108 hu      |* Opci -a: menlistk szerkesztse az Akci nyomgombnl
    109 TX=de   |* Option -i: Bearbeite Menlisten am Infobutton
    109 hu      |* Opci -i: menlistk szerkesztse az Inf nyomgombnl
    110 TX=de   |Variablentabellen mit Masken:
    110 hu      |Vltoztblzatok maszkokkal:
    111 TX=de   |Infosysteme:
    111 hu      |Infosystem:
    112 TX=de   |Erforderliche Menlisten :
    112 hu      |Szksges menlistk:
    113 TX=de   |Vorhandene Menlisten :
    113 hu      |Meglv menlistk:
    114 TX=de   |Gelschte Listen:
    114 hu      |Trlt listk:
    115 TX=de   |Nichts zu lschen!
    115 hu      |Semmit sem trlni!
    116 TX=de   |Angelegte Listen:
    116 hu      |Felvitt listk:
    117 TX=de   |Nichts zu erzeugen!
    117 hu      |Semmit sem ltrehozni!
"******** changePrintDebugLevel.sh ********
    118 TX=de   |Script im Mandanten ausfhren!
    118 hu      |Script vgrehajtsa a mandantban!
"******** checkAwk.sh ********
    119 TX=de   |Option -f: alle installierten awk testen, kein Abbruch im Fehlerfall
    119 hu      |Opci -f: sszes installlt awk tesztelse, nincs megszakts hiba esetben
    120 TX=de   |Option -d <directory>: fhre Tests in <directory> durch (nur
    120 hu      |Opci -d <directory>: Tesztek vgrehajtsa <directory>-ban (csak
    121 TX=de   |gltig ohne Option -f)
    121 hu      |-f opci nlkl rvnyes)
    122 TX=de   |test awk auf bekannte Bugs
    122 hu      |awk tesztelse ismert hibkra vonatkozan
    123 TX=de   |In dieser Umgebung gehrt das Skript nicht zum Lieferumfang.
    123 hu      |Ebben a krnyezetben a script nem tartozik az alapcsomaghoz.
    124 TX=de   |Das Skript wurde in einer zu alten Umgebung aufgerufen.
    124 hu      |A script egy tl rgi krnyezetben kerlt lehvsra.
    125 TX=de   |Optionen -d und -f sind nicht kombinierbar
    125 hu      |A -d s -f opcik nem kombinlhatk
    126 TX=de   |${DIR}/$AWK_PROG nicht gefunden
    126 hu      |${DIR}/$AWK_PROG nem talltam
    127 TX=de   |${DIR}/$AWK_PROG nicht ausfhrbar
    127 hu      |${DIR}/$AWK_PROG nem vgrehajthat
"******** checkPrinter.sh ********
    128 TX=de   |Drucker prfen:
    128 hu      |Nyomtat ellenrzse:
    129 TX=de   |* Option -p: lpr-Name des Druckers am Server
    129 hu      |* Opci -p: A nyomtat lpr neve a szervernl
    130 TX=de   |* Option -t: Datentyp der Druckdatei (pdf, ps, pcl, direct). Default=pdf
    130 hu      |* Opci -t: A nyomtatsi fjl adattpusa (pdf, ps, pcl, direct). Alaprtelmezett=pdf
    131 TX=de   |* Option -i: PDF-Datei die verwendet werden soll. Falls nicht angegeben
    131 hu      |* Opci -i: PDF fjl ami hasznlatra kerljn. Ha nincs megadva
    132 TX=de   |werden die Testdateien aus HOMEDIR/print/testdoc/ verwendet.
    132 hu      |akkor a HOMEDIR/print/testdoc/-bl kerlnek hasznlatra a tesztfjlok.
    133 TX=de   |* Option -g: Modus mit dem GhostScript die Datei umwandeln soll. Option
    133 hu      |* Opci -g: Md amivel GhostScript a fjlt talaktsa. Opci
    134 TX=de   |ist nur wirksam wenn -t nicht verwendet wird!
    134 hu      |csak akkor hatkony, ha -t nem kerl hasznlatra!
    135 TX=de   |* Option -o: Zustzliche GhostScript Option (z.B. -dPDFFitPage)
    135 hu      |* Opci -o: Kiegszt GhostScript opci (pl. -dPDFFitPage)
    136 TX=de   |* Option -s: Passwort fr GhostScript bei verschlsselten PDF-Dokumenten
    136 hu      |* Opci -s: Jelsz GhostScript-hez kdolt PDF dokumentumoknl
    137 TX=de   |* Option -c: Kopieoption fr den lpr-Befehl
    137 hu      |* Opci -c: Msolsi opci az lpr parancshoz
    138 TX=de   |Wandle PDF-Dokument ($printfile) nach $printfile.$printertype um ...
    138 hu      |PDF dokumentum ($printfile) $printfile.$printertype-ba val talaktsa ...
    139 TX=de   |Verwendetes Kommando:
    139 hu      |Hasznlt parancs:
    140 TX=de   |Druckauftrag nicht versenden ...
    140 hu      |Nyomtatsi megbzst nem elkldeni ...
    141 TX=de   |Drucke $printertype-Dokument ($printfileName) ...
    141 hu      |$printertype dokumentum ($printfileName) nyomtatsa ...
    142 TX=de   |GhostScript-Fehler beim Umwandeln der PDF-Datei aufgetreten!
    142 hu      |GhostScript hiba lpett fel a PDF fjl talaktsnl!
    143 TX=de   |Kein Drucker angegeben! Bitte zu testenden Drucker mit Option -p setzen.
    143 hu      |Nincs nyomtat megadva! Helyezze el a tesztelend nyomtatt a -p opcival!
    144 TX=de   |Die Optionen -t und -g nicht zusammen verwenden!
    144 hu      |A -t s -g opcikat nem szabad egytt megadni.
    145 TX=de   |Bei Option -p muss ein lpr-Druckername angegeben werden!
    145 hu      |A -p opcinl meg kell adni egy lpr nyomtat nevet!
    146 TX=de   |ACHTUNG!! Kein Formattyp angegeben. Es wird PDF verwendet!
    146 hu      |FIGYELEM!! Nincs megadva formtumtpus. PDF kerl hasznlatra!
    147 TX=de   |HINWEIS: Keine Testdatei angegeben. Es werden die Dokumente aus HOMEDIR/print/testdoc gedruckt!
    147 hu      |MEGJEGYZS: Nincs megadva tesztfjl. A HOMEDIR/print/testdoc-bl kerlnek nyomtatsra a dokumentumok!
    148 TX=de   |Angegebene Testdatei ($pfile) nicht gefunden!
    148 hu      |Megadott tesztfjl ($pfile) nem tallhat!
"******** chgcountrydata.sh ********
    149 TX=de   |FEHLER: Die sprachabhngige Lnderdatei wurde nicht erfolgreich generiert! (chgcountrydata.sh)
    149 hu      |HIBA: A nyelvfgg orszgfjl sikertelnl kerlt generlsra! (chgcountrydata.sh)
    150 TX=de   |Sprache oder Datei nicht gefunden!
    150 hu      |Nyelv fjl nem tallhat!
    151 TX=de   |Bitte prfen Sie das bergebene Sprachkrzel:
    151 hu      |Ellenrizze az tadott nyelvrvidtst:
    152 TX=de   |Bei korrektem Sprachkrzel folgende Datei berprfen:
    152 hu      |Korrekt nyelvrvidtsnl a kvetkez fjl ellenrzse:
    153 TX=de   |* Option -l: Sprachkrzel [a,en,esp]
    153 hu      |* Opci -l: Nyelvrvidts [a,en,esp]
    154 TX=de   |* Option -s: nur Suchworte ndern
    154 hu      |* Opci -s: Csak keresszavak mdostsa
    155 TX=de   |Skript muss im Mandantenverzeichnis ausgefhrt werden!
    155 hu      |A skriptet vgre kell hajtani a mandantknyvtrban!
    156 TX=de   |Generierung der sprachabhngigen Lnderdaten ...
    156 hu      |A nyelvfgg orszgadatok generlsa ...
    157 TX=de   |nderung der Lnderdaten ...
    157 hu      |Az orszgadatok mdostsa ...
    158 TX=de   |nderung der Lndersuchworte ...
    158 hu      |Az orszg keresszavak mdostsa ...
    159 TX=de   |nderungen gespeichert!
    159 hu      |Mdostsok elmentve!
"******** chkmvjavafops.sh ********
    160 TX=de   |* Option -f: Verschieben (sonst nur Ausgabe)
    160 hu      |* Opci -f: Eltols (egybknt csak kiads)
    161 TX=de   |* Option -c: Verzeichnis fuer Klassen (Default: java/classes)
    161 hu      |* Opci -c: Knyvtr osztlyokhoz (alaprtelmezett: java/classes)
    162 TX=de   |Kann Verzeichnis rmdir=$rmdir nicht loeschen.
    162 hu      |rmdir=$rmdir knyvtrat nem tudja trlni.
    163 TX=de   |Kein Mandantenverzeichnis.
    163 hu      |Nem mandant-knyvtr.
    164 TX=de   |Verzeichnis $CLASSES_DIR existiert nicht.
    164 hu      |$CLASSES_DIR knyvtr nem ltezik.
"******** copy_screen.sh ********
    165 TX=de   |Kopiert eine Maske (neue Maskenbeschreibung)
    165 hu      |Msol egy maszkot (j maszklers)
    166 TX=de   |* Option -e: Maske exportieren?
    166 hu      |* Opci -e: Maszk exportlsa?
    167 TX=de   |* Option -n num: Identnummer
    167 hu      |* Opci -n num: Hivatkozsi szm
    168 TX=de   |* Option -p prio: Prioritt
    168 hu      |* Opci -p prio: Priorits
    169 TX=de   |* Option -s searchword: Suchwort
    169 hu      |* Opci -s searchword: Keressz
    170 TX=de   |* Option -w workspace: Arbeitsbereich
    170 hu      |* Opci -w workspace: Munkatartomny
    171 TX=de   |Verzeichnis $dir existiert nicht
    171 hu      |$dir knyvtr nem ltezik
    172 TX=de   |Datei $dname nicht gefunden
    172 hu      |$dname nem talltam
    173 TX=de   |Das Verzeichnis $dir konnte nicht gelscht werden
    173 hu      |A knyvtrat nem lehet trlni: $dir
    174 TX=de   |Das Verzeichnis $dir konnte nicht angelegt werden
    174 hu      |Knyvtr $dir nem volt felvihet
    175 TX=de   |Datei $src konnte nicht nach $target kopiert werden
    175 hu      |A $src fjlt nem lehetett a $target-be msolni
    176 TX=de   |Die Maske $mask konnte nicht gelscht werden
    176 hu      |A $mask maszkot nem lehetett trlni
"******** create_database_and_group_name_translation_files.sh ********
    177 TX=de   |* Option -o: Verzeichnis fr die Property-Dateien
    177 hu      |* Opci -o: knyvtr property fjlokhoz
    178 TX=de   |Kann ISO-Krzel zu Sprache $l3_spr nicht ermitteln
    178 hu      |Az ISO rvidts a $l3_spr nyelvhez nem meghatrozhat
    179 TX=de   |Mehr als 1 Zeile in ISO-Datei $l3_out
    179 hu      |Tbb mint 1 sor a $l3_out ISO fjlban
    180 TX=de   |Fehler bei sed in Zeile $LINENO (rc=$rc)
    180 hu      |Hiba a sed-nl a $LINENO sorban (rc=$rc)
    181 TX=de   |Unerlaubtes Krzel $l2_kuerzel
    181 hu      |Nem megengedett $l2_kuerzel rvidts
    182 TX=de   |edpexport-Aufruf fr Sprache $l1_spr endete mit rc=$rc
    182 hu      |Az edpexport lehvs a $l1_spr nyelvhez rc=$rc-vel vgzdtt
    183 TX=de   |Verzeichnis $mdir nicht gefunden
    183 hu      |$mdir knyvtr nem tallhat
    184 TX=de   |Kann nicht in Verzeichnis $mdir wechseln
    184 hu      |Nem lehet vltani a $mdir knyvtrba
    185 TX=de   |Ausgabeverzeichnis muss angegeben werden
    185 hu      |A kiadsi knyvtrat meg kell adni
    186 TX=de   |Ausgabeverzeichnis $outputdir existiert nicht
    186 hu      |A $outputdir kiadsi knyvtr nem ltezik
    187 TX=de   |Keine Schreibberechtigung in Ausgabeverzeichnis $outputdir
    187 hu      |Nincs rsi jogosultsg a $outputdir kiadsi knyvtrban
    188 TX=de   |Passwort muss angegeben werden
    188 hu      |Meg kell adni jelszt
    189 TX=de   |Fehler bei echo
    189 hu      |Hiba a echo-nl
    190 TX=de   |Keine Bediensprachen installiert
    190 hu      |Nincsenek kezelnyelvek installlva
"******** create_mandant.sh ********
    191 TX=de   |* Option -m Mandant    Zu initialisierender Mandant (Name oder Pfad)
    191 hu      |* Opci -m Mandant          Inicializland mandant (Nv vagy elrsi t)
    192 TX=de   |* Option -i: Art der Initialisierung:
    192 hu      |* Opci -i: Az inicializls tpusa:
    193 TX=de   |EMPTY    Leermandant, enthlt div. Passwrter,
    193 hu      |EMPTY    res mandant, kl. jelszavakat tartalmaz,
    194 TX=de   |Firmenstamm-Einmalobjekte, Konten
    194 hu      |vllalattrzs-egyszeri objektumokat, fkvszlkat
    195 TX=de   |Zusatzpositionen, Infosysteme
    195 hu      |Ptpozcik, Infosystem
    196 TX=de   |Enthlt keine Lizenz!
    196 hu      |Nem tartalmaz licencet!
    197 TX=de   |INIT     Vollstndig initialisierter Mandant,
    197 hu      |INIT     Teljesen inicializlt mandant,
    198 TX=de   |enthlt nur Passwrter, Vartab
    198 hu      |csak jelszavakat, Vartabot tartalmaz
    199 TX=de   |ARCHIVE  Aus individiuellem Archiv geladener Mandant
    199 hu      |ARCHIVE  Egyedi archvumbl betlttt mandant
    200 TX=de   |Das Archiv ist mit der Option -a anzugeben
    200 hu      |Az archvumot az -a opcival kell megadni
    201 TX=de   |* Option -a: Alternatives Mandanten-Archiv verwenden
    201 hu      |* Opci -a: Alternatv mandant archvum hasznlata
    202 TX=de   |Das Verzeichnis ${mandpfad}/.ssh ist vorhanden. Verschieben nach ${HOMEDIR}/Messages/mandhelp.${manduser} gescheitert!
    202 hu      |A ${mandpfad}/.ssh knyvtr rendelkezsre ll. A ${HOMEDIR}/Messages/mandhelp.${manduser}-be val eltols nem sikerlt.
    203 TX=de   |Kein .ssh-Verzeichnis-Link in ${mandpfad} vorhanden.
    203 hu      |Nem ll rendelkezsre .ssh knyvtr link a ${mandpfad}-ban.
    204 TX=de   |Verschieben nach ${HOMEDIR}/Messages/mandhelp.${manduser} gescheitert!
    204 hu      |A ${HOMEDIR}/Messages/mandhelp.${manduser}-be val eltols nem sikerlt.
    205 TX=de   |Verzeichnis muss restauriert werden (als root-User):
    205 hu      |A knyvtrat helyre kell lltani (root felhasznlknt):
    206 TX=de   |Kann Mandantenverzeichnis $mandpfad nicht lschen
    206 hu      |$mandpfad manadantknyvtr nem trlhet
    207 TX=de   |Kann Mandantenverzeichnis $mandpfad nicht neu anlegen
    207 hu      |$mandpfad mandantknyvtr nem helyezhet el jonnan
    208 TX=de   |ACHTUNG!
    208 hu      |FIGYELEM!
    209 TX=de   |${mandpfad}/.ssh ist ein Link. Anmelden per ssh im Mandant kann scheitern.
    209 hu      |A ${mandpfad}/.ssh egy link. Az ssh-val val bejelentkezs a mandantban meghisulhat.
    210 TX=de   |Korrektur als root-User starten:
    210 hu      |Korrekci elindtsa root felhasznlknt:
    211 TX=de   |Kein .ssh-Verzeichnis in ${mandpfad} vorhanden. Restaurieren aus ${HOMEDIR}/Messages/mandhelp.${manduser} gescheitert.
    211 hu      |Nem ll rendelkezsre .ssh knyvtr a ${mandpfad}-ban. A ${HOMEDIR}/Messages/mandhelp.${manduser}-bl val helyrellts nem sikerlt.
    212 TX=de   |Kann Umgebungsdateien denv.* nicht erzeugen
    212 hu      |denv.* krnyezeti vltozk nem kszthetk
    213 TX=de   |Kann Benutzer und Gruppe fr ${mandpfad} nicht setzen
    213 hu      |Felhasznlt s csoportot nem tudja elhelyezni a ${mandpfad}-hoz
    214 TX=de   |Erzeugen des Mandanten gescheitert.
    214 hu      |A mandant ltrehozsa nem sikerlt.
    215 TX=de   |Darf nicht als root laufen
    215 hu      |Nem szabad root knt futnia
    216 TX=de   |Verzeichnis $HOMEDIRREFI fehlt
    216 hu      |$HOMEDIRREFI knyvtr hinyzik
    217 TX=de   |Verzeichnis $HOMEDIRREFU fehlt
    217 hu      |$HOMEDIRREFU knyvtr hinyzik
    218 TX=de   |Fehler beim Kopieren der Standarddateien aus $HOMEDIRREFI
    218 hu      |Hiba a standard fjlok $HOMEDIRREFI-bl val msolsakor
    219 TX=de   |Fehler beim Kopieren der Standarddateien aus $HOMEDIRREFU
    219 hu      |Hiba a standard fjlok $HOMEDIRREFU-bl val msolsakor
    220 TX=de   |Fehler beim Erzeugen des Verzeichnisses $dir
    220 hu      |Hiba a $dir knyvtr ksztsnl
    221 TX=de   |Archivdatei fr Mandanten fehlt ($MANDARCHIV)
    221 hu      |Archvum fjl mandanthoz hinyzik ($MANDARCHIV)
    222 TX=de   |Fehler beim Auspacken der Archivdatei fr Mandanten ($MANDARCHIV) aufgetreten.
    222 hu      |Hiba lpett fel az archvumfjl kicsomagolsnl a mandantokhoz ($MANDARCHIV).
    223 TX=de   |Kann Datenbankdefinitionsdateien nicht initialisieren
    223 hu      |Adatbzis definci fjlokat nem tud inicializlni
    224 TX=de   |Fehler beim Generieren der Aufzhlungen
    224 hu      |Hiba a felsorolsok generlsnl
    225 TX=de   |Fehler bei der Maskengenerierung
    225 hu      |Hiba a maszkgenerlsnl
    226 TX=de   |Kann GUI-Dateien nicht installieren
    226 hu      |GUI-fjlok nem installlhatk
    227 TX=de   |Erstellen des Archivs mit den fr eine lokale GUI-Installation notwendigen Dateien gescheitert
    227 hu      |Nem sikerlt az archvum ksztse a helyi GUI installcihoz szksges fjlokkal
    228 TX=de   |Initialisierungs-Art fehlt
    228 hu      |Inicializlsi tpus hinyzik
    229 TX=de   |Ungltige Initialisierungs-Art: $initart
    229 hu      |rvnytelen inicializcis tpus: $initart
    230 TX=de   |Mandant fehlt
    230 hu      |Hinyz mandant
    231 TX=de   |Ignoriere denv.dat
    231 hu      |Ignorld denv.dat
    232 TX=de   |Kann Mandantenverzeichnis $mandant nicht neu anlegen
    232 hu      |$mandant mandantknyvtr nem helyezhet el jonnan
    233 TX=de   |$mandpfad: Mandant ist geschtzt und darf nicht initialisiert werden!
    233 hu      |$mandpfad: A mandant vdett s nem szabad inicializlni!
    234 TX=de   |Mandanten-Archiv $RELMANDARCHIV fehlt
    234 hu      |Mandant-archvum $RELMANDARCHIV hinyzik
"******** create_new_db_file.sh ********
    235 TX=de   |Fehler: Returncode=$l3_rc bei $1
    235 hu      |Hiba: Returncode=$l3_rc $1 nl
    236 TX=de   |Verzeichnis $mandverz nicht gefunden
    236 hu      |$mandverz knyvtr nem tallhat
    237 TX=de   |Datei denv.$d fehlt in $mandverz. envmake aufrufen
    237 hu      |denv.$d fjl hinyzik $mandverz-ben. envmake lehvsa
    238 TX=de   |eval sh denv.sh in $mandverz endete mit rc=$rc
    238 hu      |eval sh denv.sh $mandverz-ben rc=$rc-vel vgzdtt
    239 TX=de   |Es konnte kein neuer Checkpunkt geschrieben werden, da soeben eine Garbage Collection endete
    239 hu      |Nem lehetett rni j ellenrz pontot, mivel pp most fejezdtt be egy Garbage Collection
"******** csv2datev.sh ********
    240 TX=de   |* Option -o: Ausgabeverzeichnis
    240 hu      |* Opci -o: Kiadsi knyvtr
    241 TX=de   |* Option -e: Eingabeencoding
    241 hu      |* Opci -e: Bevitel kdols
    242 TX=de   |* Option -i: Eingabedateien
    242 hu      |* Opci -i: Beviteli fjlok
"******** dataset_info_analyze.sh ********
    243 TX=de   |Stze
    243 hu      |Ttelek
    244 TX=de   |(Anzahl/Bytes)
    244 hu      |(Szm/Byte)
    245 TX=de   |Freilisten
    245 hu      |Szabad lista
    246 TX=de   |Suchbaumknoten
    246 hu      |Keresfa-struktra csompont
    247 TX=de   |Altversionen
    247 hu      |Rgi verzik
    248 TX=de   |gesamt
    248 hu      |ssz.
    249 TX=de   |Differenz
    249 hu      |Klnbzet
    250 TX=de   |Bestandsverlauf der grten Dateien
    250 hu      |A legnagyobb fjlok kszletalakulsa
    251 TX=de   |Verlauf der grten Bestandszunahmen
    251 hu      |A legnagyobb kszletnvekedsek alakulsa
    252 TX=de   |Argument input_file: Protokolldatei von dataset_info.sh folgenden Inhalts:
    252 hu      |input_file argumentum: A dataset_info.sh jegyzknyvfjlja a kvetkez tartalommal rendelkezik:
    253 TX=de   |* Option -n: Nur die n grten Dateien anzeigen
    253 hu      |* Opci -n: Csak az n legnagyobb fjlok megjelentse
    254 TX=de   |Default: alle Dateien
    254 hu      |Alaprtelmezett: sszes fjl
    255 TX=de   |* Option -m: Nur die m Dateien mit dem grten Zuwachs anzeigen
    255 hu      |* Opci -m: Csak a legnagyobb nvekedssel rendelkez m fjlok megjelentse
    256 TX=de   |* Option -i: Ausgabeintervall
    256 hu      |* Opci -i: Kiadsi intervallum
    257 TX=de   |Beispiel: Die Inputdatei enthalte fr jeden Tag einen Eintrag
    257 hu      |Plda: Az input fjl minden egyes naphoz tartalmaz egy bevitelt
    258 TX=de   |-i 7 bedeutet dann, dass Bestandsnderungen in Intervallen von 7 Tagen ausgegeben werden
    258 hu      |Az -i 7 ekkor azt jelenti, hogy a kszletvltozsok 7 napos intervallumokban kerlnek kiadsra
    259 TX=de   |Default: 1
    259 hu      |Alap: 1
    260 TX=de   |$input_file ist keine Datei oder leer
    260 hu      |$input_file nem fjl vagy res
    261 TX=de   |Datei $input_file enthlt keine Zeilen, die nur aus Datumsangaben der Form YYYYMMDDhhmm bestehen
    261 hu      |A $input_file fjl nem tartalmaz olyan sorokat, amik csak YYYYMMDDhhmm formj dtum megadsokbl llnak
    262 TX=de   |Datei $input_file enthlt keine Ausgabezeilen von dataset_info.sh
    262 hu      |A $input_file fjl nem tartalmazza a dataset_info.sh kiadsi sorait
    263 TX=de   |Ungltiges Argument $anz_top oder $anz_top_diff
    263 hu      |rvnytelen $anz_top vagy $anz_top_diff argumentum
    264 TX=de   |awk endete mit Fehler $rc
    264 hu      |awk $rc hiba sttussal fejezdtt be
"******** datrep007.sh ********
    265 TX=de   |Fehlermeldungen siehe $serr
    265 hu      |hibazenetek $serr
    266 TX=de   |erster awk endete mit Fehler (rc=$l6_rc)
    266 hu      |Els awk hibval vgzdtt (rc=$l6_rc)
    267 TX=de   |Keine Datenbankdatei zu Adresse $l8_segnr:*:$l8_gen gefunden
    267 hu      |Nem tallhat adatbzis fjl a $l8_segnr:*:$l8_gen cmhez
    268 TX=de   |zweiter awk endete mit Fehler (rc=$l9_rc)
    268 hu      |Msodik awk hibval vgzdtt (rc=$l9_rc)
    269 TX=de   |Datei $l9_out hat mehr als $l9_anz_prozesse Zeilen
    269 hu      |A $l9_out fjl tbb mint $l9_anz_prozesse sorral rendelkezik
    270 TX=de   |Datei $l10_in hat $l10_anz_zeilen Zeilen
    270 hu      |A $l10_in fjl $l10_anz_zeilen sorral rendelkezik
    271 TX=de   |Dies ist auerhalb des Intervalls 1 - $l10_anz_prozesse.
    271 hu      |Ez az 1 - $l10_anz_prozesse intervallumon kvl van
    272 TX=de   |Es werden zwei Prfungen durchgefhrt:
    272 hu      |Kt ellenrzs kerl vgrehajtsra:
    273 TX=de   |Scannen: Die Datenbankdateien werden sequentiell gelesen.
    273 hu      |Szkennels: Az adatbzis fjlok szekvencilisan kerlnek olvassra.
    274 TX=de   |Adressprfung: Zu allen Satz Ids werden deren physikalische Adressen geprft
    274 hu      |Cm ellenrzs: Az sszes rekord ID-hez ellenrzsre kerlnek azok fizikai cmei
    275 TX=de   |* Option -s: Nur Scannen
    275 hu      |* Opci -s: Csak szkennels
    276 TX=de   |* Option -k: Nur Adressprfung
    276 hu      |* Opci -k: Csak cm ellenrzs
    277 TX=de   |* Option -f: Scannen ab Adresse from
    277 hu      |* Opci -f: Szkennels tl cmtl
    278 TX=de   |Dabei ist from von der Form n:m:k
    278 hu      |Ennl a tl n:m:k formtum
    279 TX=de   |n: Dateinummer
    279 hu      |n: Fjlszm
    280 TX=de   |m: Offset
    280 hu      |m: Offset
    281 TX=de   |k: Loggeneration (0 oder 1)
    281 hu      |k: Log generci (0 vagy 1)
    282 TX=de   |Default: Beginn der Datenbank
    282 hu      |Alaprtelmezett: Az adatbzis kezdete
    283 TX=de   |* Option -t: Scannen bis Adresse to
    283 hu      |* Opci -t: Szkennels az ig cmig
    284 TX=de   |Dabei ist to von der Form n:m:k (siehe Option -f)
    284 hu      |Ennl az ig n:m:k formtum (lsd -f opci)
    285 TX=de   |Default: Ende der Datenbank
    285 hu      |Alaprtelmezett: Az adatbzis vge
    286 TX=de   |* Option -e: Beim Scannen keine Liste der Adressen aller Datenstze erstellen
    286 hu      |* Opci -e: A szkennelsnl az sszes rekord cmeinek a listjt nem elkszteni
    287 TX=de   |Die Liste bentigt man z.B. um alte Versionen von Datenstzen zu finden
    287 hu      |A listra pl. rekordok rgi verziinak a megtallshoz van szksgnk
    288 TX=de   |* Option -d: Adressprfung nur fr Datei dn
    288 hu      |* Opci -d: Cm ellenrzs csak dn fjlhoz
    289 TX=de   |Option ist mehrfach angebbar
    289 hu      |Opci tbbszr megadhat
    290 TX=de   |Default: Alle Dateien werden geprft
    290 hu      |Alaprtelmezett: sszes fjl ellenrzsre kerl
    291 TX=de   |* Option -y: Keine Kammvektor reparatur erstellen
    291 hu      |* Opci -y: Nem kszteni fs vektor javtst
    292 TX=de   |* Option -p: Fr das Scannen count parallele Prozesse starten
    292 hu      |* Opci -p: A szkennelshez count prhuzamos folyamatok elindtsa
    293 TX=de   |* Option -q: Fr die Adressprfung count parallele Prozesse starten
    293 hu      |* Opci -q: A cm ellenrzshez count prhuzamos folyamatok elindtsa
    294 TX=de   |Ist keine der Optionen -p oder -q gesetzt, wird versucht, alle CPUs zu benutzen
    294 hu      |Ha a -p vagy -q opcik egyike sincs elhelyezve, akkor ksrlet trtnik az sszes CPU hasznlatra
    295 TX=de   |Ist die Zahl der CPUs nicht bestimmbar, werden fr Scannen und Adressprfung je 2 CPUs verwendet
    295 hu      |Ha a CPU-k szma nem meghatrozhat, akkor a szkennelshez s cm ellenrzshez 2-2 CPU kerl hasznlatra
    296 TX=de   |* Option -v: Zustzliche Hinweise zum Programmverlauf ausgeben
    296 hu      |* Opci -v: Kiegszt megjegyzsek kiadsa a programfutshoz
    297 TX=de   |* Option -z: Debugging: Ausgabe der erzeugten temporrern Dateien
    297 hu      |* Opci -z: Debugging: A ltrehozott ideiglenes fjlok kiadsa
    298 TX=de   |Adresse $l1_adr hat falsches Format
    298 hu      |A $l1_adr cm rossz formtummal rendelkezik
    299 TX=de   |Prozess($l13_art) $l13_proznr (pid=$l13_pid) mit Fehler beendet. Siehe $l13_errorout
    299 hu      |Folyamat($l13_art) $l13_proznr (pid=$l13_pid) hibval befejezve. Lsd $l13_errorout
    300 TX=de   |Unerlaubte Art $l13_art
    300 hu      |Nem megengedett $l13_art tpus
    301 TX=de   |Noch $l13_aktive $l13_art Prozesse aktiv
    301 hu      |Mg $l13_aktive $l13_art folyamat aktv
    302 TX=de   |Unerlaubte Art $l21_prozess_art
    302 hu      |Nem megengedett $l21_prozess_art tpus
    303 TX=de   |Prozess($l21_prozess_art) $l21_proznr(pid=$l21_pid) lief nicht korrekt zu Ende, $l21_prozess_output, $l21_grep_pattern_fuer_output_ende, retwert=$retwert, l21_fehler_retwert=$l21_fehler_retwert
    303 hu      |A folyamat ($l21_prozess_art) $l21_proznr(pid=$l21_pid) nem korrekten futott vgig, $l21_prozess_output, $l21_grep_pattern_fuer_output_ende, retwert=$retwert, l21_fehler_retwert=$l21_fehler_retwert
    304 TX=de   |$mandverz ist kein absoluter Pfad
    304 hu      |A $mandverz nem abszolt elrsi tvonal
    305 TX=de   |Verzeichnis $d existiert nicht
    305 hu      |$d knyvtr nem ltezik
    306 TX=de   |Datei $mandverz/$d fehlt
    306 hu      |$mandverz/$d hinyzik
    307 TX=de   |Kann Umgebung in Verzeichnis $mandverz nicht herstellen
    307 hu      |Nem ltrehozhat krnyezet a $mandverz knyvtrban
    308 TX=de   |Es kann nur eine der Optionen -s und -k angegeben werden.
    308 hu      |Az -s s -k opciknak csak az egyike adhat meg.
    309 TX=de   |Bei Option -k knnen keine Adressen angegeben werden.
    309 hu      |A -k opcinl nem adhatk meg cmek.
    310 TX=de   |Bei Option -k kann die Prozessanzahl fr die Datenbankdateiprfung nicht angegeben werden.
    310 hu      |A -k opcinl nem adhat meg a folyamatok szma az adatbzis fjl ellenrzshez.
    311 TX=de   |Bei Option -s knnen keine Dateien angegeben werden.
    311 hu      |Az -s opcinl nem adhatk meg fjlok.
    312 TX=de   |Angeben von Prozessanzahl fr die Adressprfung sinnlos bei Option -s.
    312 hu      |A folyamatok szmnak a megadsa a cm ellenrzshez rtelmetlen az -s opcinl.
    313 TX=de   |Adresse $von_adr darf nicht grer als Adresse $bis_adr sein.
    313 hu      |A $von_adr cm nem lehet nagyobb, mint a $bis_adr cm.
    314 TX=de   |Argument $wert ist keine gltige Prozessanzahl
    314 hu      |A $wert argumentum nem rvnyes folyamat szm
    315 TX=de   |Argument ${dn_zu_checken[$i]} ist keine gltige Dateiangabe
    315 hu      |A ${dn_zu_checken[$i]} argumentum nem rvnyes fjl megads
    316 TX=de   |Dateinummer ${dn_zu_checken[$i]} ist auerhalb des erlaubten Bereichs ($min_dn ... $max_dn).
    316 hu      |A ${dn_zu_checken[$i]} fjlszm a megengedett ($min_dn ... $max_dn) tartomnyon kvl van
    317 TX=de   |Programmausgaben werden in Datei $sout geschrieben
    317 hu      |A program kiadsok a $sout fjlba kerlnek rsra
    318 TX=de   |Programmfehlermeldungen werden in Datei $serr geschrieben
    318 hu      |A program hibazenetek a $serr fjlba kerlnek rsra
    319 TX=de   |Analysedateien werden in Verzeichnis $logverz geschrieben
    319 hu      |Az analzis fjlok a $logverz knyvtrba kerlnek rsra
    320 TX=de   |Programm mit Fehler beendet. Siehe $serr. $(date).
    320 hu      |Program hibval befejezve. Lsd $serr. $(date).
    321 TX=de   |Programm ohne Fehler beendet. $(date).
    321 hu      |Program hiba nlkl befejezve. $(date).
"******** db_cons_check.sh ********
    322 TX=de   |* Option -m: Mandant, falls nicht aktuelles Verzeichnis
    322 hu      |* Opci -m: Mandant, ha nem aktulis knyvtr
    323 TX=de   |Kann nicht ins Mandantenverzeichnis $MAND wechseln
    323 hu      |Nem lehet $MAND mandantknyvtrba vltani
    324 TX=de   |Kann Umgebung im Mandanten nicht laden
    324 hu      |Krnyezet a mandantban nem betlthet
    325 TX=de   |Datenbank im Mandantenverzeichnis $MAND wird geprft.
    325 hu      |Adatbzis a $MAND mandantknyvtrban ellenrzsre kerl.
    326 TX=de   |Prfe LogDB-Strukturen mit datrep007...
    326 hu      |Log adatbzis struktrk ellenrzse datrep007-val...
    327 TX=de   |Aufruf von datrep007 mit exit status $rc gescheitert, vermutlich Datenschaden
    327 hu      |A datrep007 lehvsa a $rc exit sttussal nem sikerlt, valsznleg adatkrok
    328 TX=de   |ok
    328 hu      |ok
    329 TX=de   |Prfe Datenbank-Verwaltungsinformationen mit datrep0...
    329 hu      |Adatbzis kezelsi informcik ellenrzse datrep0-val...
    330 TX=de   |Aufruf von datrep0 mit exit status $rc gescheitert, siehe $logbase.err
    330 hu      |datrep0 lehvsa $rc exit sttussal nem sikerlt, lsd $logbase.err
    331 TX=de   |Prfe Datenstze und Schlssel mit datrep1...
    331 hu      |Rekordok s kulcsok ellenrzse datrep1-el...
    332 TX=de   |Aufruf von datrep1 mit exit status $rc gescheitert, siehe $logbase.err
    332 hu      |datrep1 lehvsa $rc exit sttussal nem sikerlt, lsd $logbase.err
    333 TX=de   |Datenbank ist in Ordnung, es wurden keine Fehler gefunden
    333 hu      |Az adatbzis rendben van, nem voltak tallhatk hibk
"******** db_trigger.sh ********
    334 TX=de   |* Option -s: Datenstze nicht ab aktuellem Ende sondern
    334 hu      |* Opci -s: Rekordok kiadsa nem az aktulis befejezstl,
    335 TX=de   |ab Startpunkt logadr ausgeben
    335 hu      |hanem a logadr kezdponttl
    336 TX=de   |logadr ist von der Form n:m:k (aktuell nur k=0 erlaubt)
    336 hu      |logadr az n:m:k formval rendelkezik (aktulisan csak k=0 megengedett)
    337 TX=de   |(siehe auch 2.Spalte der Ausgabe des Scripts)
    337 hu      |(lsd a script kiadsnak 2. oszlopt is)
    338 TX=de   |* Option -t: Nicht jede Sekunde sondern alle sleeptime Sekunden prfen
    338 hu      |* Opci -t: Ellenrzs nem minden egyes msodperben, hanem az sszes sleeptime msodpercben
    339 TX=de   |* Option -e: Aktuelles Logende ausgeben
    339 hu      |* Opci -e: Aktulis log befejezs kiadsa
    340 TX=de   |Abbruch des Programmes mit SIGHUP oder SIGINT auf die Prozessgruppe
    340 hu      |A program megszaktsa SIGHUP-vel vagy SIGINT-vel a folyamat csoportra
    341 TX=de   |Beispiel: 'kill -SIGHUP -123' (wobei 123 die Prozessnummer von $name ist)
    341 hu      |Plda: 'kill -SIGHUP -123' (ahol 123 a $name folyamatszma)
    342 TX=de   |Startpunkt $logadr ist nicht von der Form n:m:k
    342 hu      |A $logadr kezdpont nem az n:m:k formval rendelkezik
    343 TX=de   |Im Startpunkt $logadr ist die 3.Zahl != 0
    343 hu      |A $logadr kezdpontban a 3. szm != 0
    344 TX=de   |Im Startpunkt $logadr ist die 2.Zahl < minimaler Offset = $SegBegEintrag
    344 hu      |A $logadr kezdpontban a 2. szm < minimlis offset = $SegBegEintrag
"******** dispo.sh ********
    345 TX=de   |Aufruf: $0 [ max. Laufzeit in min ]
    345 hu      |meghvs: $0 [ max. futsi id percekben ]
"******** disposerv.sh ********
    346 TX=de   |* Option  +  : permanente Dispo einschalten
    346 hu      |* + opci    : lland diszp bekapcsolsa
    347 TX=de   |* Option  -  : permanente Dispo ausschalten
    347 hu      |* - opci    : lland diszp kikapcsolsa
    348 TX=de   |* ohne Option: Status der permanenten Dispo ermitteln
    348 hu      |* opci nlkl: alland diszp llapotnak vizsglsa
    349 TX=de   |$name im Mandantenverzeichnis aufrufen!
    349 hu      |$name a mandant-knyvtrbl kell indtani
    350 TX=de   |permanente Dispo ausschalten
    350 hu      |Permanens diszp kikapcsolsa
    351 TX=de   |* es ist keine permanente Dispo aktiv
    351 hu      |* nem aktv permanens diszp
    352 TX=de   |permanente Dispo anschalten
    352 hu      |Permanens diszp bekapcsolsa
    353 TX=de   |* permanente Dispo wird gerade gestartet
    353 hu      |* a permanens diszp pp elindtsra kerl
    354 TX=de   |* permanente Dispo laeuft bereits (pid=$pid)
    354 hu      |* a permanens diszp mr fut (pid=$pid)
    355 TX=de   |* permanente Dispo laeuft (pid=$pid)
    355 hu      |* a permanens diszp fut (pid=$pid)
"******** dmsexport.sh ********
    356 TX=de   |* Option -t: Testfall, kein su vor dem Export
    356 hu      |* Opci -t: Teszt eset, nincs su az export eltt
    357 TX=de   |* Option -d: Testmodus anschalten
    357 hu      |* -d: Tesztmdozat
"******** dn_keycmd_typecmd_2_strings.sh ********
    358 TX=de   |* Option -m: bersetzungen aus Mandant manddir holen
    358 hu      |* Opci -m: Fordtsok behozsa a manddir mandantbl
    359 TX=de   |* Option -p: pw: Passwort
    359 hu      |* Opci -p: pw: Jelsz
    360 TX=de   |* Option -P: Systemlogin verwenden
    360 hu      |* Opci -P: Rendszer login hasznlata
    361 TX=de   |* Option -l: lang: Krzel fr Sprache in der Kommandos angegeben werden
    361 hu      |* Opci -l: lang: Rvidts ahhoz a nyelvhez, amiben megadsra kerlnek utastsok
    362 TX=de   |Passwort fehlt!
    362 hu      |Hinyz jelsz!
    363 TX=de   |Datei $FOPDATEI.OUT (FOP-Output von $FOPDATEI) wurde nicht erzeugt
    363 hu      |$FOPDATEI.OUT fjl ($FOPDATEI FOP output-ja) nem kerlt ltrehozsra
    364 TX=de   |Ausgabe des batchlg-Aufrufs($rmdir/batchlg.out)
    364 hu      |A batchlg lehvs kiadsa ($rmdir/batchlg.out)
    365 TX=de   |Fehlerausgabe ($rmdir/batchlg.err)
    365 hu      |Hiba kiads ($rmdir/batchlg.err)
"******** drep1.sh ********
    366 TX=de   |Datei $d fehlt im Verzeichnis $(pwd)
    366 hu      |$d fjl hinyzik az knyvtrban: $(pwd)
    367 TX=de   |Umgebung kann nicht hergestellt werden
    367 hu      |Krnyezet nem hozhat ltre
    368 TX=de   |Umgebung konnte nicht hergestellt werden
    368 hu      |Krnyezetet nem lehetett ellltani
    369 TX=de   |Output in $logname
    369 hu      |Output in $logname
"******** ediconfig_admin.sh ********
    370 TX=de   |Speichert Aufrufparameterlisten.
    370 hu      |Elmenti a lehvsi paramter listkat.
    371 TX=de   |Datei nicht im Lieferumfang: $filename
    371 hu      |Fjl nincs az alapcsomagban: $filename
    372 TX=de   |Datei nicht gefunden: $filename
    372 hu      |$filename fjl nem tallhat
"******** edimsggen.sh ********
    373 TX=de   |* Option -n: Identnummer der zu generierenden Nachricht
    373 hu      |* Opci -n: A generland zenet hivatkozsi szma
    374 TX=de   |* Option -p: Passwort fr Abas Anmeldung
    374 hu      |* Opci -p: Jelsz Abas bejelentkezshez
"******** edpconf.sh ********
    375 TX=de   |Konfiguration konnte nicht durchgefhrt werden
    375 hu      |Konfigurci nem volt vgrehajthat
    376 TX=de   |Zurck
    376 hu      |Vissza
    377 TX=de   |Aktuelle EDP-Konfiguration auf Rechner `uname -n`:
    377 hu      |Aktulis EDP-konfigurci `uname -n` rendszeren:
    378 TX=de   |Veralteten Konfigurationseintrag gefunden:
    378 hu      |Elavult konfigurcis bejegyzs:
    379 TX=de   |$anzalt veraltete Konfigurationseintrge gefunden:
    379 hu      |$anzalt elavult konfigurcis bejegyzsek:
    380 TX=de   |$anzalt veraltete EDP-Konfigurationszeile(n) in /etc/inetd.conf gefunden:
    380 hu      |$anzalt elavult EDP-konfigurcis sor(ok) /etc/inetd.conf ban:
    381 TX=de   |Bitte zuerst Portnummer angeben!
    381 hu      |lszr adjon meg portszmot
    382 TX=de   |Portnummer muss numerisch sein!
    382 hu      |Portszmnak numerikusnak kell lennie!
    383 TX=de   |Portnummer zu klein - mu grer als 1024 sein!
    383 hu      |Portszm tl kicsi - nagyobbnak kell lennie mint 1024
    384 TX=de   |Prfe Konfigurationsdateien...
    384 hu      |Konfigurcis fjlok ellenrzse...
    385 TX=de   |Eintrge in den Konfigurationsdateien sind in Ordnung.
    385 hu      |A konfigurcis fjlok bejegyzsei rendben vannak.
    386 TX=de   |Testen EDP-Konfiguration fr Port $svcnr/$svcname nach <return>
    386 hu      |Az EDP-konfigurci tesztelse a $svcnr/$svcname portra a <return> utn
    387 TX=de   |Hinweis: Falls nach 1 Minute keine Reaktion mehr erfolgt,
    387 hu      |Utals: amennyiben 1 perc utn nem trtnik semmi,
    388 TX=de   |kann mit der Ebenenwechseltaste abgebrochen werden.
    388 hu      |a szintvlts billentyvel meg lehet szaktani.
    389 TX=de   |Prfe Zugriff ber Service $svcname...
    389 hu      |Hozzfrs ellenrzse $svcname...n keresztl
    390 TX=de   |EDP antwortet, HOMEDIR ist aber falsch angegeben!
    390 hu      |EDP vlaszol, HOMEDIR azonban rosszul megadva!
    391 TX=de   |EDP kann ber Service $svcname angesprochen werden
    391 hu      |EDP $svcname szervizen keresztl mkdtethet
    392 TX=de   |Der Service ist kein EDP-Server!
    392 hu      |A szerviz nem EDP-server!
    393 TX=de   |Kann EDP nicht ber den Service-Namen starten!
    393 hu      |EDP nem indthat a szerviz-nven keresztl!
    394 TX=de   |Prfe Zugriff ber Portnummer $svcnr...
    394 hu      |Hozzfrs ellenrzse $svcnr portszmon keresztl...
    395 TX=de   |EDP kann ber Portnummer $svcnr angesprochen werden
    395 hu      |EDP $svcnr portszmon keresztl mkdtethet
    396 TX=de   |Auf dem Port antwortet kein EDP-Server!
    396 hu      |A porton nem vlaszol EDP-szerver!
    397 TX=de   |Kann EDP nicht ber Portnummer $svcnr starten!
    397 hu      |Az EDP nem indthat $svcnr portszmon keresztl!
    398 TX=de   |EDP-Konfiguration in Ordnung.
    398 hu      |EDP-konfigurci rendben van.
    399 TX=de   |EDP-Zugriff nur ber Portnummer mglich, nicht ber Service-Name (unkritisch)
    399 hu      |EDP-hozzfrs csak portszmon keresztl lehetsges, nem szerviz-nven keresztl (nem kritikus)
    400 TX=de   |EDP-Konfiguration fehlerhaft. Bitte prfen!
    400 hu      |Hibs EDP-konfigurci. Krem, ellenrizze!
    401 TX=de   |Konfigurationsart whlen
    401 hu      |Konfigurcis md vlasztsa
    402 TX=de   |EDP-Port in System-Konfiguration: $svcnr
    402 hu      |EDP port rendszer konfigurciban: $svcnr
    403 TX=de   |EDP-Port aus homedir.env:         $svcnr_env
    403 hu      |EDP port homedir.env-bl:         $svcnr_env
    404 TX=de   |EDP-Port ist bereits konfiguriert, aber ungleich Umgebungsvariable EDPPORT
    404 hu      |EDP port mr konfigurlva van, de egyenltlenl az EDPPORT krnyezeti vltozhoz
    405 TX=de   |HOMEDIR=$HOMEDIR   Service=$svcname   Port=$svcnr
    405 hu      |HOMEDIR=$HOMEDIR   Szerviz=$svcname   Port=$svcnr
    406 TX=de   |EDP-Server konfigurieren
    406 hu      |EDP szerver konfigurlsa
    407 TX=de   |Anzeigen der konfigurierten Ports
    407 hu      |A konfigurlt portok megjelentse
    408 TX=de   |Anzeigen der verfgbaren Konfigurationsarten
    408 hu      |A rendelkezsre ll konfigurcis tpusok megjelentse
    409 TX=de   |Konfiguration mit aktuellem Port durchfhren
    409 hu      |Aktulis porttal rendelkez konfigurci vgrehajtsa
    410 TX=de   |Testen der Konfiguration mit aktuellem Port
    410 hu      |Aktulis porttal rendelkez konfigurci tesztelse
    411 TX=de   | Portnummernwahl (aktuelle Portnummer: $svcnr) 
    411 hu      | Portszm vlaszts (aktulis portszm: $svcnr) 
    412 TX=de   |Standard-EDP-Port:  6550
    412 hu      |Standard EDP port:  6550
    413 TX=de   |Zweiter EDP-Port:   6551 (nur falls 6550 schon vergeben)
    413 hu      |Msodik EDP port:   6551 (csak ha 6550 m ki van adva)
    414 TX=de   |Dritter EDP-Port:   6552 (nur falls 6550 und 6551 schon vergeben)
    414 hu      |Harmadik EDP port:  6552 (csak ha 6550 s 6551 mr ki van adva)
    415 TX=de   |Individuelle Portnummer eingeben
    415 hu      |Egyedi portszm bevitele
    416 TX=de   |Whlen der Konfigurationsart (aktuell: $konftype)
    416 hu      |A konfigurcis tpus kivlasztsa (aktulis: $konftype)
    417 TX=de   |Auf Rechner $hostname verfgbare Konfigurationsarten:
    417 hu      |$hostname rendszeren rendelkezsre ll konfigurcis tpusok:
    418 TX=de   |Portnummer:
    418 hu      |Portszm:
"******** edpexport.sh ********
    419 TX=de   |Kann edputils.sh nicht laden
    419 hu      |edputils.sh nem tlthet be
    420 TX=de   |$name: Exportieren von Daten aus Abas mittels EDP-Abfragen,
    420 hu      |$name: Adatok exportlsa Abas bl EDP-lekrdezsekkel,
    421 TX=de   |Ausgabe erfolgt auf der Standardausgabe
    421 hu      |Kiads a standard kiadson trtnik
    422 TX=de   |Verbindungs-Optionen:
    422 hu      |Kapcsolat-opcik:
    423 TX=de   |Angaben zur auszufhrenden Aktion:
    423 hu      |Adatok a vgrehajtand mvelethez:
    424 TX=de   |-a: Aktion: Q:  Query (Datenabfrage)     T:  Tabellenliste
    424 hu      |-a: Action: Q:  Query (adatlekrdezs)   T:  Tblzati lista
    425 TX=de   |R/RO: Lesen von Datenstzen/Objekten ber Primrschlssel (ID)
    425 hu      |R/RO: rekordok/objektumok olvassa elsdleges kulcson keresztl (ID)
    426 TX=de   |F:  Feldliste Selektion      FE: Feldliste Editor
    426 hu      |F:  Mez lista szelekci     FE: Mez lista szerkeszt
    427 TX=de   |FA: Feldliste alle Felder    FI: Feldliste Infosystem
    427 hu      |FA: sszes mez mezlistja  FI: Mezlista infosystem
    428 TX=de   |FV: Feldliste fr Verweisart FP: Feldliste fr Prozedur
    428 hu      |FV: Mezlista utals tpushoz FP: Mezlista procedrhoz
    429 TX=de   |S:  Schlsselliste           I:  Infosystemliste
    429 hu      |S:  Kulcslista               I:  Infosystemlistval
    430 TX=de   |D:  Datenbankliste           GA: Gruppenliste (alle Gruppen)
    430 hu      |D:  Adatbzislista           GA: Csoportlista (sszes csoport)
    431 TX=de   |G:  Gruppenliste Selektion   GN: Gruppenliste Neuanlage
    431 hu      |G:  Csoport lista szelekci  GN: Csoport lista j felvitel
    432 TX=de   |AK: Aufzhlungskpfe         AP: Aufzhlungspositionen
    432 hu      |AK: Felsorols fejrszek     AP: Felsorols ttelek
    433 TX=de   |V:  Verweisart-Info          VV: V-Verweis-Info
    433 hu      |V:  Utals tpus inf        VV: V utals inf
    434 TX=de   |MN: Meldung ber Nummer      MT: Meldung ber Text
    434 hu      |MN: zenet szmon keresztl  MT: zenet szvegen keresztl
    435 TX=de   |DC: Liste der Kommandos fr alle Datenbanken und Gruppen
    435 hu      |DC: Az utastsok listja az sszes adatbzishoz s csoporthoz
    436 TX=de   |OC: Liste der mglichen Kommandos fr ein Objekt
    436 hu      |OC: A lehetsges utastsok listja egy objektumhoz
    437 TX=de   |TC: Liste der Tippkommandos
    437 hu      |TC: A gpelsi parancsok listja
    438 TX=de   |DT: Informationen zu den Abas Datentypen
    438 hu      |DT: Informcik az Abas adattpusokhoz
    439 TX=de   |P:  Informationen zu Prozeduren
    439 hu      |P:  Informcik procedrkhoz
    440 TX=de   |XP: Prozedur ausfhren
    440 hu      |XP: Procedra vgrehajtsa
    441 TX=de   |TV: Wert gegen Art testen und aufbereiten
    441 hu      |TV: rtk tesztelse s elksztse tpussal szemben
    442 TX=de   |O:  Optionen
    442 hu      |O:  Opcik
    443 TX=de   |Default: Query
    443 hu      |Default: Query
    444 TX=de   |-l: Tabelle: Selektionsleiste oder Standardtabelle (Datei:Gruppe)
    444 hu      |-l: Tblzat: szelekcis sablon vagy standard tblzat (fjl:csoport)
    445 TX=de   |Dient auch als Argument fr Aktionen T,I,D,GA,G,GN,AK,AP,V,VV,MN,MT
    445 hu      |Argumentumknt is szolgl a T,I,D,GA,G,GN,AK,AP,V,VV,MN,MT mveletekhez
    446 TX=de   |Bei Aktionen MN/MT: Wrterbuch:Sprachliste:Gro/Klein-ignorieren
    446 hu      |MN/MT mveleteknl: sztr:nyelvlista:nagy/kis figyelmen kvl hagysa
    447 TX=de   |Bei Aktion I:  [Arbeitsbereich/][Suchwort][:Menge] oder Identnummer
    447 hu      |I mveletnl: [Munkatartomny/][Keressz][:Mennyisg] vagy hivatkozsi szm
    448 TX=de   |Bei Aktion P/XP: (auszufhrende) Prozedur
    448 hu      |P/XP mveletnl: (vgrehajtand) procedra
    449 TX=de   |-s: zu verwendender Schlssel bei Abfragen
    449 hu      |-s: alkalmazand kulcs lekrdezseknl
    450 TX=de   |-S: Sortierung der Daten (feld.richtung,feld.richtung,...)
    450 hu      |-S: Az adatok szortrozsa (feld.richtung,feld.richtung,...)
    451 TX=de   |-Z: Zeilenselektion: Selektion ber Tabellenzeilen auch bei Kopfschl.
    451 hu      |-Z: Sorszelekci: tblzati sorokon keresztli szelekci
    452 TX=de   |-A: Ablageart: lebendig, abgelegt, beides, alle (Default: lebendig)
    452 hu      |-A: Irattr tpusa: l, archivlt, mindkett, sszes (alaprtelmezett: l)
    453 TX=de   |-k: Selektionskriterien, auch mehrfach.
    453 hu      |-k: Szelekcis kritriumok, tbbszrs is.
    454 TX=de   |Bei Aktion Q: Selektionsstring gem Abas Selektionssyntax
    454 hu      |Q mveletnl: Szelekcis string Abas szelekcis szintakszis szerint
    455 TX=de   |Bei Aktion R: IDs der zu lesenden Stze mit ; getrennt
    455 hu      |R mveletnl: Az olvasand rekordok ID-jei ;-vel elvlasztva
    456 TX=de   |Bei Aktionen MN/MT: Meldungsnummern mit , getrennt oder Meldungtext
    456 hu      |MN/MT mveleteknl: zenet szmok ,-vel elvlasztva vagy zenet szveg
    457 TX=de   |Bei Aktion F*: Liste der Felder, fr die die Ausgabe erfolgen soll
    457 hu      |F* mveletnl: Azoknak a mezknek a listja, amikhez a kiads vgbemenjen
    458 TX=de   |Bei Aktion DC: [Datenbank][:Gruppe][:Kommando][:Mit Objekt]
    458 hu      |DC mveletnl: [Adatbzis][:Csoport][:Parancs][:Objektummal]
    459 TX=de   |[:Nur erlaubte][:Fr Passwort]
    459 hu      |[:Csak megengedett][:Jelszhoz]
    460 TX=de   |Bei Aktion OC: Objekt-ID[:Kommando][:Nur erlaubte][:Fr Passwort]
    460 hu      |Az OC mveletnl: Objektum ID[:Utasts][:Csak megengedett][:Jelszhoz]
    461 TX=de   |Bei Aktion TC: [Kommando][:Nur erlaubte][:Fr Passwort]
    461 hu      |TC mveletnl: [Parancs][:Csak megengedett][:Jelszhoz]
    462 TX=de   |Bei Aktion DT: Liste der Arten, fr die Informationen zurckgegeben werden sollen
    462 hu      |DT mveletnl: Azoknak a tpusoknak a listja, amikhez informcik visszaadsra kerljenek
    463 TX=de   |Bei Aktion TV: Angabe fr den zu testenden Wert in der Form \"Art=Wert\"
    463 hu      |TV mveletnl: megads a tesztelend rtkhez a \"tpus=rtk\" formban
    464 TX=de   |-K: Datei mit Selektionskriterien (eine Zeile je Abfrage)
    464 hu      |-K: Fjl szelekcis kritriumokkal (egy sor lekrdezsenknt)
    465 TX=de   |-f: Liste der auszugebenden Felder (komma-getrennt, Default: alle)
    465 hu      |-f: A kiadand mezk listja (vesszvel elvlasztott, alaprtelmezett: sszes)
    466 TX=de   |-F: Feldnamen als erste Zeile ausgeben (=berschriftzeile)
    466 hu      |-F: Meznevek els sorknt val kiadsa (=cmsor)
    467 TX=de   |-B: Feldbeschreibungen als erste Zeile ausgeben (=berschriftzeile)
    467 hu      |-B: Mezlersok els sorknt val kiadsa (=cmsor)
    468 TX=de   |-n: Nur count Stze ausgeben, beginnend bei start oder 1
    468 hu      |-n: Csak count ttelek kiadsa, start-nl vagy 1-nl kezdden
    469 TX=de   |Optionen:
    469 hu      |Opcik:
    470 TX=de   |-z: Fr Zeilenschaltung darzustellendes Zeichen (Default: #)
    470 hu      |-z: Sorvlts szmra brzoland karakter (Default: #)
    471 TX=de   |-j: Datumsdarstellung: EKS, EKS4 oder SORT (Default: EKS)
    471 hu      |-j: Dtumbrzols: EKS, EKS4 vagy SORT (default: EKS)
    472 TX=de   |-v: Verweisdarstellung: EXT oder REF (Default: EXT)
    472 hu      |-v: Utalsbrzols: EXI vagy REF (defult: EXI)
    473 TX=de   |-q: Freitextdarstellung: EXT oder TEXT[:n] (Default: EXT)
    473 hu      |-q: Szabad szveg brzols: EXI vagy TEXT[:n] [default: EXI)
    474 TX=de   |n ist die auszugebende Lnge; 0 = alles; Default: 300
    474 hu      |n a kiadand hosszsg; 0 = mind; default: 300
    475 TX=de   |-r: Dezimalpunktdarstellung bei Realzahlen: PERIOD oder COMMA
    475 hu      |-r: tizedes pont brzols vals szmoknl: PERIOD vagy COMMA
    476 TX=de   |(Default: PERIOD)
    476 hu      |(Default: PERIOD)
    477 TX=de   |-o: Setzen einer beliebigen EDP-Option. Argument: option=wert
    477 hu      |-o: Tetszleges EDP-opci elhelyezse. Argumentum: option=wert
    478 TX=de   |Diese Option kann beliebig hufig angegeben werden.
    478 hu      |Ez az opci tetszlegesen gyakran megadhat.
    479 TX=de   |-O: Formatieren der Ausgabe. Weitere Informationen erhalten Sie mit
    479 hu      |-O: A kiads formattlsa. Tovbbi informcik
    480 TX=de   |$FEHLERTEXT: \"$OPTARG\" ist als Feldtrenner nicht zulssig
    480 hu      |$FEHLERTEXT: \"$OPTARG\" mezelvlasztknt nem megengedett
    481 TX=de   |Bei Ausgabeformatierung drfen die Log-Ausgabe und Hinweise nicht auf Kanal 1 geleitet werden.
    481 hu      |A kiads formzsnl a log kiadst s az utalsokat nem szabad az 1-es csatornra vezetni.
    482 TX=de   |$FEHLERTEXT: Falsche Aktion: $aktion
    482 hu      |$FEHLERTEXT: Rossz mvelet: $aktion
    483 TX=de   |$FEHLERTEXT: Bitte eine Tabelle angeben!
    483 hu      |$FEHLERTEXT: Adjon meg tblzatot!
    484 TX=de   |$FEHLERTEXT: Bitte ein Infosystem angeben!
    484 hu      |$FEHLERTEXT: Adjon meg infosystemet!
    485 TX=de   |$FEHLERTEXT: Bitte eine Aufzhlung angeben (Option -l)!
    485 hu      |$FEHLERTEXT: Adjon meg felsorolst (opci -l)!
    486 TX=de   |$FEHLERTEXT: Bitte eine Verweis-Art angeben (Option -l)!
    486 hu      |$FEHLERTEXT: Adjon meg utals-tpust (-l opci)!
    487 TX=de   |$FEHLERTEXT: Bitte eine Prozedur angeben (Option -l)!
    487 hu      |$FEHLERTEXT: Adjon meg procedrt (opci -l)!
    488 TX=de   |$FEHLERTEXT: Bitte einen Meldungstext angeben (Option -k)!
    488 hu      |$FEHLERTEXT: Adjon meg egy zenet szveget (opci -k)!
    489 TX=de   |$FEHLERTEXT: Bitte IDs der zu lesenden Stze angeben (Option -k)!
    489 hu      |$FEHLERTEXT: Adja meg az olvasand rekordok ID-jeit (-k opci)!
    490 TX=de   |$FEHLERTEXT: Bitte entweder -l oder -k/-K angeben!
    490 hu      |$FEHLERTEXT: Adjon meg vagy -l-t vagy -k/-K-t!
    491 TX=de   |$FEHLERTEXT: Bitte ein Objekt angeben (Option -k)!
    491 hu      |$FEHLERTEXT: Adjon meg egy objektumot (opci -k)!
    492 TX=de   |$FEHLERTEXT: Bitte eine Prozedur angeben!
    492 hu      |$FEHLERTEXT: Adjon meg procedrt!
    493 TX=de   |$FEHLERTEXT: Zeilenselektion bei dieser Aktion nicht mglich!
    493 hu      |$FEHLERTEXT: Sorszelekci ennl a mveletnl nem lehetsges!
    494 TX=de   |$FEHLERTEXT: Ablageart kann bei dieser Aktion nicht verwendet werden!
    494 hu      |$FEHLERTEXT: Irattr-tpus ennl a mveletnl nem hasznlhat!
    495 TX=de   |$FEHLERTEXT: Passwort fehlt!
    495 hu      |$FEHLERTEXT: Hinyz jelsz!
    496 TX=de   |datmod_ende_abwarten.sh vorher lieferte rc=$rc
    496 hu      |datmod_ende_abwarten.sh elzleg szlltott rc=$rc
"******** edpimport.sh ********
    497 TX=de   |Datenzeile enthlt mehr Felder als Feldliste
    497 hu      |Adatsor tbb mezt tartalmaz, mint a mezlista
    498 TX=de   |Erstes Tabellenfeld fehlt!
    498 hu      |Els tblzati mez hinyzik!
    499 TX=de   |Erstes Tabellenfeld nicht gefunden
    499 hu      |Els tblzati mez nem tallhat
    500 TX=de   |Ungltige Steueranweisung
    500 hu      |rvnytelen vezrlutasts
    501 TX=de   |$INVALIDCONTROLSTR: unbekannte Option
    501 hu      |$INVALIDCONTROLSTR: ismeretlen opci
    502 TX=de   |$INVALIDCONTROLSTR: Ungltiger Optionswert
    502 hu      |$INVALIDCONTROLSTR: rvnytelen opcirtk
    503 TX=de   |Global gesetzte Transaktion kann nicht gendert werden
    503 hu      |Globlisan elhelyezett tranzakci nem mdosthat
    504 TX=de   |Diese Option ist hier noch nicht zulssig
    504 hu      |Ez az opci itt mg nem megengedett
    505 TX=de   |Transaktion unverndert
    505 hu      |Tranzakci vltozatlan
    506 TX=de   |Kommandostring
    506 hu      |Parancs string
    507 TX=de   |Tag nicht gefunden
    507 hu      |Tag nem tallhat
    508 TX=de   |Unzulssige Querbezugsart
    508 hu      |Nem megengedett kereszthivatkozsi tpus
    509 TX=de   |Fehler bei interner Statusverarbeitung
    509 hu      |Hiba bels sttusfeldolgozsnl
    510 TX=de   |Querbezge werden auf dieser Architektur nicht untersttzt
    510 hu      |Kereszthivatkozsok ezen az architektrn nem tmogatottak
    511 TX=de   |Kann Pipedatei fr Querbezge nicht erzeugen
    511 hu      |Nem ltrehozhat pipe fjl kereszthivatkozsokhoz
    512 TX=de   |Querbezge sind nicht mglich.
    512 hu      |Kereszthivatkozsok nem lehetsgesek.
    513 TX=de   |Datei existiert nicht.
    513 hu      |fjl nem ltezik.
    514 TX=de   |Pfad oberhalb aktuellem Verzeichnis ist nicht erlaubt.
    514 hu      |Elrsi tvonal az aktulis knyvtr felett nem megengedett.
    515 TX=de   |Absoluter Pfad ist nicht erlaubt.
    515 hu      |Abszolt elrsi tvonal nem megengedett.
    516 TX=de   |$FEHLERTEXT: Kann Temporrverzeichnis $rmdir nicht lschen
    516 hu      |$FEHLERTEXT: A $rmdir ideiglenes knyvtr nem trlhet
    517 TX=de   |$name: Importieren von Daten in Abas (Neuanlage, Update)
    517 hu      |$name: Adatok importlsa Abas-be (j eszkz, frissts)
    518 TX=de   |Die Daten werden als Semikolon-getrennte Zeilen erwartet.
    518 hu      |Az adatok pontos vesszvel elvlasztott sorokknt vrhatk.
    519 TX=de   |Angaben zum Import:
    519 hu      |Adatok az importhoz:
    520 TX=de   |-b: Angabe der Datenbank/Gruppe, in die importiert werden soll
    520 hu      |-b: Az adatbank/csoport adata, amibe importlni kell
    521 TX=de   |Format: Datei:Gruppe  (Gruppe kann beim Update-Modus entfallen)
    521 hu      |Formtum: Fjl:csoport (csoport a frissts mdusznl elmaradhat)
    522 TX=de   |Bei Aktion CMDSTR: der auszufhrende Kommandstring
    522 hu      |CMDSTR mveletnl: a vgrehajtand parancs string
    523 TX=de   |-u: Update (ndern vorhandener Daten, statt Neuanlage)
    523 hu      |-u: Frissts (meglv adatok mdostsa, j felvitel helyett)
    524 TX=de   |Die zu ndernden Stze werden ber die erste Spalte identifiziert:
    524 hu      |A mdostand ttelek az els oszlopon keresztl kerlnek azonostsra:
    525 TX=de   |- Referenz, dann kann die Option -b ganz entfallen
    525 hu      |- hivatkozs, ekkor a -b opci teljesen elmaradhat
    526 TX=de   |- eindeutige Identnummer bzw. eindeutiges Suchwort,
    526 hu      |- egyrtelm hivatkozsi szm ill. egyrtelm keressz,
    527 TX=de   |dann mu die Option -b mit Datei-Nummer/Name angegeben werden
    527 hu      |ekkor a -b opcit fjl-szmmal/nvvel kell megadni
    528 TX=de   |Bei Tabellenzeilen steht in der ersten Spalte die Zeilenoperation
    528 hu      |Tblzati soroknl az els oszlopban ll a sormvelet
    529 TX=de   |und die Zeilenangabe:
    529 hu      |s a sormegads:
    530 TX=de   |+za = Einfgen einer Zeile vor Zeile za
    530 hu      |+za = sor beszrsa a za sor el
    531 TX=de   |(za ist Zeilennummer, Zeilenreferenz oder leer)
    531 hu      |(za a sorszm, sorhivatkozs vagy res)
    532 TX=de   |-za = Lschen der Zeile(n) za (keine Feldwerte ntig)
    532 hu      |-za = a za sor(ok) trlse (nem szksgesek mezrtkek)
    533 TX=de   |(za ist Zeilennummer, Zeilenreferenz, \"#\" (letzte)
    533 hu      |(za a sorszm, sorreferencia, \"#\" (utols)
    534 TX=de   |oder \"*\" (alle). Bereiche mit \"-\", Liste mit \";\")
    534 hu      |vagy \"*\" (sszes), tartomnyok \"-\" kal, lista \";\" val)
    535 TX=de   |za  = ndern der (vorhandenen) Zeile za
    535 hu      |za = a (meglv) za sor mdostsa
    536 TX=de   |(za ist Zeilennummer, Zeilenreferenz oder \"#\" (letzte))
    536 hu      |(za a sorszm, sorreferencia vagy \"#\" (utols))
    537 TX=de   |ACHTUNG: Die erste Spalte der Feldliste fr Kopfteil und
    537 hu      |FIGYELEM: A mezjegyzk els oszlopa a fejrsz s
    538 TX=de   |Tabellenteil wird ignoriert!
    538 hu      |tblzati rsz szmra trldik!
    539 TX=de   |-a: Durchzufhrende Aktion, wenn nicht Neu/ndern (statt -u):
    539 hu      |-a: Vgrehajtand mvelet, ha nem j/Mdosts (-u helyett):
    540 TX=de   |-M: \"Eingabe\" fr eventuelle Menauswahl
    540 hu      |-M: \"bevitel\" esetleges menkivlaszts szmra
    541 TX=de   |-n: Definition der Zeichenfolge, die als \"Feldwert NICHT ndern\"
    541 hu      |-n: a karaktersor defincija, melyet \"mezrtk NEM mdostsa\" knt
    542 TX=de   |interpretiert wird. Diese Zeichenfolge ist dann als Feldwert nicht
    542 hu      |rtelmeznk. Ez a karaktersor ekkor mezrtkknt nem
    543 TX=de   |mglich. Es gibt keinen Defaultwert, diese Option mu angegeben
    543 hu      |lehetsges. Nem ltezik default rtk, ennek az opcinak megadva kell
    544 TX=de   |werden, falls die Funktion bentigt wird!
    544 hu      |lennie, ha a funkci szksges!
    545 TX=de   |-T: Alle Datennderungen zusammen in einer Transaktion durchfhren
    545 hu      |-T: sszes adatmdosts vgrehajtsa egytt egy tranzakciban
    546 TX=de   |-f: Feldliste (komma-getrennt, Default: alle)
    546 hu      |-f: Mezlista (vesszvel elvlasztott, default: sszes)
    547 TX=de   |Fehlt diese Option, muss die erste Zeile der Eingabedatei
    547 hu      |Ha hinyzik ez az opci, a beviteli fjl els sornak
    548 TX=de   |die Feldliste enthalten (dann getrennt mit Semikolon ;)
    548 hu      |tartalmaznia kell a mezlistt (aztn pontos vesszvel ; elvlasztva)
    549 TX=de   |-I: Name der Eingabedatei; falls weggelassen wird von stdin gelesen
    549 hu      |-I: a beviteli fjl neve; ha elmarad, stdin ltal kerl olvassra
    550 TX=de   |-2: Datensatz wird durch zwei Zeilenschaltungen statt einer begrenzt
    550 hu      |-2: Rekord kt sorvltson keresztl elhatrolva egy helyett
    551 TX=de   |Eine einfache Zeilenschaltung gilt dann als Feldtrenner
    551 hu      |Egy egyszer sorvlts ekkor mezelvlasztknt rvnyes
    552 TX=de   |-Z: Interpretation der Importdaten im Format der Zeilenselektion
    552 hu      |-Z: az importadatok interpretcija a sorszelekci formtumban
    553 TX=de   |Die Daten werden so interpretiert, wie sie von edpexport.sh mit -Z
    553 hu      |Az adatok gy kerlnek interpretlsra, ahogy az edpexport.sh ltal -Z vel
    554 TX=de   |erzeugt werden. Das Argument mu das Gruppenwechselfeld fr den
    554 hu      |kszlnek. Az argumentumnak tartalmaznia kell a csoportvlt mezt a
    555 TX=de   |Kopfteil enthalten sowie nach einem \":\" das erste Tabellenfeld
    555 hu      |fejrsz szmra, valamint \":\" utn az els tblzati mezt
    556 TX=de   |Die Felder knnen als Feldnummer oder Feldname angegeben werden
    556 hu      |A mezk megadhatk mezszmknt vagy meznvknt
    557 TX=de   |-r: Ausgabe von Informationen ber die verarbeiteten Objekte:
    557 hu      |-r: Informcik kiadsa a feldolgozott objektumokrl:
    558 TX=de   |REF=Referenz, NUM=Identnummer, NUMROWS=Anzahl Zeilen
    558 hu      |REF=referencia, NUM=hivatkozsi szm, NUMROWS=sorok szma
    559 TX=de   |-S: Simulationsmodus: Importdatei wird nicht importiert, sondern die
    559 hu      |-S: Szimulls mdozat: Importfjl nem kerl importlsra, hanem az
    560 TX=de   |EDP-Kommandos, die ausgefhrt wrden, werden auf stderr ausgegeben.
    560 hu      |EDP parancsok, amik vgrehajtsra kerlnnek, stderr-re kerlnek kiadsra.
    561 TX=de   |-z: Fuer Zeilenschaltung erwartetes Zeichen (Default: #)
    561 hu      |-z: Sorvlts szmra vrt karakter (default: #)
    562 TX=de   |Mehrfache Angabe der Aktion ist nicht erlaubt
    562 hu      |A mvelet tbbszrs megadsa nem megengedett
    563 TX=de   |$FEHLERTEXT: Datei $infile existiert nicht!
    563 hu      |$FEHLERTEXT: $infile fjl nem ltezik!
    564 TX=de   |$FEHLERTEXT: EDP-Aufruf gescheitert
    564 hu      |$FEHLERTEXT: EDP-lehvs sikertelen
    565 TX=de   |$FEHLERTEXT: Eingabedaten nicht vollstaendig korrekt
    565 hu      |$FEHLERTEXT: Beviteli adatok nem teljesen korrektek
    566 TX=de   |$FEHLERTEXT: Fehler beim Einlesen der Importdaten
    566 hu      |$FEHLERTEXT: Hiba az import adatok beolvassnl
    567 TX=de   |$FEHLERTEXT: Programm wegen Fehler abgebrochen
    567 hu      |$FEHLERTEXT: Program hiba miatt megszakadt
"******** edpinfosys.sh ********
    568 TX=de   |Feld mit zwei Feldwerten
    568 hu      |Mez kt mez rtkkel
    569 TX=de   |Zu viele Eingabedaten
    569 hu      |Tl sok beviteli adat
    570 TX=de   |filter_metadata: interner Fehler - Tabellenkennzeichen falsch
    570 hu      |filter_metadata: bels hiba - rossz tblzati azonost
    571 TX=de   |filter_data: interner Fehler - Tabellenkennzeichen falsch
    571 hu      |filter_data: bels hiba - rossz tblzati azonost
    572 TX=de   |build_datafile: interner Fehler - Name der Infosystem-Datendatei fehlt
    572 hu      |build_datafile: bels hiba - az infosystem-adatfjl neve hinyzik
    573 TX=de   |$name: Infosystem ber EDP ausfhren und Daten exportieren
    573 hu      |$name: Infosystem EDP n keresztli vgrehajtsa s adatok exportlsa
    574 TX=de   |Der Inhalt der Tabelle wird auf der Standardausgabe ausgegeben
    574 hu      |A tblzat tartalma a standard kiadson kerl kiadsra
    575 TX=de   |Angaben zum Infosystem-Export:
    575 hu      |Adatok az Infosystem-exporthoz:
    576 TX=de   |-n: Suchwort des auszufhrenden Infosystems, Start ber Tippkommando
    576 hu      |-n: A vgrehajtand infosystem keresszava, indts gpelsi paranccsal
    577 TX=de   |-N: Nummer oder Suchwort des auszufhrenden Infosystems,
    577 hu      |-N: A vgrehajtand infosystem szma vagy keresszava,
    578 TX=de   |dieses wird dann mit <Hole> statt ber Tippkommando gestartet
    578 hu      |ez a gpelsi parancs helyett a <Hole> paranccsal kerl indtsra
    579 TX=de   |-x: Kommando in Abas Kommandosyntax zum Starten des Infosystems,
    579 hu      |-x: Parancs Abas parancsszintaxisban az infosystem indtshoz,
    580 TX=de   |auch mit Feldvorbesetzungen.
    580 hu      |mez alaprtelmezett belltsokkal is.
    581 TX=de   |-s: Liste der zu setzenden Felder (Kopf/Tabelle) inkl. Startbutton
    581 hu      |-s: Az elhelyezend mezk (fej/tblzat) listja startgombbal bez.
    582 TX=de   |und ggf. deren Werte; getrennt durch \",\" oder aktuellen Feldtrenner
    582 hu      |s adott esetben azok rtkei; elvlasztva \",\"-vel vagy aktulis mezelvlasztval
    583 TX=de   |Default: \"bstart\", muss ansonsten explizit angegeben werden
    583 hu      |Default: \"bstart\", egybknt explicit meg kell adni
    584 TX=de   |Syntax: [zeile:]feldname[=feldwert]
    584 hu      |Szintakszis: [zeile:]feldname[=feldwert] azaz [sor:]meznv[=mezrtk]
    585 TX=de   |Bei Angabe von \"-\" wird die Liste von stdin gelesen.
    585 hu      |\"-\" megadsnl stdin lista olvassra kerl.
    586 TX=de   |-w: Liste der Werte fr die Felder bei -s, getrennt mit dem aktuellen
    586 hu      |-w: rtkek listja a mezk szmra -s nl, elvlasztva az aktulis
    587 TX=de   |Trennzeichen. Bei Angabe von \"-\" wird die Liste von stdin gelesen.
    587 hu      |elvlasztjellel. \"-\" megadsnl a stdin tl a lista olvassra kerl.
    588 TX=de   |-k: Liste der auszugebenden Kopf-Felder (komma-getrennt)
    588 hu      |-k: A kiadand fejrsz-mezk listja (vesszvel elvlasztva)
    589 TX=de   |\"+\" = alle, \"-\" = keine, Default: keine
    589 hu      |\"+\" = mind, \"-\" = nincs, Default: nincs
    590 TX=de   |-f: Liste der auszugebenden Tab-Felder (komma-getrennt)
    590 hu      |-f: A kiadand tblzati mezk listja (vesszvel elvlasztva)
    591 TX=de   |\"+\" = alle, \"-\" = keine, Default: alle
    591 hu      |\"+\" = mind, \"-\" = nincs, Default: mind
    592 TX=de   |-T: Zeilenangabe fr auszugebende Zeilen, z.B. von-bis oder \$-Selektion
    592 hu      |-T: sor megads kiadand sorokhoz, pl. tl-ig vagy \$ szelekci
    593 TX=de   |-I: Name der Eingabedatei, statt -s und -w
    593 hu      |-I: A beviteli fjl neve, -s s -w helyett
    594 TX=de   |-Z: Ausgabe im Zeilenselektionsformat (Kopffelder in jeder Zeile
    594 hu      |-Z: Kiads a sor szelekcis formtumban (fejrsz mezk kiadsa
    595 TX=de   |zusammen mit Tabellenfeldern ausgeben)
    595 hu      |minden egyes sorban tblzati mezkkel egytt)
    596 TX=de   |-z: Fr Zeilenschaltung erwartetes Zeichen (Default: #)
    596 hu      |-z: A sorvlts szmra vrt karakter (default: #)
    597 TX=de   |Option wird noch nicht untersttzt.
    597 hu      |Az opci mg nem tmogatott.
    598 TX=de   |$FEHLERTEXT: Liste der zu setzenden Felder oder Eingabedatei angeben, nicht beides
    598 hu      |$FEHLERTEXT: A belltand mezk listja vagy a beviteli fjl megadsa, nem mindkett
    599 TX=de   |$FEHLERTEXT: Nur eine Eingabedatei erlaubt
    599 hu      |$FEHLERTEXT: Csak egy beviteli fjl megengedett
    600 TX=de   |$FEHLERTEXT: Auszufhrendes Infosystem fehlt
    600 hu      |$FEHLERTEXT: Vgrehajtand infosystem hinyzik
"******** edputils.sh ********
    601 TX=de   |Script kann nicht direkt aufgerufen werden!
    601 hu      |A script nem hajthat vgre kzvetlenl
    602 TX=de   |-h: Hostname bei Remote-Zugriff (optional)
    602 hu      |-h: Hostnv remote-hozzfrsnl (opcionlis)
    603 TX=de   |-i: Portnummer bei Remote-Zugriff, nur zusammen mit -h (Default: 6550)
    603 hu      |-i: Portszm remote-hozzfrsnl, csak -h val egytt (default: 6550)
    604 TX=de   |-m: Mandant (Default: Mandantenverzeichnis = aktuelles Verz.)
    604 hu      |-m: Mandant (Default: mandantknyvtr = aktulis knyvtr)
    605 TX=de   |-U: Login mit Benutzernamen
    605 hu      |-U: Login felhasznli nvvel
    606 TX=de   |-W: Login als Web-Anwender, Name mit -U angeben
    606 hu      |-W: Login web felhasznlknt, nv megadsa -U -val
    607 TX=de   |-p: Passwort; falls weggelassen, wird es interaktiv erfragt
    607 hu      |-p: Jelsz; ha elmarad, interaktav ton lekrdezsre kerl
    608 TX=de   |-P: Passwort nicht erfragen (z.B. bei Systemlogin oder Einmalpasswort)
    608 hu      |-P: Jelszt nem krdezni (pl. rendszerlogin-nl vagy egyszeri jelsznl)
    609 TX=de   |-t: Feldtrenner (Default: ;)
    609 hu      |-t: Mezelvlaszt (default: ;)
    610 TX=de   |-c: Zeichensatz: EKS, ANSI, ISO8859-1, UTF-8, ... (Default: ISO8859-1)
    610 hu      |-c: Karakterkszlet: EKS, ANSI, ISO8859-1, UTF-8, ... (Default: ISO8859-1)
    611 TX=de   |-H: Hinweismeldungen in Datei statt auf Standardfehlerausgabe
    611 hu      |-H: zenetek fjlban standard hibakiads helyett
    612 TX=de   |-L: Logging - Ausgabe der EDP-Kommunikation in Datei oder Kanal 1 oder 2
    612 hu      |-L: Logging - Az EDP kommunikci kiadsa fjlba vagy az 1-es vagy 2-es csatornba
    613 TX=de   |-d: Debug
    613 hu      |-d: Debug
    614 TX=de   |FEHLER
    614 hu      |HIBA
    615 TX=de   |HINWEIS
    615 hu      |UTALS
    616 TX=de   |FORTSCHRITT
    616 hu      |HALMOZOTT
    617 TX=de   |SPERRE
    617 hu      |ZRLAT
    618 TX=de   |AKTUALISIERUNG
    618 hu      |Aktualizls
    619 TX=de   |DIALOG
    619 hu      |DIALOG
    620 TX=de   |Keine Verbindung zum EDP-Server
    620 hu      |Nincs csatlakozs az EDP-szerverhez
    621 TX=de   |Unzulssige Formatangabe
    621 hu      |nem megengedett formtummegads
    622 TX=de   |Ungltige Feldangabe
    622 hu      |rvnytelen mez megads
    623 TX=de   |Ungltige Breitenangabe
    623 hu      |rvnytelen szlessg adat
    624 TX=de   |Feldtrenner darf nicht ';' sein, wenn eine \$-Selektion erzeugt werden soll.
    624 hu      |A mez elvlaszt nem lehet ';', ha \$ szelekci kerljn ltrehozsra.
    625 TX=de   |Kann Bearbeitung nicht beginnen:
    625 hu      |Feldolgozs nem kezddhet:
    626 TX=de   |Ungltiger Statusname
    626 hu      |rvnytelen sttusnv
    627 TX=de   |$name: Ausgabeformate (DOKU[2], TAB, HTML, XML, IMPORT) und ihre Optionen
    627 hu      |$name: Kiadsi formtumok (DOKU[2], TAB, HTML, XML, IMPORT) s opciik
    628 TX=de   |Generelle Syntax: -O Format[:Format-Option1][:Format-Option2][:...]
    628 hu      |ltalnos szintakszis: -O Format[:Format-Option1][:Format-Option2][:...]
    629 TX=de   |Dokumentationsformat, Ausgabe von Name-Wert-Paaren
    629 hu      |Dokumentcis formtum, nv-rtk-prok kiadsa
    630 TX=de   |DOKU: Eine Zeile je Feld, DOKU2: Eine Zeile je Kopfteil/Tabellenzeile
    630 hu      |DOKU: Egy sor meznknt, DOKU2: Egy sor fejrszenknt/tblzati soronknt
    631 TX=de   |Delim|Position:Trennzeichenfolge (Delim) oder
    631 hu      |Delim|Pozci: elvlaszt karaktersor (Delim) vagy
    632 TX=de   |feste Spaltenangabe (Position) fr die Werte.
    632 hu      |biztos oszlopmegads (pozci) az rtkek szmra.
    633 TX=de   |SuppressEmpty: 1/2 = Leere Felder unterdrcken (2=auch Nullen, Default=0)
    633 hu      |SuppressEmpty: 1/2 = res mezk elrejtse (2=nullk is, alaprtelmezett=0)
    634 TX=de   |ByObjects:     1 = Objektweise Ausgabe, d.h. Kopffelder nur einmalig
    634 hu      |ByObjects:     1 = objektumszer kiads, vagyis fejmezk csak egyszer
    635 TX=de   |ausgeben statt pro Tabellenzeile (Default=0)
    635 hu      |kiadva s nem tblzati soronknt (Default=0)
    636 TX=de   |Feldname = Name bzw. Beschreibung des Feldes, ber das
    636 hu      |Meznv = a mez neve ill. lersa, melyen keresztl
    637 TX=de   |die Ergebnisdaten zu Objekten zusammengefat werden
    637 hu      |az eredmnyadatok objektumokhoz sszefoglalsra kerlnek
    638 TX=de   |PrintRecNr:    0 = Keine Datensatznummern ausgeben (Default=1)
    638 hu      |PrintRecNr:    0 = Nincs ttelszm kiadsa (Default=1)
    639 TX=de   |PrintRowNr:    0 = Keine Zeilennummern ausgeben
    639 hu      |PrintRowNr:    0 = Nincs sorszm kiadsa
    640 TX=de   |1 = Zeilennummern als berschriften ausgeben (=Default)
    640 hu      |1 = Sorszmok feliratknt val kiadsa (=Default)
    641 TX=de   |2 = Zeilennummern als Index beim Feldnamen ausgeben
    641 hu      |2 = Sorszmok indexknt val kiadsa a meznvnl
    642 TX=de   |Feldname = Name bzw. Beschreibung des Feldes
    642 hu      |Meznv = a mez neve ill. lersa
    643 TX=de   |wird als Index beim Feldnamen ausgegeben
    643 hu      |indexknt kerl kiadsra a meznvnl
    644 TX=de   |PreValStr:     vor dem Feldwert auszugebende Zeichenfolge
    644 hu      |PreValStr:     a mezrtk eltt kiadand karaktersor
    645 TX=de   |PostValStr:    nach dem Feldwert auszugebende Zeichenfolge
    645 hu      |PostValStr:    a mezrtk utn kiadand karaktersor
    646 TX=de   |Fr die Trennzeichenfolge und die Zeichenfolgen vor/nach dem Feldwert
    646 hu      |Az elvlasztjelek s a mezrtk eltti/utni karaktersorok szmra
    647 TX=de   |knnen die folgenden Metazeichen verwendet werden:
    647 hu      |a kvetkez metajelek hasznlhatk:
    648 TX=de   |T=Tabulator, D=Doppelpunkt, B=Blank, N=Newline
    648 hu      |T=tabultor, D=kettspont, B=blank, N=Newline
    649 TX=de   |Tabellarisches Format. Die Default-Spaltenbreite entspricht
    649 hu      |Tblzatos formtum. A default-oszlopszlessg a
    650 TX=de   |der nominellen Feldbreite.
    650 hu      |a nv szerinti mezszlessg
    651 TX=de   |Width:         Zahl: Angabe einer festen Spaltenbreite
    651 hu      |Width:         Szm: egy fix oszlopszlessg megadsa
    652 TX=de   |\"AUTO\": automatische Ermittlung der optimalen Spaltenbreite
    652 hu      |\"AUTO\": az optimlis oszlopszlessg automatikus meghatrozsa
    653 TX=de   |\"AUTODATA\": wie AUTO, aber ohne Bercksichtigung der Spaltenberschriften
    653 hu      |\"AUTODATA\": Mint az AUTO, azonban az oszlop feliratok figyelembevtele nlkl
    654 TX=de   |+Width:        Mindest-Spaltenbreite, falls Feldbreite kleiner ist
    654 hu      |+Width:        Legkisebb oszlopszlessg, ha mezszlessg kisebb
    655 TX=de   |-Width:        Hchst-Spaltenbreite, falls Feldbreite grer ist
    655 hu      |-Width:        Legnagyobb oszlopszlessg, ha a mezszlessg nagyobb
    656 TX=de   |WithHeader:    0 = keine berschriftzeile ausgeben (Default=1)
    656 hu      |WithHeader:    0 = nincs felirati sor kiadsa (alaprtelmezett=1)
    657 TX=de   |ColumnDelim.:  Zeichenfolge zur Ausgabe zwischen den Spalten (Default=\" \")
    657 hu      |ColumnDelim.:  Karaktersor az oszlopok kztti kiadshoz (alaprtelmezett=\" \")
    658 TX=de   |HTML-Format. Die Daten werden als HTML-Tabelle ausgegeben.
    658 hu      |HTML-formtum. Az adatok HTML-tblzatknt kerlnek kiadsra.
    659 TX=de   |Part:          Auszugebende Teile der HTML-Datei:
    659 hu      |Part:          A HTML-fjl kiadand rszei:
    660 TX=de   |H=Header+Body, F=Body+Footer, B=nur Body, Leer=alles
    660 hu      |H=Header+Body, F=Body+Footer, B=csak Body, res=mind
    661 TX=de   |WithHeader:    0 = keine Tabellenberschrift ausgeben (Default=1)
    661 hu      |WithHeader:    0 = nincs tblzati felirat kiadsa (Default=1)
    662 TX=de   |LineThickness: Dicke der Tabellenlinien (Default=1)
    662 hu      |LineThickness: A tblzati vonalak vastagsga (default=1)
    663 TX=de   |EvenColors:    Farben der geraden Tabellenzeilen: Hintergrund,Schrift
    663 hu      |EvenColors:    Az egyenes tblzati sorok sznei: httr,rs
    664 TX=de   |OddColors:     Farben der ungeraden Tabellenzeilen: Hintergrund,Schrift
    664 hu      |OddColors:     A nem egyenes tblzati sorok sznei: httr,rs
    665 TX=de   |HeadColors:    Farben der Tabellenkopfzeile: Hintergrund,Schrift
    665 hu      |HeadColors:    Tblzati fejsor sznei: httr,rs
    666 TX=de   |BorderColor:   Farbe der Tabellenlinien (Default=#000000)
    666 hu      |BorderColor:   A tblzati vonalak szne (default=#000000)
    667 TX=de   |XML-Format. Die Daten werden im Abas XML-Format ausgegeben.
    667 hu      |XML-formtum. Az adatok az Abas XML-formtumban kerlnek kiadsra.
    668 TX=de   |Part:          Auszugebende Teile der XML-Struktur:
    668 hu      |Part:          Az XML-struktra kiadand rszei:
    669 TX=de   |CaptionField:  Feldname fr die Datensatzbezeichnung (Default=\"name\")
    669 hu      |CaptionField:  Meznv a rekord megnevezshez (default=\"name\")
    670 TX=de   |RecIDField:    Feldname fr die Datensatzidentfikation (Default=\"id\"/\"sn\")
    670 hu      |RecIDField:    Meznv a rekord azonostshoz (alaprtelmezett=\"id\"/\"sn\")
    671 TX=de   |PrintTypes:    0 = Arten der Felder nicht ausgeben (Default=1)
    671 hu      |PrintTypes:    0 = A mezk tpusait nem kiadni (alaprtelmezett=1)
    672 TX=de   |Formatierung fr Import mit edpimport.sh
    672 hu      |Formzs edpimport.sh-val val importhoz
    673 TX=de   |Action:        Aktion fr den Import; Default: NEW
    673 hu      |Action:        Mvelet az importhoz; Alaprtelmezett: NEW
    674 TX=de   |Database:      Datenbank fr den Import
    674 hu      |Database:      Adatbzis az importhoz
    675 TX=de   |Group:         Gruppe fr den Import
    675 hu      |Group:         Csoport az importhoz
    676 TX=de   |RecordIDFlds:  Liste der Datensatz identifizierenden Felder
    676 hu      |RecordIDFlds: A rekordot azonost mezk listja
    677 TX=de   |getrennt mit \",\"; Default: Erstes Feld
    677 hu      |elvlasztva a kvetkezvel: \",\"; Alaprtelmezett: els mez
    678 TX=de   |Ein vorangestelltes \"+\" fgt eine \$-Selektion
    678 hu      |Egy elhelyezett \"+\" beszr egy \$ szelekcit
    679 TX=de   |fr diese Felder als erste Spalte in die Ausgabe ein
    679 hu      |ezekhez a mezkhz els oszlopknt a kiadsba
    680 TX=de   |RowOp:         Zeilenoperation +/-/=, die dem ersten Tabellenfeld
    680 hu      |RowOp:         Sor mvelet +/-/=, ami az els tblzati mez
    681 TX=de   |vorangestellt wird.
    681 hu      |el kerl helyezsre.
    682 TX=de   |RowIDFlds:     Angabe der optionalen Liste der Zeilen identifizierenden
    682 hu      |RowIDFlds:     A sorokat azonost mezk opcionlis listjnak a
    683 TX=de   |Felder, getrennt mit \",\". Fgt eine \$-Selektion fr diese
    683 hu      |megadsa, \",\"-vel elvlasztva. Hozzad egy \$ szelekcit ezekhez
    684 TX=de   |Felder als Zeilenangabe hinzu.
    684 hu      |mezkhz sor megadsknt.
    685 TX=de   |RowIsRecord:   1 = Tabellenzeilen als einzelne Datenstze importieren
    685 hu      |RowIsRecord:   1 = Tblzati sorok egyes rekordokknt val importlsa
    686 TX=de   |0 = Kopf+Zeilen als Datenstze importieren
    686 hu      |0 = Fej+sorok importlsa rekordokknt
    687 TX=de   |Default: 1 bei Infosystemen, sonst 0
    687 hu      |Alaprtelmezett: 1 infosystemeknl, egybknt 0
    688 TX=de   |Formatierung im CSV-Format gem IETF RFC 4180
    688 hu      |Formzs a CSV formtumban az IETF RFC 4180 szerint
    689 TX=de   |Siehe http://tools.ietf.org/html/rfc4180
    689 hu      |lsd http://tools.ietf.org/html/rfc4180
"******** erp_check_disk_space.sh ********
    690 TX=de   |S3-Bereich, unter dem sich die Mandanten befinden (darf mehrfach vorkommen)
    690 hu      |S3 tartomny, ami alatt a mandantok tallhatk (tbbszr elfordulhat)
    691 TX=de   |PARTITION
    691 hu      |PARTITION
    692 TX=de   |zu untersuchende Partition
    692 hu      |Vizsgland partci
    693 TX=de   |MAX. ZULSSIGE PROZENTUALE BELEGUNG DER PARTITION
    693 hu      |A PARTCI MAX. MEGENGEDETT SZZALKOS BEFEDSE
    694 TX=de   |maximaler zulssiger
    694 hu      |maximum megengedett
    695 TX=de   |prozentualer Fllgrad auf der Partition bei grtmglichem Anwachsen
    695 hu      |szzalkos kitltsi fok a partcin a mandantok lehet legnagyobb
    696 TX=de   |der Mandanten bei der GC [$MAX_FILL_LEVEL]
    696 hu      |nvekedsnl a GC-nl [$MAX_FILL_LEVEL]
    697 TX=de   |zeigt den Nettodatenbestand der einzelnen Mandanten an
    697 hu      |az egyes mandantok nett adatllomnyt jelenti meg
    698 TX=de   |zu viele Argumente (max. 6)
    698 hu      |tl sok argumentum (max. 6)
    699 TX=de   |ungltiges Verzeichnis
    699 hu      |rvnytelen knyvtr
    700 TX=de   |ungltige Partition
    700 hu      |rvnytelen partci
    701 TX=de   |Platte zu voll
    701 hu      |A lemez tlsgosan teli
    702 TX=de   |Rckgabewerte:
    702 hu      |Visszaadsi rtkek:
    703 TX=de   |$N_SUCCESS: Erfolg
    703 hu      |$N_SUCCESS: siker
    704 TX=de   |$N_GENERAL_ERROR: allgemeine Fehler (ungltige Argumente, fehlende Rechte etc.)
    704 hu      |$N_GENERAL_ERROR: ltalnos hibk (rvnytelen argumentumok, hinyz jogok stb.)
    705 TX=de   |$N_DISK_FULL_ERROR: nicht gengend Platz auf der Platte fr GC
    705 hu      |$N_DISK_FULL_ERROR: nem elegend hely a lemezen a GC-hz
    706 TX=de   |$N_EXTERNAL_ERROR: Nettodatenbestand der Mandanten nicht bestimmbar
    706 hu      |$N_EXTERNAL_ERROR: a mandantok nett adatllomnya nem meghatrozhat
    707 TX=de   |Gre der Partition
    707 hu      |A partci nagysga
    708 TX=de   |Nettodatenbestand aller Mandanten
    708 hu      |Az sszes mandant nett adatllomnya
    709 TX=de   |von allen Mandanten insgesamt belegter Plattenplatz
    709 hu      |az sszes mandant sszesen befedett lemez helye
    710 TX=de   |maximaler Zuwachs whrend der GC =
    710 hu      |maximum nvekeds a GC alatt =
    711 TX=de   |zum Betrieb ntiger freier Platz
    711 hu      |A mkdshez szksges szabad hely
    712 TX=de   |maximal bentigter Platz auf der Partition whrend GC =
    712 hu      |maximum szksges hely a partcin a GC alatt =
    713 TX=de   |momentan freier Platz auf der Partition
    713 hu      |jelenleg szabad hely a partcin
    714 TX=de   |momentan belegter Platz auf der Partition
    714 hu      |jelenleg befedett hely a partcin
    715 TX=de   |maximaler Zuwachs whrend der GC + momentan belegter Platz
    715 hu      |maximum nvekeds a GC alatt + jelenleg befedett hely
    716 TX=de   |kein ausfhrbares %s gefunden
    716 hu      |nem tallhat vgrehajthat %s
    717 TX=de   |konnte keine Partion fr %s bestimmen
    717 hu      |nem tudott meghatrozni partcit %s-hez
    718 TX=de   |konnte Nettodatenbestand fr %s nicht bestimmen
    718 hu      |nem tudott meghatrozni nett adatllomnyt %s-hez
    719 TX=de   |starte_gc.sh lieferte Fehlercode $%d
    719 hu      |starte_gc.sh $%d hibakdot idzett el
    720 TX=de   |konnte Plattenbelegung fr Mandanten %s nicht bestimmen
    720 hu      |nem tudott meghatrozni lemez befedst a %s mandanthoz
    721 TX=de   |(%d * Nettodatenbestand) - von Datenbank belegter Platz =
    721 hu      |(%d * nett adatllomny) - az adatbzis befedett helye =
    722 TX=de   |Nettodatenbestand in Mandant %s: %d
    722 hu      |Nett adatllomny a %s mandantban: %d
    723 TX=de   |von Mandant %s insgesamt belegter Platz: %d
    723 hu      |A %s mandantban sszesen befedett hely: %d
    724 TX=de   |von Mandant %s insgesamt belegter Platz(laut Ausgabe von du): %d
    724 hu      |A %s mandant sszesen befedett helye (du kiadsnak megfelelen): %d
    725 TX=de   |max. erlaubte Plattenbelegung nach Vorgabe (%d%%)
    725 hu      |maximum megengedett lemez befeds megads szerint (%d%%)
    726 TX=de   |* Option -p
    726 hu      |* Opci -p
    727 TX=de   |* Option -h
    727 hu      |* Opci -h
    728 TX=de   |* Option -f
    728 hu      |* Opci -f
    729 TX=de   |* Option -v:
    729 hu      |* Opci -v:
"******** fontdeploy.sh ********
    730 TX=de   |<fontdir>   : Beliebiges Verzeichnis der zu installierenden Fonts
    730 hu      |<fontdir>   : Az installland fontok tetszleges knyvtra
    731 TX=de   |<clientdir> : Pfad des Mandanten, der bearbeitet werden soll
    731 hu      |<clientdir> : Annak a mandantnak az elrsi tvonala, ami feldolgozsra kerljn
    732 TX=de   |Kanal nicht angegeben!
    732 hu      |Nincs megadva csatorna!
    733 TX=de   |Keine Fonts im Verzeichnis $clientdir/print/fonts vorhanden!
    733 hu      |Nem llnak rendelkezsre fontok a $clientdir/print/fonts knyvtrban!
    734 TX=de   |Sichere vorhandene Konfigurationsdatei ($clientdir/print/config/userconfig.xml) ...
    734 hu      |A meglv konfigurcis fjl mentse ($clientdir/print/config/userconfig.xml) ...
    735 TX=de   |Erzeuge leere Konfigurationsdatei ($clientdir/print/config/userconfig.xml) ...
    735 hu      |res konfigurcis fjl ltrehozsa ($clientdir/print/config/userconfig.xml) ...
    736 TX=de   |Konverter-Modus: $funktion
    736 hu      |Konvertl md:  $funktion
    737 TX=de   |Fehler beim Bearbeiten von $layout aufgetreten!
    737 hu      |Hiba lpett fel a $layout feldolgozsnl!
    738 TX=de   |Fontverzeichnis in $clientdir/win/ftexteditor leeren ...
    738 hu      |Font knyvtr kirtse a $clientdir/win/ftexteditor-ban ...
    739 TX=de   |Fontverzeichnis in $clientdir leeren ...
    739 hu      |Font knyvtr kirtse a $clientdir-ben ...
    740 TX=de   |Fonts nach $clientdir/win/ftexteditor kopieren ...
    740 hu      |Fontok msolsa a $clientdir/win/ftexteditor-ba ...
    741 TX=de   |Alle Layout-Fonts aus $client/win/jasper/layout gegen das Fontmapping validieren ...
    741 hu      |A $client/win/jasper/layout-bl az sszes layout font rvnyestse a font mapping-gel szemben ...
    742 TX=de   |Folgende Fonts sind im Mapping enthalten, fehlen aber auf der Platte:
    742 hu      |A kvetkez fontok tallhatk a mapping-ben, azonban hinyoznak a lemezen:
    743 TX=de   |Fontdatei fehlt: $i
    743 hu      |Font fjl hinyzik: $i
    744 TX=de   |Jasper-Fontmapping in $client/print/fonts ist nicht installiert!
    744 hu      |Jasper font mapping a $client/print/fonts-ban nincs installlva!
    745 TX=de   |Fontmapping fr \"$installNewFonts\" in $client erstellen ...
    745 hu      |Font mapping ksztse \"$installNewFonts\"-hoz $client-ben ...
    746 TX=de   |Beachten Sie, dass fr \"$installNewFonts\" nur ein Mapping-Rumpf angelegt wird, der dann auf den Font \"DejaVuSans\" zeigt. Den echten Fontnamen mssen Sie anschlieend noch in das Mapping eintragen!
    746 hu      |Vegye figyelembe, hogy a \"$installNewFonts\"-hoz csak egy mapping trzs kerl felvitelre, ami aztn a \"DejaVuSans\" bettpusra mutat. A valdi bettpus nevet utna mg be kell rnia a mapping-be!
    747 TX=de   |--- Verwende Mandantenverzeichns $client ---
    747 hu      |--- $client mandantknyvtr hasznlata ---
    748 TX=de   |--- Mandant $client wird ausgelassen da Verzeichnis nicht vorhanden. ---
    748 hu      |--- $client mandant kihagysra kerl, mivel nem ll rendelkezsre knyvtr. ---
    749 TX=de   |Installiere Fonts fr den Kanal $channel
    749 hu      |Fontok installlsa a $channel csatornhoz
    750 TX=de   |-a oder -c <clientdir> angeben.
    750 hu      |-a vagy -c <clientdir> megadsa.
    751 TX=de   |Kopiere $j nach $client/print/fonts
    751 hu      |$j msolsa $client/print/fonts-ba
    752 TX=de   |Kopiere Font $fontdeployname in die Mandanten
    752 hu      |$fontdeployname font msolsa a mandantokba
    753 TX=de   |Font $fontdeployname nicht vorhanden!
    753 hu      |$fontdeployname font nem ll rendelkezsre!
    754 TX=de   |Kopiere Fonts aus $fontdeploydir in die Mandanten
    754 hu      |Fontok msolsa $fontdeploydir-bl a mandantokba
    755 TX=de   |Keine Fonts im Verzeichnis $fontdeploydir vorhanden!
    755 hu      |Nem llnak rendelkezsre fontok a $fontdeploydir knyvtrban!
    756 TX=de   |Archiv auspacken: $client/print/fonts/custom-fonts.jar
    756 hu      |Archvum kicsomagolsa: $client/print/fonts/custom-fonts.jar
    757 TX=de   |Verzeichnis erstellen: de/abas/custom/fonts
    757 hu      |Knyvtr ksztse: de/abas/custom/fonts
    758 TX=de   |Font kopieren: $j $rmdir/de/abas/custom/fonts/$fontname
    758 hu      |Font msolsa: $j $rmdir/de/abas/custom/fonts/$fontname
    759 TX=de   |Archiv einpacken: $rmdir/custom-fonts.jar
    759 hu      |Archvum becsomagolsa: $rmdir/custom-fonts.jar
    760 TX=de   |Archiv verschieben nach: $client/print/fonts/custom-fonts.jar
    760 hu      |Archvum eltolsa a kvetkezbe: $client/print/fonts/custom-fonts.jar
    761 TX=de   |Archiv verschieben nach: $client/win/ftexteditor/lib/custom-fonts.jar
    761 hu      |Archvum eltolsa a kvetkezbe: $client/win/ftexteditor/lib/custom-fonts.jar
    762 TX=de   |Keine Fonts im Fontverzeichnis \"$fontdeploydir\" gefunden.
    762 hu      |Nem tallhatk fontok a \"$fontdeploydir\" font knyvtrban.
    763 TX=de   |Installiere Mapping (Fontmapping-Datei) ...
    763 hu      |Mapping installls (font mapping fjl) ...
    764 TX=de   |Mapping-Vorlage (Fontmapping) nicht gefunden!
    764 hu      |Mapping minta (font mapping) nem tallhat!
    765 TX=de   |Installiere Mapping (Extension-Datei) ...
    765 hu      |Mapping installls (extension fjl) ...
    766 TX=de   |Mapping-Vorlage (Extension) nicht gefunden!
    766 hu      |Mapping minta (extension) nem tallhat!
    767 TX=de   |Falsche Funktion: $funktion
    767 hu      |Rossz funkci:  $funktion
"******** fr_gen.sh ********
    768 TX=de   |Unbekannte Sprache: $1
    768 hu      |Ismeretlen nyelv: $1
    769 TX=de   |Generiere Sprache:
    769 hu      |Generlt nyelv:
    770 TX=de   |Kann GUI-Masken nicht installieren
    770 hu      |GUI-maszkok nem installlhatk
    771 TX=de   |Kann Infosystem-Masken nicht installieren
    771 hu      |Infosystem-maszkok nem installlhatk
    772 TX=de   |Kann masken.dat nicht installieren
    772 hu      |masken.dat nem installlhat
    773 TX=de   |Generiere individuelle Aufzhlungen in Sprache:
    773 hu      |Egyedi felsorolsok generlsa ezen a nyelven:
"******** fr_ins.sh ********
    774 TX=de   |Unbekannte Option: $1
    774 hu      |Ismeretlen opci: $1
    775 TX=de   |Installationssprache '$SPR' nicht definiert!
    775 hu      |A '$SPR' installcis nyelv nem definilt!
    776 TX=de   |Keine Sprachen angegeben!
    776 hu      |Nincs nyelv megadva!
    777 TX=de   |Sprache: $s wirklich entfernen?
    777 hu      |Valban trljem a $s nyelvet ?
    778 TX=de   |Sprache: $s wird gelscht...
    778 hu      |Nyelv: $s trldik...
    779 TX=de   |Sprache: $s ist NICHT installiert!
    779 hu      |A $s nyelv NINCS installlva !
    780 TX=de   |Keine Sprache gelscht
    780 hu      |Nincs nyelv trlve
    781 TX=de   |Sprache mu angegeben werden
    781 hu      |A nyelvnek megadsra kell kerlnie
    782 TX=de   |Sprache: $s bereits installiert!
    782 hu      |A $s nyelv mr installlva van !
    783 TX=de   |Keine neue Sprache installiert!
    783 hu      |Nincs j installlt nyelv!
    784 TX=de   |Sprachen - Installation von $sprachen luft...
    784 hu      |Nyelv-installlsa dolgozik... ($sprachen)
    785 TX=de   |***  fertig - done - pronto  ***
    785 hu      |***  ksz - fertig - done - pronto  ***
"******** fr_msg.sh ********
    786 TX=de   |Unbekannte Sprache: $spr
    786 hu      |Ismeretlen nyelv: $spr
    787 TX=de   |Nach Deutsch kann nicht bersetzt werden
    787 hu      |Nmetre nem fordthat le
    788 TX=de   |Programm nur lauffhig in der mehrsprachigen Version!
    788 hu      |A program csak tbbnyelv verziban futtathat!
    789 TX=de   |bersetze: FO-Programme
    789 hu      |Fordts: FO-programok
    790 TX=de   |bersetze: FO-Kommandos
    790 hu      |Fordts: FO-parancsok
    791 TX=de   |Fehler: bersetzung nicht mglich
    791 hu      |Hiba: Fordts nem lehetsges
    792 TX=de   |bersetze: Shell-Scripts
    792 hu      |Fordts: Shell-Scriptek
    793 TX=de   |bersetze: Kommando-Mens
    793 hu      |Fordts: Utasts-menk
    794 TX=de   |bersetze: Masken
    794 hu      |Fordts: Maszkok
    795 TX=de   |bersetze: Property-Dateien
    795 hu      |Fordts: Property Files
"******** freitext_rep.sh ********
    796 TX=de   |* Option -r: Reparieren
    796 hu      |* -r opci : javts
    797 TX=de   |* Option -S: Setze Mandantensperre
    797 hu      |* Akci -S:  Az mandantzrlat belltsa
    798 TX=de   |* Option -D: Alleinlufer
    798 hu      |* Opci -D: egyedl futkhoz
    799 TX=de   |* Option -A 'datrep1 -d Optionen': nur einige Dateien untersuchen
    799 hu      |* Opci -A 'datrep1 -d opcik': csak nhny fjl ellenrzse
    800 TX=de   |Konnte Startversion nicht bestimmen
    800 hu      |A kezd verzit nem lehetett meghatrozni
    801 TX=de   |Suche alle Freitextreferenzen
    801 hu      |sszes szabad szveg hivatkozs keresse
    802 TX=de   |Suche alle Freitexte
    802 hu      |sszes szabad szveg keresse
    803 TX=de   |datftupd gescheitert
    803 hu      |datftupd sikertelen
    804 TX=de   |mv archiv.stat gescheitert
    804 hu      |mv archiv.stat sikertelen
    805 TX=de   |Analysiere Ergebnis
    805 hu      |Eredmny elemzse
    806 TX=de   |awk datrep1.ref gescheitert
    806 hu      |awk datrep1.ref sikertelen
    807 TX=de   |awk archiv.alle gescheitert
    807 hu      |awk archiv.alle sikertelen
    808 TX=de   |sort gescheitert
    808 hu      |sort sikertelen
    809 TX=de   |Fehlerprotokoll der Freitextfehler in: $rmdir/datrep1.err
    809 hu      |A szabad szveg hibk hibajegyzknyve ebben: $rmdir/datrep1.err
    810 TX=de   |Verarbeite Ergebnis
    810 hu      |Eredmny feldolgozsa
    811 TX=de   |$(wc -l < freitext_rep.fehler) Fehler, Informationen in $rmdir
    811 hu      |$(wc -l < freitext_rep.fehler) Hiba, informcik a $rmdir-ben
    812 TX=de   |Reparatur mit:
    812 hu      |Javts ezzel:
"******** ganzallein.sh ********
    813 TX=de   |Installationssperre muss gesetzt sein!
    813 hu      |Installcis zrlatnek elhelyezve kell lennie!
"******** ganzunter.sh ********
    814 TX=de   |Installation ist gesperrt
    814 hu      |Installci zrolva van
    815 TX=de   |Es knnen keine Mandantensperren gesetzt werden
    815 hu      |Nem helyezhetk el mandantzrlatok
"******** gdpduex.sh ********
    816 TX=de   |Keine Identnummer angegeben.
    816 hu      |Nincs megadva hivatkozsi szm.
    817 TX=de   |Kein  Password angegeben.
    817 hu      |Nincs megadva jelsz.
"******** gen_is_datagen.sh ********
    818 TX=de   |Erzeugt Druckdatengeneratoren zu Infosystemen mit Druckausgabe
    818 hu      |Ltrehoz nyomtatsi adatgenertorokat infosystemekhez nyomtatsi kiadssal
    819 TX=de   |Drucke mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD erzeugen
    819 hu      |Nyomtatsok ltrehozsa $WORKSPACE munkatartomnnyal s $SEARCHWORD keresszval
    820 TX=de   |Drucke mit Arbeitsbereich $WORKSPACE erzeugen
    820 hu      |Nyomtatsok ltrehozsa $WORKSPACE munkatartomnnyal
    821 TX=de   |Drucke mit Suchwort $SEARCHWORD erzeugen
    821 hu      |Nyomtatsok ltrehozsa $SEARCHWORD keresszval
    822 TX=de   |Drucke aus Liste $FILE erzeugen
    822 hu      |Nyomtatsok ltrehozsa a $FILE listbl
    823 TX=de   |Drucke aller Infosysteme erzeugen
    823 hu      |sszes infosystem nyomtatsainak ltrehozsa
    824 TX=de   |Drucke mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD konnte nicht erzeugt werden
    824 hu      |Nem lehetett ltrehozni nyomtatsokat $WORKSPACE munkatartomnnyal s $SEARCHWORD keresszval
    825 TX=de   |Fehler beim Erzeugen der Drucke mit Suchwort $SEARCHWORD
    825 hu      |Hiba a nyomtatsok ltrehozsnl a $SEARCHWORD keresszval
    826 TX=de   |Fehler beim Erzeugen der Drucke mit Arbeitsbereich $WORKSPACE
    826 hu      |Hiba a nyomtatsok ltrehozsnl a $WORKSPACE munkatartomnnyal
    827 TX=de   |Fehler beim Erzeugen der Drucke aus Datei $FILE
    827 hu      |Hiba a nyomtatsok ltrehozsnl a $FILE fjlbl
    828 TX=de   |Fehler beim Erzeugen der Drucke aller Infosysteme
    828 hu      |Hiba az sszes infosystem nyomtatsainak a ltrehozsnl
"******** gen_paytrans_msg.sh ********
    829 TX=de   |* Option -x: XML-Beschreibung des Nachricht
    829 hu      |* Opci -x: Az zenet XML-lersa
"******** generate_reserved_number_ranges.sh ********
    830 TX=de   |Konfiguration wird von stdin eingelesen.
    830 hu      |A konfigurci az stdin-bl kerl beolvassra.
    831 TX=de   |Auf stdout wird das EDP-Skript ausgegeben.
    831 hu      |Az EDP script az stdout-on kerl kiadsra.
"******** get_completed_db_files.sh ********
    832 TX=de   |Fehler: Returncode=$rc bei $1
    832 hu      |Hiba: Returncode=$rc $1 nl
    833 TX=de   |Fehler bei Aufruf von toba_test
    833 hu      |Hiba toba_test felhvsnl
"******** getanwender.sh ********
    834 TX=de   |Anwenderliste konnte nicht erstellt werden
    834 hu      |Felhasznli listt nem lehetett elkszteni
    835 TX=de   |* Option -l: Auflisten der Anwender im Mandanten
    835 hu      |* Opci -l: A felhasznlk felsorolsa a mandantban
    836 TX=de   |* Option -c: Zhlen der Anwender im Mandanten, Ergebnis auf stdout
    836 hu      |* Opci -c: A felhasznlk megszmolsa a mandantban, eredmny stdout on
    837 TX=de   |* Option -m: Mandant, in dem die Funktion ausgefhrt werden soll
    837 hu      |* Opci -m: Mandant, amelyben vgre kell hajtani a funkcit
    838 TX=de   |Default: Aufruf im Mandantenverzeichnis
    838 hu      |Alap: Felhvs a mandantknyvtrban
    839 TX=de   |Filterkritierien:
    839 hu      |Szrkritriumok:
    840 TX=de   |* Option -t: Nur Anwender an Bildschirmtyp bstyp bercksichtigen
    840 hu      |* Opci-t: Csak bstyp kpernytpus felhasznlinak figyelembevtele
    841 TX=de   |Bildschirmtypen: ASC, GUI, EDP, BAT, REP
    841 hu      |Kperny tpusok: ASC, GUI, EDP, BAT, REP
    842 TX=de   |* Option -b: Nur Anwender an Bildschirm bskenn bercksichtigen
    842 hu      |* Opci -b: Csak bskenn kperny felhasznlinak figyelembevtele
    843 TX=de   |Bildschirmkennung ist der Teil hinter dem Bildschirmtyp
    843 hu      |Kpernyazonost a kpernytpus utni rsz
    844 TX=de   |* Option -z: Nur Anwender mit Zeichen zeich bercksichtigen
    844 hu      |* Opci -z: Csak zeich jel felhasznlk figyelembevtele
    845 TX=de   |* Option -s: Suchmuster fr Standort-Angabe
    845 hu      |* Opci -s: Keres muszter telephely-megadshoz
    846 TX=de   |Kann Mandantenverzeichnis fr Mandant $mand nicht ermitteln
    846 hu      |$mand mandant szmra nem hatrozhat meg mandantknyvtr
    847 TX=de   |Kann nicht ins Mandantenverzeichnis $manddir wechseln
    847 hu      |Nem lehet $manddir mandantknyvtrba vltani
    848 TX=de   |Mu im Mandantenverzeichnis oder mit Option -m aufgerufen werden
    848 hu      |A mandantknyvtrban vagy az -m opcival kell felhvni
"******** getinisetting.sh ********
    849 TX=de   |$name - Ausgeben von Einstellungen aus INI-Dateien
    849 hu      |$name - Belltsok kiadsa INI-fjlokbl
    850 TX=de   |usage: $name [-d] [-f Format] INI-Filename Abschnitt Schlssel
    850 hu      |usage: $name [-d] [-f Format] INI-fjlnv szakasz kulcs
    851 TX=de   |$name [-d] [-f Format] -a INI-Filename Abschnitt
    851 hu      |$name [-d] [-f Format] -a INI-fjlnv szakasz
    852 TX=de   |* INI-Filename: Name der zu durchsuchenden Datei im INI-Format
    852 hu      |* INI-fjlnv: az tkutatand fjl neve INI-formtumban
    853 TX=de   |* Abschnitt:    Abschnittsname, gesucht wird [Abschnitt]
    853 hu      |* Fejezet:        A fejezet neve, keress [Fejezet]
    854 TX=de   |* Option -a:    Eintrge zu allen Schlsseln ausgeben.
    854 hu      |* Opci -a:     Bejegyzsek kiadsa az sszes kulcshoz.
    855 TX=de   |Fehlt diese Option, muss ein Schlssel angegeben werden
    855 hu      |Ha hinyzik ez az opci, meg kell adni kulcsot
    856 TX=de   |* Option -f:    Ausgabeformat, Default: V
    856 hu      |* Opci -f:     Kiadsi formtum, default: V
    857 TX=de   |K = Key     (Schlssel, Text vor \"=\")
    857 hu      |K = Key     (Kulcs, szveg eltt \"=\")
    858 TX=de   |V = Value   (Wert, Text nach \"=\")
    858 hu      |V = Value   (rtk, szveg utn \"=\")
    859 TX=de   |B = Both    (Schlssel und Wert, getrennt durch \"=\")
    859 hu      |B = Mindkett (kulcs s rtk, elvlasztva a kvetkezvel \"=\")
    860 TX=de   |S = Section (den angegebenen oder alle Abschnitts-
    860 hu      |S = Section (a megadott vagy az sszes szakasz-
    861 TX=de   |namen ausgeben)
    861 hu      |nv kiadsa)
    862 TX=de   |* Option -d:    debug
    862 hu      |* -d opci:     debug
    863 TX=de   |INI-Dateiname fehlt
    863 hu      |INI-fjlnv hinyzik
    864 TX=de   |Datei nicht vorhanden: $1
    864 hu      |llomny: $1 nem ltezik
    865 TX=de   |Abschnitt fehlt
    865 hu      |Szakasz hinyzik
    866 TX=de   |Schlssel oder Option -a fehlt
    866 hu      |Kulcs vagy -a opci hinyzik
"******** getmaskvar.sh ********
    867 TX=de   |Gibt die Namen aller Variablen aus, die in einer Maske verwendet werden.
    867 hu      |Kiadja az sszes olyan vltoz nevt, ami egy maszkban hasznlatra kerl.
    868 TX=de   |Erlaubt ist: alte Maskenbeschreibung, neue Maskenbeschreibung, GUI-Maske
    868 hu      |Megengedett: rgi maszklers, j maszklers, GUI maszk
    869 TX=de   |* Option -p: Prfix ausgeben (0: Kopfteil, 1: Tabelle)
    869 hu      |* Opci -p: Eltag kiadsa (0: fejrsz, 1: tblzat)
    870 TX=de   |* Option -t: <typentab> verwenden anstelle der typentab im <Mandantenverzeichnis>
    870 hu      |* Opci -t: <typentab> hasznlata a typentab helyett a <mandantknyvtr>-ban
    871 TX=de   |* Option -u: mehrfach in der Maske vorkommende Variablen nur einmal ausgeben
    871 hu      |* Opci -u: A maszkban tbbszr elfordul vltozkat csak egyszer kiadni
    872 TX=de   |$arg ist keine Maske
    872 hu      |$arg nem maszk
    873 TX=de   |Datei $arg nicht gefunden
    873 hu      |$arg nem talltam
    874 TX=de   |Verzeichnis $arg nicht gefunden
    874 hu      |$arg knyvtr nem tallhat
"******** getverwinfo.sh ********
    875 TX=de   |* Option -m: Mandant (Default: aktuelles Verzeichnis)
    875 hu      |* Opci -m: Mandant [Default: aktulis knyvtr]
    876 TX=de   |* Option -b: Datenbank (Default: alle Datenbanken)
    876 hu      |* Opci -b: Adatbank [Default: sszes adatbank]
    877 TX=de   |* Option -g: Gruppe (Default: alle Gruppen)
    877 hu      |* Opci -g: Csoport [Default: sszes csoport]
    878 TX=de   |* Option -c: Zeichensatz: EKS, ANSI, ISO8859 (Default: ISO8859)
    878 hu      |* Opci -c: Jelmondat: EKS, ANSI, ISO8859 [Default: ISO8859]
    879 TX=de   |* Option -r: Ausgeben der Referrer statt den Verweisenden
    879 hu      |* Opci -r: Referlk kiadsa az utastk helyett
    880 TX=de   |(= Verwendungsnachweis fuer Verweise)
    880 hu      |[= Hasznlati nyilvntarts az utastsokhoz]
    881 TX=de   |* Option -w: Ausfhrlichere Meldungen ausgeben (fr Problemanalyse)
    881 hu      |* Opci -w: Rszletes jelentsek kiadsa [problma elemzshez]
    882 TX=de   |\"Kann Felder von Tabelle $tabelle nicht ermitteln\""
    882 hu      |\"$tabelle tblzat mezi nem kzlhetk\""
    883 TX=de   |Gruppenangabe ohne Datenbank nicht zulssig
    883 hu      |Adatbank nlkli csoportmegads nem megengedett
    884 TX=de   |Kann Datenbanken nicht ermitteln
    884 hu      |Adatbankok nem kzlhetk
    885 TX=de   |\"Kann Datenbanken nicht auswerten\""
    885 hu      |\"adatbankok nem kirtkelhetk\""
    886 TX=de   |Fehler beim Filtern der Datenbankauswertung
    886 hu      |Hiba az adatbanki kirtkels szrsnl
    887 TX=de   |\"Kann Felder von Tabelle $rdb:$rgr nicht ermitteln\""
    887 hu      |\"$rdb:$rgr tblzat mezi nem meghatrozhatk\""
    888 TX=de   |Fehler beim Ermitteln der Verweisfelder
    888 hu      |Hiba az utalsi mezk kzlsnl
    889 TX=de   |Fehler beim Sortieren der Verweisfelder
    889 hu      |Hiba az utalsi mezk szortrozsnl
"******** grepinfiles.sh ********
    890 TX=de   |* Option -g: Datei der Variablen-Namen
    890 hu      |* Opci -g: A vltoznevek llomnya
    891 TX=de   |* Option -k: Datei der FOP-Namen
    891 hu      |* Opci -k: Az FOP-nevek llomnya
    892 TX=de   |* Option -i: Gross/Kleinschreibung NICHT beachten
    892 hu      |* Opci -i: Nagy-/kisbetket NE vegye figyelembe
    893 TX=de   |* Option -o: Ausgabe-Datei
    893 hu      |* Opci -o: Kimeneti fjl
    894 TX=de   |*            Default: found.lst
    894 hu      |*            Default: found.lst
    895 TX=de   |* Option -q: quiet=Skriptlauf ohne Ausgabe in Fenster
    895 hu      |* Opci -q: quiet =Skript futtats ablakba trtn kiads nlkl
    896 TX=de   |* Option -s: Liste der Dateien mit Treffern in Ergebnisdatei ausgeben
    896 hu      |* Opci -s: A fjlok listjnak kiadsa eredmnyfjl tallataival
"******** gui-install.sh ********
    897 TX=de   |Auspacken des Archivs $zipfile im Verzeichnis $ziptempdir gescheitert
    897 hu      |A $zipfile archvum kicsomagolsa a $ziptempdir knyvtrban nem sikerlt
    898 TX=de   |GUI-Programmdateien wurden in $TARGET_DIR installiert.
    898 hu      |A GUI programfjlok a $TARGET_DIR-be kerltek installlsra.
"******** guifiles.sh ********
    899 TX=de   |gibt die Namen aller GUI-Programmdateien aus
    899 hu      |kiadja az sszes GUI-programfjl nevt
    900 TX=de   |* Option -a: alle Dateien (default: nur Dateien von Abas)
    900 hu      |* Opci -a: sszes fjl (alaprtelmezett: csak az Abas fjljai)
    901 TX=de   |Bestimmen des Inhalts des Archivs $zipfile gescheitert
    901 hu      |A $zipfile archvum tartalmnak a meghatrozsa nem sikerlt.
"******** guimaskengen.sh ********
    902 TX=de   |Fehler beim Bestimmen der Maskendateien
    902 hu      |Hiba a maszkfjlok meghatrozsnl
    903 TX=de   |Die Optionen -H und -n drfen nicht zusammen angegeben werden.
    903 hu      |A -H s -n opcikat nem szabad egytt megadni.
    904 TX=de   |Uhrzeit kann nicht bestimmt werden
    904 hu      |Id nem meghatrozhat
    905 TX=de   |Kann Maskenbeschreibungen nicht sichern
    905 hu      |A maszklersok nem menthetk
    906 TX=de   |Auspacken der Masken der neuen Maskenbeschreibung gescheitert
    906 hu      |Az j maszklers maszkjainak a kicsomagolsa nem sikerlt
    907 TX=de   |Anlegen von $tagfile gescheitert
    907 hu      |$tagfile elhelyezse sikertelen
"******** hardlinks_possible.sh ********
    908 TX=de   |return: 0 Harte Links von dir1 nach dir2 mglich
    908 hu      |return: 0 hard link dir1-bl dir2-be lehetsges
    909 TX=de   |return: 2 Harte Links von dir1 nach dir2 nicht mglich
    909 hu      |return: 2 hard link dir1-bl dir2-be nem lehetsges
    910 TX=de   |return: 1 Fehler ist aufgetreten
    910 hu      |return: 1 Hibk fordultak el.
    911 TX=de   |$dir ist kein Verzeichnis
    911 hu      |$dir nem knyvtr
    912 TX=de   |Kann Datei $dir1/$tmpdatei nicht anlegen
    912 hu      |$dir1/$tmpdatei fjl nem helyezhet el
"******** has_syslog_format.sh ********
    913 TX=de   |* Option -f: mandantenrelativer Pfad der Kommandologbuchdatei
    913 hu      |* Opci -f: A parancs logbuch fjl mandant-relatv elrsi tvonala
    914 TX=de   |* Option -q: Keine Hinweisausgabe
    914 hu      |* Opci -q: Nincs utals kiads
    915 TX=de   |Das Logbuch $logfile wurde nicht gefunden
    915 hu      |A $logfile logbuch nem volt megtallhat
    916 TX=de   |Das Logbuch $logfile ist leer
    916 hu      |A $logfile logbuch res
    917 TX=de   |wegen Aufraeumen des TMP-Verzeichnisses
    917 hu      |a TMP knyvtr kitakartsa miatt
"******** head.sh ********
    918 TX=de   |usage: $name -n <Zeilen> -i <Eindatei> [ -o <Ausdatei> ] [ -d ]
    918 hu      |hasznlat: $name -n <Sor> -i <forrsfile> [ -o <clfile> ] [ -d ]
    919 TX=de   |* Option -n: erste n Zeilen von Datei mit Kopf-
    919 hu      |* -n opci: kiadni az els n sort az llomnybl fej-
    920 TX=de   |und Fuzeile versehen ausgeben
    920 hu      |s lblccel elltva
    921 TX=de   |* Option -o: Ausgabedatei
    921 hu      |* -o opci: Kimen llomny
    922 TX=de   |Option $1 unbekannnt
    922 hu      |$1 opci ismeretlen
    923 TX=de   |Datei $IFILE existiert nicht
    923 hu      |$IFILE fjl nem ltezik
    924 TX=de   |====== Datei $IFILE, $von Zeilen komplett BEGINN =========
    924 hu      |====== $IFILE llomny, $von sor komplett KEZDET =======
    925 TX=de   |====== Datei $IFILE, $von Zeilen komplett ENDE   =========
    925 hu      |====== $IFILE llomny, $von sor komplett VGE  =======
    926 TX=de   |====== Datei $IFILE, $ZEILEN von $von Zeilen BEGINN ======
    926 hu      |====== $IFILE llomny, $ZEILEN sor a $von-bl KEZDET =======
    927 TX=de   |====== Datei $IFILE, $ZEILEN von $von Zeilen ENDE   ======
    927 hu      |====== $IFILE llomny, $ZEILEN sor a $von-bl VGE   =======
"******** hilfe.sh ********
    928 TX=de   |Kommando nicht verfgbar
    928 hu      |Parancs nem ll rendelkezsre
    929 TX=de   |In homedir.env eingetragener Benutzer $s3user existiert nicht!
    929 hu      |A homedir.env-ben bejegyzett $s3user felhasznl nem ltezik!
    930 TX=de   |Gewnschte Sprache (`fr_test.sh -D`):
    930 hu      |Kvnt nyelv (`fr_test.sh -D`):
    931 TX=de   |bersetzung nicht vorhanden!
    931 hu      |A fordts nem ll rendelkezsre!
    932 TX=de   |Sprache wechseln
    932 hu      |Nyelvvlts
    933 TX=de   |Bitte gewnschte Funktion whlen
    933 hu      |Vlassza ki a kvnt funkcit!
    934 TX=de   |Sichern des Datenbestandes
    934 hu      |Adatllomnyt mentse
    935 TX=de   |Nachladen des Datenbestandes
    935 hu      |Adatllomny visszatltse
    936 TX=de   |Prfen der Datensicherung auf Lesefehler
    936 hu      |Adatments ellenrzse olvassi hibkra
    937 TX=de   |Anzeigen der aktiven Datenbank-Anwender in einem Mand.
    937 hu      |Az aktv adatbanki felhasznlk megjelentse egy mandantban
    938 TX=de   |Anzeigen aller aktiven Bildschirme (Bildschirmauskunft)
    938 hu      |sszes aktv kperny megjelentse (Kpernyinformci)
    939 TX=de   |Programmabbruch und Wiederanlauf
    939 hu      |Programegszakts s jraindts
    940 TX=de   |Fremdsprachenbersetzer
    940 hu      |Idegennyelv fordt
    941 TX=de   |Installationssperre verwalten
    941 hu      |Installcis zrlat kezelse
    942 TX=de   |Mandantensperre verwalten
    942 hu      |Mandant-zrlat kezelse
    943 TX=de   |Wartungsprogramme fr einen Mandanten
    943 hu      |Karbantartsi programok egy mandant-ra
    944 TX=de   |Wartungsprogramme im Programmbereich
    944 hu      |Karbantartsi programok a programtartomnyban
    945 TX=de   |Serverkonfiguration (TCP/IP)
    945 hu      |Szerverkonfigurci (TCP/IP)
    946 TX=de   |Whlen Sie die gewnschte Funktion
    946 hu      |Vlassza ki a kvnt funkcit
    947 TX=de   |Mandanten kopieren
    947 hu      |Mandantok msolsa
    948 TX=de   |Mandanten initialisieren
    948 hu      |Mandantok inicializlsa
    949 TX=de   |Bitte zu konfigurierenden Dienst auswhlen
    949 hu      |Krem vlassza ki a kongifurland szolgltatst
    950 TX=de   |GUI-Anwendungsserver
    950 hu      |GUI-alkalmazsszerver
    951 TX=de   |EDP-Server
    951 hu      |EDP-szerver
"******** homedir_env.sh ********
    952 TX=de   |* Option -u: (upgrade) homedir.env waehrend Upgrade
    952 hu      |* Opci -u: (upgrade) homedir.env frissts alatt
    953 TX=de   |* Option -f: file, - fuer stdin
    953 hu      |* -f opci : fjl, - egyenl stdin
"******** homedircopy.sh ********
    954 TX=de   |rmdir aufgehoben: $rmdir
    954 hu      |rmdir trlve: $rmdir
    955 TX=de   |* Option -?: usage: Diesen Text ausgeben
    955 hu      |* -? opci:  usage(hasznlat): ennek a szvegnek a kiadsa
    956 TX=de   |* Option -d: debug: Alle Befehle ausgeben
    956 hu      |* -d opci: debug(hibakeress): az sszes utasts kiadsa
    957 TX=de   |* Option -a: architecture: Architekturabhngiges Verzeichnis
    957 hu      |* opci -a: architecture: Architektrtl fgg knyvtr
    958 TX=de   |$HOMEDIR/$ARCHNAME nicht mitkopieren
    958 hu      |$HOMEDIR/$ARCHNAME-t nem msolni
    959 TX=de   |* Option -v: verbose: erweiterte Hinweise/Meldungen
    959 hu      |* -v opci: verbose(bven): kibvtett utalsok/zenetek
    960 TX=de   |* Option -s: source: zu kopierendes HOMEDIR (Quellhomedir)
    960 hu      |* Opci -s: source: Msoland HOMEDIR (forrs homedir)
    961 TX=de   |* Option -t: target: Zielhomedir, fr Betriebssysteme ungleich
    961 hu      |* Opci -t: target: Cl homedir. Opercis rendszerekhez klnbz
    962 TX=de   |Windows kann mit host:pfad ein Zielhomedir auf einem anderen
    962 hu      |Windows a host:pfad-dal megadhat egy cl homedir-t egy msik
    963 TX=de   |Rechner angegeben werden
    963 hu      |szmtgpen.
    964 TX=de   |Kopier- und Zugangskommando (rsync und ssh) zu einem anderen
    964 hu      |A msolsi s hozzfrsi parancs (rsync und ssh) egy msik
    965 TX=de   |Rechner sind durch die Umgebungsvariablen S3_RCP und S3_RSH
    965 hu      |munkallomshoz az S3_RCP s S3_RSH krnyezeti vltozkon keresztl
    966 TX=de   |nderbar.
    966 hu      |mdosthat.
    967 TX=de   |Sperre $l1_sp in HOMEDIR=$HOMEDIR konnte nicht gesetzt werden
    967 hu      |A $l1_sp zrlatot a HOMEDIR=$HOMEDIR-ben nem lehetett elhelyezni
    968 TX=de   |Es wird gerade ein Wrterbuch generiert
    968 hu      |ppen generlsra kerl egy sztr
    969 TX=de   |Sperre $l2_sp in HOMEDIR=$HOMEDIR konnte nicht aufgehoben werden
    969 hu      |A $l2_sp zrlatot a HOMEDIR=$HOMEDIR-ben nem lehetett megszntetni
    970 TX=de   |Zielhost aus target $1 nicht bestimmbar (rc=$rc)
    970 hu      |Cl host target $1-bl nem meghatrozhat (rc=$rc)
    971 TX=de   |Zielverzeichnis aus target $1 nicht bestimmbar (rc=$rc)
    971 hu      |Cl knyvtr target $1-bl nem meghatrozhat (rc=$rc)
    972 TX=de   |Zielverzeichnis muss als absoluter Pfad angegeben werden
    972 hu      |A clknyvtrat abszolt elrsi tvonalknt kell megadni
    973 TX=de   |Quellhomedir fehlt
    973 hu      |Forrs homedir hinyzik
    974 TX=de   |$source ist kein Verzeichnis
    974 hu      |$source nem knyvtr
    975 TX=de   |Zielhomedir fehlt
    975 hu      |Cl homedir hinyzik
    976 TX=de   |Umgebung in $target konnte nicht hergestellt werden
    976 hu      |Krnyezetet a $target-ben nem lehetett ltrehozni
    977 TX=de   |Datei homedir.env muss manuell erstellt werden.
    977 hu      |A homedir.env fjlt manulisan kell elkszteni.
    978 TX=de   |envmake -D . in $target muss aufgerufen werden
    978 hu      |envmake -D . a $target-ben kell lehvni
    979 TX=de   |Unterverzeichnis $ARCHNAME in $target existiert nicht
    979 hu      |A $ARCHNAME alknyvtr a $target-ben nem ltezik
    980 TX=de   |Datei $d fehlt in $source
    980 hu      |$d fjl $source-ben hinyzik
    981 TX=de   |Zielverzeichnis $target ist nicht schreibbar
    981 hu      |$target clknyvtr nem rhat
    982 TX=de   |Quellhomedir $source = Mandantenverzeichnis $d
    982 hu      |$source forrs homedir = $d mandantknyvtr
    983 TX=de   |Quellhomedir $source liegt unter Mandantenverzeichnis $d
    983 hu      |$source forrs homedir a $d mandantknyvtr alatt van
    984 TX=de   |Vergleich von $source und $target lieferte $vgl
    984 hu      |sszehasonlts $source s $target szlltott $vgl
    985 TX=de   |Mandantenverzeichnis $source/$d gibt es nicht
    985 hu      |$source/$d mandantknyvtr nem ltezik
"******** infoallmaskgen.sh ********
    986 TX=de   |* Option -m category: Infosystemmasken einer Kategorie
    986 hu      |* Opci -m category: Egy kategria infosystem maszkjai
    987 TX=de   |Kategorie INFO: alle Infosystemmasken (default)
    987 hu      |INFO kategria: sszes infosystem maszk (default)
    988 TX=de   |Kategorie STDINFO: nur Standard-Infosystemmasken
    988 hu      |STDINFO kategria: csak standard infosystem maszkok
    989 TX=de   |Kategorie OWNINFO: nur Kunden-Infosystemmasken
    989 hu      |OWNINFO kategria: csak vev infosystem maszkok
    990 TX=de   |* -T: Datei mit allen Anforderungstexten erzeugen
    990 hu      |* -T: Fjl ltrehozsa az sszes felirati szveggel
    991 TX=de   |* -t <dir>: Verzeichnis fr die mit -T erzeugen Dateien
    991 hu      |* -t <dir>: Knyvtr a -T -vel ltrehozott fjlokhoz
    992 TX=de   |spr: Sprachverzeichnis (default:
    992 hu      |nyelv: Nyelvknyvtr [default:
"******** infomaskgen.sh ********
    993 TX=de   |* -s<spr>: Sprachverzeichnis (default:
    993 hu      |* -s<nyelv>: Nyelvknyvtr [default:
    994 TX=de   |* -A: nur die alte Maskenbeschreibung aus der neuen erzeugen
    994 hu      |* -A: csak a rgi maszklers ltrehozsa az jbl
    995 TX=de   |* -a <dateiname>: ASCII-Maske in Datei generieren
    995 hu      |* -a <dateiname>: ASCII maszk generlsa fjlban
    996 TX=de   |* -f <maskenliste> Datei mit je einem Maskennamen pro Zeile (z.B
    996 hu      |* -f <maskenliste> Fjl egy-egy maszknvvel soronknt (pl.
    997 TX=de   |<maskenname> (z.B
    997 hu      |<maszknv> [pl.
    998 TX=de   |Generierung der GUI-Masken gescheitert
    998 hu      |A GUI (grafikus kezelfellet) maszkok generlsa nem sikerlt
    999 TX=de   |$myinfile: Identnummer kann nicht bestimmt werden
    999 hu      |$myinfile: Hivatkozsi szm nem meghatrozhat
   1000 TX=de   |Maske $mymaske: Generierung der alten Maskenbeschreibung gescheitert
   1000 hu      |$mymaske maszk: A rgi maszklers generlsa nem sikerlt
   1001 TX=de   |$myinfile: sed gescheitert
   1001 hu      |$myinfile: sed sikertelen
   1002 TX=de   |$0     im Mandanten-Verzeichnis aufrufen
   1002 hu      |$0     a mandant-knyvtrbl kell indtani
   1003 TX=de   |Verzeichnis screens/$xmlmaskdir existiert nicht
   1003 hu      |screens/$xmlmaskdir knyvtr nem ltezik
"******** infosys_defines.sh ********
   1004 TX=de   |Selektionen:
   1004 hu      |Szelekcik:
   1005 TX=de   |-s searchword: Suchwort
   1005 hu      |-s searchword: Keressz
   1006 TX=de   |Beispiel: BSTATUS (Infosysteme BSTATUS)
   1006 hu      |Plda: BSTATUS (BSTATUS infosystemek)
   1007 TX=de   |-w workspace: Arbeitsbereich workspace
   1007 hu      |-w workspace: Munkatartomny workspace
   1008 TX=de   |Beispiel: -w la (Arbeitsbereich Lagerwesen)
   1008 hu      |Plda: -w la (munkatartomny raktrkezels)
   1009 TX=de   |Hinweis: -w und -s sind zu einem eindeutigen Infosystem kombinierbar
   1009 hu      |Megjegyzs: -w s -s egyrtelm infosystemm kombinlhat
   1010 TX=de   |Beispiel: -w la -s BSTATUS (Infosystem BSTATUS im Arbeitsbereich la)
   1010 hu      |Plda: -w la -s BSTATUS (BSTATUS infosystem az la munkatartomnyban)
   1011 TX=de   |-f file: Datei mit einer Infosystemliste
   1011 hu      |-f file: Fjl infosystemlistval
   1012 TX=de   |Jede Zeile entspricht genau einem Infosystem
   1012 hu      |Minden sor pontosan egy infosystemnek felel meg
   1013 TX=de   |und hat dazu zwei Felder Arbeitsbereich und Suchwort
   1013 hu      |s ehhez kt mezje van, a munkatartomny s keressz
   1014 TX=de   |Der Trenner ist ein Leerzeichen
   1014 hu      |Az elvlaszt egy szkz
   1015 TX=de   |Beispiel: la BSTATUS (Infosystem BSTATUS im Arbeitsbereich la)
   1015 hu      |Plda: la BSTATUS (BSTATUS infosystem az la munkatartomnyban)
   1016 TX=de   |-p password: Abas Passwort
   1016 hu      |-p password: Abas jelsz
   1017 TX=de   |-q: Keine Hinweismeldungen ausgeben
   1017 hu      |-q: Nincs utals zenetek kiadsa
   1018 TX=de   |-H file: Hinweise von Skripten und EDP auf file
   1018 hu      |-H file: Scriptek s EDP utalsai file-ra
   1019 TX=de   |-L file: Logging - Ausgabe der EDP-Kommunikation
   1019 hu      |-L file: Logging - az EDP kommunikci kiadsa
   1020 TX=de   |-m mode: Art des Vorganges
   1020 hu      |-m mode: A folyamat tpusa
   1021 TX=de   |Man unterscheidet zwischen:
   1021 hu      |Megklnbztetjk a kvetkezket:
   1022 TX=de   |NORMAL: ohne Anpassungen (voreingestellt)
   1022 hu      |NORMAL: testreszabsok nlkl (elzetesen belltott)
   1023 TX=de   |EXTEND: mitsamt Anpassungen
   1023 hu      |EXTEND: testreszabsokkal egytt
   1024 TX=de   |-o mode: Generierte Layouts erzeugen
   1024 hu      |-o mode: Generlt layoutok ltrehozsa
   1025 TX=de   |Der Parameter mode kennt folgende Einstellungen:
   1025 hu      |A mode paramter a kvetkez belltsokat ismeri:
   1026 TX=de   |FORCED = Erzwungene Erzeugung
   1026 hu      |FORCED = Ktelez ltrehozs
   1027 TX=de   |UNFORCED = Erzeugung nur, wenn nicht bereits vorhanden
   1027 hu      |UNFORCED = Ltrehozs csak akkor, ha mg nem ll rendelkezsre
   1028 TX=de   |Skript darf nicht als root ausgefhrt werden
   1028 hu      |A scriptet nem lehet rootknt vgrehajtani
   1029 TX=de   |Die Option -f ist nicht mit -s und -w kombinierbar
   1029 hu      |Az -f opci nem kombinlhat -s s -w opcikkal
   1030 TX=de   |Die Datei $FILE wurde nicht gefunden oder ist leer
   1030 hu      |A $FILE fjl nem volt megtallhat vagy res
"******** infosys_export.sh ********
   1031 TX=de   |Exportiert Infosysteme
   1031 hu      |Infosystemek exportlsa
   1032 TX=de   |-e: Umgebung bekannt machen
   1032 hu      |-e: Krnyezet ismertt ttele
   1033 TX=de   |-c: Standort auf Mandantenverzeichnis testen
   1033 hu      |-c: Telephely tesztelse mandantknyvtron
   1034 TX=de   |-t separator: Feldtrenner der Datei in -f
   1034 hu      |-t separator: A fjl mezelvlasztja -f -ben
   1035 TX=de   |Default ist Leerzeichen
   1035 hu      |A standard a szkz
   1036 TX=de   |Beispiel: -t\; (Trenner ist Strichpunkt)
   1036 hu      |Plda: -t\; (elvlaszt a pontosvessz)
   1037 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD exportieren
   1037 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystem exportlsa
   1038 TX=de   |Infosysteme mit Arbeitsbereich $WORKSPACE exportieren
   1038 hu      |$WORKSPACE munkatartomny infosystemek exportlsa
   1039 TX=de   |Infosysteme mit Suchwort $SEARCHWORD exportieren
   1039 hu      |$SEARCHWORD keresszav infosystemek exportlsa
   1040 TX=de   |Infosysteme aus Liste $FILE exportieren
   1040 hu      |Infosystemek exportlsa $FILE listbl
   1041 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD konnte nicht exportiert werden
   1041 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemet nem lehetett exportlni
   1042 TX=de   |Fehler beim Export der Infosysteme mit Suchwort $SEARCHWORD
   1042 hu      |Hiba a $SEARCHWORD keresszav infosystemek exportjnl
   1043 TX=de   |Fehler beim Export der Infosysteme mit Arbeitsbereich $WORKSPACE
   1043 hu      |Hiba a $WORKSPACE munkatartomny infosystemek exportjnl
   1044 TX=de   |Fehler beim Export der Infosysteme aus Datei $FILE
   1044 hu      |Hiba az infosystmek exportjnl $FILE fjlbl
"******** infosys_get_files.sh ********
   1045 TX=de   |-d:  Testmodus
   1045 hu      |-d: Tesztmdozat
   1046 TX=de   |Darstellungen:
   1046 hu      |Megjelents:
   1047 TX=de   |-v view: ALL     = alle Dateien (Voreinstellung)
   1047 hu      |-v view: ALL     = sszes fjl (elzetes bellts)
   1048 TX=de   |INCLUDE = alle mit include markierten Dateien
   1048 hu      |INCLUDE = sszes include-val kijellt fjllal
   1049 TX=de   |RECORD  = alle Dateien aus dem Datensatz
   1049 hu      |RECORD  = sszes fjl a rekordbl
   1050 TX=de   |LAYOUT  = alle Dateien aus Infosystem-Layouts
   1050 hu      |LAYOUT  = sszes fjl az infosystem layoutok-bl
   1051 TX=de   |EXPORT  = alle exportierten Dateien
   1051 hu      |EXPORT  = sszes exportlt fjl
   1052 TX=de   |Die Datei $file wurde nicht gefunden oder ist leer
   1052 hu      |A $file fjl nem volt megtallhat vagy res
"******** infosys_get_imports.sh ********
   1053 TX=de   |Liefert Liste mit importierbaren Importdateien.
   1053 hu      |Listt hoz importlhat importfjlokkal.
   1054 TX=de   |* Option -p: Passwort
   1054 hu      |* Opci -p: Jelsz
   1055 TX=de   |* Option -t: Art der Importdateien
   1055 hu      |* Opci -t: Az importfjlok tpusa
   1056 TX=de   |DFLT = importierbare eigene Dateien
   1056 hu      |DFLT = importlhat sajt fjlok
   1057 TX=de   |ohne Anpassungen
   1057 hu      |Testreszabsok nlkl
   1058 TX=de   |CUST = importierbare eigene Dateien
   1058 hu      |CUST = importlhat sajt fjlok
   1059 TX=de   |mitsamt Anpassungen
   1059 hu      |Testreszabsokkal egytt
   1060 TX=de   |Das Verzeichnis $importdir wurde nicht gefunden.
   1060 hu      |$importdir knyvtr nem tallhat.
   1061 TX=de   |Das Verzeichnis $importdir ist nicht lesbar.
   1061 hu      |A $importdir knyvtr nem olvashat.
   1062 TX=de   |Es wurden keine Importdateien gefunden.
   1062 hu      |Nem voltak tallhatk importfjlok.
   1063 TX=de   |Es wurden keine Lieferdateien gefunden.
   1063 hu      |Nem voltak tallhatk szlltsi fjlok.
   1064 TX=de   |Es wurden keine Importdateien gefunden, die importierbar sind.
   1064 hu      |Nem voltak tallhatk importfjlok, amik importlhatk.
"******** infosys_layoutgen.sh ********
   1065 TX=de   |Erzeugt Layouts zu Infosystemen
   1065 hu      |Layoutokat hoz ltre infosystemekhez
   1066 TX=de   |Layouts zu Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD erzeugen
   1066 hu      |Layoutok ltrehozsa $WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemhez
   1067 TX=de   |Layouts zu Infosystemen mit Arbeitsbereich $WORKSPACE erzeugen
   1067 hu      |Layoutok ltrehozsa $WORKSPACE munkatartomny infosystemekhez
   1068 TX=de   |Layouts zu Infosystemen mit Suchwort $SEARCHWORD erzeugen
   1068 hu      |Layoutok ltrehozsa $SEARCHWORD keresszav infosystemekhez
   1069 TX=de   |Layouts zu Infosystemen aus Liste $FILE erzeugen
   1069 hu      |Layoutok ltrehozsa infosystemekhez a $FILE listbl
   1070 TX=de   |Layouts zu allen Infosystemen erzeugen
   1070 hu      |Layoutok ltrehozsa az sszes infosystemhez
   1071 TX=de   |Fehler bei der Erzeugung der Layouts
   1071 hu      |Hiba a layoutok ltrehozsnl
"******** infosys_patch.sh ********
   1072 TX=de   |Aktualisiert Infosysteme zu Korrekturzwecken
   1072 hu      |Infosystemek aktualizlsa korrekcis clokra
   1073 TX=de   |-u mode: Modus der Aktualisierung, d.h. Wert der EDP-Option UPDATEMODE
   1073 hu      |-u mode: Az aktualizls mdja, azaz az UPDATEMODE EDP-opci rtke
   1074 TX=de   |Voreinstellung ist leer. (Siehe EDP-Spezifikation)
   1074 hu      |Elzetes bellts res. (Lsd EDP-specifikci)
   1075 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD aktualisieren
   1075 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystem aktualizlsa
   1076 TX=de   |Infosysteme mit Arbeitsbereich $WORKSPACE aktualisieren
   1076 hu      |$WORKSPACE munkatartomny infosystemek aktualizlsa
   1077 TX=de   |Infosysteme mit Suchwort $SEARCHWORD aktualisieren
   1077 hu      |$SEARCHWORD keresszav infosystemek aktualizlsa
   1078 TX=de   |Infosysteme aus Liste $FILE aktualisieren
   1078 hu      |Infosystemek aktualizlsa $FILE listbl
   1079 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD konnte nicht aktualisiert werden
   1079 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemet nem lehetett aktualizlni
   1080 TX=de   |Fehler bei der Aktualisierung der Infosysteme mit Suchwort $SEARCHWORD
   1080 hu      |Hiba a $SEARCHWORD keresszav infosystemek aktualizlsnl
   1081 TX=de   |Fehler bei der Aktualisierung der Infosysteme mit Arbeitsbereich $WORKSPACE
   1081 hu      |Hiba a $WORKSPACE munkatartomny infosystemek aktualizlsnl
   1082 TX=de   |Fehler bei der Aktualisierung der Infosysteme aus Datei $FILE
   1082 hu      |Hiba az infosystemek aktualizlsnl $FILE fjlbl
"******** infosys_remove.sh ********
   1083 TX=de   |Entfernt Infosysteme
   1083 hu      |Infosystemek eltvoltsa
   1084 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD entfernen
   1084 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystem eltvoltsa
   1085 TX=de   |Infosysteme mit Arbeitsbereich $WORKSPACE entfernen
   1085 hu      |$WORKSPACE munkatartomny infosystemek eltvoltsa
   1086 TX=de   |Infosysteme mit Suchwort $SEARCHWORD entfernen
   1086 hu      |$SEARCHWORD keresszav infosystemek eltvoltsa
   1087 TX=de   |Infosysteme aus Liste $FILE entfernen
   1087 hu      |Infosystemek eltvoltsa a $FILE listbl
   1088 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD konnte nicht entfernt werden
   1088 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemet nem lehetett eltvoltani
   1089 TX=de   |Fehler bei der Entfernung der Infosysteme mit Suchwort $SEARCHWORD
   1089 hu      |Hiba a $SEARCHWORD keresszav infosystemek eltvoltsnl
   1090 TX=de   |Fehler bei der Entfernung der Infosysteme mit Arbeitsbereich $WORKSPACE
   1090 hu      |Hiba a $WORKSPACE munkatartomny infosystemek eltvoltsnl
   1091 TX=de   |Fehler bei der Entfernung der Infosysteme aus Datei $FILE
   1091 hu      |Hiba az infosystemek eltvoltsnl a $FILE fjlbl
"******** infosys_replace_type.sh ********
   1092 TX=de   |-a action: Festlegung der Aktion
   1092 hu      |-a action: A mvelet meghatrozsa
   1093 TX=de   |LIST    = Betroffene Felder ausgeben (Voreinstellung)
   1093 hu      |LIST    = rintett mezk kiadsa (elzetes bellts)
   1094 TX=de   |REPLACE = Verweisausgabe umstellen
   1094 hu      |REPLACE = Utals kiads tlltsa
   1095 TX=de   |Dies betrifft nur individuell einstellbare Maskenfelder in
   1095 hu      |Ez csak az egyedileg bellthat maszkmezket rinti a
   1096 TX=de   |ausgelieferten Infosystemen. Ausgenommen ist der Arbeitsbereich demo
   1096 hu      |kiszlltott infosystemekben. Kivtel a demo munkatartomny
   1097 TX=de   |-t target: Echo von Artikelverweisen in Standardinfosystemen festlegen
   1097 hu      |-t target: rucikk utalsok echo-jnak meghatrozsa standard infosystemekben
   1098 TX=de   |NUM = Ziel ist Nummernausgabe (Voreinstellung)
   1098 hu      |NUM = Cl a szmkiads (elzetes bellts)
   1099 TX=de   |Betroffene Arten: VPS1 VPNS1 VPBS1 VPKS1 PS2 PS7
   1099 hu      |rintett tpusok: VPS1 VPNS1 VPBS1 VPKS1 PS2 PS7
   1100 TX=de   |SW  = Ziel ist Suchwortausgabe
   1100 hu      |SW  = Cl a keressz kiads
   1101 TX=de   |Betroffene Arten: VP1 VPN1 VPB1 VPK1 P2 P7
   1101 hu      |rintett tpusok: VP1 VPN1 VPB1 VPK1 P2 P7
   1102 TX=de   |-c separator: Feldtrenner der Datei in -f
   1102 hu      |-c separator: A fjl mez elvlasztja -f-ben
   1103 TX=de   |Beispiel: -c\; (Trenner ist Strichpunkt)
   1103 hu      |Plda: -c\; (az elvlaszt pontosvessz)
   1104 TX=de   |Suche alle individuell einstellbaren Maskenfelder ...
   1104 hu      |sszes egyedileg bellthat maszkmez keresse ...
   1105 TX=de   |Bestimme daraus alle Verweise ...
   1105 hu      |Ebbl sszes utals meghatrozsa ...
   1106 TX=de   |Zeige Umstellungen an ...
   1106 hu      |tlltsok megjelentse ...
   1107 TX=de   |Extrahiere betroffene Verweisarten: $origintypes ...
   1107 hu      |rintett utals tpusok extrahlsa: $origintypes ...
   1108 TX=de   |Starte Umstellung zu Verweisarten: $targettypes ...
   1108 hu      |tllts elindtsa utals-tpusokhoz: $targettypes ...
   1109 TX=de   |Die Formatierung der Datei $FILE liefert leeres Ergebnis!
   1109 hu      |A $FILE fjl formzsa res eredmnyt hoz!
   1110 TX=de   |Es wurden keine individuellen einstellbaren Maskenfelder gefunden
   1110 hu      |Nem voltak tallhatk egyedileg bellthat maszkmezk
   1111 TX=de   |Gefundene Maskenfelder: $number
   1111 hu      |Tallt maszkmezk: $number
   1112 TX=de   |Es wurden keine Verweise gefunden
   1112 hu      |Nem voltak tallhatk utalsok
   1113 TX=de   |Gefundene Verweise: $number
   1113 hu      |Tallt utalsok: $number
   1114 TX=de   |Die Anzahl von Quell- und Zielverweisarten ist verschieden
   1114 hu      |A forrs- s cl-utalstpusok szma klnbz
   1115 TX=de   |Es wurde keine der betroffenen Verweisarten gefunden
   1115 hu      |Nem voltak tallhatk az rintett utalstpusok
   1116 TX=de   |Betroffene Felder: $number
   1116 hu      |rintett mezk: $number
"******** infosys_stdnames.sh ********
   1117 TX=de   |* Option -d: Testmodus
   1117 hu      |* -d: Tesztmdozat
   1118 TX=de   |* Option -f: Das Argument ist der Pfad der Datei, in
   1118 hu      |* Opci -f: Az argumentum annak a fjlnak az elrsi tvonala,
   1119 TX=de   |der die Standardnamen stehen. Beispiel:
   1119 hu      |amiben a standard nevek szerepelnek. Plda:
   1120 TX=de   |$HOMEDIR/files.txt (Voreinstellung)
   1120 hu      |$HOMEDIR/files.txt (elzetes bellts)
   1121 TX=de   |* Option -r: Das Argument kann zwei Werte annehmen:
   1121 hu      |* Opci -r: Az argumentum kt rtket vehet fel:
   1122 TX=de   |STD: Gesucht sind Standardnamen (Voreinstellung)
   1122 hu      |STD: Standard nevek kerlnek keressre (elzetes bellts)
   1123 TX=de   |OWN: Gesucht sind individuelle Namen
   1123 hu      |OWN: Egyedi nevek kerlnek keressre
   1124 TX=de   |Die Datei $filestxt wurde nicht gefunden oder ist leer
   1124 hu      |A $filestxt fjl nem volt megtallhat vagy res
"******** infosys_trans_name.sh ********
   1125 TX=de   |bersetzen von Bezeichnungen in Infosystemen
   1125 hu      |Megnevezsek fordtsa infosystemekben
   1126 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD bearbeiten.
   1126 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystem szerkesztse.
   1127 TX=de   |Infosysteme mit Arbeitsbereich $WORKSPACE bearbeiten.
   1127 hu      |$WORKSPACE munkatartomny infosystemek szerkesztse.
   1128 TX=de   |Infosysteme mit Suchwort $SEARCHWORD bearbeiten.
   1128 hu      |$SEARCHWORD keresszav infosystemek szerkesztse.
   1129 TX=de   |Infosysteme aus Liste $FILE bearbeiten.
   1129 hu      |Infosystemek szerkesztse a $FILE listbl.
   1130 TX=de   |bersetzen bei Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD gescheitert.
   1130 hu      |A fordts a $WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemnl nem sikerlt.
   1131 TX=de   |bersetzen bei Infosystemen mit Suchwort $SEARCHWORD gescheitert.
   1131 hu      |A fordts a $SEARCHWORD keresszav infosystemeknl nem sikerlt.
   1132 TX=de   |bersetzen bei Infosystemen mit Arbeitsbereich $WORKSPACE gescheitert.
   1132 hu      |A fordts a $WORKSPACE munkatartomny infosystemeknl nem sikerlt.
   1133 TX=de   |bersetzen bei Infosystemen aus Datei $FILE gescheitert.
   1133 hu      |A fordts a $FILE fjlbl val infosystemeknl nem sikerlt.
"******** infosys_upgrade.sh ********
   1134 TX=de   |Aktualisiert Version von Infosystemen
   1134 hu      |Aktualizlja az infosystemek verzijt
   1135 TX=de   |Bei Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD die Version wechseln.
   1135 hu      |A $WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemnl a verzi vltsa.
   1136 TX=de   |Bei Infosystemen mit Arbeitsbereich $WORKSPACE die Version wechseln.
   1136 hu      |A $WORKSPACE munkatartomny infosystemeknl a verzi vltsa.
   1137 TX=de   |Bei Infosystemen mit Suchwort $SEARCHWORD die Version wechseln.
   1137 hu      |A $SEARCHWORD keresszav infosystemeknl a verzi vltsa.
   1138 TX=de   |Bei Infosystemen aus Liste $FILE die Version wechseln.
   1138 hu      |Az infosystemeknl a $FILE listbl a verzi cserje.
   1139 TX=de   |Versionswechsel bei Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD gescheitert.
   1139 hu      |A verzivlts a $WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemnl nem sikerlt.
   1140 TX=de   |Versionswechsel bei Infosystemen mit Suchwort $SEARCHWORD gescheitert.
   1140 hu      |A verzivlts a $SEARCHWORD keresszav infosystemeknl nem sikerlt.
   1141 TX=de   |Versionswechsel bei Infosystemen mit Arbeitsbereich $WORKSPACE gescheitert.
   1141 hu      |A verzivlts a $WORKSPACE munkatartomny infosystemeknl nem sikerlt.
   1142 TX=de   |Versionswechsel bei Infosystemen aus Datei $FILE gescheitert.
   1142 hu      |A verzivlts a $FILE fjlbl val infosystemeknl nem sikerlt.
"******** infosysimport.sh ********
   1143 TX=de   |Importiert Infosysteme
   1143 hu      |Infosystemeket importl
   1144 TX=de   |Veraltet: Parameterliste aus Infosystemnamen
   1144 hu      |Elavult: Paramterlista infosystemnevekbl
   1145 TX=de   |isname1 isname2 ... Format <ARB>.<SUCH>
   1145 hu      |isname1 isname2 ... Formtum <ARB>.<SUCH>
   1146 TX=de   |Importverzeichnis ${IMPORTDIR} wurde nicht gefunden
   1146 hu      |${IMPORTDIR} import knyvtr nem volt megtallhat
   1147 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD importieren
   1147 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystem importlsa
   1148 TX=de   |Infosysteme mit Arbeitsbereich $WORKSPACE importieren
   1148 hu      |$WORKSPACE munkatartomny infosystemek importlsa
   1149 TX=de   |Infosysteme mit Suchwort $SEARCHWORD importieren
   1149 hu      |$SEARCHWORD keresszav infosystemek importlsa
   1150 TX=de   |Infosysteme aus Liste $FILE importieren
   1150 hu      |Infosystemek importlsa $FILE listbl
   1151 TX=de   |Infosysteme aus Parameterliste importieren
   1151 hu      |Infosystemek importlsa paramterlistbl
   1152 TX=de   |Infosystem mit Arbeitsbereich $WORKSPACE und Suchwort $SEARCHWORD konnte nicht importiert werden
   1152 hu      |$WORKSPACE munkatartomny s $SEARCHWORD keresszav infosystemet nem lehetett importlni
   1153 TX=de   |Fehler beim Import der Infosysteme mit Suchwort $SEARCHWORD
   1153 hu      |Hiba a $SEARCHWORD keresszav infosystemek importjnl
   1154 TX=de   |Fehler beim Import der Infosysteme mit Arbeitsbereich $WORKSPACE
   1154 hu      |Hiba a $WORKSPACE munkatartomny infosystemek importjnl
   1155 TX=de   |Fehler beim Import der Infosysteme aus Datei $FILE
   1155 hu      |Hiba az infosystemek importjnl a $FILE fjlbl
   1156 TX=de   |Fehler beim Import der Infosysteme aus der Parameterliste
   1156 hu      |Hiba az infosystemek importjnl a paramterlistbl
"******** init_mandant.sh ********
   1157 TX=de   |Warnung: Falsche Zusatztabellen-Nummer
   1157 hu      |Figyelmeztets: Rossz kiegszt adatbzis szm
   1158 TX=de   |TRANSACTDATA  Mandant ohne Bewegungsdaten
   1158 hu      |TRANSACTDATA  Mandant mozgsi adatok nlkl
   1159 TX=de   |MASTERDATA    Mandant ohne Bewegungsdaten und
   1159 hu      |MASTERDATA    Mandant mozgsi adatok nlkl s
   1160 TX=de   |ohne individuelle Stammdaten
   1160 hu      |egyedi trzsadatok nlkl
   1161 TX=de   |MASTERDATA2   Mandant ohne Bewegungsdaten, individuelle
   1161 hu      |MASTERDATA2   Mandant mozgsi adatok, egyedi trzsadatok
   1162 TX=de   |Stammdaten und Konten
   1162 hu      |s fknyvi szmlk nlkl
   1163 TX=de   |FINACC        Finanzbuchhaltungsdaten initialisieren
   1163 hu      |FINACC        Pnzgyi knyvelsi adatok inicializlsa
   1164 TX=de   |FINACC2       Finanzbuchhaltungsdaten und Konten initialisieren
   1164 hu      |FINACC2       Pnzgyi knyvelsi adatok s fknyvi szmlk inicializlsa
   1165 TX=de   |ADDDB         Zusatztabellen leeren (mit -z)
   1165 hu      |ADDDB         Kiegszto adatok rtse (-z vel)
   1166 TX=de   |* Option -z: Nummern der zurckzusetzenden Zusatz-DBs
   1166 hu      |* Opci -z: visszalltand kiegszto adatok szmai
   1167 TX=de   |(nur bei TRANSACTDATA, MASTERDATA(2) oder ADDDB)
   1167 hu      |(csak -i esetn TRANSACTDATA, MASTERDATA(2) vagy ADDDB)
   1168 TX=de   |Mgliche Nummern sind 1 bis 40
   1168 hu      |Lehetsges szmok 1 s 40 kzt
   1169 TX=de   |Mehrfache Nummern mit Komma, Bereiche mit \"-\"
   1169 hu      |Tbb szmot vesszovel, a tartomnyokat \"-\" megadni
   1170 TX=de   |* Option -k: Beizubehaltende Datenbanken (nur bei -i B/C/C2)
   1170 hu      |* Opci -k: Megtartand adatbzisok (csak a kvetkeznl: -i B/C/C2)
   1171 TX=de   |Mehrfache Nummern mit Komma getrennt
   1171 hu      |Tbbszrs szmok vesszvel elvlasztva
   1172 TX=de   |konnte Logfile $logfile nicht anlegen
   1172 hu      |$logfile log file-t nem lehetett felvinni
   1173 TX=de   |Generierung des EDP-Import-Skripts fuer DB $DB mit edpexport.sh gescheitert
   1173 hu      |Az EDP import script generlsa a $DB adatbzishoz edpexport.sh-val nem sikerlt
   1174 TX=de   |EDP-Import von $EDP_IMPORT_SCRIPT gescheitert
   1174 hu      |$EDP_IMPORT_SCRIPT EDP importja nem sikerlt
   1175 TX=de   |Generierung von $EDP_IMPORT_SCRIPT gescheitert
   1175 hu      |$EDP_IMPORT_SCRIPT generlsa sikertelen
   1176 TX=de   |Fehler beim Leeren der Datenbanken: $1
   1176 hu      |Hiba az adatbzisok kirtsnl: $1
   1177 TX=de   |Fehler beim Exportieren der IDs von $tablename
   1177 hu      |Hiba az ID-k exportlsnl a $tablename-bl
   1178 TX=de   |Fehler beim Exportieren der IDs der Versionen von $dn
   1178 hu      |Hiba a verzik ID-jainak exportlsakor $dn-bl
   1179 TX=de   |Fehler beim Lschen der Stze in $tablename
   1179 hu      |Hiba a rekordok trlsnl a $tablename-ban
   1180 TX=de   |Fehler beim Lschen der Versionen in $tablename
   1180 hu      |Hiba a verzik trlsekor $tablename-ban
   1181 TX=de   |Kann Liste der Datenbanken nicht ermitteln
   1181 hu      |Az adatbzisok listja nem meghatrozhat
   1182 TX=de   |Kann Liste der Bewegungsdatenbanken nicht ermitteln
   1182 hu      |A mozgsi adatbzisok listja nem meghatrozhat
   1183 TX=de   |Kann Liste der Stammdatenbanken nicht ermitteln
   1183 hu      |A trzsadatbzisok listja nem meghatrozhat
   1184 TX=de   |Fehler beim Lschen der Stze in DB 137
   1184 hu      |Hiba a rekordok trlsnl a DB 137-ban
   1185 TX=de   |Fehler $datreprc beim Reparieren der Verweise auf gelschte Daten
   1185 hu      |$datreprc hiba a trlt adatokra val utalsok javtsnl
   1186 TX=de   |$mandant: Mandant existiert nicht
   1186 hu      |$mandant: Mandant nem ltezik
   1187 TX=de   |Kann nicht ins Mandantenverzeichnis gehen.
   1187 hu      |Nem lehet mandantknyvtrba vltani
   1188 TX=de   |Kann Mandant nicht sperren (s3lock.sh -m)
   1188 hu      |Mandant nem zrolhat (s3lock.sh -m)
   1189 TX=de   |Funktion nicht mglich, Mandant ist in Benutzung
   1189 hu      |Funkci nem lehetsges, mandant hasznlatban
"******** inkrexport.sh ********
   1190 TX=de   |* Option -I: Startadresse
   1190 hu      |* Opci -I: Kezd cm
   1191 TX=de   |* Option ausser -I siehe upexport -h
   1191 hu      |* Opci kivve -I lsd upexport -h
   1192 TX=de   |Verzeichnis $smprefix defekt
   1192 hu      |$smprefix knyvtr hibs
   1193 TX=de   |Datei $smprefix/lastcommit wurde nicht erstellt
   1193 hu      |A $smprefix/lastcommit fjl nem kerlt elksztsre
"******** inkrexportbi.sh ********
   1194 TX=de   |* <modellnr>: Abbildungsmodellnummer
   1194 hu      |* <modellnr>: Lekpezsi modell szm
   1195 TX=de   |* -d: Debugoption
   1195 hu      |* -d: Debug
   1196 TX=de   |* -L limit: Scheibengroesse
   1196 hu      |* -L limit: Lemez nagysg
   1197 TX=de   |* -w limit: Maximale Spaltenbreite
   1197 hu      |* -w limit: Maximum oszlop szlessg
   1198 TX=de   |Datei $fieldsfile fehlt
   1198 hu      |$fieldsfile hinyzik
   1199 TX=de   |Verzeichnis $statusdir fehlt
   1199 hu      |$statusdir knyvtr hinyzik
   1200 TX=de   |Script $psqlcall fehlt
   1200 hu      |$psqlcall hinyzik
   1201 TX=de   |mkdir -p $minidir gescheitert
   1201 hu      |mkdir -p $minidir sikertelen
   1202 TX=de   |inkrexportfix.sh gescheitert
   1202 hu      |inkrexportfix.sh sikertelen
   1203 TX=de   |Diagnosemeldung in dinkrexport
   1203 hu      |Diagnzisjelents dinkrexport-ban
   1204 TX=de   |inkrexport gescheitert mit: $logadr $ainkrexportrc, siehe $minidir/inkrexport.err
   1204 hu      |inkrexport nem sikerlt a kvetkezvel: $logadr $ainkrexportrc, lsd $minidir/inkrexport.err
   1205 TX=de   |inkrexport hat keine Ausgabe $tsvdir
   1205 hu      |inkrexport nem rendelkezik $tsvdir kiadssal
   1206 TX=de   |inkrexport hat kein $tsvdir/lastcommit hinterlassen
   1206 hu      |inkrexport nem hagyott htra $tsvdir/lastcommit-ot
   1207 TX=de   |inkrexportpsql.sh gescheitert, siehe $minidir/inkrexportpsql.err
   1207 hu      |inkrexportpsql.sh nem sikerlt, lsd $minidir/inkrexportpsql.err
   1208 TX=de   |sh $tsvdir/awkscript gescheitert, siehe $minidir/awkscript.err
   1208 hu      |sh $tsvdir/awkscript nem sikerlt, lsd $minidir/awkscript.err
   1209 TX=de   |psql $POPT -f $tsvdir/psqlscript gescheitert, siehe $minidir/psqlscript.err
   1209 hu      |psql $POPT -f $tsvdir/psqlscript nem sikerlt, lsd $minidir/psqlscript.err
   1210 TX=de   |psql Fehler beim Import: siehe $minidir/psqlscript.err
   1210 hu      |psql hiba az importnl: lsd $minidir/psqlscript.err
   1211 TX=de   |erzeugen von $lastcommitfile gescheitert
   1211 hu      |$lastcommitfile ltrehozsa nem sikerlt
"******** inkrexportfix.sh ********
   1212 TX=de   |* <fieldsfile>: Feldliste die zu patchen ist
   1212 hu      |* <fieldsfile>: Patchelend mezlista
   1213 TX=de   |* <minidir>: Verzeichnis mit mini mandant
   1213 hu      |* <minidir>: Knyvtr mini mandanttal
   1214 TX=de   |Feldliste '$fields' ist nicht gefuellt
   1214 hu      |'$fields' mezlista nincs kitltve
   1215 TX=de   |Parameter '$minidir' ist kein Verzeichnis
   1215 hu      |'$minidir' paramter nem knyvtr
   1216 TX=de   |Ergaenzen der Feldliste gescheitert
   1216 hu      |A mezlista kiegsztse nem sikerlt
   1217 TX=de   |feldliste gescheitert, siehe $minidir/fields.err
   1217 hu      |feldliste nem sikerlt, lsd $minidir/fields.err
"******** inkrexportpsql.sh ********
   1218 TX=de   |* <minidir>: Minimandantenverzeichnis
   1218 hu      |* <minidir>: Mini mandant knyvtr
   1219 TX=de   |* <tsvdir>: Verzeichnis von inkrexport.sh mit tsv Dateien
   1219 hu      |* <tsvdir>: inkrexport.sh knyvtra tsv fjlokkal
   1220 TX=de   |Parameter '$tsvdir' ist kein Verzeichnis
   1220 hu      |'$tsvdir' paramter nem knyvtr
   1221 TX=de   |Datei $minidir/namelist nicht gefuellt
   1221 hu      |$minidir/namelist fjl nincs kitltve
   1222 TX=de   |Erzeugen von $tsvdir/awkscript gescheitert
   1222 hu      |$tsvdir/awkscript ltrehozsa nem sikerlt
   1223 TX=de   |Erzeugen von $tsvdir/namen gescheitert
   1223 hu      |$tsvdir/namen ltrehozsa nem sikerlt
   1224 TX=de   |sort $tsvdir/files $minidir/namelist gescheitert
   1224 hu      |sort $tsvdir/files $minidir/namelist nem sikerlt
   1225 TX=de   |join $tsvdir/sum gescheitert
   1225 hu      |join $tsvdir/sum nem sikerlt
"******** install-lucene.sh ********
   1226 TX=de   |Installation der Volltextsuche
   1226 hu      |A teljes szveg keress installcija
   1227 TX=de   |* Option -j <arg>: Jetty installieren /deinstallieren
   1227 hu      |* Opci -j <arg>: Jetty installlsa/uninstalllsa
   1228 TX=de   |* Option -i: Index fr Volltextsuche erstellen
   1228 hu      |* Opci -i: Index ksztse teljes szveg keresshez
   1229 TX=de   |* Option -w: Webapplikation fr Volltextsuche erstellen
   1229 hu      |* Opci -w: Webalkalmazs ksztse teljes szveg keresshez
   1230 TX=de   |* dir1, dir2, ...: Mandantenverzeichnisse
   1230 hu      |* dir1, dir2, ...: Mandantknyvtrak
   1231 TX=de   |Lschen der Jetty-Installation in $jettydistdir gescheitert
   1231 hu      |A Jetty installci trlse a $jettydistdir-ben nem sikerlt
   1232 TX=de   |Lschen der Web-Applikationen in $jettybasedir gescheitert
   1232 hu      |A webalkalmazs trlse a $jettybasedir-ben nem sikerlt
   1233 TX=de   |Jetty Distribution fr alle Mandanten ist bereits installiert im Verzeichnis $jettydistdir.
   1233 hu      |A Jetty distribution az sszes mandanthoz mr installlva van a $jettydistdir knyvtrban.
   1234 TX=de   |Jetty-Installation in $jettydistdir nicht erfolgreich.
   1234 hu      |A Jetty installci a $jettydistdir-ben nem sikeres.
   1235 TX=de   |Jetty Basisverzeichnis fr alle Mandanten ist bereits installiert im Verzeichnis $jettybasedir.
   1235 hu      |A Jetty bzisknyvtr az sszes mandanthoz mr installlva van a $jettybasedir knyvtrban.
   1236 TX=de   |Verzeichnis $manddir nicht gefunden
   1236 hu      |$manddir knyvtr nem tallhat
   1237 TX=de   |$name: Ignoriere denv.dat
   1237 hu      |$name: denv.dat figyelmen kvl hagysa
   1238 TX=de   |Ungltiger Mandantname
   1238 hu      |rvnytelen mandant nv
   1239 TX=de   |Der Mandantenname konnte nicht bestimmt werden.
   1239 hu      |A mandant nevt nem lehetett meghatrozni.
   1240 TX=de   |Kann Verzeichnis $myindexdir nicht lschen
   1240 hu      |$myindexdir knyvtr nem trlhet
   1241 TX=de   |Kann Verzeichnis $mydicdir nicht lschen
   1241 hu      |$mydicdir knyvtr nem trlhet
   1242 TX=de   |Die Erzeugung des Index $index wurde abgebrochen!
   1242 hu      |A $index index ltrehozsa megszaktsra kerlt!
   1243 TX=de   |Die Erzeugung des Dictionary Index wurde abgebrochen!
   1243 hu      |A Dictionary Index ltrehozsa megszaktsra kerlt!
   1244 TX=de   |Der Index $index wurde erstellt
   1244 hu      |A $index index elksztsre kerlt
   1245 TX=de   |Jetty-Installation in $jettydistdir existiert nicht
   1245 hu      |Jetty installci a $jettydistdir-ben nem ltezik
   1246 TX=de   |WebApp-Installation in $jettybasedir existiert nicht
   1246 hu      |WebApp installci a $jettybasedir-ben nem ltezik
   1247 TX=de   |Index $index in Verzeichnis $myindexdir nicht gefunden
   1247 hu      |$index index a $myindexdir knyvtrban nem tallhat
"******** iotop.sh ********
   1248 TX=de   |* Option -n: Nur die ersten count Prozesse anzeigen
   1248 hu      |* Opci -n: Csak az els count folyamatok megjelentse
   1249 TX=de   |* Option -b: Refresh alle count Sekunden
   1249 hu      |* Opci -b: sszes count msodperc frisstse
   1250 TX=de   |* Option -s: sort = 2.4.3 bedeutet z.B. Sortierung nach Spalten 2,4,3
   1250 hu      |* Opci -s: sort = 2.4.3 pl. a 2,4,3 oszlopok szerinti szortrozst jelenti
   1251 TX=de   |Es sind nur Spaltenwerte zwischen 2 und 8 erlaubt.
   1251 hu      |Csak 2 s 8 kztti oszlop rtkek megengedettek.
   1252 TX=de   |Default: $sort_krit
   1252 hu      |Alap: $sort_krit
   1253 TX=de   |Sortierung ist immer absteigend
   1253 hu      |Szortrozs mindig lefel
   1254 TX=de   |* Option -r: Nur count Refreshs machen
   1254 hu      |* Opci -r: Csak count refresh vgrehajtsa
   1255 TX=de   |* Option -p: Prfen, ob die Dateien /proc/*/io existieren
   1255 hu      |* Opci -p: Ellenrzs, hogy a /proc/*/io fjlok lteznek-e
   1256 TX=de   |Diese sind Voraussetzung fr $name
   1256 hu      |Ezek elfelttelek a $name-hez
   1257 TX=de   |Returnwert: 23 wenn die Dateien fehlen, 0 sonst
   1257 hu      |Return rtk: 23, ha a fjlok hinyoznak, 0 egybknt
   1258 TX=de   |Ausgabe:
   1258 hu      |Kiads:
   1259 TX=de   |pid         : Prozessnummer
   1259 hu      |pid         : Folyamatszm
   1260 TX=de   |cancel_write: Geschriebene Bytes, die nicht auf Platte landeten
   1260 hu      |cancel_write: rott byte-ok, amik nem a lemezre mentek
   1261 TX=de   |rchar       : Gelesene Bytes (Cache, Pipes, Sockets...)
   1261 hu      |rchar       : Olvasott byte-ok (cache, pipes, sockets...)
   1262 TX=de   |read_bytes  : Von Platte gelesenen Bytes
   1262 hu      |read_bytes  : Lemezrl olvasott byte-ok
   1263 TX=de   |syscr       : Lesende Systemaufrufe
   1263 hu      |syscr       : Olvas rendszerlehvsok
   1264 TX=de   |syscw       : Schreibende Systemaufrufe
   1264 hu      |syscw       : r rendszerlehvsok
   1265 TX=de   |wchar       : Geschriebene Bytes
   1265 hu      |wchar       : rott byte-ok
   1266 TX=de   |write_bytes : Auf Platte geschriebene Bytes
   1266 hu      |write_bytes : Lemezre rt byte-ok
   1267 TX=de   |cmd         : Programmname
   1267 hu      |cmd         : Program neve
   1268 TX=de   |awk hatte Fehler (rc=$rc)
   1268 hu      |awk $rc hiba sttussal fejezdtt be
   1269 TX=de   |Die Dateien /proc/*/io fehlen. Diese werden fr $name bentigt
   1269 hu      |A /proc/*/io fjlok hinyoznak. Ezek a $name-hez szksgesek
"******** issubdir.sh ********
   1270 TX=de   |$name: Vergleicht zwei Verzeichnisse
   1270 hu      |$name: sszehasonlt kt knyvtrat
   1271 TX=de   |stdout: \"0\" falls dir1 = dir2
   1271 hu      |stdout: \"0\" ha dir1 = dir2
   1272 TX=de   |\"1\" falls dir1 Unterverzeichnis von dir2
   1272 hu      |\"1\" ha dir1 alknyvtra dir2-nek
   1273 TX=de   |\"2\" falls dir2 Unterverzeichnis von dir1
   1273 hu      |\"2\" ha dir2 alknyvtra dir1-nek
   1274 TX=de   |\"\"  sonst
   1274 hu      |\"\"  egybknt
   1275 TX=de   |Kein Verzeichnis: $dir1
   1275 hu      |Nincs knyvtr: $dir1
   1276 TX=de   |Kein Verzeichnis: $dir2
   1276 hu      |Nincs knyvtr: $dir2
"******** jarversion.sh ********
   1277 TX=de   |* Option -f: Verzeichnis oder Datei
   1277 hu      |* Opci -f: Knyvtr vagy fjl
   1278 TX=de   |* Option -t: Trenner
   1278 hu      |* Opci -t: Elvlaszt
   1279 TX=de   |* Option -u: Auch unbekannte Archive auflisten
   1279 hu      |* Opci -u: Ismeretlen archvumok felsorolsa is
   1280 TX=de   |* Option -e: Versionen bekannter externer Bibliotheken auflisten
   1280 hu      |* Opci -e: Ismert kls knyvtrak verziinak felsorolsa
   1281 TX=de   |* Option -c: Ort einer Klasse auffinden
   1281 hu      |* Opci -c: Egy osztly helynek megtallsa
   1282 TX=de   |* Option -j: JFOP-JVM-Parameter nutzen
   1282 hu      |* Opci -j: JFOP JUM paramter hasznlata
   1283 TX=de   |* Option -m: Alle Manifest-Attribute eines JAR-Archivs ausgeben
   1283 hu      |* -m opci: Egy JAR archvum sszes manifest attribtumnak kiadsa
"******** jasper.sh ********
   1284 TX=de   |Keine auszufhrende Funktion angegeben!
   1284 hu      |Nincs megadva vgrehajtand funkci
   1285 TX=de   |Keine Layoutdatei (jrxml) angegeben!
   1285 hu      |Nincs megadva layout fjl (jrxml)!
   1286 TX=de   |Keine Datendatei angegeben!
   1286 hu      |Nincs megadva adatfjl!
"******** javautils.sh ********
   1287 TX=de   |Die geforderte Java-Version ($JAVA_VERSION) konnte nicht gefunden werden, oder die
   1287 hu      |A krt Java verzi ($JAVA_VERSION) nem volt megtallhat, vagy a
   1288 TX=de   |gefundene Version wird explizit nicht untersttzt!
   1288 hu      |tallt verzi nem tmogatott!
   1289 TX=de   |Die Umgebungsvariable JAVAPATH muss richtig gesetzt, oder die geforderte
   1289 hu      |A JAVAPATH krnyezeti vltozt megfelelen el kell helyezni, vagy a krt
   1290 TX=de   |Version muss in der Umgebung (PATH) verfgbar sein (muss auf das Home vom
   1290 hu      |verzinak a krnyezetben (PATH) rendelkezsre kell llnia (a home-ra kell
   1291 TX=de   |jdk/jre zeigen z.B. /usr/lib/java$JAVA_VERSION)
   1291 hu      |mutatnia jdk/jre-rl pl. /usr/lib/java$JAVA_VERSION)
   1292 TX=de   |In homedir.env muss der JAVAPATH auf ein untersttztes Java $JAVA_VERSION gesetzt
   1292 hu      |A homedir.env-ben a JAVAPATH-t egy tmogatott Java $JAVA_VERSION-ra kell
   1293 TX=de   |werden. Wenn homedir.env gendert wird, envmake nicht vergessen!
   1293 hu      |helyezni. Ha a homedir.env mdosul, envmake-et nem elfelejteni!
   1294 TX=de   |Die Java-Version ($full_version) ist nicht erlaubt!
   1294 hu      |Megadott Java-verzi ($full_version) nem megengedett!
"******** jfopserver.sh ********
   1295 TX=de   |* Option -m: Mandant
   1295 hu      |* Opci -m: Mandant
   1296 TX=de   |* Option -n: Servername
   1296 hu      |* Opci -n: szervernv
   1297 TX=de   |* Option -h: Hostname
   1297 hu      |* Opci -h: Hostname
   1298 TX=de   |* Option -p: Port
   1298 hu      |* opci -p: port
   1299 TX=de   |* Option -i: interaktiv
   1299 hu      |* Opci -i: interaktv
   1300 TX=de   |* Option -P: Properties Datei mit Konfiguration
   1300 hu      |* Opci -P: Properties fjl konfigurcival
   1301 TX=de   |* Option -E: Datei mit Umgebungskonfiguration
   1301 hu      |* Opci -E: Fjl krnyezeti konfigurcival
   1302 TX=de   |* Option -I: Abas Installationsnummer
   1302 hu      |* Opci -I: Abas installcis szm
"******** jfopserver_cmds.sh ********
   1303 TX=de   |Datei $CONNECTION_FILE nicht gefunden!
   1303 hu      |$CONNECTION_FILE nem talltam
   1304 TX=de   |Konnte Host nicht bestimmen!
   1304 hu      |Host nem meghatrozhat!
   1305 TX=de   |Konnte Port nicht bestimmen!
   1305 hu      |Port nem meghatrozhat!
"******** jfopserver_kill.sh ********
   1306 TX=de   |* Option -m: Mandantenverzeichnis
   1306 hu      |* Opci -m: Mandant-knyvtr
"******** jfopserver_shutdown.sh ********
   1307 TX=de   |* Option -n: Nur SHUTDOWN senden und nicht warten
   1307 hu      |* Opci -n: Csak SHUTDOWN kldse s nem vrakozni
   1308 TX=de   |* Option -m: Default: Aktuelles Verzeichnis
   1308 hu      |* Opci -m: Default: aktulis knyvtr
   1309 TX=de   |* Option -h: Default: Alle
   1309 hu      |* Opci -h: Default: sszes
   1310 TX=de   |* Option -t: Default: 15 Sekunden
   1310 hu      |* Opci -t: Default: 15 msodperc
"******** jfopserver_utils.sh ********
   1311 TX=de   |tools.jar nicht gefunden
   1311 hu      |tools.jar nem talltam
"******** killclient.sh ********
   1312 TX=de   |* Option -l: alle Clients, die eine Datensatzsperre halten,
   1312 hu      |* -l opci: az sszes kliens, ami rekordzrlattal rendelkezik,
   1313 TX=de   |werden gekillt.
   1313 hu      |lelltsra kerl.
   1314 TX=de   |* Option -n: Client mit Aufrufernummer call_number wird gekillt
   1314 hu      |* Opci -n: A call_number lehvsszm kliens lelltsra kerl
   1315 TX=de   |* Option -s: Nur Ausgabe der Nummern der zu killenden Aufrufer
   1315 hu      |* Opci -s: Csak a lelltand (kill) lehvk szmainak kiadsa
   1316 TX=de   |Nur mit Option -l sinnvoll
   1316 hu      |Csak -l opcival sszer
   1317 TX=de   |Fehler bei $1
   1317 hu      |Hiba a $1-nl
   1318 TX=de   |Aufruf von datanm endete mit Returncode $rc
   1318 hu      |A datanm lehvsa $rc return kddal vgzdtt
   1319 TX=de   |Prozessnummer von datanm kann nicht bestimmt werden
   1319 hu      |datanm folyamatszma nem meghatrozhat
   1320 TX=de   |Befehl datanm $l1_modus nach $l1_maxwait Sekunden nicht beendet
   1320 hu      |datanm $l1_modus parancs $l1_maxwait msodperc utn nincs befejezve
   1321 TX=de   |Siehe $rmdir/datanm.out und $rmdir/datanm.err
   1321 hu      |Lsd $rmdir/datanm.out s $rmdir/datanm.err
   1322 TX=de   |Prozess $l1_datanm_pid gekillt
   1322 hu      |$l1_datanm_pid folyamat lelltva
   1323 TX=de   |Datei $l1_neu_zu_erzeugen nach $l1_maxwait Sekunden nicht vorhanden
   1323 hu      |$l1_neu_zu_erzeugen fjl $l1_maxwait msodperc utn nem ll rendelkezsre
   1324 TX=de   |Aufruf von datanm NUM $l2_aufr endete mit Returncode $rc
   1324 hu      |A datanm NUM $l2_aufr lehvsa $rc return kddal vgzdtt
   1325 TX=de   |Aufrufer $l2_aufr (Prozess $l2_pa_pid) abgemeldet
   1325 hu      |$l2_aufr lehv ($l2_pa_pid folyamat) kijelentkezve
   1326 TX=de   |Keinen Prozess zu Aufrufer $l2_aufr gefunden
   1326 hu      |Nem tallhat folyamat a $l2_aufr lehvhoz
   1327 TX=de   |Nur Aufrufernummern grer 1 erlaubt
   1327 hu      |Csak 1-nl nagyobb lehvszmok megengedettek
   1328 TX=de   |Verzeichnis $client_directory nicht gefunden
   1328 hu      |$client_directory knyvtr nem tallhat
   1329 TX=de   |Datei $d nicht gefunden
   1329 hu      |$d nem talltam
   1330 TX=de   |Fehler bei eval-Aufruf
   1330 hu      |Hiba eval-lehvsnl
   1331 TX=de   |awk endete mit rc=$rc. Siehe $rmdir/awk.err
   1331 hu      |awk rc=$rc-vel vgzdtt. Lsd $rmdir/awk.err
   1332 TX=de   |Zu killende Aufrufer:
   1332 hu      |Lelltand (kill) lehvk:
   1333 TX=de   |Aufrufer $call_number darf nicht abgemeldet werden
   1333 hu      |$call_number lehvnak nem szabad kijelentkeznie
"******** kopier.sh ********
   1334 TX=de   |Textauswahl:
   1334 hu      |Szveg(program) vlaszts:
   1335 TX=de   |Name des Mandanten, in dem sich die Texte befinden:
   1335 hu      |A mandant neve, melyben a szveg(program) megtallhat:
   1336 TX=de   |Name des Textbereichs,
   1336 hu      |A szvegllomny neve,
   1337 TX=de   |in dem sich die Texte befinden:
   1337 hu      |tartalmaz szvegllomny neve :
   1338 TX=de   |Auswahl der zu kopierenden Texte?
   1338 hu      |A msoland szvegek kivlasztsa?
   1339 TX=de   |Alle Texte des Bereichs: $arber
   1339 hu      |Az sszes szveg a kvetkez tartomnybl: $arber
   1340 TX=de   |Auswahl mit Men
   1340 hu      |Kivlaszts men segtsgevel
   1341 TX=de   |Eingabe ber Tastatur
   1341 hu      |Beads billentyzetrl
   1342 TX=de   |Name des Textes in GROSSBUCHSTABEN, der kopiert werden soll :
   1342 hu      |A msoland szveg neve NAGYBETKKEL :
   1343 TX=de   |in den die Texte kopiert werden sollen:
   1343 hu      |ahova a szvegeket msolni kell :
   1344 TX=de   |Zu kopierenden Text nicht gefunden.
   1344 hu      |A msoland szveg nem tallhat.
"******** ktypengen.sh ********
   1345 TX=de   |* Option -s: Mandantenindividuelles Schema fr Startvers
   1345 hu      |* Opci -s: Mandant-egyni sma a startverzihoz
   1346 TX=de   |* Option -z: Mandantenindividuelles Schema fr Zielvers
   1346 hu      |* Opci -z: Mandant-egyni sma a clverzihoz
   1347 TX=de   |* Option -l: aktualisiere Lngendateien
   1347 hu      |* Opci -l: aktualizlt hossz-fjlok
   1348 TX=de   |* Option -m: S3-Schema mit mandantenindividuellen Lngen
   1348 hu      |* Opci -m: S3-sma mandant-egyni hosszokkal
   1349 TX=de   |* Option -v: VKALK_UP = Artikel-VKALK-VARS schenken
   1349 hu      |* Opci -v: VKALK_UP = rucikk VKALK_VARS ajndkozsa
   1350 TX=de   |* Option -k: Erstelle ktypentab
   1350 hu      |* Opci -k: Elksztett ktypentab
   1351 TX=de   |* Option -e: Holezeilen Behandlung in dvartab.dat dfeldtab.dat
   1351 hu      |* Opci -e: lehvs sor kezels ebben: dvartab.dat dfeldtab.dat
   1352 TX=de   |* Option -t: TAZ-Update
   1352 hu      |* Opci -t: TAZ-udate
   1353 TX=de   |* Option -g: GD-Update, gregorianisches Datum
   1353 hu      |* Opci -g: GD-update, Gergely-naptr
   1354 TX=de   |* Option -b: aktualisiere dbaumtab.dat
   1354 hu      |* Opci -b: aktualizlt dbaumtab.dat
   1355 TX=de   |HDIR       : s3-Schema aus HDIR statt HOMEDIR verwenden
   1355 hu      |HDIR       : s3-sma hasznlata a HDIR-bl a HOMEDIR helyett
   1356 TX=de   |kann Verzeichnis $mydir/abasbase nicht anlegen
   1356 hu      |$mydir/abasbase knyvtr nem helyezhet el
   1357 TX=de   |kann Verzeichnis $mydir/$DBDIR_LIB nicht anlegen
   1357 hu      |$mydir/$DBDIR_LIB knyvtr nem helyezhet el
   1358 TX=de   |kann Verzeichnis $mydir/$DBDIR_META nicht anlegen
   1358 hu      |$mydir/$DBDIR_META knyvtr nem helyezhet el
   1359 TX=de   |kann Verzeichnis $mydir/$DBDIR_GEN nicht anlegen
   1359 hu      |$mydir/$DBDIR_GEN knyvtr nem helyezhet el
   1360 TX=de   |kann Verzeichnis $mydir/$DBDIR_DAT nicht anlegen
   1360 hu      |$mydir/$DBDIR_DAT knyvtr nem helyezhet el
   1361 TX=de   |kann Verzeichnis $mydir/$DBDIR_DAZ nicht anlegen
   1361 hu      |$mydir/$DBDIR_DAZ knyvtr nem felvihet
   1362 TX=de   |kopieren von $1 nach $2 gescheitert
   1362 hu      |$1 rl $2 re msols sikertelen
   1363 TX=de   |kopieren mit cat von $1 nach $2 gescheitert
   1363 hu      |msols cat tal $1 rl $2 re sikertelen
   1364 TX=de   |mycd verlangt exakt ein Argument
   1364 hu      |mycd egzakt ignyel egy argumentumot
   1365 TX=de   |`pwd`: Verzeichnis $1 nicht erreichbar
   1365 hu      |`pwd`: $1 knyvtr nem elrhet
   1366 TX=de   |Entweder Option -s oder Option -z erforderlich
   1366 hu      |Vagy az -s opci vagy a -z opci szksges
   1367 TX=de   |STARTVERS=$STARTVERS muss gesetzt sein
   1367 hu      |STARTVERS=$STARTVERS nak elhelyezve kell lennie
   1368 TX=de   |START_DAT=$START_DAT oder ZIEL_DAT=$ZIEL_DAT fehlen der Umgebung
   1368 hu      |START_DAT=$START_DAT vagy ZIEL_DAT=$ZIEL_DAT hinyzik a krnyezetbl
   1369 TX=de   |MLDDIR=$MLDDIR nicht existent
   1369 hu      |MLDDIR=$MLDDIR nem ltezik
   1370 TX=de   |Kann Verzeichnis $rmdir nicht lschen.
   1370 hu      |$rmdir knyvtr nem trlhet.
   1371 TX=de   |Kann Verzeichnis $rmdir nicht anlegen.
   1371 hu      |$rmdir knyvtr nem vihet fel.
   1372 TX=de   |$LAENGEN_VON/sltab fehlt
   1372 hu      |$LAENGEN_VON/sltab hinyzik
   1373 TX=de   |$LAENGEN_VON/schltab fehlt
   1373 hu      |$LAENGEN_VON/schltab hinyzik
   1374 TX=de   |Kann Verzeichnis $SCHEMA_DIR/$DBDIR nicht loeschen
   1374 hu      |$SCHEMA_DIR/$DBDIR knyvtr nem trlhet
   1375 TX=de   |$START_DAT/lib/schltab.vlge fehlt
   1375 hu      |$START_DAT/lib/schltab.vlge hinyzik
   1376 TX=de   |Kann Satzlaengen nicht aktualisieren
   1376 hu      |Ttelhosszsgok nem aktualizlhatk
   1377 TX=de   |Kann Verzeichnis `pwd`/txt nicht anlegen
   1377 hu      |`pwd`/txt knyvtr nem helyezhet el
   1378 TX=de   |$DBDIR_META/schltab.ori ist leer
   1378 hu      |$DBDIR_META/schltab.ori res
   1379 TX=de   |txtmake -a $HDIR gescheitert
   1379 hu      |txtmake -a $HDIR sikertelen
   1380 TX=de   |${HDIR}/msg.vt.dic fehlt
   1380 hu      |Hinyz ${HDIR}/msg.vt.dic
   1381 TX=de   |txtmake -t $HDIR gescheitert
   1381 hu      |txtmake -t $HDIR sikertelen
   1382 TX=de   |txtmake -c $HDIR gescheitert
   1382 hu      |txtmake -c $HDIR sikertelen
   1383 TX=de   |txtmake -l $HDIR gescheitert
   1383 hu      |txtmake -l $HDIR sikertelen
   1384 TX=de   |datlge.dat kann nicht erzeugt werden
   1384 hu      |datlge.dat nem kszthet
   1385 TX=de   |datgrp.dat kann nicht erzeugt werden
   1385 hu      |datgrp.dat nem kszthet
   1386 TX=de   |dattyp.dat kann nicht erzeugt werden
   1386 hu      |dattyp.dat nem ltrehozhat
   1387 TX=de   |tdattab xi gescheitert
   1387 hu      |tdattab xi sikertelen
   1388 TX=de   |nummerieren gescheitert
   1388 hu      |A szmozs nem sikerlt
   1389 TX=de   |msgprep -ur Sprachenupdate msg.ku.dic nicht erfolgreich
   1389 hu      |msgprep -ur nyelv frissts msg.ku.dic nem sikeres
   1390 TX=de   |msgmake -u gescheitert
   1390 hu      |msgmake -u sikertelen
   1391 TX=de   |schemadiff.sh -x gescheitert
   1391 hu      |schemadiff.sh -x sikertelen
   1392 TX=de   |`pwd`/$DBDIR_META/dvartab.ori fehlt
   1392 hu      |`pwd`/$DBDIR_META/dvartab.ori hinyzik
   1393 TX=de   |`pwd`/$DBDIR_META/dfeldtab.ori fehlt
   1393 hu      |`pwd`/$DBDIR_META/dfeldtab.ori hinyzik
   1394 TX=de   |datenart.sh gescheitert
   1394 hu      |datenart.sh sikertelen
   1395 TX=de   |$MDIR zu klein: $DAT_MINFREE kB pro Mandant benoetigt.
   1395 hu      |$MDIR tl kicsi: $DAT_MINFREE kB szksges mandantonknt
   1396 TX=de   |Kann aus dfeldtab.dat `pwd`/$DBDIR_META/ktypentab nicht erzeugen
   1396 hu      |dfeldtab.dat bl nem kszthet `pwd`/$DBDIR_META/ktypentab
   1397 TX=de   |datentab.sh gescheitert
   1397 hu      |datentab.sh sikertelen
"******** laufwerk.sh ********
   1398 TX=de   |Temporres Verzeichnis TMP=$TMP nicht bekannt
   1398 hu      |Ismeretlen ideiglenes knyvtr TMP=$TMP !
   1399 TX=de   |(alle),
   1399 hu      |(Minden),
   1400 TX=de   |(nur Floppys),
   1400 hu      |(csak floppy-k),
   1401 TX=de   |(nur Tapes),
   1401 hu      |(csak szalagok),
   1402 TX=de   |Keine Laufwerke in devices.txt eingetragen
   1402 hu      |Nincsenek bejegyezve meghajtk a devices.txt ben
   1403 TX=de   |Bitte Laufwerk auswhlen.
   1403 hu      |Krem vllasszon meghajtt.
   1404 TX=de   |Laufwerke $DEVTXT     Lokaler Rechner: $me
   1404 hu      |Meghajtk $DEVTXT     Helyi rendszer: $me
   1405 TX=de   |Kein Laufwerk:   $n,  $D
   1405 hu      |Nincs meghajt:  $n,  $D
   1406 TX=de   |Kein Laufwerk:   $n,  $RR: $D
   1406 hu      |Nincs meghajt:  $n,  $RR: $D
   1407 TX=de   |Keine Zugangsberechtigung fr $RR
   1407 hu      |Nincs hozzfrsi jogosultsg $RR szmra
"******** lizinfo.sh ********
   1408 TX=de   |* Option -l: Anzeigen der aktiven Bildschirme
   1408 hu      |* Opci -l: Az aktv kpernyk megjelentse
   1409 TX=de   |* Option -a: Anzeigen der aktiven Bildschirme mit Lizenzinformation
   1409 hu      |* Opci -a: Az aktv kpernyk megjelentse licenc informcival
   1410 TX=de   |* Option -b: Anzeigen der angemeldeten Benutzer
   1410 hu      |* Opci -b: A bejelentkezett felhasznl megjelentse
   1411 TX=de   |(Kriterium ist Zeichen aus Passwortsatz)
   1411 hu      |(Kritrium jel a jelsz ttelbl)
   1412 TX=de   |* Option -L: Anzeigen der Details zu einem Bildschirm
   1412 hu      |* Opci -L: A rszletek megjelentse kpernyhz
   1413 TX=de   |* Option -B: Anzeigen der Details zu einem Benutzerzeichen
   1413 hu      |* Opci -B: A rszletek megjelentse felhasznli jelzshez
   1414 TX=de   |Achtung: Bei Leerzeichen im Benutzerzeichen
   1414 hu      |Figyelem: A felhasznli jelzsben res karakternl
   1415 TX=de   |muss stattdessen \"_\" angegeben werden!
   1415 hu      |ehelyett \"_\" megadsa!
   1416 TX=de   |* Option -t: Spaltentrennzeichen festlegen. Default: Leerzeichen
   1416 hu      |* Opci -t: Oszlop elvlaszt karakterek rgztse. Default: szkzk
   1417 TX=de   |* Option -s: Sortierte Ausgabe der Anwenderliste. Sortierreihenfolge:
   1417 hu      |* Opci -s: A felhasznli lista szortrozott kiadsa. Szortrozsi sorrend:
   1418 TX=de   |Bildschirm, Benutzer und PID
   1418 hu      |kperny, felhasznl s PID
   1419 TX=de   |Batch-Prozesse werden ausgefiltert
   1419 hu      |Batch folyamatok kiszrsre kerlnek
   1420 TX=de   |* Option -u: Sortierte Ausgabe der Anwenderliste. Sortierreihenfolge:
   1420 hu      |* Opci -u: A felhasznli lista szortrozott kiadsa. Szortrozsi sorrend:
   1421 TX=de   |Benutzer, Bildschirm und PID
   1421 hu      |felhasznl, kperny s PID
   1422 TX=de   |Verzeichnis $global_tmp nicht gefunden
   1422 hu      |$global_tmp knyvtr nem tallhat
   1423 TX=de   |Verzeichnis $global_tmp nicht schreibbar
   1423 hu      |$global_tmp knyvtr nem rhat
   1424 TX=de   |Kann Temporrverzeichnis $dmsperrendir fr Bildschirmliste nicht erzeugen
   1424 hu      |Nem lehet ltrehozni ideiglenes knyvtrat a kperny listhoz: $dmsperrendir
   1425 TX=de   |Kann Temporrverzeichnis $dmsperrendir nicht auf ausfhrbar setzen
   1425 hu      |$dmsperrendir ideiglenes knyvtr nem helyezhet vgrehajthatra
   1426 TX=de   |Kann Datei $dmsperren fr Bildschirmliste nicht erzeugen
   1426 hu      |$dmsperren fjl kperny listhoz nem hozhat ltre
   1427 TX=de   |Kann Datei $dmsperren fr Bildschirmliste nicht schreibbar machen
   1427 hu      |$dmsperren fjl kperny listhoz nem tehet rhatv
   1428 TX=de   |Kann Bildschirmliste in Datei $dmsperren nicht erstellen
   1428 hu      |Kperny lista $dmsperren fjlban nem kszthet el
   1429 TX=de   |Kann Bildschirmliste in Datei $dmsperren nicht sortieren
   1429 hu      |Kperny lista $dmsperren fjlban nem szortrozhat
   1430 TX=de   |Das Verzeichnis $rmdir konnte nicht angelegt werden.
   1430 hu      |A $rmdir knyvtrat nem lehetett felvinni.
   1431 TX=de   |Die Rechte am Verzeichnis $rmdir konnten nicht gesetzt werden.
   1431 hu      |A jogokat a $rmdir knyvtrnl nem lehetett belltani.
   1432 TX=de   |HOMEDIR ist nicht gesetzt
   1432 hu      |HOMEDIR nincs elhelyezve
   1433 TX=de   |$HOMEDIR ist kein Verzeichnis
   1433 hu      |$HOMEDIR nem knyvtr
   1434 TX=de   |Kann nicht nach $HOMEDIR wechseln
   1434 hu      |Nem vlthat $HOMEDIR szerint
   1435 TX=de   |Aktion momentan nicht mglich, System ist gesperrt
   1435 hu      |A mvelet nem lehetsges, a rendszer zrolva van
"******** lizinfodlg.sh ********
   1436 TX=de   |Auszuwertende Mandanten auswhlen
   1436 hu      |Kirtkelend mandantok kivlasztsa
   1437 TX=de   |Auswahl mit Leer oder ENTER, weiter mit FERTIG
   1437 hu      |Kivlaszts res-sel vagy ENTER-rel, tovbb KSZ-szel
   1438 TX=de   |Bildschirm \"$1\" ist bereits wieder abgemeldet
   1438 hu      |\"$1\" kperny megint ki van jelentkezve
   1439 TX=de   |Details zu Bildschirm \"$1\"
   1439 hu      |Rszletek \"$1\" kpernyhz
   1440 TX=de   |Mandant ----------- Aufr Zeichen ------- PID -- Standort --------------------
   1440 hu      |Mandant ----------- Felh karakter------- PID -- Telephely --------------------
   1441 TX=de   |Es sind keine Bildschirme angemeldet
   1441 hu      |Nincsenek bejelentkezett kpernyk
   1442 TX=de   |$bstext in Installation $HOMEDIR
   1442 hu      |$bstext $HOMEDIR installciban
   1443 TX=de   |(ENTER: Details)
   1443 hu      |(ENTER: Rszletek)
   1444 TX=de   |Anwender $1 hat sich bereits wieder abgemeldet
   1444 hu      |$1 felhasznl mr megint kijelentkezett
   1445 TX=de   |Details zu Benutzer \"$1\"
   1445 hu      |Rszletek a \"$1\" felhasznlhoz
   1446 TX=de   |Mandant ----------- Aufr Bildschirm -------------- PID -- Standort ----------
   1446 hu      |Mandant ----------- Felh kperny --------------- PID -- Telephely ----------
   1447 TX=de   |Es sind keine Benutzer angemeldet
   1447 hu      |Nem bejelentkezett felhasznlk
   1448 TX=de   |$bentext in Installation $HOMEDIR
   1448 hu      |$bentext $HOMEDIR installciban
   1449 TX=de   |Whlen Sie die Mandanten aus, aus denen die Anzahl lizenzierter
   1449 hu      |Vlassza ki azokat a mandantokat, melyekbl az
   1450 TX=de   |Bildschirmarbeitspltze gelesen werden soll.
   1450 hu      |engedlyezett kperny llomsokat olvassuk.
   1451 TX=de   |Sie mssen fr jeden Mandanten ein gltiges Passwort eingeben!
   1451 hu      |Minden mandanthoz meg kell adnia rvnyes jelszt!
   1452 TX=de   |Eingabe von RETURN bernimmt das zuletzt eingegebene Passwort.
   1452 hu      |A RETURN bevitele tveszi az utoljra bevitt jelszt.
   1453 TX=de   |Mandant: $mand
   1453 hu      |A $mand mandantbl:
   1454 TX=de   |Mandantenverzeichnis $mand  existiert nicht!
   1454 hu      |$mand mandantknyvtr nem ltezik!
   1455 TX=de   |Mandanten-Verzeichnis                   : $mand
   1455 hu      |Mandant-knyvtr                        : $mand
   1456 TX=de   |Bildschirmauskunft fr Abas Installation in $HOMEDIR
   1456 hu      |Kpernyinformci Abas installcihoz $HOMEDIR ben
   1457 TX=de   |$anzuser Benutzer an $anzbs Bildschirm(en)
   1457 hu      |$anzuser felhasznl $anzbs kperny(k) hz
   1458 TX=de   |Gewnschte Funktion whlen
   1458 hu      |Kvnt funkci vlasztsa
   1459 TX=de   |Anzeigen der aktiven Bildschirme
   1459 hu      |Az aktv kpernyk megjelentse
   1460 TX=de   |Anzeigen der aktiven Benutzer an allen Bildschirmen
   1460 hu      |Az aktv felhasznlk megjelentse az sszes kpernyn
   1461 TX=de   |Anzeigen der konfigurierten Lizenzzahl und des Ablaufdatums in den Mandanten
   1461 hu      |A konfigurlt licencszm s a lejrati dtum megjelentse a mandantokban
"******** loaddruckparam.sh ********
   1462 TX=de   |$name: Laden von Standard-Druckparameterdaten
   1462 hu      |$name: Standard nyomtatsi paramter adatok betltse
   1463 TX=de   |HINWEIS: Aufruf ist nur mglich, wenn niemand im Mandanten angemeldet ist!
   1463 hu      |MEGJEGYZS: A lehvs csak akkor lehetsges, ha senki sincs a mandantban bejelentkezve!
   1464 TX=de   |* Option -f oldvers: Ursprungsversion fr den Import
   1464 hu      |* Opci -f oldvers: Eredeti verzi az importhoz
   1465 TX=de   |Default: 0000r0n00
   1465 hu      |Default: 0000r0n00
   1466 TX=de   |* Option -t newvers: Zielversion fr das Update/die Neuanlage
   1466 hu      |* Opci -t newvers: Clverzi a frisstshez/j felvitelhez
   1467 TX=de   |* Option -m: Name(n) der Module die verarbeitet werden sollen
   1467 hu      |* Opci -m: Azoknak a moduloknak a neve(i), amik feldolgozsra kerljenek
   1468 TX=de   |Mehrere Module werden durch ein Komma getrennt
   1468 hu      |Tbb modul vesszvel kerl elvlasztsra
   1469 TX=de   |* Option -l: Auflisten der vorhandenen Module
   1469 hu      |* Opci -l: A rendelkezsre ll modulok felsorolsa
   1470 TX=de   |* Option -e: EDP-Protokollierung in Datei logfile
   1470 hu      |* Opci -e: EDP protokoll bevitelek a logfile fjlba
   1471 TX=de   |$name: Ungltige Option: $1
   1471 hu      |$name: rvnytelen opci: $1
   1472 TX=de   |Anzahl angemeldeter Benutzer: $anzuser
   1472 hu      |Bejelentkezett felhasznlk szma: $anzuser
   1473 TX=de   |Programm luft nur im ALLEIN-Modus.
   1473 hu      |Program csak az egyedl felhasznli mdban fut.
"******** loadinfosys.sh ********
   1474 TX=de   |Daten aktualisieren
   1474 hu      |Adatok aktualizlsa
   1475 TX=de   |Daten entfernen
   1475 hu      |Adatok eltvoltsa
   1476 TX=de   |Daten importieren
   1476 hu      |Adatok importlsa
   1477 TX=de   |Version wechseln
   1477 hu      |Verzivlts
   1478 TX=de   |Bezeichnungen in allen Sprachen aktualisieren
   1478 hu      |Megnevezsek aktualizlsa az sszes nyelven
   1479 TX=de   |Artikelverweise umstellen
   1479 hu      |rucikk utalsok tlltsa
   1480 TX=de   |Druckdatengeneratoren erzeugen
   1480 hu      |Nyomtatsi adatgenertorok ltrehozsa
   1481 TX=de   |Layouts erzeugen
   1481 hu      |Layout-ok ksztse
   1482 TX=de   |Java-Klassen erzeugen
   1482 hu      |Java osztlyok ltrehozsa
   1483 TX=de   |Verwaltet Infosysteme
   1483 hu      |Infosystemeket kezel
   1484 TX=de   |Aktionen, die mit Selektionen einstellbar sind:
   1484 hu      |Mveletek, amik szelekcikkal bellthatk:
   1485 TX=de   |-l: Auflisten (Voreinstellung)
   1485 hu      |-l: kilistzsa (default)
   1486 TX=de   |-e: Veraltet. Stattdessen -a EXPORT verwenden
   1486 hu      |-e: Elavult. Helyette -a EXPORT hasznlata
   1487 TX=de   |-r: Entfernen
   1487 hu      |-r: Eltvolts
   1488 TX=de   |-u: Veraltet. Stattdessen -a UPDATE verwenden
   1488 hu      |-u: Elavult. Helyette -a UPDATE hasznlata
   1489 TX=de   |-a mode: Aktualisieren oder Anpassen
   1489 hu      |-a mode: Aktualizls vagy testreszabs
   1490 TX=de   |IMPORT     = Importieren der Stammdaten (Voreinstellung bei -i)
   1490 hu      |IMPORT     = A trzsadatok importlsa (elzetes bellts -i esetn)
   1491 TX=de   |EXTIMPORT  = Importieren der Stammdaten mitsamt den Anpassungen
   1491 hu      |EXTIMPORT  = A trzsadatok importlsa a testreszabsokkal egytt
   1492 TX=de   |UPDATE     = Aktualisieren der Stammdaten (Voreinstellung bei -u)
   1492 hu      |UPDATE     = A trzsadatok aktualizlsa (elzetes bellts -u-nl)
   1493 TX=de   |EXTUPDATE  = Aktualisieren der Stammdaten mitsamt den Anpassungen
   1493 hu      |EXTUPDATE  = A trzsadatok aktualizlsa a testreszabsokkal egytt
   1494 TX=de   |UPGRADE    = Versionswechsel der Stammdaten
   1494 hu      |UPGRADE    = A trzsadatok verzivltsa
   1495 TX=de   |EXTUPGRADE = Versionswechsel der Stammdaten mitsamt den Anpassungen
   1495 hu      |EXTUPGRADE = A trzsadatok verzivltsa a testreszabsokkal egytt
   1496 TX=de   |STDUPGRADE = Versionswechsel im Lieferumfang
   1496 hu      |STDUPGRADE = Verzivlts az alapcsomagban
   1497 TX=de   |EXPORT     = Export der Stammdaten (Voreinstellung bei -e)
   1497 hu      |EXPORT     = A trzsadatok exportja (elzetes bellts -e esetn)
   1498 TX=de   |EXTEXPORT  = Export der Stammdaten mitsamt den Anpassungen
   1498 hu      |EXTEXPORT  = A trzsadatok exportja a testreszabsokkal egytt
   1499 TX=de   |-i: Veraltet. Stattdessen -a IMPORT verwenden.
   1499 hu      |-i: Elavult. Helyette -a IMPORT hasznlata.
   1500 TX=de   |-g: Druckdatengeneratoren erstellen
   1500 hu      |-g: Nyomtatsi adatgenertorok ksztse
   1501 TX=de   |-j: Erzeugt die Klassen der Java-Schnittstelle
   1501 hu      |-j: Ltrehozza a Java interfsz osztlyait
   1502 TX=de   |-c target: Stellt die Ausgabe von Artikelverweisen im Lieferumfang auf
   1502 hu      |-c target: Elhelyezi az rucikk utalsok kiadst az alapcsomagban
   1503 TX=de   |den Parameter target um.
   1503 hu      |target paramterre lltja t.
   1504 TX=de   |Ohne Selektionsangaben ist stets der Lieferumfang betroffen.
   1504 hu      |Szelekcis megadsok nlkl mindig az alapcsomag rintett.
   1505 TX=de   |Der Parameter target kennt folgende Einstellungen:
   1505 hu      |A target paramter az albbi belltsokat ismeri:
   1506 TX=de   |NUM = Ziel ist Nummernausgabe
   1506 hu      |NUM = Cl a szmkiads
   1507 TX=de   |-x: Schreibt in die Stammdaten die bersetzten Bezeichnungen
   1507 hu      |-x: A lefordtott megnevezseket a trzsadatokba rja
   1508 TX=de   |-o und -j sind verboten
   1508 hu      |-o s -j tilos
   1509 TX=de   |Bei -a STDUPGRADE sind keine Selektionsangaben erlaubt!
   1509 hu      |Az -a STDUPGRADE esetn nem megengedettek szelekcis adatok!
   1510 TX=de   |Fehler beim Selektieren von Infosystemen
   1510 hu      |Hiba az infosystemek szelektlsnl
   1511 TX=de   |Das Aktualisieren der AJO-Schnittstelle ist fehlgeschlagen!
   1511 hu      |Az AJO interfsz aktualizlsa nem sikerlt!
   1512 TX=de   |Es wurden keine passenden Importdateien gefunden
   1512 hu      |Nem voltak tallhatk megfelel importfjlok
   1513 TX=de   |Der Import war fehlerbehaftet
   1513 hu      |Az import hibkat tartalmazott
   1514 TX=de   |Der Versionswechsel der Standardinfosysteme war fehlerbehaftet
   1514 hu      |A standard infosystemek verzivltsa hibs volt
   1515 TX=de   |Der Versionswechsel der Infosysteme war fehlerbehaftet
   1515 hu      |Az infosystemek verzivltsa hibs volt
   1516 TX=de   |Es sind Fehler bei der Aktualisierung der Bezeichungen aufgetreten
   1516 hu      |Hibk lptek fel a megnevezsek aktualizlsnl
   1517 TX=de   |Es sind Fehler bei der Umstellung der Artikelverweise aufgetreten
   1517 hu      |Hibk lptek fel az rucikk utalsok tlltsakor
   1518 TX=de   |Das Erzeugen der Druckdatengeneratoren war fehlerbehaftet
   1518 hu      |A nyomtatsi adatgenertorok ltrehozsa hibs volt
   1519 TX=de   |Das Erzeugen der Layouts war fehlerbehaftet
   1519 hu      |A layoutok ltrehozsa hibs volt
"******** lockana.sh ********
   1520 TX=de   |* Option -p: Personalisiert Sperren in der Sperrtabelle mit dem Bearbeiterzeichen
   1520 hu      |* Opci -p: Megszemlyesti a zrlatokat a zrlattblzatban a feldolgozi azonostval
   1521 TX=de   |* Option -s: PREFIX: In die Dateinamen PREFIX einbauen: LOCK.${PREFIX}...
   1521 hu      |* Opci -s: PREFIX: A fjlnevekbe PREFIX beptse: LOCK.${PREFIX}...
   1522 TX=de   |Fehler bei: datanm SYSINFO > $SYSINFO
   1522 hu      |Hiba a kvetkeznl:datanm SYSINFO > $SYSINFO
   1523 TX=de   |Fehler bei: datanm SHOW $AUFRUFER
   1523 hu      |Hiba a kvetkeznl: datanm SHOW $AUFRUFER
   1524 TX=de   |Fehler bei: datanm SPERREN $SPERREN
   1524 hu      |Hiba a kvetkeznl:datanm SPERREN $SPERREN
   1525 TX=de   |Fehler bei: datanm WARTET $WARTET
   1525 hu      |Hiba a kvetkeznl: datanm WARTET $WARTET
   1526 TX=de   |Fehler bei: datanm KOM $KOMMANDO
   1526 hu      |Hiba kv-nl: datanm KOM $KOMMANDO
   1527 TX=de   |Fehler bei: top -b -n1 > $TOP
   1527 hu      |Hiba a top -b -n1 prepoz-nl > $TOP
"******** logbook_interpret.sh ********
   1528 TX=de   |Datei $inputfile gibt es nicht oder ist nicht lesbar
   1528 hu      |$inputfile fjl nem ltezik vagy nem olvashat
"******** logdb_kleiner_machen.sh ********
   1529 TX=de   |source_directory: Mandantenverzeichnis, das
   1529 hu      |source_directory: Mandantknyvtr, amit
   1530 TX=de   |komprimiert werden soll.
   1530 hu      |komprimlni kell.
   1531 TX=de   |target_directory: Dort landet das komprimierte
   1531 hu      |target_directory: Ott landol a komprimlt
   1532 TX=de   |abasbase/db.dat-Verzeichnis.
   1532 hu      |abasbase/db.dat-knyvtr.
   1533 TX=de   |* Option -s: Mit manuellem Test.
   1533 hu      |* Opci -s: Manulis teszttel.
   1534 TX=de   |Script bricht nach Komprimierung ab
   1534 hu      |Script komprimls utn megszakad
   1535 TX=de   |Rest muss manuell gemacht werden
   1535 hu      |Maradkot manulisan
   1536 TX=de   |(siehe Header des Scripts)
   1536 hu      |(lsd script header)
   1537 TX=de   |Fehler bei bc (Zahl=$z)
   1537 hu      |Hiba a bc-nl (number=$z)
   1538 TX=de   |Fehler bei awk ($rmdir/awk.out)
   1538 hu      |Hiba a awk-nl (($rmdir/awk.out)
   1539 TX=de   |Fehler bei Umwandlung von Zahl $z ($rmdir/awk.out)
   1539 hu      |Hiba az talaktsnl a $z szmbl ($rmdir/awk.out)
   1540 TX=de   |source_directory $SOURCE_DIR ist kein Verzeichnis
   1540 hu      |source_directory $SOURCE_DIR nem knyvtr
   1541 TX=de   |target_directory $TARGET_DIR ist kein Verzeichnis
   1541 hu      |target_directory $TARGET_DIR nem knyvtr
   1542 TX=de   |mandtest.sh lieferte Returnwert $rc
   1542 hu      |mandtest.sh szlltott returnrtk $rc
   1543 TX=de   |In $SOURCE_DIR fehlt denv.dat oder denv.sh
   1543 hu      |$SOURCE_DIR-ben hinyzik denv.dat vagy denv.sh
   1544 TX=de   |envmake -D . in $SOURCE_DIR muss aufgerufen werden
   1544 hu      |El kell indtani kv-t: envmake -D . in $SOURCE_DIR
   1545 TX=de   |Programm $vers_prog nicht gefunden
   1545 hu      |$vers_prog: Program nem tallhat
   1546 TX=de   |Version aus $vers_prog nicht bestimmbar
   1546 hu      |Verzi $vers_prog-bl nem meghatrozhat
   1547 TX=de   |Unterverzeichnis $UNTER_VERZ konnte nicht angelegt werden
   1547 hu      |$UNTER_VERZ alknyvtrat nem lehetett felvinni
   1548 TX=de   |Unterverzeichnis $UNTER_VERZ konnte nicht geleert werden
   1548 hu      |$UNTER_VERZ alknyvtrat nem lehetett kirteni
   1549 TX=de   |Unterverzeichnis $dir konnte nicht angelegt werden
   1549 hu      |$dir alknyvtrat nem lehetett felvinni
   1550 TX=de   |Start der Komprimierung
   1550 hu      |Komprimls indtsa
   1551 TX=de   |Programm $prog erzeugte keine Returncode-Datei $rmdir/$prog.rc
   1551 hu      |$prog program nem ksztett $rmdir/$prog.rc returncode-fjlt
   1552 TX=de   |Programm $prog endete mit Returncode $rc. Siehe $rmdir/$prog.err
   1552 hu      |$prog program $rc returncode-dal vgzdtt. Lsd $rmdir/$prog.err
   1553 TX=de   |Komprimierung beendet. Datenbank befindet sich in $UNTER_VERZ/$DBDIR
   1553 hu      |Komprimls befejezdtt. Az adatbank a $UNTER_VERZ/$DBDIR-ben tallhat
   1554 TX=de   |Mandant $SOURCE_DIR ist aktiv.
   1554 hu      |$SOURCE_DIR mandant aktv.
   1555 TX=de   |Komprimierte Datenbankdateien in $UNTERVERZ/$DBDIR
   1555 hu      |Komprimlt adatbank-fjlok a $UNTERVERZ/$DBDIR-ben
   1556 TX=de   |In $SOURCE_DIR wurde nichts geaendert
   1556 hu      |A $SOURCE_DIR-ben semmi sem mdosult
   1557 TX=de   |$SOURCE_DIR/$DBDIR/ekslogdb* wird removed
   1557 hu      |$SOURCE_DIR/$DBDIR/ekslogdb* thelyezsre kerl
   1558 TX=de   |Datenbankdateien werden von $UNTER_VERZ/$DBDIR nach $SOURCE_DIR/$DBDIR gemoved
   1558 hu      |Adatbank-fjlok a $UNTER_VERZ/$DBDIR-bl a $SOURCE_DIR/$DBDIR-be kerlnek
   1559 TX=de   |Verzeichnis $DBDIR wird nach $DBDIR.sav gemoved
   1559 hu      |$DBDIR knyvtr a $DBDIR.sav-ba kerl
   1560 TX=de   |Totalbereinigung
   1560 hu      |Teljes tisztts
   1561 TX=de   |Mandant $SOURCE_DIR kann getestet werden
   1561 hu      |$SOURCE_DIR mandant tesztelhet
   1562 TX=de   |Folgende Schritte muessen nach ERFOLGREICHEM Test gemacht werden
   1562 hu      |A kvetkez lpseket kell megtenni SIKERES teszt utn
   1563 TX=de   |Bei NICHT erfolgreichem Test wird der Mandant wieder betriebsbereit mit:
   1563 hu      |SIKERTELEN teszt utn a mandant a kv-vel lesz ismt zemksz:
   1564 TX=de   |Komprimierung erfolgreich beendet
   1564 hu      |Komprimls sikeresen befejezdtt
"******** loglevel29.sh ********
   1565 TX=de   |Filtert den letzten Eintrag mit level=29 und die Aufruferkette aus dem Kommandologbuch.
   1565 hu      |Kiszri az utols bevitelt a level=29-cel s a lehv lncot a parancsnaplbl.
   1566 TX=de   |* Option -w: Wartungslogbuch verwenden
   1566 hu      |* Opci -w: Karbantartsi napl hasznlata
"******** mailit.sh ********
   1567 TX=de   |Signatur-Datei: \"$signaturefile\"  ->Lesen von stdin noch nicht implementiert!
   1567 hu      |Alrsfjl: \"$signaturefile\"  ->Az stdin olvassa mg nincs implementlva!
   1568 TX=de   |Signature-Datei muss existieren: $signaturefile
   1568 hu      |Az alrsfjlnak lteznie kell: $signaturefile
   1569 TX=de   |Zu versendende Datei: \"$sendfile\"  ->Lesen von stdin noch nicht implementiert!
   1569 hu      |A kldend fjlhoz: \"$sendfile\" ->stdin olvassa mg nincs bevezetve!
   1570 TX=de   |Zu versendende Datei muss existieren: $sendfile
   1570 hu      |A kldend fjlhoz lteznie kell:  $sendfile
"******** makeguitgz.sh ********
   1571 TX=de   |erstellt ein Archiv mit den GUI-Dateien, die lokal installiert werden knnen
   1571 hu      |Kszt egy archvumot azokkal a GUI fjlokkal, amik helyileg installlhatk
   1572 TX=de   |<mandantdir>: Mandantenverzeichnis
   1572 hu      |<mandantdir>: Mandantknyvtr
   1573 TX=de   |default: aktuelles Verzeichnis
   1573 hu      |default: aktulis knyvtr
   1574 TX=de   |Verzeichnis $mandant existiert nicht
   1574 hu      |$mandant knyvtr nem ltezik
   1575 TX=de   |Verzeichnis $mandant/win existiert nicht
   1575 hu      |$mandant/win knyvtr nem ltezik
   1576 TX=de   |Verzeichnis $archivdir kann nicht angelegt werden
   1576 hu      |$archivdir knyvtr nem helyezhet el
   1577 TX=de   |Fehler beim Bestimmen der GUI-Programmdateien
   1577 hu      |Hiba a GUI-programfjlok meghatrozsnl
   1578 TX=de   |Verzeichnis $mytmpdir kann nicht angelegt werden
   1578 hu      |$mytmpdir knyvtr nem helyezhet el
   1579 TX=de   |$mandant/win/$arg: Datei/Verzeichnis nicht gefunden
   1579 hu      |$mandant/win/$arg: fjl/knyvtr nem tallhat
   1580 TX=de   |Datei $archiv kann nicht erstellt werden
   1580 hu      |$archiv fjl nem kszthet el
   1581 TX=de   |Datei $archiv erstellt
   1581 hu      |$archiv fjl elksztve
"******** makesymlinks.sh ********
   1582 TX=de   |Link $link nicht angelegt!
   1582 hu      |$link link nem kerlt felvitelre!
"******** mandcopy.sh ********
   1583 TX=de   |Problem beim Entsperren des Quellmandanten!
   1583 hu      |Problma a forrsmandant zrlatnak feloldsakor!
   1584 TX=de   |Problem beim Entsperren des Zielmandanten!
   1584 hu      |Problma a clmandant zrlatnak feloldsakor!
   1585 TX=de   |Fehler $l14_rc beim Auslesen der Daten von Mandant $vondir
   1585 hu      |Hiba $l14_rc az adatok $vondir mandantbl val kiolvassakor
   1586 TX=de   |Datei $datei nicht gefunden!
   1586 hu      |$datei nem talltam
   1587 TX=de   |Schreibrechte von $datei konnten nicht entfernt werden
   1587 hu      |A $datei rsos jogosultsgait nem lehetett eltvoltani
   1588 TX=de   |Daher wird $datei kopiert statt gelinkt
   1588 hu      |Ezrt $datei msolsra kerl linkels helyett
   1589 TX=de   |Fehler beim Ermitteln der Standarddateien (Buchstaben U, I)
   1589 hu      |Hibk a standard fjlok kzlsnl (betk U, I)
   1590 TX=de   |Fehler beim Ermitteln der Standarddateien (Buchstaben F)
   1590 hu      |Hibk a standard fjlok kzlsnl (betk F)
   1591 TX=de   |Fehler bei $glob_rcp_aufruf $src $target
   1591 hu      |Hiba a $glob_rcp_aufruf $src $target-nl
   1592 TX=de   |Fehler $rc bei find $*
   1592 hu      |Hiba: $rc find $*-nl
   1593 TX=de   |In Fehlermeldung erwhnte Datei/Verzeichnis wird nicht kopiert
   1593 hu      |A hibazenetben megemltett fjl/knyvtr nem kerl msolsra
   1594 TX=de   |Kopieren wird fortgesetzt
   1594 hu      |Msols folytatdik
   1595 TX=de   |Kann Zielmandant nicht entsperren
   1595 hu      |A clmandant nem vehet ki a zrlat all
   1596 TX=de   |Kommando $cp_cmd -r $vondir $nachdir schrieb Fehlermeldungen
   1596 hu      |A $cp_cmd -r $vondir $nachdir parancs hibazeneteket rt
   1597 TX=de   |Datei $rmdir/lokal_cp.err:
   1597 hu      |llomny $rmdir/lokal_cp.err:
   1598 TX=de   |Prfen Sie die betroffenen Dateien im Quellmandanten $vondir
   1598 hu      |Ellenrizze az rintett fjlokat a $vondir forrsmandantban
   1599 TX=de   |Fehlen diese Dateien im Quellmandanten, wurden sie whrend des Kopiervorgangs gelscht
   1599 hu      |Ha ezek a fjlok hinyoznak a forrsmandantban, akkor a msolsi folyamat alatt trlsre kerltek
   1600 TX=de   |Dadurch wird die Funktionsfhigkeit des Zielmandanten im Allgemeinen nicht beeintrchtigt
   1600 hu      |Ezltal a clmandant mkdkpessge ltalban nem kerl akadlyozsra
   1601 TX=de   |Die Liste aller erfolgreich kopierten Dateien liegt in Datei $rmdir/lokal_cp.out
   1601 hu      |Az sszes sikeresen msolt fjl listja a $rmdir/lokal_cp.out fjlban van
   1602 TX=de   |ACHTUNG: Fehler beim Lesen des Quellmandanten
   1602 hu      |FIGYELEM: Hiba a forrsmandant olvassnl
   1603 TX=de   |Der Zielmandant kann aber eventuell dennoch korrekt sein.
   1603 hu      |A clmandant azonban esetleg mgis korrekt lehet.
   1604 TX=de   |Bitte testen Sie im Anschluss den Zielmandanten.
   1604 hu      |Krem tesztelje utna a clmandantot!
   1605 TX=de   |Kann $vondir nicht nach $nachdir kopieren
   1605 hu      |$vondir nem msolhat $nachdir szerint
   1606 TX=de   |Kann beizubehaltende Dateien nicht in Zielmandant kopieren:
   1606 hu      |Megtartand fjlok nem msolhatk a clmandantba:
   1607 TX=de   |Probleme beim Neukonfigurieren der GUI-Dateien, siehe $l10_guierr
   1607 hu      |Problmk a GUI-llomnyok jra konfig-nl, lsd $l10_guierr
   1608 TX=de   |* Option -?: usage  : Diesen Text ausgeben
   1608 hu      |* -? opci: usage(hasznlat): ennek a szvegnek a kiadsa
   1609 TX=de   |* Option -d: debug  : Alle Befehle ausgeben
   1609 hu      |* -d opci: debug(hibakeress): az sszes utasts kiadsa
   1610 TX=de   |* Option -s: source : zu kopierender Mandant (Quellmandant)
   1610 hu      |* -s opci: source(forrs): a msoland mandant
   1611 TX=de   |* Option -t: target :
   1611 hu      |* -t opci: target(cl):
   1612 TX=de   |falls Quell- und Zielmandant im selben HOMEDIR:
   1612 hu      |Ha a forrs- s clmandant ugyanabban a HOMEDIR-ben van:
   1613 TX=de   |target = Name oder Verzeichnis des Zielmandanten
   1613 hu      |target = A clmandant neve vagy knyvtra
   1614 TX=de   |sonst
   1614 hu      |egybknt
   1615 TX=de   |target = Verzeichnis des Zielmandanten.
   1615 hu      |target = A clmandant knyvtra
   1616 TX=de   |Das HOMEDIR des Zielmandanten muss mit Option -h angegeben
   1616 hu      |A clmandant HOMEDIR-jt a -h opcival kell megadni
   1617 TX=de   |werden.
   1617 hu      |.
   1618 TX=de   |Bei Betriebssystemen ungleich Windows kann mit host:pfad
   1618 hu      |A nem Windows opercis rendszer a host:pfad -dal
   1619 TX=de   |auch ein Verzeichnis auf anderem Rechner angegeben werden.
   1619 hu      |hasznlatval megadhat egy knyvtr egy msik munkallomson.
   1620 TX=de   |Kopierkommando ($default_rcp_aufruf) und
   1620 hu      |Msolsi parancs ($default_rcp_aufruf) s
   1621 TX=de   |Zugangskommando ($default_rsh_aufruf)
   1621 hu      |hozzfrsi parancs ($default_rsh_aufruf)
   1622 TX=de   |zu einem anderen Rechner sind durch die Umgebungsvariablen
   1622 hu      |egy msik szmtgphez az S3_RCP s S3_RSH krnyezeti
   1623 TX=de   |S3_RCP und S3_RSH einstellbar.
   1623 hu      |vltozkon keresztl bellthatk.
   1624 TX=de   |* Option -a: Umfang : DB|STDFOP|ALL|CF|ALLMOD
   1624 hu      |* Opci -a: Mret:  DB|STDFOP|ALL|CF|ALLMOD
   1625 TX=de   |DB     : Datenbank
   1625 hu      |DB     : Adatbank
   1626 TX=de   |STDFOP : Standard-FOPs
   1626 hu      |STDFOP : standard FOP-ok
   1627 TX=de   |ALL    : Komplettes Mandantenverzeichnis
   1627 hu      |ALL    : Komplett mandant-knyvtr
   1628 TX=de   |ALLMOD : Komplettes Mandantenverzeichnis plus Installation der
   1628 hu      |ALLMOD : Komplett mandantknyvtr plusz a modulok
   1629 TX=de   |Module und Erzeugen der Scripte der Systemdienste
   1629 hu      |installcija s a rendszer szolgltatsok scriptjeinek ltrehozsa
   1630 TX=de   |CF     : Wie ALL, aber nur die Datenbankdateien kopieren, die in
   1630 hu      |CF     : Ugyanaz, mint az ALL, de csak azoknak az adatbzis fjloknak a msolsa, amik
   1631 TX=de   |Import- oder Exportkonfiguration conf_name (Option -n) vorkommen.
   1631 hu      |a conf_name (-n opci) import vagy export konfigurciban fordulnak el.
   1632 TX=de   |* Option -n: Konfiguration : Nur bei Umfang CF. Name der Import- oder
   1632 hu      |* Opci -n: Konfigurci: Csak CF terjedelemnl. Az import vagy export
   1633 TX=de   |Exportkonfiguration deren Datenbankdateien kopiert werden sollen.
   1633 hu      |konfigurci neve, aminek az adatbzis fjljai msolsra kerljenek.
   1634 TX=de   |* Option -p: Passwort : Nur bei Umfang CF. Passwort fr den
   1634 hu      |* Opci -p: Jelsz: Csak CF terjedelemnl. Jelsz a
   1635 TX=de   |Quellmandanten um Konfigurationsdaten auszulesen.
   1635 hu      |forrsmandanthoz a konfigurcis adatok kiolvasshoz.
   1636 TX=de   |* Option -y: tmpdir : Nur bei Umfang CF. Verzeichnis in das
   1636 hu      |* Opci -y: tmpdir : Csak CF terjedelemnl. Knyvtr amibe
   1637 TX=de   |vorbergehend der Inhalt der in der Konfiguration enthaltenen
   1637 hu      |tmenetileg a konfigurciban tartalmazott adatbzis fjlok
   1638 TX=de   |Datenbankdateien geschrieben wird (auf ausreichenden freien
   1638 hu      |tartalma rsra kerl (az elegend szabad lemezhelyre
   1639 TX=de   |Plattenplatz achten!); existiert das Verzeichnis nicht, wird es
   1639 hu      |figyelni!); ha a knyvtr nem ltezik, akkor felvitelre
   1640 TX=de   |angelegt.
   1640 hu      |kerl.
   1641 TX=de   |* Option -w: wait   : Max. Wartezeit beim Sperren des Quellmandanten
   1641 hu      |* Opci -w: wait    : Max. vrakozsi id a forrsmandant zrolsakor
   1642 TX=de   |* Option -u:          Unterbrechungssperre statt Sichern-Sperre im
   1642 hu      |* Opci -u:           Megszaktsi zr im biztonsgi zr helyett
   1643 TX=de   |Quellmandanten setzen
   1643 hu      |Forrsmandant belltsa
   1644 TX=de   |* Option -i:          Install.sperre ignorieren und auch nicht setzen
   1644 hu      |* Opci -i:           Install. zrlat ignorlsa, be se lltsa
   1645 TX=de   |* Option -c:          Datenbankdateien stets kopieren statt hart linken
   1645 hu      |* Opci -c:           Adatbzis fjlok msolsa hard linkels helyett
   1646 TX=de   |* Option -h: target_homedir: HOMEDIR (ohne Hostnamen) des Zielmandanten,
   1646 hu      |* Opci -h: target_homedir: A clmandant HOMEDIR-je (host name nlkl),
   1647 TX=de   |falls abweichend vom Quellmandanten
   1647 hu      |ha eltr a forrsmandanttl
   1648 TX=de   |Eine Voraussetzung fr das Linken der Datenbankdateien ist (wahrscheinlich temporr) nicht erfllt:
   1648 hu      |Elfelttel az adatbzis-fjlok linkelshez (valsznleg ideiglenesen) nem teljeslt:
   1649 TX=de   |Zustand von Log1 erlaubt kein Linken der Datenbankdateien
   1649 hu      |Log1 llapota nem engedlyezi az adatbzis fjlok linkeldst
   1650 TX=de   |Letzte zu linkende Log$i-Datei ($dat) existiert nicht
   1650 hu      |Az utols linkelend Log$i fjl ($dat) nem ltezik
   1651 TX=de   |Quellversion nicht bestimmbar
   1651 hu      |Forrsverzi nem meghatrozhat
   1652 TX=de   |Zielversion nicht bestimmbar
   1652 hu      |Clverzi nem meghatrozhat
   1653 TX=de   |Quellversion = $quellversion ungleich Zielversion = $zielversion
   1653 hu      |Forrsverzi = $quellversion nem azonos a clverzival = $zielversion
   1654 TX=de   |Sprachen im Zielmandant konnten nicht bestimmt werden
   1654 hu      |Nyelveket a clmandantban nem lehetett meghatrozni
   1655 TX=de   |Im Zielmandanten wird fehlende Sprache $l9_spr installiert
   1655 hu      |A clmandantban a hinyz $l9_spr nyelv installlsra kerl
   1656 TX=de   |denv.dat oder denv.sh fehlen in $nachdir
   1656 hu      |denv.dat vagy denv.sh hinyzik a $nachdir-ben
   1657 TX=de   |Fehler: Returncode $l12_rc bei eval sh ./denv.sh (pwd=$nachdir)
   1657 hu      |Hiba: $l12_rc return code eval sh ./denv.sh-nl (pwd=$nachdir)
   1658 TX=de   |Datei $l6_dat fehlt
   1658 hu      |$l6_dat hinyzik
   1659 TX=de   |Kann Zielmandantenverzeichnis $nachdir nicht lschen
   1659 hu      |$nachdir clmandant knyvtr nem trlhet
   1660 TX=de   |Fehler $l13_rc bei $l13_cmd
   1660 hu      |Hiba $l13_rc $l13_cmd-nl
   1661 TX=de   |Konfiguration $konf_name nicht gefunden
   1661 hu      |$konf_name konfigurci nem tallhat
   1662 TX=de   |Kann Umgebung nicht bauen(rc=$l11_rc) - Mandant $nachname in Benutzung?
   1662 hu      |Krnyezetet nem kpes felpteni(rc=$l11_rc) - $nachname mandant hasznlatban?
   1663 TX=de   |Hinweis: Schreiberlaubnis fr Zielverzeichnis $target/$l19_d konnte nicht gesetzt werden
   1663 hu      |Megjegyzs: rs engedlyt a $target/$l19_d clknyvtrhoz nem lehetett elhelyezni
   1664 TX=de   |Wenn im folgenden keine Fehler auftreten, kann dieser Hinweis ignoriert werden
   1664 hu      |Ha a kvetkezkben nem lp fel hiba, akkor ez a megjegyzs figyelmen kvl hagyhat
   1665 TX=de   |Hinweis: Schreiberlaubnis fr Zielverzeichnis $target/$l20_d konnte nicht aufgehoben werden
   1665 hu      |Megjegyzs: rs engedlyt a $target/$l20_d clknyvtrhoz nem lehetett megszntetni
   1666 TX=de   |Falsches Argument zu Option a: $umfang
   1666 hu      |Rossz argumentum az a opcihoz: $umfang
   1667 TX=de   |Quellmandant fehlt
   1667 hu      |Hinyz forrsmandant
   1668 TX=de   |Zielmandant fehlt
   1668 hu      |Hinyz clmandant
   1669 TX=de   |Kopierumfang fehlt
   1669 hu      |Hinyz msolsi terjedelem
   1670 TX=de   |Zu Zielmandant auf Rechner $target_host fehlt HOMEDIR (Option -h)
   1670 hu      |A clmandanthoz a $target_host munkallomson hinyzik a HOMEDIR (-h opci)
   1671 TX=de   |Bei Kopierumfang CF mssen Optionen -n, -p, und -y angegeben werden
   1671 hu      |A CF msolsi terjedelemnl meg kell adni az -n, -p s -y opcikat
   1672 TX=de   |MNAME von $source kann nicht ermittelt werden
   1672 hu      |$source MNAME ja nem hatrozhat meg
   1673 TX=de   |MANDANTDIR von $source kann nicht ermittelt werden
   1673 hu      |$source MANDANTDIR ja nem hatrozhat meg
   1674 TX=de   |Falscher Quellmandant
   1674 hu      |Rossz forrsmandant
   1675 TX=de   |Zielarchitektur von $target_host:$target_homedir nicht bestimmbar
   1675 hu      |A $target_host:$target_homedir clarchitektrja nem meghatrozhat
   1676 TX=de   |Kann weder Mandantenname noch -verzeichnis zu target=$target bestimmen
   1676 hu      |Nem meghatrozhat sem mandantnv, sem mandantknyvtr a target=$target-hez
   1677 TX=de   |Kann Zielverzeichnis zu Mandantenname $nachname nicht bestimmen
   1677 hu      |Nem meghatrozhat clknyvtr a $nachname mandantnvhez
   1678 TX=de   |Zielmandant $nachdir ist nicht schreibbar
   1678 hu      |$nachdir clmandant nem rhat
   1679 TX=de   |Kann Mandantenname zu Zielverzeichnis $nachdir nicht bestimmen
   1679 hu      |Nem meghatrozhat mandantnv a $nachdir clknyvtrhoz
   1680 TX=de   |Zielmandant darf nicht berschrieben werden!
   1680 hu      |A clmandantot nem szabad fellrni!
   1681 TX=de   |Kann Mandant nicht sperren, da System nicht betriebsbereit
   1681 hu      |Nem zrolhat mandant, mivel a rendszer nem zemksz
   1682 TX=de   |Mandant $nachname konnte nicht gesperrt werden
   1682 hu      |$nachname mandantot nem lehetett zrolni
   1683 TX=de   |Datenbankdateien werden nun kopiert statt gelinkt
   1683 hu      |Adatbzis fjlok most msolsra kerlnek linkels helyett
   1684 TX=de   |Script kann mit der Interrupt Taste abgebrochen werden
   1684 hu      |A script a megszakts billentyvel megszakthat
   1685 TX=de   |Mandant $vondir konnte nicht gesperrt werden
   1685 hu      |$vondir mandantot nem lehetett zrolni
   1686 TX=de   |Eben lief eine Garbage Collection ($gen) ($seg_vorher -> $seg_nachher)
   1686 hu      |ppen futott egy Garbage Collection ($gen) ($seg_vorher -> $seg_nachher)
   1687 TX=de   |Problem beim Freigeben der Installationssperre
   1687 hu      |Problma az installcis zrlat feloldsnl
   1688 TX=de   |Es wird kopiert ...
   1688 hu      |Msolsra kerl ...
   1689 TX=de   |Fehler: falsche Auswahl zu kopierender Dateien ($umfang)
   1689 hu      |Hiba: msoland fjlok rossz kivlasztsa ($umfang)
   1690 TX=de   |Kopiervorgang erfolgreich
   1690 hu      |A msols sikerlt
"******** mandcopydlg.sh ********
   1691 TX=de   |* Option -?: usage:   Diesen Text ausgeben
   1691 hu      |* -? opci:  usage(hasznlat): ennek a szvegnek a kiadsa
   1692 TX=de   |* Option -d: debug:   Alle Befehle ausgeben
   1692 hu      |* -d opci: debug(hibakeress): az sszes utasts kiadsa
   1693 TX=de   |formatiere_ausgabe: Zu kleine Anzahl Parameter, $# statt $l1_min_anz_param
   1693 hu      |formatiere_ausgabe: tl kevs paramter, $# $l1_min_anz_param helyett
   1694 TX=de   |$l3_ziel_homedir existiert, ist aber kein Verzeichnis
   1694 hu      |$l3_ziel_homedir ltezik, azonban nem knyvtr
   1695 TX=de   |$l3_ziel_homedir ist kein absoluter Pfad
   1695 hu      |$l3_ziel_homedir nem abszolt elrsi tvonal
   1696 TX=de   |$l2_nachdir existiert, ist aber kein Verzeichnis
   1696 hu      |$l2_nachdir ltezik, de nem knyvtr
   1697 TX=de   |Kann Verzeichnisse nicht prfen
   1697 hu      |Knyvtrak nem ellenrizhetk
   1698 TX=de   |Fehler: Quellmandant = Zielmandant
   1698 hu      |Hiba: forrsmandant = clmandant
   1699 TX=de   |Fehler: Der Quellmandant ist ein Unterverzeichnis des Zielmandants
   1699 hu      |Hiba: A forrsmandant a clmandant alknyvtra
   1700 TX=de   |Fehler: Der Zielmandant ist ein Unterverzeichnis des Quellmandants
   1700 hu      |Hiba: A clmandant a forrsmandant alknyvtra
   1701 TX=de   |Rechner $l4_ziel_host ist nicht erreichbar
   1701 hu      |$l4_ziel_host szmtgp nem elrhet
   1702 TX=de   |$l6_nachdir ist kein absoluter Pfad
   1702 hu      |$l6_nachdir nem abszolt elrsi tvonal
   1703 TX=de   |Prfung von $rsh_text und/oder $rcp_text zu Rechner $ziel_host fehlgeschlagen:
   1703 hu      |A $rsh_text s/vagy $rcp_text ellenrzse a $ziel_host szmtgphez nem sikerlt:
   1704 TX=de   |(Errordatei $rmdir/${errdat}.err)
   1704 hu      |(Error fjl $rmdir/${errdat}.err)
   1705 TX=de   |$l8_ziel_homedir ist kein absoluter Pfad
   1705 hu      |$l8_ziel_homedir nem abszolt elrsi tvonal
   1706 TX=de   |$l8_ziel_homedir ist kein Verzeichnis auf Rechner $ziel_host
   1706 hu      |$l8_ziel_homedir nem knyvtr a $ziel_host szmtgpen
   1707 TX=de   |jn-Test: $1 (j/n)
   1707 hu      |in teszt: $1 (i/n)
   1708 TX=de   |Nur als root ausfhrbar
   1708 hu      |Csak root-knt hajthat vgre.
   1709 TX=de   |Kopieren von Mandanten
   1709 hu      |Mandantok msolsa
   1710 TX=de   |Achtung: Der zu kopierende Mandant (Quellmandant) sowie der Mandant,
   1710 hu      |Figyelem: a msoland mandant (forrs mandant) valamint a mandant,
   1711 TX=de   |in den kopiert werden soll (Zielmandant) mssen in der Datei
   1711 hu      |amelyikbe t kell msolni (cl-mandant), be kell legyenek
   1712 TX=de   |$HOMEDIR/mandantdir.env eingetragen sein!
   1712 hu      |jegyezve a $HOMEDIR/mandantdir.env fjlba!
   1713 TX=de   |Falls der Zielmandant in einem anderen HOMEDIR liegt, muss er
   1713 hu      |Ha a cl mandant egy msik HOMEDIR-ben van, akkor ott
   1714 TX=de   |dort in mandantdir.env eingetragen sein.
   1714 hu      |berva kell lennie a mandantdir.env-ben.
   1715 TX=de   |Weitermachen?
   1715 hu      |Tovbb?
   1716 TX=de   |Es wurde kein zweiter Mandant gefunden
   1716 hu      |Nem volt tallhat msodik mandant
   1717 TX=de   |Bitte Zielmandanten in $HOMEDIR/mandantdir.env eintragen
   1717 hu      |Jegyezze be a clmandantot a $HOMEDIR/mandantdir.env-be
   1718 TX=de   |Quellmandant auswhlen
   1718 hu      |Forrsmandant kivlasztsa
   1719 TX=de   |mandwahl.sh gescheitert
   1719 hu      |mandwahl.sh sikertelen
   1720 TX=de   |Kein Verzeichnis: $vondir
   1720 hu      |Nincs knyvtr: $vondir
   1721 TX=de   |Zielmandant auswhlen
   1721 hu      |Clmandant kivlasztsa
   1722 TX=de   |Quellmandant:
   1722 hu      |Forrsmandant:
   1723 TX=de   |Befinden sich Quellmandant und Zielmandant im
   1723 hu      |A forrsmandant s clmandant ugyanabban az
   1724 TX=de   |selben s3-Bereich ($HOMEDIR)?
   1724 hu      |s3 tartomnyban ($HOMEDIR) tallhatk?
   1725 TX=de   |Geben Sie den s3-Bereich des Zielmandanten
   1725 hu      |Adja meg a clmandant s3 tartomnyt
   1726 TX=de   |als absoluten Pfad an:
   1726 hu      |abszolt elrsi tvonalknt:
   1727 TX=de   |Befinden sich Quellmandant und Zielmandant auf
   1727 hu      |A forrsmandant s clmandant ugyanazon a
   1728 TX=de   |demselben Rechner ($quell_host)?
   1728 hu      |szmtgpen tallhatk ($quell_host)?
   1729 TX=de   |Geben Sie den Rechnernamen des Zielmandanten an:
   1729 hu      |Adja meg a clmandant szmtgp nevt:
   1730 TX=de   |Das Zugangskommando $subst_rsh_cmd $subst_ziel_host zu Rechner $subst_ziel_host
   1730 hu      |A $subst_rsh_cmd $subst_ziel_host hozzfrsi parancs a $subst_ziel_host szmtgphez
   1731 TX=de   |darf keine Passwortabfrage oder andere Benutzereingaben verlangen und
   1731 hu      |nem krhet jelsz lekrdezst vagy ms felhasznli bevitelt s
   1732 TX=de   |kann durch die Umgebungsvariable S3_RSH gesetzt werden.
   1732 hu      |az S3_RSH krnyezeti vltozn keresztl helyezhet el.
   1733 TX=de   |Soll statt Zugangskommando $subst_rsh_cmd ein anderes
   1733 hu      |A $subst_rsh_cmd hozzfrsi parancs helyett egy msik
   1734 TX=de   |Zugangskommando zu Zielrechner $subst_ziel_host verwendet werden?
   1734 hu      |hozzfrsi parancs kerljn hasznlatra a $subst_ziel_host clszmtgphez?
   1735 TX=de   |Das Kopierkommando $subst_rcp_cmd zu Rechner $subst_ziel_host darf
   1735 hu      |A $subst_rcp_cmd msolsi parancs a $subst_ziel_host szmtgphez
   1736 TX=de   |keine Passwortabfrage oder andere Benutzereingaben verlangen
   1736 hu      |nem krhet jelsz lekrdezst vagy ms felhasznli bevitelt
   1737 TX=de   |und kann durch die Umgebungsvariable S3_RCP gesetzt werden.
   1737 hu      |s az S3_RCP krnyezeti vltozn keresztl helyezhet el.
   1738 TX=de   |Soll statt $subst_rcp_cmd ein anderes
   1738 hu      |A $subst_rcp_cmd helyett egy msik
   1739 TX=de   |Kopierkommando zu Zielrechner $subst_ziel_host verwendet werden?
   1739 hu      |msolsi parancs kerljn hasznlatra a $subst_ziel_host clszmtgphez?
   1740 TX=de   |Zugangskommando
   1740 hu      |hozzfrsi parancs
   1741 TX=de   |Kopierkommando
   1741 hu      |Msolsi parancs
   1742 TX=de   |Mit dem $rcp_text mssen auch Verzeichnisse kopiert werden knnen
   1742 hu      |A $rcp_text-tel knyvtrakat is tudni kell msolni
   1743 TX=de   |Geben Sie das $subst_remote_cmd_name zu Rechner $subst_ziel_host an
   1743 hu      |Adja meg a $subst_remote_cmd_name-t a $subst_ziel_host szmtgphez
   1744 TX=de   |Geben Sie das Verzeichnis des Zielmandanten auf Rechner $subst_ziel_host als
   1744 hu      |Vigye be a clmandant knyvtrt a $subst_ziel_host szmtgpen abszolt
   1745 TX=de   |absoluten Pfad (ohne vorangestellte Hostangabe) an$subst_eingegebenes_nachdir:
   1745 hu      |elrsi tvonalknt (elhelyezett host adat nlkl) an$subst_eingegebenes_nachdir:
   1746 TX=de   |Geben Sie den s3-Bereich des Zielmandanten auf Rechner $subst_ziel_host als absoluten
   1746 hu      |Adja meg a clmandant s3 tartomnyt a $subst_ziel_host szmtgpen abszolt
   1747 TX=de   |Pfad (ohne vorangestellte Hostangabe) an:
   1747 hu      |elrsi tvonalknt (elhelyezett host adat nlkl):
   1748 TX=de   |(<return> fr $subst_default_wert)
   1748 hu      |(<return> $subst_default_wert-hez]
   1749 TX=de   |Zu kopierende Dateimenge auswhlen
   1749 hu      |Msoland fjlmennyisg kivlasztsa
   1750 TX=de   |Nur Datenbank
   1750 hu      |csak adatbank
   1751 TX=de   |Nur Standard-FOPs und -Dateien
   1751 hu      |csak standard FOP-ok s fjlok
   1752 TX=de   |Komplett
   1752 hu      |Komplett
   1753 TX=de   |Komplett mit Modulinstallation
   1753 hu      |Kompletten modul installcival
   1754 TX=de   |Fehler: falsche Auswahl zu kopierender Dateien ($kopieren)
   1754 hu      |Hiba: msoland fjlok rossz kivlasztsa ($kopieren)
   1755 TX=de   |Quellmandant und Zielmandant liegen auf derselben Partition.
   1755 hu      |Forrsmandant s clmandant ugyanazon a partcin vannak.
   1756 TX=de   |Datenbankdateien knnen gelinkt werden.
   1756 hu      |Adatbzis fjlok linkelhetk.
   1757 TX=de   |Sollen die Datenbankdateien dennoch kopiert werden?
   1757 hu      |Az adatbzis fjlok msolsra kerljenek?
   1758 TX=de   |ACHTUNG: Quellmandant $vonname $vondir wird UNTERBROCHEN
   1758 hu      |FIGYELEM: a $vonname $vondir forrs-mandant flbe lesz SZAKTVA
   1759 TX=de   |Zielmandant  $nachname $nachdir wird BERSCHRIEBEN
   1759 hu      |a $nachname $nachdir cl-mandant fell lesz RVA
   1760 TX=de   |Kopieren starten?
   1760 hu      |Msolst indtsam?
   1761 TX=de   |System momentan nicht betriebsbereit. Erneut versuchen?
   1761 hu      |A rendszer jelenleg nem zemksz. jra prblja?
   1762 TX=de   |Kopiervorgang beginnt...
   1762 hu      |Msolsi folyamat elindul ...
   1763 TX=de   |Dateien aus Mandant $vondir erfolgreich nach $nachdir kopiert
   1763 hu      |Fjlok a $vondir mandantbl sikeresen a $nachdir-be msolva
   1764 TX=de   |Setze Zugriffsrechte im Zielmandanten
   1764 hu      |Hozzfrsi jogosultsgok belltsa a clmandantban
   1765 TX=de   |Mandant $vondir wurde nicht oder nicht komplett nach $host_vorangestellt$nachdir kopiert
   1765 hu      |A $vondir mandant nem vagy nem teljesen kerlt msolsra a $host_vorangestellt$nachdir-be
"******** manddump.sh ********
   1766 TX=de   |Erstellt ein Mandanten-Archiv, mit dem mandmake.sh/mandinit.sh
   1766 hu      |Kszt egy mandant archvumot, amivel mandmake.sh/mandinit.sh
   1767 TX=de   |wieder einen Mandanten erzeugen knnen.
   1767 hu      |ismt kszthet egy mandantot.
   1768 TX=de   |Die Dateien file1 ... usw. werden zustzlich eingepackt.
   1768 hu      |A file1 ... stb. fjlok ptllagosan becsomagolsra kerlnek.
   1769 TX=de   |* Option -t: zu erzeugende Archiv-Datei statt $TGZNAME
   1769 hu      |* Opci -t: ltrehozand archvum fjl $TGZNAME helyett
   1770 TX=de   |* Option -f: zu verwendene Dump-Datei anstatt der aktuellen Datenbank
   1770 hu      |* Opci -f: Hasznland dump fjl az aktulis adatbzis helyett
   1771 TX=de   |Fehler beim Einpacken des Archivs
   1771 hu      |Hiba az archvum becsomagolsnl
"******** mandinit.sh ********
   1772 TX=de   |FEHLER: Kann Temporrverzeichnis $rmdir nicht lschen
   1772 hu      |HIBA: A $rmdir ideiglenes knyvtr nem trlhet
   1773 TX=de   |TRANSACTDATA (B)   Mandant ohne Bewegungsdaten
   1773 hu      |TRANSACTDATA (B)   Mandant mozgsi adatok nlkl
   1774 TX=de   |MASTERDATA   (C)   Mandant ohne Bewegungsdaten und
   1774 hu      |MASTERDATA   (C)   Mandant mozgsi adatok nlkl s
   1775 TX=de   |MASTERDATA2  (C2)  Mandant ohne Bewegungsdaten, individuelle
   1775 hu      |MASTERDATA2  (C2)  Mandant mozgsi adatok, egyedi trzsadatok
   1776 TX=de   |FINACC       (F)   Finanzbuchhaltungsdaten initialisieren
   1776 hu      |FINACC       (F)   Pnzgyi knyvelsi adatok inicializlsa
   1777 TX=de   |FINACC2      (F2)  Finanzbuchhaltungsdaten und Konten initialisieren
   1777 hu      |FINACC2      (F2)  Pnzgyi knyvelsi adatok s fknyvi szmlk inicializlsa
   1778 TX=de   |ADDDB        (Z)   Zusatztabellen leeren (mit -z)
   1778 hu      |ADDDB        (Z)   Kiegszto adatok rtse (-z vel)
   1779 TX=de   |EMPTY        (L)   Leermandant, enthlt div. Passwrter,
   1779 hu      |EMPTY        (L)   res mandant, kl. jelszavakat tartalmaz,
   1780 TX=de   |INIT         (I)   Vollstndig initialisierter Mandant,
   1780 hu      |INIT         (I)   Teljesen inicializlt mandant,
   1781 TX=de   |ARCHIVE      (A)   Aus individiuellem Archiv geladener Mandant
   1781 hu      |ARCHIVE      (A)   Egyedi archvumbl betlttt mandant
   1782 TX=de   |* Option -l: Datei, in die die Loeschaktionen geschrieben werden (<dn> <groups>)
   1782 hu      |* Opci -l: Fjl, amibe a trlsi mveletek rsra kerlnek (<dn> <groups>)
"******** mandkom.sh ********
   1783 TX=de   |newpass gescheitert
   1783 hu      |newpass sikertelen
   1784 TX=de   |newpass liz gescheitert
   1784 hu      |newpass liz sikertelen
   1785 TX=de   |infoupd gescheitert
   1785 hu      |infoupd sikertelen
"******** mandmake.sh ********
   1786 TX=de   |Zugriff auf $zdbinfo nicht mglich
   1786 hu      |Hozzfrs $zdbinfo ra nem lehetsges
   1787 TX=de   |Interner Fehler bei Aufruf waehle_resetzdbs
   1787 hu      |Bels hiba waehle_resetzdbs felhvsnl
   1788 TX=de   |Zu initialisierende Zusatztabellen auswhlen
   1788 hu      |Inicializland ptadatbankokhoz kivlaszts
   1789 TX=de   |Auswahl mit Leertaste oder ENTER, Abschlieen mit FERTIG, Abbrechen mit ABBRUCH
   1789 hu      |Kivlaszts szkzzel vagy ENTERel, lezrs FERTIG, megszakts ABBRUCH
   1790 TX=de   |Script ist nur als root ausfhrbar!
   1790 hu      |Script csak root knt vgrehajthat!
   1791 TX=de   |Es wurde nur ein bzw. kein Mandant gefunden,
   1791 hu      |Csak egy ill. egy mandant sem volt tallhat,
   1792 TX=de   |Funktion darf aber nicht auf dem Originalmandanten durchgefhrt werden!
   1792 hu      |a funkcit azonban nem szabad az eredeti mandanton vgrehajtani!
   1793 TX=de   |Bitte einen zweiten Mandanten in $HOMEDIR/mandantdir.env eintragen
   1793 hu      |Jegyezzen be egy msodik mandantot a $HOMEDIR/mandantdir.env-be
   1794 TX=de   |und diesen anschlieend als Kopie des Originalmandanten initialisieren.
   1794 hu      |s utna inicializlja ezt az eredeti mandant msolataknt.
   1795 TX=de   |Initialisierungs-Art des zu erstellenden Mandanten whlen
   1795 hu      |A ksztendo mandant inicializlsi tpusnak kivlasztsa
   1796 TX=de   |Ohne Bewegungsdaten
   1796 hu      |Mozgsi adatok nlkl
   1797 TX=de   |Stammdaten initialisieren
   1797 hu      |Trzsadatok inicializlsa
   1798 TX=de   |Stammdaten und Konten initialisieren
   1798 hu      |Trzsadatok s fknyvi szmlk inicializlsa
   1799 TX=de   |FIBU-Daten initialisieren
   1799 hu      |FIBU adatok inicializlsa
   1800 TX=de   |FIBU-Daten und Konten initialisieren
   1800 hu      |Pnzgyi knyvelsi adatok s fknyvi szmlk inicializlsa
   1801 TX=de   |Zusatztabellen leeren
   1801 hu      |Kiegszto adatbankok kirtse
   1802 TX=de   |Leer, mit Firmen- und Kontenstamm, Infosystemen
   1802 hu      |res, vllalati trzsadatok s fknyvi szmlatrzs, infosystemek
   1803 TX=de   |Komplett leer
   1803 hu      |Komplett res
   1804 TX=de   |Zu initialisierenden Mandanten auswhlen
   1804 hu      |Inicializland mandant kivlasztsa
   1805 TX=de   |Zu initialisierenden Mandanten zuerst aus anderem Mandanten kopieren?
   1805 hu      |Az inicializland mandantot eloszr ms mandantokbl msolja?
   1806 TX=de   |Abbruch - Mandanten $mandpfad dennoch initialisieren?
   1806 hu      |Megszakts - Mgis inicializljam a $mandpfad mandantot?
   1807 TX=de   |Kein Verzeichnis: $sourcepfad
   1807 hu      |Nem knyvtr: $sourcepfad
   1808 TX=de   |Fehler beim Aufruf von issubdir.sh
   1808 hu      |Hiba issubdir.sh felhvsnl
   1809 TX=de   |Mandant $mandname wird als Kopie von $sourcename erstellt.
   1809 hu      |A $mandname mandant a $sourcename msolataknt elkszl.
   1810 TX=de   |Fehler beim Kopieren des Quellmandanten
   1810 hu      |Hiba a forrsmandant msolsnl
   1811 TX=de   |Kann Zugriffsrechte nach Kopie nicht setzen
   1811 hu      |Nem lehet hozzfrsi jogokat elhelyezni msolat utn
   1812 TX=de   |Mandant kann nicht initialisiert werden
   1812 hu      |A mandant nem installlhat
   1813 TX=de   |Nichts zu tun, keine Zusatztabellen ausgewhlt
   1813 hu      |Nincs mit tenni, nincsenek ptadatbankok kivlasztva
   1814 TX=de   |Nach erfolgter Initialisierung Zugriffsrechte im Mandanten setzen?
   1814 hu      |Sikeres inicializls utn kri a hozzfrsi jogok belltst a mandantokban?
   1815 TX=de   |Mandant $mandpfad wird initialisiert
   1815 hu      |$mandpfad mandant inicializldik
   1816 TX=de   |Initialisierungsart: $initarttext
   1816 hu      |Inicializlsi tpus: $initarttext
   1817 TX=de   |ACHTUNG: Alle Dateien im Mandanten werden gelscht!
   1817 hu      |FIGYELEM: sszes fjl a mandantban trlsre kerl!
   1818 TX=de   |(Datenbanken, FOPs, etc.)
   1818 hu      |(Adatbankok, FOPok, stb.)
   1819 TX=de   |ACHTUNG: Stamm- und Bewegungsdaten im Mandanten werden gelscht!
   1819 hu      |FIGYELEM: a mandantban lv trzsadatok s mozgsi adatok trlsre kerlnek!
   1820 TX=de   |Basis-Stammdaten bleiben erhalten.
   1820 hu      |A bzis trzsadatok megmaradnak.
   1821 TX=de   |Sollen einzelne Datenbanken beibehalten werden,
   1821 hu      |Ha egyes adatbzisok megtartsra kerljenek,
   1822 TX=de   |bitte mandinit.sh direkt aufrufen und Option -k verwenden.
   1822 hu      |akkor hvja le kzvetlenl a mandinit.sh-t s hasznlja a -k opcit!
   1823 TX=de   |ACHTUNG: Alle Bewegungsdaten im Mandanten werden gelscht!
   1823 hu      |FIGYELEM: Az sszes mozgsi adat a mandantban trlsre kerl!
   1824 TX=de   |ACHTUNG: Alle Finanzbuchhaltungsdaten im Mandanten werden gelscht!
   1824 hu      |FIGYELEM: a mandantban lv sszes pnzgyi knyvelsi adat trlsre kerl!
   1825 TX=de   |ACHTUNG: Daten im Mandanten werden gelscht!
   1825 hu      |FIGYELEM: Az adatok a mandantban trlsre kerlnek!
   1826 TX=de   |ACHTUNG: Alle eventuell vorhandenen Verweise auf die
   1826 hu      |FIGYELEM: A kivlasztott kiegszt adatbzisokra val
   1827 TX=de   |ausgewhlten Zusatztabellen werden gelscht!
   1827 hu      |sszes esetlegesen meglv utals trlsre kerl!
   1828 TX=de   |Vorgang starten?
   1828 hu      |Folyamat indtsa?
   1829 TX=de   |Initialisierung luft...
   1829 hu      |Az inicializls folyamatban.
   1830 TX=de   |Fehler bei Initialisierung des Mandanten
   1830 hu      |Hiba a mandant inicializlsnl
   1831 TX=de   |Initialisierung erfolgreich beendet
   1831 hu      |Az inicializls sikeresen befejezodtt
   1832 TX=de   |Kann nicht in den Mandanten wechseln
   1832 hu      |Nem vlthat a mandantba
   1833 TX=de   |Setze Zugriffsrechte im initialisierten Mandanten
   1833 hu      |Hozzfrsi jogok belltsa az inicializlt mandantokban
   1834 TX=de   |Kann Zugriffsrechte nicht setzen
   1834 hu      |Nem helyezhetk el hozzfrsi jogosultsgok
   1835 TX=de   |Die automatische Initialisierung des Mandanten ist erfolgt.
   1835 hu      |A mandant automatikus inicializlsa megtrtnt.
   1836 TX=de   |Sie knnen den Mandanten jetzt im Einbenutzer-Betrieb starten.
   1836 hu      |Most elindthatja a mandantot az egyfelhasznls zemmdban.
   1837 TX=de   |Bitte prfen und ggf. korrigieren Sie dabei folgende Daten:
   1837 hu      |Ellenrizze s adott esetben korriglja ennl a kvetkez adatokat:
   1838 TX=de   |- Nummernzhler
   1838 hu      |- Szm szmll
   1839 TX=de   |- Termindatensatz (letzter Jahresabschlu, abgeschlossene Monate,
   1839 hu      |- Hatrid rekord (utols vzrs, lezrt hnapok,
   1840 TX=de   |Startdatum Umsatzsteuer/Anlagenbuchhaltung/Kostenrechnung)
   1840 hu      |Indulsi dtum forgalmi ad/trgyieszkz-knyvels/kltsgszmts]
   1841 TX=de   |- Geschftsjahres-/Monatsabschlsse
   1841 hu      |- Gazdasgi v-/hnapzrsok
   1842 TX=de   |Sie knnen diese Schritte auch spter durchfhren.
   1842 hu      |Ezeket a lpseket ksbb is vgrehajthatja.
   1843 TX=de   |Mandant jetzt im Einbenutzer-Modus starten?
   1843 hu      |A mandant indtsa most az egyfelhasznls mdban?
   1844 TX=de   |Kann Umgebung in `pwd` nicht setzen
   1844 hu      |`pwd` ben nem helyezhet el krnyezet
   1845 TX=de   |Datei `pwd`/denv.sh fehlt - envmake aufrufen
   1845 hu      |`pwd`/denv.sh fjl hinyzik - envmake felhvsa
   1846 TX=de   |Bitte prfen Sie die Textbereiche tx, tb, fax im Mandanten
   1846 hu      |Krem, ellenrizze a mandantokban lv tx, tb, fax szvegtartomnyokat!
   1847 TX=de   |auf aufzurumende oder anzupassende Texte.
   1847 hu      |kitakartand vagy testreszabsra sznt szvegek
   1848 TX=de   |Der Mandant wurde neu erstellt. Die Anmeldung im Mandanten ist momentan
   1848 hu      |A mandant jra kszlt. A bejelentkezs a mandantban jelenleg
   1849 TX=de   |nur mit dem Wartungspasswort mglich.
   1849 hu      |csak a karbantartsi jelszval lehetsges.
   1850 TX=de   |Sie mssen noch den Konfigurationsdatensatz anpassen, diverse Firmenstamm-
   1850 hu      |Mg testre kell szabnia a konfigurcis rekordot, klnbz vllalattrzs-
   1851 TX=de   |Datenstze (Betriebsdatensatz, Passwrter, div. Einmal-Datenstze)
   1851 hu      |rekordokat (zemi rekord, jelszavak, kl. egyszeri rekordok)
   1852 TX=de   |und andere Stammdaten erfassen, bevor der Mandant genutzt werden kann.
   1852 hu      |s ms trzsadatok rgztse, mieltt a mandant hasznlhat lenne.
   1853 TX=de   |Das Anlegen der Firmenstammstze und weiterer Daten kann mit dem
   1853 hu      |A vllalattrzs ttelek s tovbbi adatok felvitele a
   1854 TX=de   |Text DATEN erfolgen.
   1854 hu      |DATEN szveggel trtnhet.
   1855 TX=de   |Fr die GUI muss zudem die Datei $mandpfad/win/abasgui.ini
   1855 hu      |A GUI-hoz tovbb a $mandpfad/win/abasgui.ini fjlt
   1856 TX=de   |angepasst werden.
   1856 hu      |testre kell szabni.
   1857 TX=de   |Der Mandant wurde neu erstellt und folgende Daten geladen:
   1857 hu      |A mandant jbl elkszlt s betltsre kerltek a kvetkez adatok:
   1858 TX=de   |- Firmenstammstze einschlielich Passwrter,
   1858 hu      |- Vllalattrzs ttelek belertve a jelszavakat,
   1859 TX=de   |Standardselektionsleisten, Vartab
   1859 hu      |standard szelekcis sablonokat, Vartabot
   1860 TX=de   |- Zusatzpositionen im Teilestamm
   1860 hu      |- Ptpozcik a cikktrzsben
   1861 TX=de   |- Kontenstamm
   1861 hu      |- Szlatrzs
   1862 TX=de   |- Standardinfosysteme
   1862 hu      |- Standard infosystemek
   1863 TX=de   |- Standarddruckparameter
   1863 hu      |- Standard nyomtatsi paramter
   1864 TX=de   |- Einige weitere Standard-Stammdatenstze in anderen Datenbanken
   1864 hu      |- Nhny tovbbi standard trzsadat-ttel ms adatbankokban
   1865 TX=de   |Sie mssen diese Daten ggf. noch an eigene Bedrfnisse anpassen sowie
   1865 hu      |Adott esetben mg a sajt ignyeihez kell szabnia ezeket az adatokat s
   1866 TX=de   |weitere bentigten Stammdaten erfassen/laden.
   1866 hu      |tovbbi szksges trzsadatokat kell rgztenie/betltenie.
   1867 TX=de   |ACHTUNG: Der Mandant enthlt noch keine Lizenz. Diese mu bei der erstmaligen
   1867 hu      |FIGYELEM: A mandant mg nem tartalmaz licencet. Ezt a mandantnl val elszri
   1868 TX=de   |Anmeldung am Mandanten erst vergeben werden.
   1868 hu      |bejelentkezsnl elszr meg kell adni.
"******** mandplatz.sh ********
   1869 TX=de   |* Option -m: Minimum % DB_size frei (Default=0)
   1869 hu      |* Opci -m: Minimum % DB_size szabad (default=0)
   1870 TX=de   |oder Option -p: DB muss DB_PLUS % wachsen koennen (Default=100)
   1870 hu      |vagy opci -p: DB nek DB_PLUS % kal kell nvekednie (default=100)
   1871 TX=de   |* Option -o: Mandandant waechst zusaetzlich um OFFSET MB (Default=10)
   1871 hu      |* opci -o: mandant ptllag OFFSET MB tal nvekszik (default=10)
   1872 TX=de   |Platzbedarf der Datenbanken nicht feststellbar
   1872 hu      |Az adatbankok helyignye nem megllapthat
"******** mandtest.sh ********
   1873 TX=de   |$pwd ist kein Mandantenverzeichnis!
   1873 hu      |$pwd nem mandantknyvtr!
   1874 TX=de   |* Option -q: quiet, keine Ausgabe auf stderr
   1874 hu      |* opci -q: Quiet
   1875 TX=de   |* Option -f: force, s3lock/mlock ignorieren
   1875 hu      |* -f opci: force, s3lock/mlock ignorlva
   1876 TX=de   |Verzeichnis db.dat fehlt
   1876 hu      |db.dat knyvtr hinyzik
   1877 TX=de   |Datei 00VERSION fehlt
   1877 hu      |llomny 00VERSION nem ltezik
   1878 TX=de   |Verzeichnis log fehlt
   1878 hu      |log knyvtr hinyzik
   1879 TX=de   |Datei denv.dat fehlt
   1879 hu      |denv.dat hinyzik
   1880 TX=de   |${MANDBEZ:-$pwd}: Mandant ist gesperrt, Anmeldung momentan nicht mglich
   1880 hu      |${MANDBEZ:-$pwd}: installci zrolva, kapcsolat a mandant-al nem lehetsges
"******** mandwahl.sh ********
   1881 TX=de   |Mandanten auswhlen, Ergebnis in Datei out oder
   1881 hu      |Mandant kivlasztsa, eredmny out fjlban vagy
   1882 TX=de   |-x program - Programm in allen ausgewhlten Mandanten starten
   1882 hu      |-x program - Program indtsa az sszes kivlasztott mandantban
   1883 TX=de   |* Option -a: im Men auch alle auswhlbar
   1883 hu      |* Opci -a: A menben az sszes is kivlaszthat
   1884 TX=de   |* Option -m: im Men mehrere auswhlbar
   1884 hu      |* Opci -m: A menben tbb kivlaszthat
   1885 TX=de   |* Option -q: alle auswhlen (ohne Men)
   1885 hu      |* Opci -q: sszes kivlasztsa (men nlkl)
   1886 TX=de   |* Option -w: geschtzte Mandanten auslassen
   1886 hu      |* Opci -w: vdett mandantok kihagysa
   1887 TX=de   |* Option -d: Programm program in Verzeichnis dir als Benutzer MNAME lt. dir/denv.dat starten
   1887 hu      |* Opci -d: program program indtsa a dir knyvtrban MNAME felhasznlknt dir/denv.dat szerint
   1888 TX=de   |* Option -v: Menpunkt Nummer num als Vorbelegung
   1888 hu      |* Opci -v: szm num menpont elzetes kitltsknt
   1889 TX=de   |* Option -t: String titel als Titel des Mens
   1889 hu      |* Opci -t: String titel a men cmeknt
   1890 TX=de   |* Option -u: String header als berschrift ber dem Men
   1890 hu      |* Opci -u: String header feliratknt a men felett
   1891 TX=de   |* Option -s: userid des Mandanten verwenden
   1891 hu      |* Opci -s: A mandant userid-jnek hasznlata
   1892 TX=de   |* Option -S denvvar: userid die in denv.dat und denvvar steht verwenden
   1892 hu      |* Opci -S denvvar: userid hasznlata, ami a denv.dat-ban s denvvar-ban van
   1893 TX=de   |Bitte Mandant auswhlen
   1893 hu      |Vlasszon mandantot
   1894 TX=de   |HOMEDIR=$HOMEDIR ist kein Verzeichnis
   1894 hu      |HOMEDIR=$HOMEDIR nem knyvtr
   1895 TX=de   |Variable MNAME aus $HOMEDIR/denv.dat nicht bestimmbar
   1895 hu      |MNAME vltoz a $HOMEDIR/denv.dat-bl nem meghatrozhat
   1896 TX=de   |Kommando konnte nicht ausgefhrt werden:
   1896 hu      |A parancs nem volt vgrehajthat
"******** maskencmp.sh ********
   1897 TX=de   |Keine individuellen Masken fuer die Sprache $spr
   1897 hu      |Nincsenek egyedi maszkok a $spr nyelvhez
   1898 TX=de   |Keine Standardmasken fuer die Sprache $spr
   1898 hu      |Nincsenek standard maszkok a $spr nyelvhez
"******** maskengen.sh ********
   1899 TX=de   |maskengen.sh: Unbekannte Option: $1
   1899 hu      |maskengen.sh: Ismeretlen opci: $1
   1900 TX=de   |Verzeichnis $mquelleneu und Datei $mquelle nicht gefunden
   1900 hu      |$mquelleneu knyvtr s $mquelle fjl nem tallhat
   1901 TX=de   |Fehler beim Bestimmen des Maskenverzeichnisses
   1901 hu      |Hiba a maszkknyvtr meghatrozsnl
   1902 TX=de   |Masken werden neu konfiguriert ---
   1902 hu      |A maszkokat jra konfigurlom ---
   1903 TX=de   |Keine Masken gefunden! Sprache $spr
   1903 hu      |Nem talltam maszkot! Beltott nyelv - $spr
   1904 TX=de   |mask.0 nicht vorhanden
   1904 hu      |llomny mask.0 nem ltezik
   1905 TX=de   |sed-Aufruf gescheitert
   1905 hu      |sed-felhvs sikertelen
   1906 TX=de   |Sichern der Masken der neuen Maskenbeschreibung gescheitert
   1906 hu      |Az j maszklers maszkjainak a mentse nem sikerlt
   1907 TX=de   |Kann $maskendat nicht erzeugen
   1907 hu      |$maskendat nem kszthet
   1908 TX=de   |Maskengenerierung erfolglos
   1908 hu      |Maszkgenerls sikertelen
   1909 TX=de   |Kann $maskenref nicht installieren
   1909 hu      |$maskenref nem installlhat
   1910 TX=de   |Kann $screensref nicht installieren
   1910 hu      |$screensref nem installlhat
"******** maskengen_defines.sh ********
   1911 TX=de   |rmdir muss gesetzt sein
   1911 hu      |rmdir nak elhelyezve kell lennie
   1912 TX=de   |Kann nicht ins Verzeichnis $mymand wechseln
   1912 hu      |nem lehet vltani a $mymand knyvtrba
   1913 TX=de   |Kann nicht ins Verzeichnis $myzieldir wechseln
   1913 hu      |nem lehet vltani a $myzieldir knyvtrba
"******** maskenlist.sh ********
   1914 TX=de   |Liefert Liste von Maskendateien bzw. -verzeichnissen, die bei der Maskengenerierung verwendet werden
   1914 hu      |Azoknak a maszkfjloknak, ill. -knyvtraknak a listjt hozza, amik a maszkgenerlsnl kerlnek hasznlatra
   1915 TX=de   |* Option -H: nur HOMEDIR-Masken
   1915 hu      |* Opci -H: csak HOMEDIR-maszkok
   1916 TX=de   |* Option -M: nur individuelle Masken
   1916 hu      |* opci -M: csak egyedi maszkok
   1917 TX=de   |* Option -a: nur Masken, die nur in der alten Maskenbeschreibung vorliegen
   1917 hu      |* Opci -a: Csak olyan maszkok, amik csak a rgi maszklersban llnak rendelkezsre
   1918 TX=de   |* Option -A: auch Masken, die in der neuen und alten Maskenbeschreibung vorliegen
   1918 hu      |* Opci -A: Olyan maszkok is, amik az j s a rgi maszklersban llnak rendelkezsre
   1919 TX=de   |* Option -G SCREEN: nur Masken in der alten Maskenbeschreibung, die aus der neuen generiert werden
   1919 hu      |* Opci -G SCREEN: Csak olyan maszkok a rgi maszklersban, amik az jbl kerlnek generlsra
   1920 TX=de   |* Option -n: nur Masken in der neuen Maskenbeschreibung
   1920 hu      |* Opci -n: Csak maszkok az j maszklersban
   1921 TX=de   |* Option -I: fehlende Masken oder berflssige Masken ignorieren
   1921 hu      |* Opci -I: Hinyz maszkok vagy flsleges maszkok figyelmen kvl hagysa
   1922 TX=de   |* Option -L: GUI-Masken (default: ascii-Masken)
   1922 hu      |* Opci -L: GUI maszkok (alaprtelmezett: ascii maszkok)
   1923 TX=de   |* Option -i category: Infosystemmasken einer Kategorie
   1923 hu      |* Opci -i category: egy kategria infosystem maszkjai
   1924 TX=de   |Kategorie INFO: alle Infosystemmasken
   1924 hu      |INFO kategria: sszes infosystem maszk
   1925 TX=de   |* Option -l category: GUI-Masken einer Kategorie
   1925 hu      |* Opci -l category: egy kategria GUI maszkjai
   1926 TX=de   |Kategorie INFO: alle GUI-Infosystem-Masken
   1926 hu      |INFO kategria: sszes GUI infosystem maszk
   1927 TX=de   |Kategorie STDINFO: Standard-GUI-Infosystem-Masken
   1927 hu      |STDINFO category: standard GUI infosystem maszkok
   1928 TX=de   |Kategorie OWNINFO: GUI-Infosystem-Masken der Kunden
   1928 hu      |OWNINFO kategria: a vevk GUI infosystem maszkjai
   1929 TX=de   |Kategorie DB: GUI-Datenbank-Masken
   1929 hu      |DB kategria: GUI adatbzis maszkok
   1930 TX=de   |* Option -p: nur Dateinamen liefern (default: absoluten Pfad)
   1930 hu      |* opci -p: csak fjlnevek megadsa (default: abszolt elrsi tvonal)
   1931 TX=de   |* Option -r: Dateinamen der Properties-Dateien liefern
   1931 hu      |* Opci -r: A properties fjlok fjlneveinek szlltsa
   1932 TX=de   |* Option -D <dir>: Verzeichnis, in dem die individuellen Masken in der neuen Maskenbeschreibung liegen
   1932 hu      |* Opci -D <dir>: Knyvtr, amiben az egyedi maszkok az j maszklersban vannak
   1933 TX=de   |spr: Sprachverzeichnis (default: .)
   1933 hu      |spr: Nyelvi knyvtr (default: .)
   1934 TX=de   |Gruppe eksscreens in files.txt unbekannt
   1934 hu      |eksscreens csoport a files.txt-ben ismeretlen
   1935 TX=de   |Masken fehlen im HOMEDIR (alte Maskenbeschreibung)
   1935 hu      |Maszkok hinyoznak a HOMEDIR ben (rgi maszklers)
   1936 TX=de   |Masken fehlen im HOMEDIR (neue Maskenbeschreibung)
   1936 hu      |Maszkok hinyoznak a HOMEDIR ben (j maszklers)
   1937 TX=de   |Platzhalterdateien fr Masken fehlen im HOMEDIR
   1937 hu      |Helykitlt fjlok maszkokhoz hinyoznak a HOMEDIR-ben
   1938 TX=de   |berflssige Platzhalterdateien fr Masken im HOMEDIR (Platzhalterdatei ohne Prioritt und mit Prioritt a)
   1938 hu      |Flsleges helykitlt fjlok maszkokhoz a HOMEDIR-ben (helykitlt fjl priorits nlkl s a prioritssal)
   1939 TX=de   |Platzhalter fr Masken fehlen in $mandmaskdir
   1939 hu      |Helykitltk maszkokhoz hinyoznak a $mandmaskdir-ben
   1940 TX=de   |berflssige Platzhalterdateien fr Masken in $mandmaskdir (Platzhalterdatei mit Prioritt a)
   1940 hu      |Flsleges helykitlt fjlok maszkokhoz a $mandmaskdir-ben (helykitlt fjl a prioritssal)
   1941 TX=de   |berflssige Platzhalterdateien fr Masken in $mandmaskdir (Platzhalterdatei, aber keine neue Maske)
   1941 hu      |Flsleges helykitlt fjlok maszkokhoz a $mandmaskdir-ben (helykitlt fjl, de nem j maszk)
   1942 TX=de   |Masken fehlen
   1942 hu      |Hinyoznak maszkok
   1943 TX=de   |Masken in $homemaskdir werden ignoriert:
   1943 hu      |A $homemaskdir -ben lev maszkok ignorlva:
   1944 TX=de   |Masken in $mandmaskdir werden ignoriert:
   1944 hu      |A $mandmaskdir -ben lev maszkok ignorlva:
   1945 TX=de   |Masken in $mandmaskdir sind doppelt vorhanden:
   1945 hu      |A maszkok a $mandmaskdir-ben dupln llnak rendelkezsre:
"******** menu_da ********
   1946 TX=de   |Programm 'menu' existiert nicht
   1946 hu      |A 'menu' program nem ltezik
"******** modify_screen.sh ********
   1947 TX=de   |verndert Masken
   1947 hu      |Maszkokat mdost
   1948 TX=de   |* Option -f: Datei mit Maskenverzeichnissen
   1948 hu      |* Opci -f: Fjl maszkknyvtrakkal
   1949 TX=de   |Verzeichnis $maskdir existiert nicht
   1949 hu      |$maskdir knyvtr nem ltezik
   1950 TX=de   |Datei $maskdir/INDEX existiert nicht
   1950 hu      |$maskdir/INDEX fjl nem ltezik
   1951 TX=de   |Fehler beim ndern der Masken
   1951 hu      |Hiba a maszkok mdostsnl
"******** multisitegen_admin.sh ********
   1952 TX=de   |Beim Bekanntmachen der Umgebung ist ein Fehler aufgetreten.
   1952 hu      |A krnyezet ismertt ttelnl hiba lpett fel.
   1953 TX=de   |Skript im Mandanten aufrufen.
   1953 hu      |Script lehvsa a mandantban.
"******** nachladen.sh ********
   1954 TX=de   |Nachladen (berschreibt den Datenbestand auf der Festplatte!)
   1954 hu      |Visszatlts (A merevlemez adatllomnyt trja!)
   1955 TX=de   |gesamten Datenbestand
   1955 hu      |teljes adatllomny
   1956 TX=de   |Datenbestand eines Mandanten
   1956 hu      |Egy \"mandant\" adatllomnya
   1957 TX=de   |Installation bereits gesperrt
   1957 hu      |Installci mr zrolva
   1958 TX=de   |Zum Nachladen darf kein Benutzer angemeldet sein!
   1958 hu      |Utntltsre nem szabad felhasznlnak bejelentkezve lennie!
   1959 TX=de   |Verzeichnis $mand nicht gefunden
   1959 hu      |$mand knyvtr nem tallhat
   1960 TX=de   |kann nicht ins Verzeichnis $mand wechseln
   1960 hu      |nem lehet vltani a $mand knyvtrba
   1961 TX=de   |Beim Nachladen darf kein Benutzer angemeldet sein!
   1961 hu      |Utntltsnl nem szabad felhasznlnak bejelentkezve lennie!
   1962 TX=de   |Name der nachzuladenden Datei (oder <enter>, wenn
   1962 hu      |Az jra betltend llomny neve (vagy <enter>, ha az
   1963 TX=de   |alle Dateien des Mandanten $MANDANT nachgeladen werden sollen) :
   1963 hu      |$MANDANT \"mandant\" minden adatllomnyt vissza kell tlteni):
   1964 TX=de   |Nachladen starten?
   1964 hu      |Visszatlts indul?
   1965 TX=de   |Nachladen erfolgreich beendet
   1965 hu      |Visszatlts sikeresen befejezdtt.
   1966 TX=de   |Nachladen fehlgeschlagen, Status: $status
   1966 hu      |A visszatlts nem sikerlt, llapot: $status
"******** nachtsi.sh ********
   1967 TX=de   |Abas Komplettsicherung
   1967 hu      |Abas komplett ments
   1968 TX=de   |Sicherungs-Sperre konnte nicht freigegeben werden! Exitcode =
   1968 hu      |Ments zrlatot nem lehetett felszabadtani! Exitcode =
   1969 TX=de   |Sicherung gescheitert!
   1969 hu      |Ments sikertelen!
   1970 TX=de   |Beim Sichern mssen alle Mandanten unterbrochen sein!
   1970 hu      |Mentskor minden \"mandant\" munkjt meg kell szaktani!
   1971 TX=de   |Kein passendes Laufwerk gefunden.
   1971 hu      |Nem tallhat megfelel meghajt.
   1972 TX=de   |NICHT gesichert (ausgeschlossen):
   1972 hu      |NINCS mentve (kizrva):
   1973 TX=de   |Option -z: Option z des tar verwenden
   1973 hu      |Opci -z: A tar z opcijnak hasznlata
   1974 TX=de   |PATH muss im Aufruf enthalten sein!
   1974 hu      |PATH nak szerepelnie kell a felhvsban!
   1975 TX=de   |s3-Dir (HOMEDIR) \"$S3DIR\" fehlt
   1975 hu      |s3-Dir (HOMEDIR)  \"$S3DIR\" hinyzik
   1976 TX=de   |envmake gescheitert
   1976 hu      |envmake sikertelen
   1977 TX=de   |O.K.: `date` Schreiben auf Band:
   1977 hu      |O.K.: `date` rs szalagra:
   1978 TX=de   |FEHLER: `date` Schreiben auf Band.
   1978 hu      |HIBA:`date` rs szalagra.
   1979 TX=de   |O.K.: `date` Probelesen von Band
   1979 hu      |O.K.: `date` prbaolvass szalagrl
   1980 TX=de   |FEHLER: `date` Probelesen von Band
   1980 hu      |HIBA: `date` prbaolvass szalagrl
"******** neuhome.sh ********
   1981 TX=de   |Kein neues HOMEDIR: $HOMEDIR
   1981 hu      |Nem j HOMEDIR: $HOMEDIR
   1982 TX=de   |Kein ORIHOMEDIR: $ORIHOMEDIR
   1982 hu      |Nem ORIHOMEDIR: $ORIHOMEDIR
   1983 TX=de   |Programm envmake nicht im PFAD
   1983 hu      |Program envmake nincs a PFAD ban
   1984 TX=de   |env_upd.sh vneu/homedir.env gescheitert
   1984 hu      |env_upd.sh vneu/homedir.env sikertelen
   1985 TX=de   |Datei s3homedir.env fehlt
   1985 hu      |s3homedir.env hinyzik
   1986 TX=de   |Kann Umgebung fuer HOMEDIR=$HOMEDIR nicht erzeugen
   1986 hu      |Nem kszthet krnyezet HOMEDIR=$HOMEDIR szmra
   1987 TX=de   |HOMEDIR=$HOMEDIR envmake -d: Kann Umgebung fuer $mdir nicht erzeugen
   1987 hu      |HOMEDIR=$HOMEDIR envmake -d: Nem kszthet krnyezet $mdir szmra
   1988 TX=de   |UMGEBUNG STIMMT NICHT, envmake -B aufrufen!
   1988 hu      |KRNYEZET NEM EGYEZIK, envmake -B felhvsa!
   1989 TX=de   |Kann Umgebung mit $neuhome_pwd/denv.sh nicht setzen
   1989 hu      |Krnyezet $neuhome_pwd/denv.sh val nem helyezhet el
"******** normalise_screen.sh ********
   1990 TX=de   |normiert den Inhalt von Maskendateien
   1990 hu      |a maszkfjlok tartalmt szabvnyostja
   1991 TX=de   |* Option -f: Datei mit xml-Masken
   1991 hu      |* Opci -f: Fjl xml maszkokkal
   1992 TX=de   |Fehler beim Normieren der Maskendatei(en)
   1992 hu      |Hiba a maszkfjl(ok) szabvnyostsnl
"******** oocalcfunc.sh ********
   1993 TX=de   |$name: Funktionen fr OpenOffice Calc
   1993 hu      |$name: Funkcik OpenOffice Calc szmra
   1994 TX=de   |* Option -e: Export - csv-Datei nach OO Calc-Zeilen
   1994 hu      |* Opci -e: export - csv fjl OO Calc-sorok utn
   1995 TX=de   |* Option -t: Angabe eines indiv. Datumstrenners
   1995 hu      |* Opci -t: egyedi dtumelvlaszt megadsa
"******** ooserver.sh ********
   1996 TX=de   |* Option -s: Server starten
   1996 hu      |* Opci -s: Az szerver indtsa
   1997 TX=de   |* Option -e: Server beenden
   1997 hu      |* Opci -e: Szerver befejezse
   1998 TX=de   |* Option -r: Server beenden und neu starten (restart)
   1998 hu      |* Opci -r: Szerver befejezse s jraindtsa (restart)
   1999 TX=de   |* Option -t: Server testen, exit status: 0=luft, 1=luft nicht
   1999 hu      |* Opci -t: Szerver tesztelse, exit status: 0=fut, 1=nem fut
   2000 TX=de   |* Option -l: Server testen und Meldung ausgeben, exit status wie bei -t
   2000 hu      |* Opci -l: Szerver tesztelse s zenet kiadsa, exit status mint a -t -nl
   2001 TX=de   |* Option -h: Host fr Server (Default: $defaultoohost)
   2001 hu      |* Opci -h: Host szerverhez (alaprtelmezett: $defaultoohost)
   2002 TX=de   |* Option -p: Port fr Server (Default: 8100)
   2002 hu      |* Opci -p: Port szerverhez (alaprtelmezett: 8100)
   2003 TX=de   |* Option -u: User-ID fr Serverprozess (Default: $defaultoouser)
   2003 hu      |* Opci -u: User ID szerver folyamathoz (Alaprtelmezett: $defaultoouser)
   2004 TX=de   |* Option -x: Explizite Angabe des zu startenden Programms
   2004 hu      |* Opci -x: Az elindtand program explicit megadsa
   2005 TX=de   |* Option -D: DISPLAY fr Server (Default: $DISPLAY)
   2005 hu      |* Opci -D: DISPLAY szerverhez (alaprtelmezett: $DISPLAY)
   2006 TX=de   |Server luft bereits.
   2006 hu      |az szerver mr fut.
   2007 TX=de   |Kann Pfad zu OpenOffice-Programm nicht ermitteln.
   2007 hu      |Elrsi tvonal az OpenOffice programhoz nem meghatrozhat.
   2008 TX=de   |Server konnte nicht gestartet werden.
   2008 hu      |az szervert nem lehetett elindtani.
   2009 TX=de   |Server wurde gestartet.
   2009 hu      |Az szervert elindtottk.
   2010 TX=de   |Kann lokale Prozessliste nicht erstellen.
   2010 hu      |Helyi folyamatlista nem kszthet.
   2011 TX=de   |Kann Prozessliste auf Rechner $oohost nicht erstellen.
   2011 hu      |Folyamatlista a $oohost szmtgpen nem kszthet.
   2012 TX=de   |Server luft nicht.
   2012 hu      |Szerver nem fut.
   2013 TX=de   |Es laufen mehrere Prozesse, bitte den richtigen Prozess manuell beenden.
   2013 hu      |Tbb folyamat fut, krem a megfelel folyamatot kzzel fejezze be!
   2014 TX=de   |Kann Serverprozess nicht beenden.
   2014 hu      |Nem tudom befejezni az szerverfolyamatot.
   2015 TX=de   |Serverprozess wurde beendet.
   2015 hu      |A szerver folyamat befejezsre kerlt.
   2016 TX=de   |Es laufen mehrere Prozesse.
   2016 hu      |Tbb folyamat fut.
   2017 TX=de   |Server luft (pid=$(cat $proclist))
   2017 hu      |Szerver fut (pid=$(cat $proclist))
   2018 TX=de   |Zu viele Argumente.
   2018 hu      |Tl sok argumentum.
   2019 TX=de   |Bitte Aktion angeben.
   2019 hu      |Adjon meg mveletet!
   2020 TX=de   |$aktion: Aktion nicht implementiert.
   2020 hu      |$aktion: Mvelet nincs implementlva.
"******** oozip.sh ********
   2021 TX=de   |$name: Packen und Entpacken von OpenOffice-Dokumenten
   2021 hu      |$name: OpenOffice-dokumentumok becsomagolsa s kicsomagolsa
   2022 TX=de   |* Option -z: Packen (zip) eines Verzeichnisses zu einer OO-Datei
   2022 hu      |* Opci -z: knyvtr becsomagolsa (zip) OO-fjlhoz
   2023 TX=de   |* Option -u: Entpacken (unzip) einer OO-Datei in ein Verzeichnis
   2023 hu      |* Opci -u: OO-fjl kicsomagolsa (unzip) egy knyvtrba
   2024 TX=de   |Fehler beim Packen von $oofile
   2024 hu      |Hiba $oofile becsomagolsnl
   2025 TX=de   |Fehler beim Lschen des Arbeitsverzeichnisses $zipdir
   2025 hu      |Hiba a $zipdir munkaknyvtr trlsekor
   2026 TX=de   |Kann Verzeichnis nicht anlegen: $zipdir
   2026 hu      |Nem helyezhet el knyvtr: $zipdir
   2027 TX=de   |Fehler beim Entpacken von $oofile
   2027 hu      |Hiba $oofile kicsomagolsnl
"******** ostest.sh ********
   2028 TX=de   |Kann Rechnerarchitektur mit 'archname.sh' nicht feststellen
   2028 hu      |A szmtgp architektra 'archname.sh'-val nem meghatrozhat
"******** pilot.sh ********
   2029 TX=de   |Ist ZIELVERS eine Pilotversion?
   2029 hu      |A ZIELVERS  egy piltaverzi?
   2030 TX=de   |* Option -i: Neuinstallation
   2030 hu      |* Opci -i: j installci
   2031 TX=de   |* Option -z: ZIELVERS setzen
   2031 hu      |* Opci -z: ZIELVERS
"******** proplist.sh ********
   2032 TX=de   |* Option -w: Die Dateien aus der MANDANTDIR/translationWhiteListIndv werden rekursiv durchsucht.
   2032 hu      |* Opci -w: A fjlok a MANDANTDIR/translationWhiteListIndv-bl rekurzvan kerlnek tkutatsra.
   2033 TX=de   |* Option -e: Die Dateien aus dem gegebenen DIR werden rekursiv durchsucht.
   2033 hu      |* Opci -e: A fjlok az adott DIR-bl rekurzvan kerlnek tkutatsra.
   2034 TX=de   |Angegebenes Verzeichnis existiert nicht!
   2034 hu      |A megadott knyvtr nem ltezik!
"******** protokollierung.sh ********
   2035 TX=de   |Datei $l1000_dat kann nicht angelegt werden
   2035 hu      |$l1000_dat nem kszthet
   2036 TX=de   |Zugriffsrechte von Datei $l1000_dat knnen nicht gesetzt werden
   2036 hu      |A $l1000_dat fjl hozzfrsi jogai nem helyezhetk el
   2037 TX=de   |Kein schreibender Zugriff auf Datei $l1000_dat mglich
   2037 hu      |Nem lehetsges rsos hozzfrs a $l1000_dat fjlhoz
"******** prozesse.sh ********
   2038 TX=de   |Prozessliste auf Rechner $p konnte nicht ermittelt werden
   2038 hu      |A $p szmtgpen nem lehet ellltani a processzek listjt
   2039 TX=de   |Prozessliste auf Rechner $p konnte nicht gefiltert werden
   2039 hu      |A $p szmtgpen lev processzlistt nem lehet megszrni
"******** pruef.sh ********
   2040 TX=de   |Datensicherung auf Lesefehler prfen
   2040 hu      |Adatellenrzs olvassi hibkra
"******** putinisetting.sh ********
   2041 TX=de   |$name - Schreiben von Einstellungen in INI-Dateien
   2041 hu      |$name - Belltsok bersa az INI-fjlokba
   2042 TX=de   |Ein Eintrag hat das Format 'Schlssel=Wert'
   2042 hu      |A bevitel formtuma 'Kulcs=rtk'
   2043 TX=de   |usage: $name [-d] INI-Filename Abschnitt Schlssel Wert
   2043 hu      |usage: $name [-d] INI-fjlnv szakasz kulcs rtk
   2044 TX=de   |$name [-d] -r INI-Filename Abschnitt Schlssel
   2044 hu      |$name [-d] -r INI-fjlnv szakasz kulcs
   2045 TX=de   |* INI-Filename: Name der INI-Datei
   2045 hu      |* INI-fjlnv: Az INI fjl neve
   2046 TX=de   |* Schlssel:    Schlssel des Eintrags
   2046 hu      |* Kulcs:          A bevitel kulcsa
   2047 TX=de   |* Wert:         Neuer Wert fr den Eintrag
   2047 hu      |* rtk:         A bevitel j rtke
   2048 TX=de   |* Option -r:    Eintrag entfernen
   2048 hu      |* Opci -r:     Bevitel eltvoltsa
   2049 TX=de   |INI-Dateiname darf nicht leer sein
   2049 hu      |INI-fjlnv nem lehet res
   2050 TX=de   |Schlssel fehlt
   2050 hu      |Hinyz kulcs
   2051 TX=de   |Wert fehlt
   2051 hu      |Hinyz rtk
   2052 TX=de   |Kann INI-Datei $inifile nicht anlegen
   2052 hu      |$inifile INI-fjl nem elhelyezhet
"******** rdiff.sh ********
   2053 TX=de   |* Option -o: Verzeichnis der Originale
   2053 hu      |* -o opci: az eredeti knyvtr
   2054 TX=de   |* Option -n: Verzeichnis der Neuen
   2054 hu      |* -n opci: az j knyvtr
   2055 TX=de   |* Option -t: diffs unterhalb DiffDir/SubDir erzeugen
   2055 hu      |* Opci -t: diffs ksztse DiffDir/SubDir alatt
   2056 TX=de   |Kein Verzeichnis OriDir/SubDIR=$ORIDIR/$SUBDIR
   2056 hu      |Nincs OriDir/SubDIR=$ORIDIR/$SUBDIR knyvtr
   2057 TX=de   |Kein Verzeichnis NeuDir/SubDIR=$NEUDIR/$SUBDIR
   2057 hu      |Nincs NeuDir/SubDIR=$NEUDIR/$SUBDIR knyvtr
   2058 TX=de   |Kein Verzeichnis DiffDir=$DIFFDIR
   2058 hu      |Nincs DiffDir=$DIFFDIR knyvtr
   2059 TX=de   |Kann Dateiliste fr $DIFFDIR/${subname}-files nicht anlegen
   2059 hu      |Nem helyezhet el fjllista $DIFFDIR/${subname}-files szmra
   2060 TX=de   |Kann Unterverzeichnisse in $DIFFDIR nicht anlegen
   2060 hu      |Nem helyezhetek el alknyvtrak $DIFFDIR ben
   2061 TX=de   |Kann $DIFFDIR/${subname}-files.sh nicht erzeugen
   2061 hu      |Nem kszthet $DIFFDIR/${subname}-files.sh
   2062 TX=de   |kann Zugriffrechte fuer $DIFFDIR/${subname}-files.sh nicht setzen
   2062 hu      |nem helyezhetk el hozzfrsi jogosultsgok $DIFFDIR/${subname}-files.sh szmra
"******** rewe_beweg_dump.sh ********
   2063 TX=de   |Passwort nicht gesetzt
   2063 hu      |Jelsz nincs elhelyezve
"******** s3lock.sh ********
   2064 TX=de   |!!!Sperre wurde in der Shell manuell gesetzt!!!
   2064 hu      |!!!Zrlat a shellben manulisan lett elhelyezve!!!
   2065 TX=de   |Sperre kann nicht gelesen werden
   2065 hu      |Zrlat nem olvashat
   2066 TX=de   |Kategorie/Programm
   2066 hu      |Kategria/program
   2067 TX=de   |Beschreibung
   2067 hu      |Lers
   2068 TX=de   |Sperrer-Identifikation fehlt
   2068 hu      |Hinyz zrlat-identifikci
   2069 TX=de   |Es gibt keine Sperre fr $pid
   2069 hu      |Nincs zrlat $pid szmra
   2070 TX=de   |interner Fehler bei beende_lock
   2070 hu      |bels hiba a kvetkeznl beende_lock
   2071 TX=de   |Installationssperren:
   2071 hu      |Installcis zrlat:
   2072 TX=de   |Mandantensperren:
   2072 hu      |Mandantzrlat:
   2073 TX=de   |$name: Abas Installations-/Mandantensperre setzen/beenden/testen/anzeigen
   2073 hu      |$name: Abas installcis/mandantzrlat felraksa/befejezse/tesztelse/megjelentse
   2074 TX=de   |* Aktion -s: Setzen der Installations-/Mandantensperre
   2074 hu      |* Akci -s:  Az installcis /mandantzrlat belltsa
   2075 TX=de   |* Aktion -e: Beenden der Installations-/Mandantensperre
   2075 hu      |* Akci -e:  Az installcis /mandantzrlat befejezse
   2076 TX=de   |* Aktion -t: Testen der Installations-/Mandantensperre
   2076 hu      |* Akci -t:  Az installcis /mandantzrlat tesztelse
   2077 TX=de   |\$? == 0  ->  Sperre ist nicht gesetzt
   2077 hu      |\$? == 0  ->  A zrlat nincs feltve
   2078 TX=de   |\$? != 0  ->  Sperre ist gesetzt
   2078 hu      |\$? != 0  -> Zrlat feltve
   2079 TX=de   |* Aktion -l: Auflisten der aktiven Sperren
   2079 hu      |* Akci -l: Az aktv zrlatok felsorolsa
   2080 TX=de   |* Aktion -L: Wie -l, aber mit berschrift-Zeile
   2080 hu      |* Akci -L: Mint -l, csak felirat-sorral
   2081 TX=de   |Zusatzoptionen fr alle Aktionen:
   2081 hu      |Kiegszt ttelek az sszes akcihoz:
   2082 TX=de   |* Option -m/-M   Mandantensperre statt Installationssperre
   2082 hu      |* Opci -m/-M    Mandant-zrlat installcis zrlat helyett
   2083 TX=de   |Default ist Installationssperre
   2083 hu      |Az alapbellts installcis zrlat
   2084 TX=de   |Bei Mandantensperre muss man im Mandanten stehen
   2084 hu      |Mandant-zrlat esetn a mandantban kell lennie
   2085 TX=de   |-m: Mandantensperre und Installationssperre auswerten
   2085 hu      |-m: Mandant-zrlat s installcis zrlat kirtkelse
   2086 TX=de   |-M: nur Mandantensperre auswerten (nur mit -t/-l/-L)
   2086 hu      |-M: csak a mandant-zrlat kirtkelse (csak -t/-l/-L -lel)
   2087 TX=de   |* Option -k Kat: Kategorie der Sperre oder sperrendes Programm
   2087 hu      |* Opci -k Kat: A zrlat vagy a zroland program kategrija
   2088 TX=de   |Zusatzoptionen fr -s (Setzen) und -e (Beenden):
   2088 hu      |Kiegszt ttelek a kv-hz: -s (feltenni) s -e (befejezni):
   2089 TX=de   |* Option -p PID: Prozessnr. des Sperrers, dient als Identifikator
   2089 hu      |* Opci -p PID: A zrol gyletszma, azonostsra szolgl
   2090 TX=de   |* Option -f:     Force - Setzen auch wenn bereits gesetzt
   2090 hu      |* Opci -f:      Force - Belltani, akkor is, ha mr foglalt
   2091 TX=de   |bzw. unbedingt und vollstndig wegnehmen
   2091 hu      |ill. felttlenl s teljesen elvenni
   2092 TX=de   |Zusatzoptionen fr -s (Setzen):
   2092 hu      |Kiegszt opcik a -s (feltenni)-hez
   2093 TX=de   |* Option -b Beschr: Beschreibung fr Anzeigeprogramme
   2093 hu      |* Opci -b: beschr: A megjelentsi programok lersa
   2094 TX=de   |Zusatzoptionen fr -s/-e (Setzen/Beenden):
   2094 hu      |Kiegszt opcik -s/-e -hez (elhelyezs/befejezs):
   2095 TX=de   |* Option -u      Unsynchronisiert setzen/beenden (fr Alleinlufer)
   2095 hu      |* Opci -u       Nem szinkronizlt elhelyezse/befejezse (egyedl fut programokhoz)
   2096 TX=de   |Zusatzoptionen fr -l/-L (Auflisten):
   2096 hu      |Kiegszto ttelek a -l/-L -hez (Felsorols):
   2097 TX=de   |* Option -o Output-Format: Auszugebende Spalten (auch mehrfach):
   2097 hu      |* Opci -o Kimeneti formtum: Kiadand oszlopok (tbbszr is):
   2098 TX=de   |A=alle, P=PID, K=Kategorie, B=Beschreibung
   2098 hu      |A=mind, P=PID, K=Kategria,B=Lers
   2099 TX=de   |Falsches Output-Format (-o)
   2099 hu      |Rossz output-formtum (-o)
   2100 TX=de   |Zu viele Optionen
   2100 hu      |Tl sok opci
   2101 TX=de   |Aktion fehlt
   2101 hu      |Hinyz mvelet
   2102 TX=de   |Umgebungsvariable \$HOMEDIR ist nicht gesetzt
   2102 hu      |\$HOMEDIR krnyezeti vltoz nincs elhelyezve
   2103 TX=de   |Kann nicht nach \$HOMEDIR=$HOMEDIR wechseln
   2103 hu      |Nem tud \$HOMEDIR=$HOMEDIR szerint vltani
   2104 TX=de   |Kann Hostname nicht ermitteln
   2104 hu      |Hostname nem kzlhet
   2105 TX=de   |Unzulssige Aktion
   2105 hu      |Nem megengedett mvelet
"******** s3lockdlg.sh ********
   2106 TX=de   |$name: Verwaltung der Installationssperre oder Mandantensperre
   2106 hu      |$name: Az installcis vagy mandant-zrlat kezelse
   2107 TX=de   |* Option -m: Mandantensperre statt Installationssperre
   2107 hu      |* Opci -m: Mandant-zrlat installcis zrlat helyett
   2108 TX=de   |$TYPETEXT ist nicht gesetzt
   2108 hu      |$TYPETEXT nincs belltva
   2109 TX=de   |$TYPETEXT ist bereits gesetzt. Sperre trotzdem setzen?
   2109 hu      |$TYPETEXT mr belltva. Ennek ellenre zroljak?
   2110 TX=de   |Es ist bereits eine Installationssperre gesetzt.
   2110 hu      |Mr belltottak egy installcis zrlatot.
   2111 TX=de   |Mandantensperre trotzdem setzen?
   2111 hu      |Ennek ellenra belltsam a mandant-zrlatot?
   2112 TX=de   |Geben Sie einen Hinweistext zur Sperre ein.
   2112 hu      |rjon be egy utalsi szveget a zrlathoz.
   2113 TX=de   |Abschluss der Eingabe mit <RETURN>
   2113 hu      |A bers lezrsa a <return>-nel.
   2114 TX=de   |Sperre wurde gesetzt.
   2114 hu      |A zrlatot feltettem.
   2115 TX=de   |Sperre konnte nicht gesetzt werden
   2115 hu      |A zrlatot nem lehetett feltenni.
   2116 TX=de   |Whlen Sie die zu wegzunehmende Sperre aus
   2116 hu      |Vlassza ki az  fetvoltand zrlatot
   2117 TX=de   |Sperren wurden nicht verndert
   2117 hu      |A zrlatok nem vltoztak
   2118 TX=de   |Wegzunehmende Sperre:
   2118 hu      |Eltvoltand zrlat:
   2119 TX=de   |Sperre wirklich wegnehmen?
   2119 hu      |Tnyleg eltvoltsam a zrlatot?
   2120 TX=de   |Sperre wurde weggenommen
   2120 hu      |A zrlatot eltvoltottam
   2121 TX=de   |Sperre konnte nicht weggenommen werden
   2121 hu      |A zrlatot nem tudtam eltvoltani.
   2122 TX=de   |Sperre wurde nicht verndert
   2122 hu      |A zrlat nem vltozott!
   2123 TX=de   |$TYPETEXT wirklich wegnehmen?
   2123 hu      |$TYPETEXT tnyleg elvegyem?
   2124 TX=de   |Installationssperre
   2124 hu      |Installcis zrlat
   2125 TX=de   |Mandantensperre
   2125 hu      |Mandantzrlat
   2126 TX=de   |Script mu im Mandanten aufgerufen werden
   2126 hu      |Scripet a mandantban fel kell hvni
   2127 TX=de   |$TYPETEXT verwalten
   2127 hu      |$TYPETEXT kezelse
   2128 TX=de   |Bestehende Sperren anzeigen
   2128 hu      |A meglv zrlatok megjelentse
   2129 TX=de   |Manuelle Sperre setzen
   2129 hu      |Zrlatfelvitel kzzel
   2130 TX=de   |Einzelne Sperre wegnehmen
   2130 hu      |Az zrlat eltvoltsa
   2131 TX=de   |Gesamte $TYPETEXT wegnehmen
   2131 hu      |Az egsz $TYPETEXT elvenni
"******** s3mand.sh ********
   2132 TX=de   |Mandant nicht betriebsbereit
   2132 hu      |Mandant nem zemksz
"******** s3path.sh ********
   2133 TX=de   |$progname: Programm nicht gefunden
   2133 hu      |$progname: Program nem tallhat
"******** s3tar.def ********
   2134 TX=de   |$d ist weder ein Verzeichnis noch eine Datei
   2134 hu      |$d se nem knyvtr se nem fjl
   2135 TX=de   |Unbekanntes Bandformat: $FORM
   2135 hu      |Ismeretlen szalagformtum: $FORM
   2136 TX=de   |probelesen
   2136 hu      |ellenrz olvass
"******** s3tar.sh ********
   2137 TX=de   |$aktion Laufwerk $D: Blockung $B, $NB Blcke pro Medium
   2137 hu      |$aktion Meghajt $D: Blokk $B, $NB Blokk/Mdium
   2138 TX=de   |$aktion Laufwerk $RR:$D: Blockung $B, $NB Blcke pro Medium
   2138 hu      |$aktion Meghajt $RR:$D: Blokk $B, $NB Blokk/Mdium
   2139 TX=de   |Bitte Medium einlegen, dann <return>
   2139 hu      |Krem tegye be az adathordozt, majd <return>
   2140 TX=de   |-- Vollstndigkeitskontrolle --
   2140 hu      |-- Teljessg vizsglat --
   2141 TX=de   |ACHTUNG: Folgende Dateien konnten nicht gesichert werden:
   2141 hu      |FIGYELEM: Nem lehet menteni a kvetkez llomnyokat:
   2142 TX=de   |Medium kann entnommen werden ...
   2142 hu      |Az adathordozt ki lehet venni.
   2143 TX=de   |*** ACHTUNG: Bandlesen oder Bandschreiben mit FEHLERN ***
   2143 hu      |*** FIGYELEM: Hibs szalag -rs vagy -olvass ***
"******** schemadiff.sh ********
   2144 TX=de   |Datei $startdat/satz.tabappendix fehlt
   2144 hu      |$startdat/satz.tabappendix hinyzik
   2145 TX=de   |Fehler beim Generieren der Feldlisten aus lib/UpgradeRules/dumps/*.yaml
   2145 hu      |Hiba a mezlistknak a lib/UpgradeRules/dumps/*.yaml-bl val generlsnl
   2146 TX=de   |satztab.sh gescheitert
   2146 hu      |satztab.sh sikertelen
   2147 TX=de   |satz.tabneu konnte nicht ins $startdat geschoben werden
   2147 hu      |A satz.tabneu-t nem lehetett a $startdat-ba eltolni
   2148 TX=de   |Datei $INITDATEI nicht lesbar
   2148 hu      |$INITDATEI fjl nem olvashat
   2149 TX=de   |checkres.filter nicht generiert
   2149 hu      |checkres.filter nincs generlva
   2150 TX=de   |checkres.filter gescheitert
   2150 hu      |checkres.filter sikertelen
   2151 TX=de   |awk gescheitert
   2151 hu      |awk sikertelen
   2152 TX=de   |sed gescheitert
   2152 hu      |sed sikertelen
   2153 TX=de   |sed2 gescheitert
   2153 hu      |sed2 sikertelen
   2154 TX=de   |sed3 gescheitert
   2154 hu      |sed3 sikertelen
   2155 TX=de   |awk2 gescheitert
   2155 hu      |awk2 sikertelen
   2156 TX=de   |sort2 gescheitert
   2156 hu      |sort2 sikertelen
"******** screenCreator.sh ********
   2157 TX=de   |* Option -f xmlfile: Datei mit den Felder im XML-Format
   2157 hu      |* Opci -f xmlfile: Fjl mezkkel az XML formtumban
   2158 TX=de   |* Option -l layname: Name der Layoutmethode
   2158 hu      |* Opci -l layname: A layout metdus neve
   2159 TX=de   |* Wert SIMPLETREE = Einfache Baumansicht
   2159 hu      |* rtk SIMPLETREE = Egyszer fa-struktra
   2160 TX=de   |* Option -o outputDirectory: Verzeichnis, in das die Generate erzeugt werden
   2160 hu      |* Opci -o outputDirectory: Knyvtr, amibe a -generate fjlok ltrehozsra kerlnek
   2161 TX=de   |Die angegebene Datei ${xmlfile} existiert nicht!
   2161 hu      |A ${xmlfile} fjl nem ltezik.
   2162 TX=de   |Das angegebene Verzeichnis ${outputDir} existiert nicht!
   2162 hu      |${outputDir} knyvtr nem ltezik
   2163 TX=de   |Die Layoutmethode ${layname} ist nicht bekannt.
   2163 hu      |A ${layname} layout metdus nem ismert.
   2164 TX=de   |Kann Verzeichnis rmdir=$rmdir nicht lschen
   2164 hu      |rmdir=$rmdir knyvtrat nem tudja trlni
   2165 TX=de   |Kann Verzeichnis rmdir=$rmdir nicht anlegen
   2165 hu      |rmdir=$rmdir knyvtr nem elhelyezhet
   2166 TX=de   |Die automatische Erzeugung der Maske ist gescheitert!
   2166 hu      |A maszk automatikus ltrehozsa nem sikerlt!
"******** screen_export.sh ********
   2167 TX=de   |Exportiert eine Datenbankmaske.
   2167 hu      |Exportl egy adatbzis maszkot.
   2168 TX=de   |* Option -n number: Maskennummer
   2168 hu      |* Option -n number: Maszkszm
   2169 TX=de   |* Option -p prio: Prioritt der Maske
   2169 hu      |* Opci -p prio: A maszk prioritsa
   2170 TX=de   |Maske $MASKNR Prioritt $PRIO exportieren
   2170 hu      |$MASKNR maszk $PRIO priorits exportlsa
   2171 TX=de   |Maske $MASKNR Prioritt $PRIO nicht gefunden
   2171 hu      |$MASKNR maszk $PRIO priorits nem tallhat
"******** screen_import.sh ********
   2172 TX=de   |Importiert eine Datenbankmaske.
   2172 hu      |Importl egy adatbzis maszkot.
   2173 TX=de   |* Option -g: Maske testweise generieren
   2173 hu      |* Opci -g: Maszk generlsa tesztknt
   2174 TX=de   |<tgzfile>: tgz-Datei mit der Maske (angelegt mit screen_export.sh)
   2174 hu      |<tgzfile>: tgz fjl a maszkkal (screen_export.sh-val kerlt felvitelre)
   2175 TX=de   |muss nur angegeben werden, wenn die Maske mit einer anderen Nummer oder Prioritt importiert werden soll
   2175 hu      |csak akkor kell megadni, ha a maszk egy msik szmmal vagy prioritssal kerljn importlsra
   2176 TX=de   |Datei $dname fehlt in $tgzfile
   2176 hu      |$dname fjl hinyzik a $tgzfile-ban
   2177 TX=de   |Bestimmung der Dateinummer zur Maskennummer $mymasknr gescheitert
   2177 hu      |A fjlszm meghatrozsa a $mymasknr maszkszmhoz nem sikerlt
   2178 TX=de   |Maske $MASKNR Prioritt $PRIO importieren
   2178 hu      |$MASKNR maszk $PRIO priorits importlsa
   2179 TX=de   |Datei $tgzfile existiert nicht
   2179 hu      |$tgzfile fjl nem ltezik
   2180 TX=de   |$tgzfile: Maskennummer oder Prioritt kann nicht bestimmt werden
   2180 hu      |$tgzfile: Maszkszm vagy priorits nem meghatrozhat
   2181 TX=de   |Datei $tgzfile kann nicht ausgepackt werden
   2181 hu      |$tgzfile fjl nem kicsomagolhat
   2182 TX=de   |Es knnen nur Masken importiert werden, die in der neuen Maskenbeschreibung vorliegen.
   2182 hu      |Csak olyan maszkok importlhatk, amik az j maszklersban llnak rendelkezsre.
   2183 TX=de   |Import erfolgreich
   2183 hu      |Import sikeres
   2184 TX=de   |Generierung der Maske $mask gescheitert
   2184 hu      |A $mask maszk generlsa nem sikerlt
"******** shadowinit.sh ********
   2185 TX=de   |${einrueck}Mandant $mand wird fr Abgleich wieder freigegeben
   2185 hu      |${einrueck}Mandant $mand a szinkronizcihoz ismt tadsra kerl
   2186 TX=de   |${einrueck}Mandant $source wird fr Abgleich wieder freigegeben
   2186 hu      |${einrueck}Mandant $source a szinkronizcihoz ismt tadsra kerl
   2187 TX=de   |Datei schattenmand.cfg wird nach $remote_target zurckkopiert
   2187 hu      |schattenmand.cfg fjl visszamsolsra kerl a $remote_target-be
   2188 TX=de   |KEINER-Sperre in Client $remote_target wird aufgehoben
   2188 hu      |KEINER zrlat a $remote_target kliensben megszntetsre kerl
   2189 TX=de   |Nach Korrektur des Fehlers kann Script $name mit Option -a NO gestartet werden
   2189 hu      |A hiba javtsa utn a $name script a kvetkez opcival: -a NO elindthat
   2190 TX=de   |Mit host:pfad kann auch ein Zielmandantenverzeichnis auf
   2190 hu      |A host:pfad-dal megadhat egy cl mandantknyvtr egy
   2191 TX=de   |einem anderem Rechner angegeben werden. target_homedir wird stets ohne
   2191 hu      |msik szmtgpen is. A target_homedir mindig host nlkl
   2192 TX=de   |host angegeben. Kopier- und Zugangskommando (rsync und ssh) zu dem
   2192 hu      |kerl megadsra. A msolsi s hozzfrsi parancs (rsync s ssh)
   2193 TX=de   |anderen Rechner sind durch die Schlsselwrter CpCommand und
   2193 hu      |a msik szmtgphez a CpCommand s ShCommand kulcsszavakon
   2194 TX=de   |ShCommand in schattenmand.cfg nderbar.
   2194 hu      |keresztl mdosthatk a schattenmand.cfg-ben.
   2195 TX=de   |* Option -n: Initialisierung des Servers
   2195 hu      |* Opci -n: A szerver inicializlsa
   2196 TX=de   |1    : Server fr Abgleich initialisieren.
   2196 hu      |1    : Szervert inicializlni szinkronizcihoz.
   2197 TX=de   |0    : Server nicht fr Abgleich initialisieren.
   2197 hu      |0    : Szervert nem inicializlni szinkronizcihoz.
   2198 TX=de   |(Wenn der Server aktuell weitere Schattenmandanten bedient,
   2198 hu      |(Ha a szerver aktulisan tovbbi rnykmandantokat szolgl ki,
   2199 TX=de   |die nicht neu initialisiert werden sollen)
   2199 hu      |amik ne kerljenek jra inicializlsra)
   2200 TX=de   |* Option -a: Umfang der Mandantenkopie: DB|STDFOP|ALL|NO|SDIR
   2200 hu      |* Opci -a: A mandantmsolat terjedelme: DB|STDFOP|ALL|NO|SDIR
   2201 TX=de   |DB    : Datenbank
   2201 hu      |DB    : Adatbank
   2202 TX=de   |STDFOP: Standard-FOPs
   2202 hu      |STDFOP: standard FOP-ok
   2203 TX=de   |ALL   : Komplettes Mandantenverzeichnis (Default)
   2203 hu      |ALL   : Komplett mandant-knyvtr (Default)
   2204 TX=de   |SDIR  : Es wird nur Verzeichnis abasbase kopiert
   2204 hu      |SDIR  : Csak az abasbase knyvtr kerl msolsra
   2205 TX=de   |Option bei Fehlern in der Datenbankstruktur des Clients
   2205 hu      |Opci hibknl a kliens adatbzis struktrjban
   2206 TX=de   |NO    : Es wird nichts kopiert.
   2206 hu      |NO    : Semmi sem kerl msolsra.
   2207 TX=de   |Option, wenn nach dem Kopieren ein Fehler passierte.
   2207 hu      |Opci, ha a msols utn hiba trtnt.
   2208 TX=de   |* Option -s: Quellmandantenverzeichnis
   2208 hu      |* Opci -s: Forrs mandantknyvtr
   2209 TX=de   |* Option -t: Zielmandantenverzeichnis
   2209 hu      |* Opci -t: Cl mandantknyvtr
   2210 TX=de   |* Option -h: HOMEDIR des Zielmandanten.
   2210 hu      |* Opci -h: A clmandant HOMEDIR-je
   2211 TX=de   |Fehlt dieses, wird versucht, es aus der Umgebung im Zielmandantenverzeichnis zu bestimmen
   2211 hu      |Ha ez hinyzik, akkor ksrlet trtnik a meghatrozsra a krnyezetbl a cl mandant knyvtrban
   2212 TX=de   |Erlaubte Argumente fr Option -n: 0 oder 1
   2212 hu      |Megengedett argumentumok az -n opcihoz: 0 vagy 1
   2213 TX=de   |Quellmandant und Zielmandant mssen angegeben werden
   2213 hu      |Forrs mandantot s cl mandantot meg kell adni
   2214 TX=de   |Option -n muss angegeben werden
   2214 hu      |-n opcit meg kell adni
   2215 TX=de   |Argument $mandcopy_umfang fr Mandantenkopie nicht erlaubt
   2215 hu      |$mandcopy_umfang argumentum mandant msolshoz nem megengedett
   2216 TX=de   |Quellverzeichnis $source nicht gefunden
   2216 hu      |$source forrsknyvtr nem tallhat
   2217 TX=de   |Es werden keine Daten kopiert
   2217 hu      |Nem kerlnek adatok msolsra
   2218 TX=de   |Kopieren beendet
   2218 hu      |Msols befejezve
   2219 TX=de   |Client $remote_target initialisiert
   2219 hu      |$remote_target kliens inicializlva
   2220 TX=de   |Sperren von Server $source fuer Schattenmandantabgleich
   2220 hu      |$source szerver zrolsa rnykmandant szinkronizcihoz
   2221 TX=de   |Sichern von $remote_target/schattenmand.cfg
   2221 hu      |$remote_target/schattenmand.cfg mentse
   2222 TX=de   |Ruecksichern von $remote_target/schattenmand.cfg
   2222 hu      |$remote_target/schattenmand.cfg visszamentse
   2223 TX=de   |${einrueck}schattenmand.cfg wurde aus $remote_target nach $rmdir gesichert
   2223 hu      |${einrueck}schattenmand.cfg $remote_target-bl $rmdir-be kerlt mentsre
   2224 TX=de   |${einrueck}schattenmand.cfg wurde fuer $target in $rmdir erzeugt
   2224 hu      |${einrueck}schattenmand.cfg $target-hez $rmdir-ben kerlt ltrehozsra
   2225 TX=de   |${einrueck}Kopiere $source/abasbase nach $remote_target/abasbase/smdir
   2225 hu      |${einrueck}Msols $source/abasbase $remote_target/abasbase/smdir-be
   2226 TX=de   |${einrueck}Kopiere Mandant $source nach $remote_target (Umfang=$mandcopy_umfang)
   2226 hu      |${einrueck}Msols $source mandant $remote_target-be (terjedelem=$mandcopy_umfang)
   2227 TX=de   |${einrueck}Abgleichstatus des Verzeichnisses $zielverz in $ld eingetragen
   2227 hu      |${einrueck}Szinkronizci sttust a $zielverz knyvtrnak a $ld-be berni
   2228 TX=de   |${einrueck}Zielverzeichnis $load_directory wird angelegt, falls nicht vorhanden
   2228 hu      |${einrueck}Clknyvtr $load_directory felvitelre kerl, ha nem ll rendelkezsre
   2229 TX=de   |Fehler: rc=$rc bei $cmd
   2229 hu      |Hiba: Returncode=$rc $cmd nl
   2230 TX=de   |Siehe auch $rmdir/sm.out und/oder $rmdir/sm.err
   2230 hu      |Lsd $rmdir/sm.out-ot s/vagy $rmdir/sm.err-t is
"******** shadowlock.sh ********
   2231 TX=de   |manddir: Mandantenverzeichnis
   2231 hu      |manddir: Mandant-knyvtr
   2232 TX=de   |* Option -s: Sperren des Mandanten fr den Abgleich
   2232 hu      |* Opci -s: A mandant zrolsa a szinkronizcihoz
   2233 TX=de   |* Option -e: Freigeben des Mandanten fr den Abgleich
   2233 hu      |* Opci -e: A mandant jvhagysa a szinkronizcihoz
   2234 TX=de   |pid  : Identifikation des Sperreintrags
   2234 hu      |pid  : A zrlat bevitel azonostsa
   2235 TX=de   |Muss bei lschen und setzen der Sperre angegeben werden
   2235 hu      |Meg kell adni a zrlat trlsnl s elhelyezsnl
   2236 TX=de   |* Option -b:
   2236 hu      |* Opci -b:
   2237 TX=de   |descr: Grund fr die Sperrung. Muss beim Setzen der Sperre angegeben werden
   2237 hu      |descr: A zrols oka. A zrlat elhelyezsnl kell megadni
   2238 TX=de   |* Option -t: Testen, ob Mandant fr Abgleich gesperrt ist:
   2238 hu      |* Opci -t: Tesztels, hogy a mandant a szinkronizcihoz zrolva van-e:
   2239 TX=de   |$? = 0 -> Abgleich freigegeben
   2239 hu      |$? = 0 -> Szinkronizci jvhagyva
   2240 TX=de   |$? = 1 -> Abgleich gesperrt
   2240 hu      |$? = 1 -> Szinkronizci zrolva
   2241 TX=de   |* Option -r: Sperre wird in jedem Fall gelscht
   2241 hu      |* Opci -r: A zrlat minden esetben trlsre kerl
   2242 TX=de   |* Option -l: Auflisten der Sperren fr einen oder alle Mandanten (manddir leer)
   2242 hu      |* Opci -l: A zrlatok felsorolsa egy vagy az sszes mandanthoz (manddir res)
   2243 TX=de   |Eine der Optionen -s, -e, -t, -r oder -l muss angegeben werden
   2243 hu      |Az -s, -e, -t, -r vagy -l opcik egyikt meg kell adni
   2244 TX=de   |Zu Optionen -s muss Sperrgrund (-b) angegeben werden
   2244 hu      |Az -s opcikhoz meg kell adni a zrlat okt (-b)
   2245 TX=de   |$MDIR ist kein Verzeichnis
   2245 hu      |$MDIR nem knyvtr
   2246 TX=de   |Mandant $d nicht gesperrt
   2246 hu      |$d mandant nincs zrolva
   2247 TX=de   |Variable MANDANTDIR in $MDIR kann mit envmake nicht bestimmt werden
   2247 hu      |MANDANTDIR vltoz $MDIR-ben envmake-vel nem hatrozhat meg
   2248 TX=de   |envmake -b $MDIR aufrufen
   2248 hu      |envmake -b $MDIR felhvsa!
   2249 TX=de   |In $my_mandantdir sind keine Sperren gesetzt
   2249 hu      |A $my_mandantdir-ben nincsenek elhelyezve zrlatok
   2250 TX=de   |Sperre ist nicht korrekt gesetzt und kann nur mit Option -r entfernt werden
   2250 hu      |A zrlat nincs korrekten elhelyezve s csak az -r opcival tvolthat el
   2251 TX=de   |Mandant $MDIR bereits mit pid=$SPERR_ID gesperrt
   2251 hu      |$MDIR mandant mr pid=$SPERR_ID-vel zrolva
"******** shorten.sh ********
   2252 TX=de   |* Option -i: Eingabedatei, default = stdin
   2252 hu      |* -i opci: bemeneti file, default = stdin
   2253 TX=de   |* Option -o: Ausgabedatei, default = stdout
   2253 hu      |* -o opci: kimeneti file, default = stdout
"******** sichern.sh ********
   2254 TX=de   |Datenbestand eines Mandanten (auch einzelne Dateien)
   2254 hu      |Egy mandant adatai (egyedi adatok is)
   2255 TX=de   |Pfade der Sicherung zusammenstellen
   2255 hu      |Az elrsi utak sszellitsa adatlementshez
   2256 TX=de   |Beim Sichern mu der Mandant $MANDANT unterbrochen sein!
   2256 hu      |Adatmentsnl a  $MANDANT \"mandant\"-ot ki kell lptetni!
   2257 TX=de   |Name der zu sichernden Datei (oder <enter>, wenn
   2257 hu      |A lementend llomny neve (vagy <enter>, ha
   2258 TX=de   |alle Dateien im Mandant $MANDANT gesichert werden sollen) :
   2258 hu      | $MANDANT \"mandant\" sszes adatllomnyt el kell menteni) :
   2259 TX=de   |Sichern starten?
   2259 hu      |Ments indul?
   2260 TX=de   |`abstorel $HOMEDIR/zeit` nicht gefunden!
   2260 hu      |`abstorel $HOMEDIR/zeit` nem tallhat!
   2261 TX=de   |Zum Sichern muss man im Verzeichnis \"/\" stehen.
   2261 hu      |A mentshez a \"/\" knyvtrban kell llnunk.
   2262 TX=de   |Sichern erfolgreich beendet
   2262 hu      |Ments sikeresen befejezdtt.
   2263 TX=de   |Sichern abgebrochen
   2263 hu      |Ments abortlva.
   2264 TX=de   |Sicherung fehlgeschlagen, Status
   2264 hu      |Ments sikertelen, llapot:
"******** slpimport.sh ********
   2265 TX=de   |Adressenstamm importieren.
   2265 hu      |Cmtrzs importlsa.
   2266 TX=de   |-s: Importverzeichnis
   2266 hu      |-s: Import knyvtr
   2267 TX=de   |Empfangsverzeichnis existiert nicht!
   2267 hu      |Fogad knyvtr nem ltezik!
"******** start_mandanten.sh ********
   2268 TX=de   |Freigeben aller Mandanten gescheitert
   2268 hu      |sszes mandant felszabadtsa sikertelen
   2269 TX=de   |Ursache siehe $log_datei
   2269 hu      |Oka lsd $log_datei
   2270 TX=de   |Datei `pwd`/denv.sh fehlt - Programm $name muss im HOMEDIR aufgerufen werden
   2270 hu      |`pwd`/denv.sh fjl hinyzik - $name programot le kell hvni a HOMEDIR-ben
"******** starte_gc.sh ********
   2271 TX=de   |* Option -p: Ausgabe aller Umgebungsvariablen und Zustnde,
   2271 hu      |* opci -p: sszes krnyezeti vltoz s llapot kiadsa,
   2272 TX=de   |die fr die GC relevant sind.
   2272 hu      |amik a GC szmra relevnsak.
   2273 TX=de   |Fehler: Returncode=$l1_rc bei $1
   2273 hu      |Hiba: Returncode=$l1_rc $1 nl
   2274 TX=de   |Bezugspunkt aus $rmdir/l5_gc nicht bestimmbar
   2274 hu      |Hivatkozsi pont $rmdir/l5_gc-bl nem meghatrozhat
   2275 TX=de   |$l4_toba_out ist kein CHECKPUNKT1
   2275 hu      |$l4_toba_out nem CHECKPUNKT1
   2276 TX=de   |Bezugspunkt zu GC-Eintrag an $(cat $rmdir/l2_log1_gc_la) nicht bestimmbar
   2276 hu      |Hivatkozsi pont GC bevitelhez $(cat $rmdir/l2_log1_gc_la) -hoz nem meghatrozhat
   2277 TX=de   |Anzahl Segmente in Log0 nicht bestimmbar
   2277 hu      |Szegmensek szma Log0-ban nem meghatrozhat
   2278 TX=de   |ddatrep1 lieferte estate=$rc. Siehe $rmdir/ddatrep1.d12b0zr.log oder $gclog
   2278 hu      |ddatrep1 estate=$rc-t hozott. Lsd $rmdir/ddatrep1.d12b0zr.log vagy $gclog
   2279 TX=de   |Generation muss 0 oder 1 sein
   2279 hu      |Genercinak 0-nak vagy 1-nek kell lennie
   2280 TX=de   |Option -p erst ab Version 2003r4 verwendbar
   2280 hu      |A -p opci csak a 2003r4-es verzitl hasznlhat
   2281 TX=de   |Variable platz_$x konnte nicht berechnet werden
   2281 hu      |platz_$x vltozt nem lehetett kiszmtani
   2282 TX=de   |Gre von $mandverz/abasbase/db.dat nicht bestimmbar
   2282 hu      |$mandverz/abasbase/db.dat nagysga nem meghatrozhat
   2283 TX=de   |Anzahl Segmente in Log1 nicht bestimmbar ($rmdir/log1_info)
   2283 hu      |Szegmensek szma Log1-ben nem meghatrozhat ($rmdir/log1_info)
   2284 TX=de   |Hchstes Segment in Log1 nicht bestimmbar ($rmdir/log1_info)
   2284 hu      |Legnagyobb szegmens Log1-ben nem meghatrozhat ($rmdir/log1_info)
   2285 TX=de   |Keine Ausgabe mglich, da noch keine Log1-GC stattfand
   2285 hu      |Nem lehetsges kiads, mivel mg nem ment vgbe Log1-GC
   2286 TX=de   |Nettodatenbestand:
   2286 hu      |Nett adatkszlet:
   2287 TX=de   |Von Datenbank belegter Platz:
   2287 hu      |Adatbank ltal befedett hely:
   2288 TX=de   |(4 * Nettodatenbestand) - von Datenbank belegter Platz =
   2288 hu      |(4 * Nett adatkszlet) - Adatbank ltal befedett hely =
   2289 TX=de   |zum Betrieb ntiger freier Platz:
   2289 hu      |A mkdshez szksges szabad hely:
   2290 TX=de   |vorhandener freier Platz:
   2290 hu      |Meglv szabad hely:
   2291 TX=de   |Anzahl MegaBytes (ohne letzte Log0-Datei) fr Start der Log0-GC:
   2291 hu      |A megabyte-ok szma (utols Log0 fjl nlkl) a Log0 GC indtshoz:
   2292 TX=de   |Maximaler sinnvoller Wert fr ANZ_BYTES_FUER_GC0_STRATEGIE:
   2292 hu      |Maximum sszer rtk az ANZ_BYTES_FUER_GC0_STRATEGIE-hez:
   2293 TX=de   |Anzahl Segmente in Log0:
   2293 hu      |Szegmensek szma Log0-ban:
   2294 TX=de   |Log1-GC Faktor (Log1-GC luft los, wenn
   2294 hu      |Log1-GC faktor (Log1-GC futni kezd, ha
   2295 TX=de   |Faktor * Anzahl Segm. seit letzter GC > Gesamtzahl Segm.):
   2295 hu      |faktor * szegmensek szma az utols GC ta > szegmensek sszmennyisge):
   2296 TX=de   |Anzahl Segmente in Log1 seit letzter Log1-GC
   2296 hu      |Szegmensek szma Log1-ben utols Log1-GC ta
   2297 TX=de   |Gesamtanzahl Segmente in Log1
   2297 hu      |Szegmensek sszmennyisge Log1-ben
"******** stdinfosys_delivery.sh ********
   2298 TX=de   |Schritt 1 - Voraussetzungen
   2298 hu      |Lps 1 - Elfelttelek
   2299 TX=de   |Schritt 2 - Upgrade Stammdaten
   2299 hu      |2. lps - trzsadatok frisstse
   2300 TX=de   |Schritt 3 - Nacharbeiten
   2300 hu      |Lps 3 - Utmunklatok
   2301 TX=de   |Benutzername
   2301 hu      |Felhasznli nv
   2302 TX=de   |Teste auf Mandantenverzeichnis
   2302 hu      |Tesztels mandantknyvtron
   2303 TX=de   |Abzuschaffende Infosysteme gefunden
   2303 hu      |Megszntetend infosystemek tallhatk
   2304 TX=de   |Vorgegebene Liste der zu aktualisierenden Infosysteme
   2304 hu      |Az aktualizland infosystemek megadott listja
   2305 TX=de   |Zu aktualisierende Infosysteme gefunden
   2305 hu      |Aktualizland infosystemek tallhatk
   2306 TX=de   |Neu zu installierende Infosysteme gefunden
   2306 hu      |Installland infosystemek tallhatk
   2307 TX=de   |Schaffe ab
   2307 hu      |Megszntets
   2308 TX=de   |Aktualisiere
   2308 hu      |aktualizlt
   2309 TX=de   |Installiere
   2309 hu      |Installls
   2310 TX=de   |Suche Infosysteme mit automatischer Layoutentstehung
   2310 hu      |Infosystemek keresse automatikus layout eredettel
   2311 TX=de   |Es gibt kein Infosystem mit automatischer Layoutentstehung
   2311 hu      |Nincs infosystem automatikus layout eredettel
   2312 TX=de   |Start
   2312 hu      |Start
   2313 TX=de   |Nicht gefordert
   2313 hu      |Nem krve
   2314 TX=de   |Fehlschlag
   2314 hu      |Sikertelensg
   2315 TX=de   |Installiert Infosysteme aus dem Lieferumfang
   2315 hu      |Infosystemek installlsa az alapcsomagbl
   2316 TX=de   |* Option -v: Wortreicher Reportmodus
   2316 hu      |* Opci -v: Beszdes report md
   2317 TX=de   |* Option -q: Keine Hinweismeldungen ausgeben
   2317 hu      |* Opci -q: Nincsenek zenetek
   2318 TX=de   |* Option -c: Standort auf Mandantenverzeichnis testen
   2318 hu      |* Opci -c: Hely tesztelse mandantknyvtrra
   2319 TX=de   |* Option -u: Infosystemstammdaten upgraden
   2319 hu      |* Opci -u: Infosystem trzsadatok frisstse
   2320 TX=de   |Das Upgrade entfernt veraltete, aktualisiert installierte
   2320 hu      |A frissts eltvoltja az elavultakat, aktualizlja az installltakat
   2321 TX=de   |und importiert neue bzw. noch nicht vorhandene Infosysteme
   2321 hu      |importl j, ill. mg nem meglv infosystemeket
   2322 TX=de   |* Option -t: Die Schritte des Upgrades (-u) jeweils in einer Transaktion bearbeiten
   2322 hu      |* Opci -t: A frissts (-u) lpseinek szerkesztse egy tranzakciban
   2323 TX=de   |* Option -l: Layouts mit automatischem Ursprung erzeugen
   2323 hu      |* Opci -l: Layoutok ltrehozsa automatikus eredettel
   2324 TX=de   |* Option -s: Infosystemliste
   2324 hu      |* Opci -s: Infosystemlistval
   2325 TX=de   |Beim Abschaffen der Infosysteme ist ein Fehler aufgetreten
   2325 hu      |Az infosystemek megszntetsekor hiba lpett fel
   2326 TX=de   |Beim Versionswechsel der Infosysteme ist ein Fehler aufgetreten
   2326 hu      |Az infosystemek verzivltsakor hiba lpett fel
   2327 TX=de   |Beim Neuanlegen der Infosysteme ist ein Fehler aufgetreten
   2327 hu      |Az infosystemek felvitelekor hiba lpett fel
   2328 TX=de   |Die angegebene Datei $file wurde nicht gefunden!
   2328 hu      |A megadott $file fjlnv nem volt megtallhat!
   2329 TX=de   |Die angegebene Datei $file ist leer!
   2329 hu      |$file res!
   2330 TX=de   |Nichts zu tun
   2330 hu      |Nincs mit tenni
   2331 TX=de   |Skript darf nicht als root benutzt werden
   2331 hu      |Script nem hasznlhat root-knt
   2332 TX=de   |Datei $HOMEDIR/files.txt fehlt oder ist leer
   2332 hu      |$HOMEDIR/files.txt fjl hinyzik vagy res
   2333 TX=de   |Fehler beim Bestimmen der installierten Infosysteme
   2333 hu      |Hiba az installlt infosystemek meghatrozsnl
   2334 TX=de   |Fehler beim Bestimmen der Infosysteme mit automatischer Layoutentstehung
   2334 hu      |Hiba az automatikus layout eredettel rendelkez infosystemek meghatrozsnl
"******** stillstand.sh ********
   2335 TX=de   |Mandant $MANDANT zur Zeit gesperrt.
   2335 hu      |$MANDANT \"mandant\" egyelre zrolva.
   2336 TX=de   |Abbrechen eines Bildschirms deshalb nicht mglich.
   2336 hu      |Egy kperny-megszakts miatt nem lehetsges.
   2337 TX=de   |Prozesse ermitteln, Schirm:
   2337 hu      |Processzek meghatrozsa, kperny:
   2338 TX=de   |Bildschirm auswhlen
   2338 hu      |Kpernyvlaszts
   2339 TX=de   |Prozesse an diesem Bildschirm abbrechen?
   2339 hu      |A kperny sszes processze kilp?
   2340 TX=de   |Nr Startzeit Schnittstelle Rechner Zeichen Standort
   2340 hu      |Sz Kezd id Interfsz  Szmtgp  Jel    Telephely
   2341 TX=de   |Auswahl:
   2341 hu      |Kivlaszts:
   2342 TX=de   |Im Mandanten $MANDANT sind keine Bildschirme abzubrechen
   2342 hu      |A $MANDANT \"mandant\"-ban nincs megszaktand kperny.
   2343 TX=de   |Keine Sitzung abbrechen (nur aufrumen)
   2343 hu      |Munkafzist nem megszaktani (csak kitakartani)
   2344 TX=de   |Einen Anwendungprozess abbrechen
   2344 hu      |Felhasznli folyamat megszaktsa
   2345 TX=de   |Sitzung komplett abbrechen
   2345 hu      |Munkafzis komplett megszaktsa
   2346 TX=de   |Wiederanlauf fr den ganzen Mandanten
   2346 hu      |Az egsz mandant jraindtsa
   2347 TX=de   |Im Mandanten $MANDANT wird nur aufgerumt
   2347 hu      |Az $MANDANT mandantban kitakartok.
   2348 TX=de   |Wiederanlauf fr den ganzen Mandanten durchfhren?
   2348 hu      |Az egsz mandant jraindtsnak vgrehajtsa?
   2349 TX=de   |Wiederanlauf luft, bitte warten
   2349 hu      |jraindts megtrtnt, krem vrjon...
"******** stillstand_beenden.sh ********
   2350 TX=de   |Bitte  beenden Sie  alle  Arbeiten in Ihren  Mandanten, die  sich noch beenden
   2350 hu      |Krem fejezze be a munkt azoknl a \"mandant\"-oknl, amelyeknl ez mg lehetsges,
   2351 TX=de   |lassen, und  warten Sie auf das Ende laufender  Druckausgabe. Stehengebliebene
   2351 hu      |s vrja meg a nyomtats befejezdst. Lehet, hogy a lellt nyomtatt a kvet-
   2352 TX=de   |Drucker bentigen evtl. von Hand einen Papiervorschub bis zum nchst. Seiten-
   2352 hu      |kez oldal elejig val kzi paprtovbbtssal ismt el lehet indtani. A
   2353 TX=de   |anfang. Laufende Druckauftrge werden nach dem Wiederanlauf von vorn begonnen.
   2353 hu      |folyamatban lev nyomtatst a nyomtat az jraindts utn ismt ellrl kezdi.
"******** stillstand_warnung.sh ********
   2354 TX=de   |Wiederanlauf nach Programmstillstand
   2354 hu      |Programlells utni jraindts
   2355 TX=de   |* WARNUNG: Datenstze, die noch in Bearbeitung sind, knnen   *
   2355 hu      |* FIGYELEM: Feldolgozs alatt ll rekordok                   *
   2356 TX=de   |*          durch diese Funktion beschdigt werden!            *
   2356 hu      |*          ettl a funkcitl megsrlhetnek!                 *
"******** stop_mandanten.sh ********
   2357 TX=de   |Sperren aller Mandanten gescheitert
   2357 hu      |sszes mandant zrlata sikertelen
   2358 TX=de   |Kann Datei nicht verschieben: $freigeben_tmp
   2358 hu      |Fjl nem eltolhat: $freigeben_tmp
"******** sysflogana.sh ********
   2359 TX=de   |* Option -k: Kriterium der Form NAME=WERT, auch mehrfach. Mgliche Namen:
   2359 hu      |* Opci -k: NAME=WERT formj kritrium, tbbszr is. Lehetsges nevek:
   2360 TX=de   |FROM/TO   Von/Bis-Zeitpunkt (JJJJMMTThhmm), auch partiell
   2360 hu      |FROM/TO   Tl/Ig idpont (HHNNhhmm), rszlegesen is
   2361 TX=de   |PROG      Liste mit Programmnamen, Komma getrennt
   2361 hu      |PROG      Lista programnevekkel, vesszvel elvlasztva
   2362 TX=de   |FNR       Liste mit Abas Systemfehlernummern, Komma getrennt
   2362 hu      |FNR       Lista Abas rendszerhiba szmokkal, vesszvel elvlasztva
   2363 TX=de   |* Option -v: verbose, mehr Infos zur Diag ausgeben
   2363 hu      |* Opci -v: Bbeszd (verbose), tbb informci kiadsa a prbeszdhez
   2364 TX=de   |* Option -l: Zeilennummer in analysierter Datei ausgeben
   2364 hu      |* Opci -l: Sorszm kiadsa elemzett fjlban
"******** syslog.sh ********
   2365 TX=de   |* Argument from: Datum in der Form YYYYMMDDhhmm
   2365 hu      |* Argument from: Dtum a YYYYMMDDhhmm formban
   2366 TX=de   |* Argument to: Datum in der Form YYYYMMDDhhmm
   2366 hu      |* Argument to: Dtum a YYYYMMDDhhmm formban
   2367 TX=de   |* Option -m: dir: Mandantenverzeichnis
   2367 hu      |* Opci -m: dir: Mandantknyvtr
   2368 TX=de   |Wird fr die bersetzung der Nummern in Kommandonamen und
   2368 hu      |A szmok fordtshoz parancsnevekben s
   2369 TX=de   |Zusatztabellennamen gebraucht. Falls nicht angegeben,
   2369 hu      |kiegszt adatbank nevekben kerl hasznlatra. Ha nincs megadva,
   2370 TX=de   |fehlen evtl. ein paar bersetzungen und es werden in diesem
   2370 hu      |esetleg hinyzik pr fordts
   2371 TX=de   |Fall Nummern statt Namen ausgegeben
   2371 hu      |kerlnek kiadsra nevek helyett
   2372 TX=de   |* Option -d: fn: Dateinummer, die betrachtet werden soll
   2372 hu      |* Opci -d: fn: Fjlszm, ami szemgyre vtelre kerljn
   2373 TX=de   |kann mehrfach angegeben werden
   2373 hu      |tbbszr megadhat
   2374 TX=de   |* Option -n: count: Anzahl Ergebniszeilen (Default = 10)
   2374 hu      |* Opci -n: count: Eredmnysorok szma (Default = 10)
   2375 TX=de   |* Option -k: com: Kommando, das betrachtet werden soll
   2375 hu      |* Opci -k: com: Utasts, ami szemgyre vtelre kerljn
   2376 TX=de   |es muss als normierter String angegeben werden,
   2376 hu      |Normalizlt string-knt kell megadni,
   2377 TX=de   |Option kann mehrfach angegeben werden
   2377 hu      |az opci tbbszr megadhat
   2378 TX=de   |Liste aller Kommandos mit $name -k list erhltlich
   2378 hu      |Az sszes parancs listja az $name -k list paranccsal kaphat
   2379 TX=de   |* Option -f: Statt log/SYS* nur die Datei file im Mandantenverzeichnis verwenden
   2379 hu      |* Opci -f: log/SYS helyett file fjl hasznlata a mandantknyvtrban
   2380 TX=de   |* Option -c: Ausgabe im csv (comma separated values) Format
   2380 hu      |* Opci -c: Kiads csv (comma separated values) formtumban
   2381 TX=de   |* Option -a: awk statt s3look verwenden (nur zum testen)
   2381 hu      |* Opci -a: s3look helyett awk hasznlata (csak tesztelshez)
   2382 TX=de   |* Option -t: debug (nur rmdir wird aufgehoben)
   2382 hu      |* Opci -t: debug (csak rmdir kerl megszntetsre)
   2383 TX=de   |set -x kann ber sh -x $name erreicht werden
   2383 hu      |set -x az sh -x $name parancson keresztl rhet el
   2384 TX=de   |Hinweis: Fortschrittsanzeige auf stderr ausser auf Windows
   2384 hu      |Utals: Folyamatmegjelents stderr-on kivve Windows-on
   2385 TX=de   |Fehler $rc bei sed
   2385 hu      |Hiba $rc sed-nl
   2386 TX=de   |Datum $datum nicht von der Form YYYYMMDDhhmm
   2386 hu      |$datum dtum nem YYYYMMDDhhmm formj
   2387 TX=de   |Datei $vorgegebenes_syslog in $aktdir leer oder nicht vorhanden
   2387 hu      |$vorgegebenes_syslog fjl $aktdir-ben res vagy nem ltezik
   2388 TX=de   |Datei $vorgegebenes_syslog in $aktdir nicht lesbar
   2388 hu      |$vorgegebenes_syslog fjl $aktdir-ben nem olvashat
   2389 TX=de   |Keine passenden SYS* Dateien in Verzeichnis $(pwd)/$logdir) gefunden
   2389 hu      |Nem tallhatk megfelel SYS* fjlok a $(pwd)/$logdir) knyvtrban
   2390 TX=de   |Dateien
   2390 hu      |Fjlok
   2391 TX=de   |von
   2391 hu      |-tl
   2392 TX=de   |Kommandos mit hchsten Zugriffszahlen
   2392 hu      |Utastsok legmagasabb hozzfrsi szmokkal
   2393 TX=de   |Die am meisten ausgefhrten Kommandos
   2393 hu      |A legtbbszr vgrehajtott utastsok
   2394 TX=de   |Dateien mit hchsten Zugriffszahlen ber alle Kommandos
   2394 hu      |Fjlok legmagasabb hozzfrsi szmokkal szes utastsra vonatkozan
   2395 TX=de   |DB-Zugriffe
   2395 hu      |AB-hozzfrsek
   2396 TX=de   |Anmeldungen (keine exakten Werte)
   2396 hu      |Bejelentkezsek (nem egzakt rtkek)
   2397 TX=de   |Gesamtzahlen(ohne Anmeldungen)
   2397 hu      |sszmennyisgek (bejelentkezsek nlkl)
   2398 TX=de   |Einzelkommandos mit hchsten Zugriffszahlen
   2398 hu      |Egyenknti utastsok legmagasabb hozzfrsi szmokkal
"******** system_watch.sh ********
   2399 TX=de   |Datumsangabe ungltig
   2399 hu      |Dtum adat rvnytelen
   2400 TX=de   |Zeitangabe ungltig
   2400 hu      |Id adat rvnytelen
   2401 TX=de   |* Argument: clientdir1 clientdir2 ...
   2401 hu      |* Argument: clientdir1 clientdir2 ...
   2402 TX=de   |Mandantenverzeichnisse fr die folgende Protokolle erzeugt werden:
   2402 hu      |Mandantknyvtrak, amikhez a kvetkez jegyzknyvek kerlnek ltrehozsra:
   2403 TX=de   |Aufrufertabelle(pa.dat), Sperrtabelle, dattop.sh
   2403 hu      |Lehv tblzat (pa.dat), zrlattblzat, dattop.sh
   2404 TX=de   |* Optionen -v, -t, -d, -s, -p: Zeitintervall in Sekunden fr die Programme:
   2404 hu      |* Opcik -v, -t, -d, -s, -p: Idintervallum msodpercben a programokhoz:
   2405 TX=de   |-v: vmstat (Default $vmstat_intervall Sekunden)
   2405 hu      |-v: vmstat (Default: $vmstat_intervall msodperc)
   2406 TX=de   |-t: top (Default $top_intervall Sekunden)
   2406 hu      |-t: top (Default: $top_intervall msodperc)
   2407 TX=de   |-i: iotop.sh (Default $iotop_intervall Sekunden)
   2407 hu      |-i: iotop.sh (Default: $iotop_intervall msodperc)
   2408 TX=de   |-d: dattop.sh (Default $dattop_intervall Sekunden)
   2408 hu      |-d: dattop.sh (Default: $dattop_intervall msodperc)
   2409 TX=de   |-s: Ausgabe der Sperrtabelle (Default $sperrtab_intervall Sekunden)
   2409 hu      |-s: A zrlattblzat kiadsa (alaprtelmezett $sperrtab_intervall msodperc)
   2410 TX=de   |-p: Ausgabe der Aufrufertabelle (Default $padat_intervall Sekunden)
   2410 hu      |-p: A lehv tblzat kiadsa (alaprtelmezett $padat_intervall msodperc)
   2411 TX=de   |Zeitangabe 0: Entsprechendes Programm nicht ausfhren
   2411 hu      |Id adat 0: Megfelel programot nem vgrehajtani
   2412 TX=de   |* Option -e: Zeitpunkt an dem sich $name beendet (YYYYMMDDhhmm)
   2412 hu      |* Opci -e: Idpont, amikor a $name befejezdik (YYYYMMDDhhmm)
   2413 TX=de   |* Option -w: Zeitdauer in Sekunden nach der sich $name beendet
   2413 hu      |* Opci -w: Idtartam msodpercben, ami utn a $name befejezdik
   2414 TX=de   |* Option -x: debug
   2414 hu      |* -x opci: debug
   2415 TX=de   |* Option -y: erweiterte Hinweise/Meldungen
   2415 hu      |* -y opci: kibvtett utalsok/zenetek
   2416 TX=de   |* Option -k: keine mandantenspezifischen Protokolle anlegen
   2416 hu      |* Opci -k: Mandant-specifikus jegyzknyveket nem felvinni
   2417 TX=de   |Datum $l1_datum nicht von der Form YYYYMMDDhhmm
   2417 hu      |$l1_datum dtum nem YYYYMMDDhhmm formj
   2418 TX=de   |Enddatum $l1_datum liegt in der Vergangenheit
   2418 hu      |A $l1_datum befejezsi dtum a mltban van
   2419 TX=de   |Kann Umgebung zu s3-Bereich $ORIG_HOMEDIR nicht herstellen
   2419 hu      |Nem ltrehozhat krnyezet a $ORIG_HOMEDIR s3 tartomnyhoz
   2420 TX=de   |Im Verzeichnis $(pwd) kann dattop.sh nicht gestartet werden
   2420 hu      |A $(pwd) knyvtrban a dattop.sh nem indthat el
   2421 TX=de   |Die weiteren Protokolle sind davon nicht betroffen
   2421 hu      |A tovbbi jegyzknyveket ez nem rinti
   2422 TX=de   |Ausgabedatei $l4_out fr vmstat Aufrufe existiert nicht mehr
   2422 hu      |$l4_out kiadsi fjl vmstat lehvsokhoz mr nem ltezik
   2423 TX=de   |Protokollierung von vmstat wird abgebrochen
   2423 hu      |A vmstat jegyzknyvezse megszaktsra kerl
   2424 TX=de   |Ausgabedatei $l6_out fr Datei pa.dat existiert nicht mehr
   2424 hu      |$l6_out kiadsi fjl pa.dat fjlhoz mr nem ltezik
   2425 TX=de   |Ausgabe von pa.dat wird abgebrochen
   2425 hu      |pa.dat kiadsa megszaktsra kerl
   2426 TX=de   |Datei $(pwd)/log/SYS nicht gefunden
   2426 hu      |$(pwd)/log/SYS nem talltam
   2427 TX=de   |Datei $(pwd)/log/SYS nicht lesbar
   2427 hu      |$(pwd)/log/SYS fjl nem olvashat
   2428 TX=de   |Ausgabedatei $l8_out fr Sperrtabellen existiert nicht mehr
   2428 hu      |$l8_out kiadsi fjl zrlattblzatokhoz mr nem ltezik
   2429 TX=de   |Protokollierung der Sperrtabellen wird abgebrochen
   2429 hu      |A zrlattblzatok jegyzknyvezse megszaktsra kerl
   2430 TX=de   |Ungltiger Parameter $l7_protokoll_funktion in Funktion ${<FUNCNAME[0]}
   2430 hu      |rvnytelen $l7_protokoll_funktion paramter ${<FUNCNAME[0]} funkciban
   2431 TX=de   |${FUNCNAME[0]}: Kann Umgebung in Verzeichnis $l7_cl_dir nicht herstellen
   2431 hu      |${FUNCNAME[0]}: Nem tud ltrehozni krnyezetet a $l7_cl_dir knyvtrban
   2432 TX=de   |Prozess $l7_protokoll_funktion in Verzeichnis $l7_cl_dir (ProzessId = $l7_pid) wurde nicht gestartet
   2432 hu      |$l7_protokoll_funktion folyamat a $l7_cl_dir knyvtrban (folyamat ID = $l7_pid) nem kerlt elindtsra
   2433 TX=de   |Abbruch!
   2433 hu      |Megszakts !
   2434 TX=de   |Erstelle Protokolle ber Datenbankzugriffszahlen
   2434 hu      |Jegyzknyvek ksztse adatbzis hozzfrsi szmokon keresztl
   2435 TX=de   |Kommando $l12_cmd endet mit Fehler $l12_tar_returncode
   2435 hu      |A $l12_cmd parancs a $l12_tar_returncode return kddal rendelkezett
   2436 TX=de   |Programm $l14_prog nicht gefunden
   2436 hu      |$l14_prog: Program nem tallhat
   2437 TX=de   |Sollverzeichnis $l14_progdir_soll und Istverzeichnis $l14_progdir_ist von Programm $l14_prog sind verschieden
   2437 hu      |A $l14_prog program $l14_progdir_soll cl knyvtra s $l14_progdir_ist tny knyvtra klnbz
   2438 TX=de   |Umgebungsvariable HOMEDIR (s3-Bereich) nicht gesetzt
   2438 hu      |HOMEDIR krnyezeti vltoz (s3 tartomny) nincs elhelyezve
   2439 TX=de   |HOMEDIR=$ORIG_HOMEDIR ist kein Verzeichnis
   2439 hu      |HOMEDIR=$ORIG_HOMEDIR nem knyvtr
   2440 TX=de   |Kann nicht in Verzeichnis HOMEDIR=$HOMEDIR wechseln
   2440 hu      |Nem lehet a HOMEDIR=$HOMEDIR knyvtrba vltani
   2441 TX=de   |Kann Umgebung in HOMEDIR=$HOMEDIR nicht herstellen
   2441 hu      |Nem ltrehozhat krnyezet a HOMEDIR=$HOMEDIR-ben
   2442 TX=de   |Argument $wert ist keine Zahl
   2442 hu      |Az argumentum $wert nem szm
   2443 TX=de   |Es kann nur entweder Option -w oder Option -e angegeben werden
   2443 hu      |Csak vagy -w opci vagy -e opci adhat meg
   2444 TX=de   |Bei Option -k drfen keine Mandantenverzeichnisse angegeben werden
   2444 hu      |A -k opcinl nem szabad megadni mandantknyvtrakat
   2445 TX=de   |Ohne Option -k muss mindestens ein Mandantenverzeichnis angegeben werden
   2445 hu      |-k opci nlkl legalbb egy mandantknyvtrat meg kell adni
   2446 TX=de   |Verzeichnis $client_dir nicht gefunden
   2446 hu      |$client_dir knyvtr nem tallhat
   2447 TX=de   |Kann nicht in Verzeichnis $client_dir wechseln
   2447 hu      |Nem lehet vltani a $client_dir knyvtrba
   2448 TX=de   |In Verzeichnis $client_dir fehlt Datei denv$suffix
   2448 hu      |A $client_dir knyvtrban hinyzik a denv$suffix fjl
   2449 TX=de   |Kann Umgebung in Verzeichnis $client_dir nicht herstellen
   2449 hu      |Nem ltrehozhat krnyezet a $client_dir knyvtrban
   2450 TX=de   |Verzeichnis fr Logdateien $log_dir kann nicht angelegt werden
   2450 hu      |Knyvtr a $log_dir log fjlokhoz nem vihet fel
"******** trans ********
   2451 TX=de   |bersetzungen
   2451 hu      |Fordtsok
   2452 TX=de   |Was soll bersetzt werden?
   2452 hu      |Mit kell lefordtani ?
   2453 TX=de   |FOP (nur Korrespondenzsprache)
   2453 hu      |FOP (Levelezsi nyelvek)
   2454 TX=de   |Infosysteme
   2454 hu      |Infosystem
   2455 TX=de   |Kommando-Mens
   2455 hu      |Utasts-menk
   2456 TX=de   |Hilfe-Mens
   2456 hu      |Segtsg-menk
   2457 TX=de   |Vartab-Bedeutungen
   2457 hu      |Vartab-jelentsek
   2458 TX=de   |Property-Dateien
   2458 hu      |Property-fjlok
   2459 TX=de   |Programmmeldungen
   2459 hu      |Programzenetek
   2460 TX=de   |Native GUI
   2460 hu      |Natv GUI
   2461 TX=de   |Individuelle Texte
   2461 hu      |Egyni szvegek
   2462 TX=de   |Alles
   2462 hu      |Minden
   2463 TX=de   |Werkzeuge
   2463 hu      |Eszkzk(Tools)
   2464 TX=de   |Gewnschte Operation:
   2464 hu      |A kivnt mvelet:
   2465 TX=de   |SmartTrans fr eine Maske
   2465 hu      |SmartTrans egy maszkhoz
   2466 TX=de   |Neue Texte aus Standardmasken in Wrterbuch aufnehmen
   2466 hu      |A standard-maszkokban tallhat j szvegek felvtele a sztrba
   2467 TX=de   |Neue Texte aus individuellen Masken in Wrterbuch aufnehmen
   2467 hu      |Az egyni maszkokban tallhat j szvegek felvtele a sztrba
   2468 TX=de   |Datei(en) bersetzen
   2468 hu      |Adatllomny(-ok) fordtsa
   2469 TX=de   |Wrterbuch editieren
   2469 hu      |Ltrehozsa szerkesztse
   2470 TX=de   |Wrterbuch testen
   2470 hu      |Ltrehozsa ellenrzse
   2471 TX=de   |Wrterbuch streng testen
   2471 hu      |A ltrehozsa szigor ellenrzse
   2472 TX=de   |Wrterbuch reparieren
   2472 hu      |Sztr javtsa
   2473 TX=de   |Zurck ins Hauptmen
   2473 hu      |Vissza a fmenbe
   2474 TX=de   |SmartTrans fr ein Men
   2474 hu      |SmartTrans egy menhz
   2475 TX=de   |Neue Texte aus Standardmens in Wrterbuch aufnehmen
   2475 hu      |Standard menkbl j szvegek felvtele sztrba
   2476 TX=de   |Neue Texte aus individuellen Mens in Wrterbuch aufnehmen
   2476 hu      |Egyedi menkbl j szvegek felvtele sztrba
   2477 TX=de   |Neue Texte in Wrterbuch aufnehmen
   2477 hu      |j szavak felvtele a sztrba
   2478 TX=de   |SmartTrans fr eine Vartab
   2478 hu      |SmartTrans egy Vartabhoz
   2479 TX=de   |Neue Texte aus Standard-Property-Dateien in Wrterbuch aufnehmen
   2479 hu      |j szvegek felvtele a standard property fjlokbl a sztrba
   2480 TX=de   |Neue Texte aus individuellen Property-Dateien in Wrterbuch aufnehmen
   2480 hu      |j szvegek felvtele az egyedi property fjlokbl a sztrba
   2481 TX=de   |Neue Texte aus einem Verzeichnis in Wrterbuch aufnehmen
   2481 hu      |j szvegek felvtele egy knyvtrbl a sztrba
   2482 TX=de   |SmartTrans fr ein FOP
   2482 hu      |SmartTrans egy FOP-hoz
   2483 TX=de   |SmartTrans fr einen Textbereich
   2483 hu      |SmartTrans egy szvegtartomnyhoz
   2484 TX=de   |FO-Kommandos bersetzen
   2484 hu      |FO parancsok fordtsa
   2485 TX=de   |FOP-Liste FOPALL.TRANS erstellen
   2485 hu      |FOPALL.TRANS FOP lista ksztse
   2486 TX=de   |Neue Texte aus STD-FO-Programmen in Wrterbuch aufnehmen
   2486 hu      |j szvegek felvtele a sztrba az STD-FO-programokbl.
   2487 TX=de   |Einzelnes FO-Programm in Wrterbuch aufnehmen
   2487 hu      |Egy FO-program felvtele a sztrba
   2488 TX=de   |FO-Programme eines bestimmten Textbereichs in Wrterbuch aufnehmen
   2488 hu      |Kijellt szvegllomny FO-programjnak felvtele a sztrba.
   2489 TX=de   |FO-Programme aller ow-Textbereiche in Wrterbuch aufnehmen
   2489 hu      |Minden ow-szvegllomny FO-programjnak felvtele a sztrba.
   2490 TX=de   |FO-Programme aus FOPALL.TRANS in Wrterbuch aufnehmen
   2490 hu      |FO-programokat az FOPALL.TRANS -bl a sztrba felvenni
   2491 TX=de   |Welche FOPs sollen in FO-Sprache $FOspr bersetzt werden?
   2491 hu      |Mely FOP-k kerljenek fordtsra a $FOspr FO nyelvre?
   2492 TX=de   |FO-Programme eines bestimmten Textbereiches bersetzen
   2492 hu      |Meghatrozott szvegtartomny FO-programjainak fordtsa
   2493 TX=de   |Einzelnes FO-Programm bersetzen
   2493 hu      |Egy FO-program fordtsa
   2494 TX=de   |SmartTrans fr die Maske eines Infosystems
   2494 hu      |SmartTrans egy infosystem maszkjhoz
   2495 TX=de   |SmartTrans fr die FOPs eines Infosystems (Bediensprache)
   2495 hu      |SmartTrans egy infosystem FOP-ihoz (kezelnyelv)
   2496 TX=de   |SmartTrans fr die FOPs eines Infosystems (Korrespondenzsprache)
   2496 hu      |SmartTrans egy infosystem FOP-ihoz (levelezsi nyelv)
   2497 TX=de   |SmartTrans fr die Variablenbedeutungen eines Infosystems
   2497 hu      |SmartTrans egy infosystem vltoz jelentseihez
   2498 TX=de   |Neue Texte aus einem Infosystem in Wrterbuch aufnehmen
   2498 hu      |j szvegek sztrba trtn felvtele infosystembl
   2499 TX=de   |Neue Texte aus allen Standard-Infosystemen in Wrterbuch aufnehmen
   2499 hu      |j szvegek felvtele az sszes standard infosystembl a sztrban
   2500 TX=de   |Neue Texte aus allen individuellen Infosystemen in Wrterbuch aufnehmen
   2500 hu      |j szvegek sztrba trtn felvtele az sszes egyedi infosystembl
   2501 TX=de   |Einzelnes Infosystem bersetzen
   2501 hu      |Infosystem egyenknti fordtsa
   2502 TX=de   |Alle Standard-Infosysteme bersetzen
   2502 hu      |sszes standard infosystem fordtsa
   2503 TX=de   |Alle individuellen Infosysteme bersetzen
   2503 hu      |sszes egyedi infosystem fordtsa
   2504 TX=de   |Alle Infosysteme bersetzen
   2504 hu      |sszes infosystem fordtsa
   2505 TX=de   |Wrterbuch editieren (FOP, Korrespondenzsprache)
   2505 hu      |Sztr szerkesztse (FOP, levelezsi nyelv)
   2506 TX=de   |Wrterbuch editieren (FOP)
   2506 hu      |Sztr szerkesztse (FOP)
   2507 TX=de   |Wrterbuch editieren (Masken)
   2507 hu      |Sztr szerkesztse (maszkok)
   2508 TX=de   |SmartTrans fr die FOPs eines Infosystems
   2508 hu      |SmartTrans egy infosystem FOP-ihoz
   2509 TX=de   |Welche Sprachen testen?
   2509 hu      |Ellenrizzend nyelvek
   2510 TX=de   |Alle installierten ($iSPR)
   2510 hu      |sszes installlt ($iSPR)
   2511 TX=de   |Nach Wunsch
   2511 hu      |Kvnsg szerint
   2512 TX=de   |Teilwrterbuch erzeugen
   2512 hu      |Sztr-rsz ellltsa
   2513 TX=de   |Teilwrterbuch erzeugen (Windows-Format)
   2513 hu      |Rsz-dictionary ksztse (Windows-formtum)
   2514 TX=de   |Teilwrterbuch erzeugen (CSV-Format)
   2514 hu      |Rsz-dictionary ksztse (CSV-formtum)
   2515 TX=de   |Teilwrterbuch einfgen
   2515 hu      |Rsz-dictionary beillesztse
   2516 TX=de   |Teilwrterbuch einfgen (Windows-Format)
   2516 hu      |Rsz-dictionary beillesztse (Windows-formtum)
   2517 TX=de   |Teilwrterbuch einfgen (CSV-Format)
   2517 hu      |Rsz-dictionary beillesztse (CSV-formtum)
   2518 TX=de   |Miniwrterbcher erzeugen
   2518 hu      |Mini sztrak ltrehozsa
   2519 TX=de   |Miniwrterbcher einfgen
   2519 hu      |Mini sztrak beillesztse
   2520 TX=de   |Wrterbcher testen
   2520 hu      |Ltrehozsa ellenrzse
   2521 TX=de   |Wrterbcher reparieren
   2521 hu      |Sztrak javtsa
   2522 TX=de   |Unbersetzte Texte entfernen
   2522 hu      |Le nem fordtott szvegek eltvoltsa
   2523 TX=de   |Teilwrterbuch editieren
   2523 hu      |Sztrrszlet szerkesztse
   2524 TX=de   |Welches Wrterbuch?
   2524 hu      |Melyik sztr ?
   2525 TX=de   |msg.lg.dic   (FOP)
   2525 hu      |msg.lg.dic   (FOP)
   2526 TX=de   |msg.tx.dic   (FOP - nur Korrespondenzsprache)
   2526 hu      |msg.tx.dic   (FOP - Levelezsi nyelvek)
   2527 TX=de   |msg.ma.dic   (Masken)
   2527 hu      |msg.ma.dic   (Maszkok)
   2528 TX=de   |msg.me.dic   (Kommando-Mens)
   2528 hu      |msg.me.dic   (menk)
   2529 TX=de   |msg.sh.dic   (Hilfe-Mens)
   2529 hu      |msg.sh.dic   (Shell-scriptek)
   2530 TX=de   |msg.vt.dic   (Vartab-Bedeutungen)
   2530 hu      |msg.vt.dic   (Vartab-jelentsek)
   2531 TX=de   |msg.pr.dic   (Property-Dateien)
   2531 hu      |msg.pr.dic   (Property-fjlok)
   2532 TX=de   |msg.cc.dic   (Programmmeldungen)
   2532 hu      |msg.cc.dic   (Programmzenetek)
   2533 TX=de   |msg.ng.dic   (Native GUI)
   2533 hu      |msg.ng.dic   (Natv GUI)
   2534 TX=de   |msg.ku.dic   (Individuelle Texte)
   2534 hu      |msg.ku.dic   (Egyni szvegek)
   2535 TX=de   |Welche Strings sollen extrahiert werden?
   2535 hu      |Mely sorokat kell kiemelni ?
   2536 TX=de   |Nur die unbersetzten
   2536 hu      |Csak amelyek nincsenek lefordtva
   2537 TX=de   |Nur die bersetzten
   2537 hu      |Csak a lefordtottak
   2538 TX=de   |Nur die fehlerhaften
   2538 hu      |Csak a hibsak
   2539 TX=de   |Alle in Grenzen von/bis
   2539 hu      |Az sszes -tl/-ig
   2540 TX=de   |Welche Strings sollen eingefgt werden?
   2540 hu      |Mely sorokat kell befzni ?
   2541 TX=de   |Nur die im Original unbersetzten
   2541 hu      |Csak az eredetiben le nem fordtottak
   2542 TX=de   |Kommentare bernehmen?
   2542 hu      |tvegyem a kommentrokat?
   2543 TX=de   |STD-FO-Programme
   2543 hu      |STD-FO-program
   2544 TX=de   |Individuelle FO-Programme
   2544 hu      |Egyedi FO programok
   2545 TX=de   |Alle und zustzlich amerikanische
   2545 hu      |sszes s ptllag amerikai angol
   2546 TX=de   |Nur die unbersetzten und zustzlich amerikanische
   2546 hu      |Csak a le nem fordtott s ptllag amerikai angol
   2547 TX=de   |Welches Miniwrterbuch?
   2547 hu      |Melyik mini sztr?
   2548 TX=de   |Welche Sprachen?
   2548 hu      |Mely nyelvek ?
   2549 TX=de   |de    - Deutsch
   2549 hu      |de    - Nmet
   2550 TX=de   |en    - Englisch
   2550 hu      |en    - Angol
   2551 TX=de   |fr    - Franzsisch
   2551 hu      |fr    - Francia
   2552 TX=de   |es    - Spanisch
   2552 hu      |es    - Spanyol
   2553 TX=de   |it    - Italienisch
   2553 hu      |it    - Olasz
   2554 TX=de   |pl    - Polnisch
   2554 hu      |pl    - Lengyel
   2555 TX=de   |ru    - Russisch
   2555 hu      |ru    - Orosz
   2556 TX=de   |hu    - Ungarisch
   2556 hu      |hu    - Magyar
   2557 TX=de   |cs    - Tschechisch
   2557 hu      |cs    - Cseh
   2558 TX=de   |tr    - Trkisch
   2558 hu      |tr    - Trk
   2559 TX=de   |1     - 1. individuelle
   2559 hu      |1     - 1. egyni
   2560 TX=de   |2     - 2. individuelle
   2560 hu      |2     - 2. egyni
   2561 TX=de   |3     - 3. individuelle
   2561 hu      |3     - 3. egyni
   2562 TX=de   |en-US - Amerikanisches Englisch
   2562 hu      |en-US - Amerikai angol
   2563 TX=de   |ro    - Rumnisch
   2563 hu      |ro    - Romn
   2564 TX=de   |id    - Bahasa Indonesia
   2564 hu      |id    - Bahasa Indonesia
   2565 TX=de   |nl    - Niederlndisch
   2565 hu      |nl    - Holland
   2566 TX=de   |mk    - Mazedonisch
   2566 hu      |mk    - Macedn
   2567 TX=de   |bg    - Bulgarisch
   2567 hu      |bg    - Bolgr
   2568 TX=de   |sr    - Serbisch
   2568 hu      |sr    - Szerb
   2569 TX=de   |sl    - Slowenisch
   2569 hu      |sl    - Szlovn
   2570 TX=de   |sk    - Slowakisch
   2570 hu      |sk    - Szlovk
   2571 TX=de   |pt    - Portugiesisch
   2571 hu      |pt    - Portugl
   2572 TX=de   |zh-CN - Chinesisch,vereinfacht
   2572 hu      |zh-CN - Knai,egyszerstett
   2573 TX=de   |zh-TW - Chinesisch,traditionell
   2573 hu      |zh-TW - Knai,hagyomnyos
   2574 TX=de   |el    - Griechisch
   2574 hu      |el    - Grg
   2575 TX=de   |th    - Thai
   2575 hu      |th    - Thai
   2576 TX=de   |ar    - Arabisch
   2576 hu      |ar    - Arab
   2577 TX=de   |fa    - Persisch
   2577 hu      |fa    - Perzsa
   2578 TX=de   |vi    - Vietnamesisch
   2578 hu      |vi    - Vietnami
   2579 TX=de   |ur    - Urdu
   2579 hu      |ur    - Urdu
   2580 TX=de   |ja    - Japanisch
   2580 hu      |ja    - Japn
   2581 TX=de   |Textbereich:
   2581 hu      |Szvegllomny:
   2582 TX=de   |Dateiname:
   2582 hu      |Adatllomny neve:
   2583 TX=de   |Infosystem:
   2583 hu      |Inf-rendszer:
   2584 TX=de   |Maske:
   2584 hu      |Maszk:
   2585 TX=de   |Maske auswhlen
   2585 hu      |Maszk kivlasztsa
   2586 TX=de   |Kommandomen:
   2586 hu      |Utasts-menk:
   2587 TX=de   |Vartab:
   2587 hu      |Vartab:
   2588 TX=de   |von Nummer :
   2588 hu      |sorszm-tl :
   2589 TX=de   |bis Nummer :
   2589 hu      |sorszm-ig :
   2590 TX=de   |Am.Englisch immer ausgeben?
   2590 hu      |Mindig am.angol kiadsa?
   2591 TX=de   |Gewnschte Sprache ($iSPR):
   2591 hu      |Kvnt nyelv ($iSPR):
"******** trans.def ********
   2592 TX=de   |* Option -A: Alles bersetzen
   2592 hu      |* Opci -A: Minden fordtsa
   2593 TX=de   |* Option -a: Alles aus 'file' bersetzen
   2593 hu      |* Opci -a: Minden lefordtsa a 'file'-bl
   2594 TX=de   |file: Format wie files.txt
   2594 hu      |file: Formtum, mint pl. files.txt
   2595 TX=de   |*         Option -M: Mode(s) fr Option -a
   2595 hu      |*         Opci -M: mode(s) az -a opcihoz
   2596 TX=de   |* Option -F: Alle FO-Kommandos bersetzen
   2596 hu      |* Opci -F: sszes FO parancs fordtsa
   2597 TX=de   |* Option -csltmevpnu: Wrterbuch
   2597 hu      |* Opci -csltmevpnu: sztr
   2598 TX=de   |*         m: Modus der Option
   2598 hu      |*         m: Az opci mdozata
   2599 TX=de   |*         fname: FOP-Name/Verz-Name
   2599 hu      |*         fname: FOP nv/Knyvtr nv
   2600 TX=de   |* Option -w: Angabe des Wrterbuchs
   2600 hu      |* Opci -w:  A sztr megadsa
   2601 TX=de   |* Option -W: Angabe der Sprache(n)
   2601 hu      |* Opci -W:  A nyelv(ek) megadsa
   2602 TX=de   |* Option -Y: nicht streng testen
   2602 hu      |* Opci -Y:  nem szigoran ellenrizni
   2603 TX=de   |* Option -w: Werkzeug-Modus
   2603 hu      |* Opci -w: Eszkz md
   2604 TX=de   |* Option -M: Art des Teilwrterbuchs
   2604 hu      |* Opci -M: A rsz-sztr tpusa
"******** trans_defines.sh ********
   2605 TX=de   |Falsche Eingabe, bitte wiederholen
   2605 hu      |Hibs adat, krem ismtelje meg!
   2606 TX=de   |Sprache $2 nicht vorhanden!
   2606 hu      |A(z) $2 nyelv nem ll rendelkezsre!
   2607 TX=de   |Programm mu im Mandanten-Verzeichnis aufgerufen werden!
   2607 hu      |A programot be kell tlteni a \"mandant\"-knyvtrba!
   2608 TX=de   |Kein Teilwrterbuch vorhanden!
   2608 hu      |Nem ll rendelkezsre rsz-sztr!
   2609 TX=de   |Datei: $2 nicht vorhanden!
   2609 hu      |llomny: $2 nem ltezik !
   2610 TX=de   |Textbereich: $2 nicht vorhanden!
   2610 hu      |Szvegllomny: $2 nem ll rendelkezsre!
   2611 TX=de   |Textbereich ist leer!
   2611 hu      |A szveg-tartomny(knyvtr) res
   2612 TX=de   |Teilwrterbuch $2 nicht vorhanden!
   2612 hu      |A $2 sztrrszlet nem ltezik !
   2613 TX=de   |Keine ow-Textbereiche vorhanden!
   2613 hu      |Nem lteznek ow-szvegtartomnyok !
   2614 TX=de   |Teilwrterbuch $2 konnte nicht eingefgt werden!
   2614 hu      |$2 rsz sztrt nem lehetett beilleszteni!
   2615 TX=de   |TRANS-Sperre ist bereits gesetzt!
   2615 hu      |TRANS zrlat mr el van helyezve!
   2616 TX=de   |Masken-Sperre ist bereits gesetzt!
   2616 hu      |Maszk zrlat mr el van helyezve!
   2617 TX=de   |Infosystem $2 nicht gefunden!
   2617 hu      |$2 infosystem nem tallhat!
   2618 TX=de   |Keine Infosysteme gefunden!
   2618 hu      |Nem tallhat infosystem!
   2619 TX=de   |Wrterbuch $2 ist jnger als Teilwrterbuch $3
   2619 hu      |$3 rsz-sztr rgebbi mint a $2 sztr
   2620 TX=de   |Wrterbuch $2 ist jnger als Windows-Teilwrterbuch $3
   2620 hu      |$3 Windows rsz-sztr rgebbi mint a $2 sztr
   2621 TX=de   |Teilwrterbuch $2 ist jnger als Wrterbuch $3
   2621 hu      |$3 sztr rgebbi mint a $2 rsz-sztr
   2622 TX=de   |Windows-Wrterbuch $2 ist jnger als Wrterbuch $3
   2622 hu      |A $3 sztr rgebbi mint a $2 Windows sztr
   2623 TX=de   |Verzeichnis: $2 nicht vorhanden!
   2623 hu      |Knyvtr: $2 nem ll rendelkezsre!
   2624 TX=de   |Maske nicht gefunden
   2624 hu      |Maszk nem tallhat
   2625 TX=de   |Datei $2 ist kein FOP!
   2625 hu      |$2 fjl nem FOP!
   2626 TX=de   |Keine FOPs gefunden!
   2626 hu      |Nem tallhatk FOP-ok!
   2627 TX=de   |FOPALL.TRANS nicht vorhanden!
   2627 hu      |llomny FOPALL.TRANS nem ltezik
"******** trans_dia.sh ********
   2628 TX=de   |file: Zu editierende Datei
   2628 hu      |file: Szerkesztend fjl
"******** trans_do.sh ********
   2629 TX=de   |Keine Masken gefunden!
   2629 hu      |Nem talltam maszkokat!
   2630 TX=de   |Keine Infosystemmasken gefunden!
   2630 hu      |Nem tallhatk infosystem maszkok!
   2631 TX=de   |Keine Mens gefunden!
   2631 hu      |Nem tallhatk menk!
   2632 TX=de   |Keine Property-Dateien gefunden!
   2632 hu      |Nem tallhatk property fjlok!
"******** trans_smart_do.sh ********
   2633 TX=de   |Fehler in $dicname
   2633 hu      |Hiba $dicname-ben
   2634 TX=de   |Keine neuen Texte enthalten
   2634 hu      |Nincsenek j szvegek tartalmazva
   2635 TX=de   |Keine Texte enthalten
   2635 hu      |Nincsenek szvegek tartalmazva
   2636 TX=de   |Infosystem $src nicht gefunden!
   2636 hu      |$src infosystem nem tallhat!
   2637 TX=de   |Vartab $src nicht gefunden!
   2637 hu      |$src Vartab nem tallhat!
   2638 TX=de   |Datei $src ist kein FOP!
   2638 hu      |$src fjl nem FOP!
   2639 TX=de   |Das Wrterbuch wird bereits bearbeitet!
   2639 hu      |A sztr mr szerkesztsre kerl!
"******** trans_tool_do.sh ********
   2640 TX=de   |Trotzdem weiter
   2640 hu      |Mgis tovbb
   2641 TX=de   |Kommando konnte nicht ausgefhrt werden
   2641 hu      |A parancs nem volt vgrehajthat
"******** typendiff.sh ********
   2642 TX=de   |* Option -v: Gebe Differenzen aus
   2642 hu      |* Opci -v: Differencik kiadsa
   2643 TX=de   |Datei $1 nicht vorhanden
   2643 hu      |llomny $1 nem ltezik
   2644 TX=de   |Datei $typetab1 und/oder $typtab2 nicht existent
   2644 hu      |$typetab1 s/vagy $typtab2 fjl nem ltezik
"******** umbringen.sh ********
   2645 TX=de   |* Option -a: Alle Schirme
   2645 hu      |* Opci -a: sszes kperny
   2646 TX=de   |* Option -p: Prozesse
   2646 hu      |* Opci -p: folyamatok
   2647 TX=de   |* Option -s: Ein Schirm
   2647 hu      |* opci -s: egy kperny
   2648 TX=de   |* Option -h: Hole Anwender: Dateien werden gefuellt
   2648 hu      |* Opci -h: felhasznl behozsa: fjlok kitltsre kerlnek
   2649 TX=de   |* Option -b: Bestimme Schirm pids, zwei Dateien wird gefuellt
   2649 hu      |* Opci -b: pids kperny meghatrozsa, kt fjl kerl betltsre
   2650 TX=de   |* Option -u: Beenden der Schirme in pid_alle
   2650 hu      |* Opci -u: a kpernyk befejezse pid_alle
   2651 TX=de   |* Option -e: wie -u, aber explizit via eksd
   2651 hu      |* Opci -e: ugyanaz, mint -u, de explicit eksd-n keresztl
   2652 TX=de   |$i: Leider haben auf $acthost $anzueberlebende Prozesse den Abbruch berlebt:
   2652 hu      |$i: Sajnos $acthost $anzueberlebende folyamatok tlltk a megszaktst:
   2653 TX=de   |Alle Prozesse wurden erfolgreich beendet.
   2653 hu      |Minden folyamat eredmnyesen befejezdtt.
   2654 TX=de   |Es konnten nicht alle Bildschirmprozesse beendet werden
   2654 hu      |Nem lehetett az sszes kpernyfolyamatot befejezni
   2655 TX=de   |Fehler beim Bestimmen der Datenbankprozesse
   2655 hu      |Hiba az adatbankfolyamatok meghatrozsnl
   2656 TX=de   |Es konnten nicht alle Datenbankprozesse beendet werden
   2656 hu      |Nem volt befejezhet az sszes adatbanki folyamat
   2657 TX=de   |Prozesse beenden an Schirm:
   2657 hu      |Folyamatok befejezse:
   2658 TX=de   |Aktionsoption fehlt
   2658 hu      |Hinyz mveleti opci
"******** update_screen_description.sh ********
   2659 TX=de   |aktualisiert den Inhalt von Maskendateien auf die neueste Version
   2659 hu      |a maszkfjlok tartalmt a legjabb verzira aktualizlja
   2660 TX=de   |* Option -a: alle individuellen Masken aktualisieren
   2660 hu      |* Opci -a: sszes egyedi maszk aktualizlsa
   2661 TX=de   |* Option -f: Datei mit den Namen von Maskenverzeichnissen
   2661 hu      |* Opci -f: Fjl maszkknyvtrak neveivel
   2662 TX=de   |* Option -o: Datei mit den Namen der Maskenverzeichnisse, die erfolgreich konvertiert wurden
   2662 hu      |* Opci -o: Fjl azoknak a maszkknyvtraknak a neveivel, amik sikeresen konvertlsra kerltek
   2663 TX=de   |Keine individuellen Masken in der neuen Maskenbeschreibung gefunden
   2663 hu      |Nem tallhatk egyedi maszkok az j maszklersban
   2664 TX=de   |Fehler beim Aktualisieren der Maskendatei(en)
   2664 hu      |Hiba a maszkfjl(ok) aktualizlsnl
   2665 TX=de   |Die folgenden Masken wurde aktualisiert:
   2665 hu      |A kvetkez maszkok kerltek aktualizlsra:
"******** varreorg_hook.sh ********
   2666 TX=de   |Konnte Dienst ${SERVICE_NAME} nicht ${errmsgcmd}. Bitte Dienst ${SERVICE_NAME} manuell neu starten.
   2666 hu      |Nem lehetett ${SERVICE_NAME} szolgltatst ${errmsgcmd}. Indtsa jra manulisan a ${SERVICE_NAME} szolgltatst!
"******** vartabdiff.sh ********
   2667 TX=de   |Vartab-Diff anzeigen
   2667 hu      |Vartab klnbsgek megjelentse
   2668 TX=de   |* Option -P: Passwort nicht erfragen
   2668 hu      |* Opci -P: Jelszt nem megkrdezni
   2669 TX=de   |* Option -l: Genderte Vartabs nur auflisten, keine Details
   2669 hu      |* Opci -l: Mdostott Vartaboknak csak felsorolsa, nincsenek rszletek
   2670 TX=de   |* Option -o: Diff-Ausgabemethode:
   2670 hu      |* Opci -o: Diff kiadsi metdus:
   2671 TX=de   |S[:nnn] = side-by-side-diff mit optionaler Breite nnn
   2671 hu      |S[:nnn] = side by side diff opcionlis nnn szlessggel
   2672 TX=de   |V = vimdiff, C = Kontextdiff, sonst einfacher Diff
   2672 hu      |V = vimdiff, C = kontextus diff, egybknt egyszer diff
   2673 TX=de   |* Option -k: Im diff auszugebende Kopffelder, \"\" = alle Felder
   2673 hu      |* Opci -k: a diff-ben kiadand fejrsz mezk, \"\" = sszes mez
   2674 TX=de   |* Option -f: Im diff auszugebende Tabellenfelder, \"\" = alle Felder
   2674 hu      |* Opci -f: A diff-ben kiadand tblzati mezk, \"\" = sszes mez
   2675 TX=de   |Vartab-Argument fehlt
   2675 hu      |Vartab argumentum hinyzik
   2676 TX=de   |Keine Vartabnderung fr $1 vorhanden
   2676 hu      |Nem ll rendelkezsre Vartab mdosuls $1-hez
   2677 TX=de   |Diff fr Vartab $origvt:
   2677 hu      |Diff $origvt Vartab-hoz:
"******** vnr_norm.sh ********
   2678 TX=de   |Versionsnummern im alten oder
   2678 hu      |Verziszmok a rgi vagy
   2679 TX=de   |im neuen sortierfhigen Format
   2679 hu      |az j szortrozsra kpes formtumban
   2680 TX=de   |* Option -f: Eingabedatei, sonst stdin
   2680 hu      |* Opci -f: Beviteli fjl, egybknt stdin
   2681 TX=de   |* Option -p: Ausgabe als Parameter 2002 1 2 1
   2681 hu      |* Opci -p: Kiads paramterknt 2002 1 2 1
   2682 TX=de   |* Option -r: Ausgabe ggf. im alten Format 11.4 N5 1
   2682 hu      |* Opci -r: Kiads adott esetben a rgi formtumban 11.4 N5 1
   2683 TX=de   |* Option -s: Reverse, aber _ statt blank
   2683 hu      |* Opci -s: Reverse, de blank helyett _
   2684 TX=de   |* Option -v: Ausgabe als Versionsverzeichnis v11.3n3_1
   2684 hu      |* Opci -v: Kiads verziknyvtrknt v11.3n3_1
   2685 TX=de   |* Option -z: Ausgabe als Real-Zahl 2002302.01
   2685 hu      |* Opci -z: Kiads vals szmknt 2002302.01
   2686 TX=de   |* Option -t: Teste alle Ausgabefilter
   2686 hu      |* Opci -t: Teszt sszes kiadsi filter
   2687 TX=de   |Parameter                          :
   2687 hu      |Paramter                          :
   2688 TX=de   |sortierfaehige Versionsnummer      :
   2688 hu      |Szortrozsra kpes verziszm     :
   2689 TX=de   |Ausgabe im Versionsnummernformat   :
   2689 hu      |Kiads a verziszm-formtumban    :
   2690 TX=de   |Versionsverzeichnis                :
   2690 hu      |Verziknyvtr                     :
   2691 TX=de   |Zahl                               :
   2691 hu      |Szm
   2692 TX=de   |Bundle-Version                     :
   2692 hu      |Bundle verzi
"******** wartung.sh ********
   2693 TX=de   |Inhalt von $fehlerdatei:
   2693 hu      |$fehlerdatei fjl tartalma:
   2694 TX=de   |Keine individuellen Schlssel vorhanden
   2694 hu      |Nem lteznek egyedi kulcsok
   2695 TX=de   |Schlsselauswahl: $2
   2695 hu      |Kulcs kivlaszts: $2
   2696 TX=de   |Programmaufruf: $prog_name
   2696 hu      |Programhvs: $prog_name
   2697 TX=de   |'$2' endete ohne Fehlerstatus, es gab aber Fehlerausgaben:
   2697 hu      |'$2' hiba sttus nlkl fejezdtt be, de voltak hiba kiadsok:
   2698 TX=de   |'$2' endete mit Fehlerstatus $rc.
   2698 hu      |'$2' $rc hiba sttussal fejezdtt be.
   2699 TX=de   |Fehlerausgabe:
   2699 hu      |Hiba kiads:
   2700 TX=de   |'$2' erfolgreich durchgelaufen.
   2700 hu      |'$2' sikeresen tfutva.
   2701 TX=de   |Mandantensperren verwalten (Keine Anmeldungen mehr mglich)
   2701 hu      |Mandantzrlatok kezelse (Mr nem lehet bejelentkezni)
   2702 TX=de   |Einbenutzer-Modus
   2702 hu      |Egy felhasznlos
   2703 TX=de   |Analyse der individuellen Schlssel
   2703 hu      |Az egyni kulcsok elemzse
   2704 TX=de   |Reparatur der individuellen Schlssel
   2704 hu      |Az egyni kulcsok javtsa
   2705 TX=de   |Individuellen Schlssel lschen
   2705 hu      |Az egyni kulcsok trlse
   2706 TX=de   |Datenbankreorganisation/Vartab (varreorg)
   2706 hu      |Adatbank jraszervezs / Vartab (varreorg)
   2707 TX=de   |Datenkonsistenz im Mandanten prfen
   2707 hu      |Adatkonzisztencia ellenrzse a mandantban
   2708 TX=de   |Reparatur der Reservierungen
   2708 hu      |Foglalsok javtsa
   2709 TX=de   |Shell
   2709 hu      |Shell
   2710 TX=de   |KEINER
   2710 hu      |EGY_SEM
   2711 TX=de   |UNTERBRECHUNG
   2711 hu      |MEGSZAKTS
   2712 D       |Datenbank Nummer Name
   2712 D       |3 Spaltenberschriften - bersetzungen mssen bndig sein
   2712 D       |Name ist ein 'Schlsselname'
   2712 E       |Database  Number Name
   2712 E       |Table header - translated words must be placed directly under the German words
   2712 E       |Name is a 'key name'
   2712 TX=de   |DB NR Name
   2712 hu      |Adatbzis szm nv
   2713 TX=de   |KEINER=Kein Anwender mglich        UNTERBRECHUNG=Kein DB-Zugriff mglich
   2713 hu      |EGY_SEM=Egy felhasznl sem dolgozhat  MEGSZAKTS=adatbank hozzfrs nem lehetsges
   2714 TX=de   |Wartungsprogramme fr Mandant $MANDANT
   2714 hu      |$MANDANT mandant karbantartsi programok
   2715 TX=de   |Sie haben '$wahl_txt' ausgewhlt.
   2715 hu      |'$wahl_txt'-et vlasztotta ki.
   2716 TX=de   |Fhren Sie diese Funktion nicht ohne aktuelle Datensicherung aus!
   2716 hu      |Ezt a funkcit ne hajtsa vgre aktulis adatments nlkl!
   2717 TX=de   |Bitte beachten Sie, dass diese Funktion sehr lange laufen kann.
   2717 hu      |Vegye figyelembe, hogy ez a funkci nagyon hosszan futhat!
   2718 TX=de   |Je nach Gre der Datenbank kann dies etliche Stunden dauern.
   2718 hu      |Az adatbzis nagysga szerint ez eltarthat nhny rig.
   2719 TX=de   |$wahl_txt luft...
   2719 hu      |$wahl_txt fut...
"******** xlslayoutgen.sh ********
   2720 TX=de   |-n                                Die Standard-XLS-Vorlagedatei nicht nutzen
   2720 hu      |-n                                A standard XLS mintafjlt nem hasznlni
   2721 TX=de   |-m                                Die Standard-XML-Vorlagedatei nicht nutzen
   2721 hu      |-m                                A standard XML mintafjlt nem hasznlni
   2722 TX=de   |-x <Vorlagedatei>                 XML-Vorlage fr die Layoutdatei
   2722 hu      |-x <mintafjl>                    XML minta a layoutfjlhoz
   2723 TX=de   |-t <Vorlagedatei>                 XLS-Vorlage fr die Layoutdatei
   2723 hu      |-t <mintafjl>                    XLS minta a layoutfjlhoz
   2724 TX=de   |-T <Vorlagedatei XLSX>            XLSX-Vorlage fr die Layoutdatei
   2724 hu      |-T <XLSX mintafjl>               XLSX minta a layout fjlhoz
   2725 TX=de   |-a                                Layouts fr alle aktiven Infosysteme erzeugen
   2725 hu      |-a                                Layoutok ltrehozsa az sszes aktv infosystemhez
   2726 TX=de   |-f <Ausgabedatei>                 Dateiname der generierten Layoutdatei
   2726 hu      |-f <kiadsi fjl>                 A generlt layoutfjl fjlneve
   2727 TX=de   |-i <Infosystem>                   Suchwort oder Identnummer des Infosystems
   2727 hu      |-i <infosystem>                   Az infosystem keresszava vagy hivatkozsi szma
   2728 TX=de   |-o <Ausgabepfad>                  Ausgabepfad fr die Layoutdatei
   2728 hu      |-o <kiadsi elrsi tvonal>      Kiadsi elrsi tvonal a layoutfjlhoz
   2729 TX=de   |-p <Passwort>                     Passwort
   2729 hu      |-p <jelsz>                       Jelsz
   2730 TX=de   |-w <Arbeitsbereich>               Arbeitsbereich des Infosystems
   2730 hu      |-w <munkatartomny>               Az infosystem munkatartomnya
"******** xml2lay.sh ********
   2731 TX=de   |* erzeugt GUI-Maskenbeschreibung aus xml-Datei
   2731 hu      |* ltrehoz GUI maszklerst xml fjlbl
   2732 TX=de   |* Option -m Typ: Typ=DB: Datenbankmasken, INFO: Infosystemmasken, STDINFO: Std-Infosystemmasken, OWNINFO: Kunden-Infosystemmasken
   2732 hu      |* Opci -m tpus: Tpus=DB: adatbzis maszkok, INFO: infosystem maszkok, STDINFO: standard infosystem maszkok, OWNINFO: felhasznli infosystem maszkok
   2733 TX=de   |* Option -s Spr: Sprache (default: alle installierten Bediensprachen)
   2733 hu      |* Opci -s Spr: Nyelv (alaprtelmezett: az sszes installlt kezelnyelv)
   2734 TX=de   |* Option -i dir: Verzeichnis in dem die xml-Dateien liegen
   2734 hu      |* Opci -i dir: Knyvtr amiben az xml fjlok vannak
   2735 TX=de   |* Option -j dir: Verzeichnis in dem datart.dat liegt
   2735 hu      |* Opci -j dir: Knyvtr, amiben a datart.dat van
   2736 TX=de   |* Option -o dir: Verzeichnis in dem die alte bzw. die GUI-Maskenbeschreibung erzeugt wird
   2736 hu      |* Opci -o dir: Knyvtr, amiben a rgi, ill. a GUI maszklers ltrehozsra kerl
   2737 TX=de   |* Option -e: Endung des Zieldateinamens (wird an den Standarddateinamen angehngt)
   2737 hu      |* Opci -e: A cl fjlnv vgzdse (a standard fjlnvhez kerl csatolsra)
   2738 TX=de   |* Option -z <datetime>: Datum und Uhrzeit der Generierung der Masken
   2738 hu      |* Opci -z <datetime>: A maszkok generlsnak dtuma s ideje
   2739 TX=de   |* Option -P Typ: in den Maskendateien verwendete Variablen prfen
   2739 hu      |* Opci -P tpus: A maszkfjlokban hasznlt vltozk ellenrzse
   2740 TX=de   |Typ: Typ=DB: Datenbankmasken, INFO: Infosystemmasken, STDINFO: Std-Infosystemmasken, OWNINFO: Kunden-Infosystemmasken
   2740 hu      |Tpus: Tpus=DB: adatbzis maszkok, INFO: infosystem maszkok, STDINFO: standard infosystem maszkok, OWNINFO: felhasznli infosystem maszkok
   2741 TX=de   |* Option -V: beim Prfen eine vorbereitete Variablentablle benutzen
   2741 hu      |* Option -V: Az ellenrzsnl egy elksztett vltoztblzat hasznlata
   2742 TX=de   |* Option -T: Datei mit allen Anforderungstexten erzeugen
   2742 hu      |* Opci -T: Fjl ltrehozsa az sszes felirati szveggel
   2743 TX=de   |* Option -t <dir>: Verzeichnis fr die mit -T erzeugen Dateien
   2743 hu      |* Opci -t <dir>: Knyvtr a -T -vel ltrehozott fjlokhoz
   2744 TX=de   |* Option -a: alte Maskenbeschreibung statt GUI-Masken generieren
   2744 hu      |* Opci -a: Rgi maszklers generlsa GUI maszkok helyett
   2745 TX=de   |* Option -l <edplog>: EDP-Kommandos in Datei protokollieren
   2745 hu      |* Option -l <edplog>: EDP parancsok jegyzknyvezse fjlban
   2746 TX=de   |* Option -q: Keine Ausgabe der Namen der Masken-Dateien
   2746 hu      |* Option -q: nincs kiadsa a maszkfjlok neveinek
   2747 TX=de   |Wenn die alte Maskenbeschreibung generiert werden soll, dann muss die Bediensprache angegeben werden.
   2747 hu      |Ha a rgi maszklers generlsra kerljn, akkor meg kell adni a kezelnyelvet.
   2748 TX=de   |Wenn die GUI-Maske fr alle installieren Bediensprachen generiert werden soll dann darf kein Ausgabeverzeichnis angegeben werden.
   2748 hu      |Ha a GUI maszk az sszes installlt kezelnyelvhez generlsra kerljn, akkor nem szabad megadni kiadsi knyvtrt.
   2749 TX=de   |alte Maskenbeschreibung fr Sprache $spriso aus Abas Maskenbeschreibung erzeugen ---
   2749 hu      |Rgi maszklers ltrehozsa $spriso nyelvhez az Abas maszklersbl ---
   2750 TX=de   |GUI-Maskenbeschreibung fr Sprache $spriso aus Abas Maskenbeschreibung erzeugen ---
   2750 hu      |GUI maszklers ltrehozsa a $spriso nyelvhez az Abas maszklersbl ---
   2751 TX=de   |Fehler gefunden beim Prfen der Maskendatei(en) fr Sprache $spr
   2751 hu      |Hiba tallhat a maszkfjl(ok) ellenrzsnl a $spr nyelvhez
   2752 TX=de   |Masken konnten nicht von $OUTTMP nach $OUTDIR verschoben werden
   2752 hu      |A maszkokat nem lehetett eltolni a $OUTTMP-bl a $OUTDIR-be.
   2753 TX=de   |Fehler beim Erzeugen der alten Maskenbeschreibung fr Sprache $spr
   2753 hu      |Hiba a rgi maszklers ltrehozsnl a $spr nyelvhez
   2754 TX=de   |Fehler beim Erzeugen der GUI-Masken fr Sprache $spr
   2754 hu      |Hiba a GUI maszkok ltrehozsnl a $spr nyelvhez
"******** xmlprint.sh ********
   2755 TX=de   |TEXTTRANS:  -l Textdatei (mit absolutem Pfad!) -o PDF-Filename
   2755 hu      |TEXTTRANS:  -l Szvegfjl (abszolt elrsi tvonallal!) -o PDF-filenv
   2756 TX=de   |* Option -n: Prfung der Java-Version einschalten
   2756 hu      |* Opci -n: A Java-verzi ellenrzsnek bekapcsolsa
   2757 TX=de   |* Option -k: Angabe von Sicherheitsoptionen:
   2757 hu      |* Opci -k: Biztonsgi opcik megadsa:
   2758 TX=de   |* Option -s: Nicht bedruckbarer Seitenrand (Angabe in mm ohne Einheit)
   2758 hu      |* Opci -s: Nem nyomtathat oldalszl (adat mm-ben egysg nlkl)
   2759 TX=de   |* Option -t: Konvertiert alle OVR-Layouts aus win/ovw nach XML
   2759 hu      |* opci -t: az sszes OVR layout-ot a win/ovw-bl XML-be konvertlja
   2760 TX=de   |* Option -y: Mandant-Pfad in dem gedruckt werden soll
   2760 hu      |* Opci -y: Mandant-tvonal, amiben nyomtatni kell
   2761 TX=de   |* Option -x: Drucker-Systemname fr Remote-Druck
   2761 hu      |* Opci -x: Nyomtat rendszer nv tvoli nyomtatshoz
   2762 TX=de   |* Option -z: Remote-Rechner an den der Druckauftrag per ssh gesendet wird
   2762 hu      |* Opci -z: Tvoli szmtgp amihez a nyomtatsi megbzs ssh rvn kerl kldsre
   2763 TX=de   |Keine auszufhrende Funktion angegeben
   2763 hu      |Nincs megadva vgrehajtand funkci
   2764 TX=de   |Fr Remote-Druck muss ein Druckername (Option -x) angegeben werden!
   2764 hu      |A tvoli nyomtatshoz meg kell adni egy nyomtat nevet (opci -x)!
   2765 TX=de   |Keine Fonts im Verzeichnis print/fonts vorhanden!
   2765 hu      |Nem llnak rendelkezsre fontok a print/fonts knyvtrban!
   2766 TX=de   |Sichere vorhandene Konfigurationsdatei (print/config/userconfig.xml) ...
   2766 hu      |A meglv konfigurcis fjl mentse (print/config/userconfig.xml) ...
   2767 TX=de   |Erzeuge leere Konfigurationsdatei (print/config/userconfig.xml) ...
   2767 hu      |res konfigurcis fjl ltrehozsa (print/config/userconfig.xml) ...
   2768 TX=de   |Datendatei $data nicht gefunden! Druckvorgang wird abgebrochen.
   2768 hu      |$data adatfjl nem tallhat. A nyomtatsi folyamat megszaktsra kerl.
   2769 TX=de   |Script im Mandanten ausfhren oder Mandantpfad mit Option -y setzen!
   2769 hu      |Script vgrehajtsa a mandantban vagy mandant elrsi tvonal -y opcival val elhelyezse!
"******** zugriff.sh ********
   2770 TX=de   |Kein HOMEDIR: `pwd`
   2770 hu      |Nem HOMEDIR: `pwd`
   2771 TX=de   |Root-Verzeichnis / kann kein HOMEDIR sein.
   2771 hu      |Root-knyvtr / nem lehet HOMEDIR.
   2772 TX=de   |Bitte $HOMEDIR in /etc/passwd eintragen bzw. \$MNAME korrekt besetzen
   2772 hu      |Krem a $HOMEDIR -t az /etc/passwd -ben megadni, ill. helyesen belltani a \$MNAME -t
   2773 TX=de   |Bitte Gruppennummer fuer User \"$MNAME\" in /etc/passwd eintragen
   2773 hu      |A \"$MNAME\" felhasznlnak krem a csoportszmt az /etc/passwd -ben megadni
   2774 TX=de   |Keine Architekturen vorhanden!
   2774 hu      |Nem lteznek architektrk!
   2775 TX=de   |root und spooler
   2775 hu      |root s spooler
   2776 TX=de   |Bitte Gruppennummer fuer User root in /etc/passwd eintragen
   2776 hu      |Krem, adja meg User root csoportszmt a /etc/passwd -ben
   2777 TX=de   |Kein Mandantenverzeichnis $mdir, denv.sh fehlt
   2777 hu      |Nem $mdir mandantknyvtr, denv.sh hinyzik
   2778 TX=de   |Root-Verzeichnis / kann kein MANDANTDIR sein.
   2778 hu      |Root-knyvtr / nem lehet MANDANTDIR.
   2779 TX=de   |*** Benutzer $MNAME fehlt in /etc/passwd
   2779 hu      |*** A $MNAME felhasznl hinyzik az /etc/passwd -bl
   2780 TX=de   |Setze Benutzer in `pwd` auf $s3
   2780 hu      |A `pwd` -ben belltottam a felhasznlt $s3 -ra
   2781 TX=de   |*** Gruppennummer fr Benutzer $MNAME fehlt in /etc/passwd
   2781 hu      |*** A $MNAME felhasznlnak hinyzik a csoportszma az /etc/passwd -bl
   2782 TX=de   |Setze Gruppe in `pwd` auf $s3grp
   2782 hu      |A `pwd` -ben belltottam a csoportot $s3grp -re
   2783 TX=de   |*** Benutzer $MNAME ist nicht in Gruppe $s3grp
   2783 hu      |*** $MNAME felhasznl nincs a $s3grp csoportban
"******** lizinfo.sh ********
   2784 TX=de   |* Option -a: Anzeigen der Lizenzbelegung
   2784 hu      |* Opci -a: A licencfoglals megjelentse
"******** guimaskengen.sh ********
   2785 TX=de   |Fehler beim Bestimmen der GUI-Maskendateien
   2785 hu      |Hiba a GUI-maszkfjlok meghatrozsnl
   2786 TX=de   |Fehler beim Bestimmen der Webclient-Maskendateien
   2786 hu      |Hiba a Web Client maszkfjlok meghatrozsnl
"******** maskenlist.sh ********
   2787 TX=de   |* Option -L category: Webclient-Masken einer Kategorie
   2787 hu      |* Opci -L category: egy kategria webclient maszkjai
   2788 TX=de   |Kategorie INFO: alle Webclient-Infosystem-Masken
   2788 hu      |INFO kategria: sszes webclient infosystem maszk
   2789 TX=de   |Kategorie STDINFO: Standard-Webclient-Infosystem-Masken
   2789 hu      |STDINFO category: standard webclient infosystem maszkok
   2790 TX=de   |Kategorie OWNINFO: Webclient-Infosystem-Masken der Kunden
   2790 hu      |OWNINFO kategria: a vevk webclient infosystem maszkjai
   2791 TX=de   |Kategorie DB: Webclient-Datenbank-Masken
   2791 hu      |DB kategria: webclient adatbzis maszkok
"******** xml2lay.sh ********
   2792 TX=de   |* Option -O dir: Verzeichnis in dem die Webclient-Maskenbeschreibung erzeugt wird
   2792 hu      |* Opci -O dir: Knyvtr, amiben a Web Client maszklers ltrehozsra kerl
   2793 TX=de   |GUI-Masken konnten nicht von $OUTTMP nach $OUTDIR verschoben werden
   2793 hu      |A GUI maszkokat nem lehetett eltolni a $OUTTMP-bl a $OUTDIR-be.
   2794 TX=de   |Webclient-Maske $jsonfile konnte nicht von $OUTTMP nach $OUTDIRJSON verschoben werden
   2794 hu      |A webclient maszkokat $jsonfile nem lehetett eltolni a $OUTTMP-bl a $OUTDIRJSON-be.
   2795 TX=de   |Fehler beim Erzeugen der Webclient-Masken fr Sprache $spr
   2795 hu      |Hiba a webclient maszkok ltrehozsnl a $spr nyelvhez
"******** starte_gc.sh ********
   2796 TX=de   |(4 * (Nettodatenbestand + NettoIndex) - von Datenbank belegter Platz =
   2796 hu      |(4 * (Nett adatkszlet + NettoIndex) - Adatbank ltal befedett hely =
"******** maskenlist.sh ********
   2797 TX=de   |* Option -A: nur Masken, die in der neuen und alten Maskenbeschreibung vorliegen
   2797 hu      |* Opci -A: Csak olyan maszkok, amik rendelkezsre llnak az j s rgi maszklersban
"******** mandcopy.sh ********
   2798 TX=de   |Datei $vondir/mandcopy.ini fehlt.
   2798 hu      |$vondir/mandcopy.ini hinyzik.
"******** trans.def ********
   2799 TX=de   |Aufruf von: 'ajo_install.sh -R -a -c' lieferte: $rc
   2799 hu      |A 'ajo_install.sh -R -a -c' lehvsa $rc return kddal vgzdtt
